/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.ipc.IPCConnectorClient;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PullRemoteReceiver;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.KerberosThreadManager;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SOAPConnectorClient
implements InvocationHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static final Vector emptyParams = new Vector(1);
    private static final String SOAPActionURI = "urn:AdminService";
    private SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean offline = true;
    private boolean secEnabled;
    private boolean isInternal;
    private boolean autoAcceptSigner = false;
    private Properties proxyProps;
    private URL url;
    private String protocol = "http";
    private String host;
    private String port;
    private String user;
    private String password;
    private String loginSource;
    private String authTarget;
    private String krb5Ccache;
    private String krb5Config;
    private String krb5Service;
    private String krb5RefreshingTicket;
    private int requestTimeout;
    private boolean JSSEFIPSProviderEnabled = false;
    private X509Certificate targetCertificate = null;
    private KerberosPolicy kerberosPolicy = null;
    private boolean keyStoreWarning = true;
    private boolean trustStoreWarning = true;
    private boolean usingJSSESocketFactory = false;
    private String remoteJMXVersion = "1.0.0";
    private String tested_ipaddr;

    public SOAPConnectorClient(Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SOAPConnectorClient");
        }
        this.proxyProps = (Properties)props.clone();
        this.host = this.proxyProps.getProperty("host");
        String sslSocketFactory = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.SocketFactory.provider");
            }
        });
        if (sslSocketFactory == null || !sslSocketFactory.equals("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
            this.usingJSSESocketFactory = true;
        }
        if (this.host.indexOf(58) > -1 && this.host.indexOf(91) < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = this.proxyProps.getProperty("port");
        this.user = this.proxyProps.getProperty("username");
        this.password = this.proxyProps.getProperty("password");
        this.loginSource = this.proxyProps.getProperty("loginsource");
        this.authTarget = this.proxyProps.getProperty("authTarget");
        this.krb5Ccache = this.proxyProps.getProperty("krb5Ccache");
        this.krb5Config = this.proxyProps.getProperty("krb5Config");
        this.krb5Service = this.proxyProps.getProperty("krb5Service");
        this.krb5RefreshingTicket = this.proxyProps.getProperty("krb5RefreshingTicket");
        String requestTimeoutProp = this.proxyProps.getProperty("com.ibm.SOAP.requestTimeout");
        if (requestTimeoutProp == null) {
            requestTimeoutProp = System.getProperty("com.ibm.SOAP.requestTimeout", "600");
        }
        this.requestTimeout = Integer.parseInt(requestTimeoutProp);
        this.secEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled"));
        this.isInternal = new Boolean(this.proxyProps.getProperty("isInternal"));
        this.autoAcceptSigner = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly"));
        Tr.debug(tc, "autoAcceptSigner " + this.autoAcceptSigner);
        if (!this.isInternal) {
            SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();
            sslConfigManager.initializeClientSSL();
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SOAPConnectorClient", this);
        }
    }

    public void setUserAndPwd(String uid, String pwd) {
        this.user = uid;
        this.password = pwd;
    }

    public String getType() {
        return "SOAP";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy proxy) {
        return new PullRemoteReceiver(proxy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconnect() throws ConnectorNotAvailableException {
        block24: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reconnect");
            }
            if (!this.offline) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "reconnect");
                return;
            }
            if (this.secEnabled) {
                try {
                    final Properties sslProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                        }
                    });
                    final HashMap<String, String> connectionInfo = new HashMap<String, String>();
                    connectionInfo.put("com.ibm.ssl.direction", "outbound");
                    connectionInfo.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                    connectionInfo.put("com.ibm.ssl.remoteHost", this.host);
                    connectionInfo.put("com.ibm.ssl.remotePort", this.port);
                    JSSEHelper.getInstance().setOutboundConnectionInfo(connectionInfo);
                    final String soapSslAlias = this.proxyProps.getProperty("sslConfig");
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (sslProps != null) {
                                    JSSEHelper.getInstance().setSSLPropertiesOnThread(sslProps);
                                } else {
                                    Properties ssl_props;
                                    String newSoapSslAlias = soapSslAlias;
                                    if (newSoapSslAlias == null) {
                                        newSoapSslAlias = SecurityHelper.getHelper().getClientSSLAlias();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "soapSslAlias: " + newSoapSslAlias);
                                    }
                                    if ((ssl_props = JSSEHelper.getInstance().getProperties(newSoapSslAlias, connectionInfo, null)) != null) {
                                        JSSEHelper.getInstance().setSSLPropertiesOnThread(ssl_props);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    if (this.autoAcceptSigner) {
                        Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                        RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting SSL properties.", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.constructor", "274", this);
                }
                this.protocol = "https";
                if (AdminCertificateHelper.getInstance().isRSAPropagationEnabled()) {
                    this.targetCertificate = SecurityHelper.retrieveRSACertificate(this.proxyProps);
                }
                if (!AdminCertificateHelper.getInstance().isRSAPropagationEnabled() && SecurityHelper.isKerberosEnabled(this.proxyProps, this.isInternal)) {
                    this.kerberosPolicy = SecurityHelper.retrieveKerberosPolicy(this.proxyProps, this.isInternal);
                }
            }
            final Call call = new Call();
            call.setSOAPMappingRegistry(this.smr);
            call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            call.setTargetObjectURI(SOAPActionURI);
            call.setMethodName("isAlive");
            call.setParams(emptyParams);
            call.setTargetObjectURI(SOAPActionURI);
            call.setTimeout(this.requestTimeout * 1000);
            SOAPContext context = call.getSOAPContext();
            if (context != null) {
                context.setProperty("JMXRemoteVersion", this.remoteJMXVersion);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reconnect setting context " + this.remoteJMXVersion);
                }
            }
            GenericSerializer.setVersion(this.remoteJMXVersion);
            try {
                try {
                    Response resp = (Response)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws SOAPException, ConnectorNotAvailableException {
                            Thread currThread = Thread.currentThread();
                            ClassLoader origThrCCL = currThread.getContextClassLoader();
                            GenericSerializer.setContextClassLoader(origThrCCL);
                            currThread.setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                Response res;
                                Response response = res = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                return response;
                            }
                            catch (SOAPException se) {
                                if (SOAPConnectorClient.this.protocol.equals("https") && !se.getMessage().contains("javax.net.ssl.SSLHandshakeException")) {
                                    Response res;
                                    Response response = res = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                    return response;
                                }
                                throw se;
                            }
                            finally {
                                currThread.setContextClassLoader(origThrCCL);
                            }
                        }
                    });
                    this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion(resp);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "reconnect response remoteJMXVersion " + this.remoteJMXVersion);
                    }
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    throw e;
                }
                if (!this.secEnabled) break block24;
            }
            catch (Exception se) {
                try {
                    this.tested_ipaddr = null;
                    if (!tc.isEntryEnabled()) throw new ConnectorNotAvailableException(se);
                    Tr.exit(tc, "reconnect", se);
                    throw new ConnectorNotAvailableException(se);
                }
                catch (Throwable throwable) {
                    if (!this.secEnabled) throw throwable;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                JSSEHelper.getInstance().setOutboundConnectionInfo(null);
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    catch (PrivilegedActionException pae) {
                        FFDCFilter.processException((Throwable)pae.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", "358", this);
                        throw new ConnectorNotAvailableException(pae.getException().getMessage(), pae.getException());
                    }
                }
            }
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", "358", this);
                throw new ConnectorNotAvailableException(pae.getException().getMessage(), pae.getException());
            }
        }
        this.offline = false;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "reconnect");
    }

    public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke", new Object[]{method2, args});
        }
        String methodName = method2.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "method name: " + methodName);
        }
        if (methodName.equals("invoke")) {
            return this.invoke((ObjectName)args[0], (String)args[1], (Object[])args[2], (String[])args[3]);
        }
        if (methodName.equals("getAttribute")) {
            return this.getAttribute((ObjectName)args[0], (String)args[1]);
        }
        if (methodName.equals("getAttributes")) {
            return this.getAttributes((ObjectName)args[0], (String[])args[1]);
        }
        if (methodName.equals("setAttribute")) {
            this.setAttribute((ObjectName)args[0], (Attribute)args[1]);
            return null;
        }
        if (methodName.equals("setAttributes")) {
            return this.setAttributes((ObjectName)args[0], (AttributeList)args[1]);
        }
        if (methodName.equals("isAlive")) {
            return this.isAlive();
        }
        if (methodName.equals("reconnect")) {
            this.reconnect();
            return null;
        }
        if (methodName.equals("getType")) {
            return this.getType();
        }
        if (methodName.equals("getProxyProperties")) {
            return this.getProxyProperties();
        }
        if (methodName.equals("queryNames")) {
            return this.queryNames((ObjectName)args[0], (QueryExp)args[1]);
        }
        if (methodName.equals("getMBeanCount")) {
            return this.getMBeanCount();
        }
        if (methodName.equals("getDomainName")) {
            return this.getDomainName();
        }
        if (methodName.equals("getDefaultDomain")) {
            return this.getDefaultDomain();
        }
        if (methodName.equals("getMBeanInfo")) {
            return this.getMBeanInfo((ObjectName)args[0]);
        }
        if (methodName.equals("getServerMBean")) {
            return this.getServerMBean();
        }
        if (methodName.equals("isInstanceOf")) {
            return this.isInstanceOf((ObjectName)args[0], (String)args[1]);
        }
        if (methodName.equals("isRegistered")) {
            return this.isRegistered((ObjectName)args[0]);
        }
        if (methodName.equals("openRemoteNotificationChannel")) {
            return this.openRemoteNotificationChannel((AdminServiceProxy)args[0]);
        }
        if (methodName.equals("addNotificationListener")) {
            return this._addNotficationListener(args);
        }
        if (methodName.equals("removeNotificationListener")) {
            this._removeNotificationListener(args);
            return null;
        }
        if (methodName.equals("resetFilter")) {
            this.resetFilter((ListenerIdentifier)args[0], (ConsolidatedFilter)args[1]);
            return null;
        }
        if (methodName.equals("pullNotifications")) {
            return this.pullNotifications((ListenerIdentifier)args[0], (Integer)args[1]);
        }
        if (methodName.equals("queryMBeans")) {
            return this.queryMBeans((ObjectName)args[0], (QueryExp)args[1]);
        }
        if (methodName.equals("getObjectInstance")) {
            return this.getObjectInstance((ObjectName)args[0]);
        }
        if (methodName.equals("getClassLoaderFor")) {
            return this.getClassLoaderFor((ObjectName)args[0]);
        }
        if (methodName.equals("getClassLoader")) {
            return this.getClassLoader((ObjectName)args[0]);
        }
        throw new ConnectorException(nls.getFormattedMessage("ADMC0044E", new Object[]{methodName}, "Unsupported AdminClient operation: {0}"));
    }

    public Session isAlive() throws Throwable {
        return (Session)this.invokeTemplate("isAlive", emptyParams, false);
    }

    public Session isAlive(int timeout) throws Throwable {
        return (Session)this.invokeTemplate("isAlive", emptyParams, false, timeout);
    }

    public Set queryNames(ObjectName name, QueryExp query) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        if (query != null) {
            params.addElement(new Parameter("queryexp", query.getClass(), query, null));
        } else {
            params.addElement(new Parameter("queryexp", QueryExp.class, query, null));
        }
        return (Set)this.invokeTemplate("queryNames", params, true);
    }

    public Integer getMBeanCount() throws Throwable {
        return (Integer)this.invokeTemplate("getMBeanCount", emptyParams, true);
    }

    public String getDomainName() throws Throwable {
        return (String)this.invokeTemplate("getDomainName", emptyParams, true);
    }

    public String getDefaultDomain() throws Throwable {
        return (String)this.invokeTemplate("getDefaultDomain", emptyParams, true);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        return (MBeanInfo)this.invokeTemplate("getMBeanInfo", params, true);
    }

    public ObjectName getServerMBean() throws Throwable {
        return (ObjectName)this.invokeTemplate("getServerMBean", emptyParams, true);
    }

    public Boolean isInstanceOf(ObjectName name, String className) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        params.addElement(new Parameter("classname", String.class, className, null));
        return (Boolean)this.invokeTemplate("isInstanceOf", params, true);
    }

    public Boolean isRegistered(ObjectName name) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        return (Boolean)this.invokeTemplate("isRegistered", params, true);
    }

    public Object getAttribute(ObjectName name, String attribute) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        params.addElement(new Parameter("attribute", String.class, attribute, null));
        return this.invokeTemplate("getAttribute", params, true);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        params.addElement(new Parameter("attribute", String[].class, attributes, null));
        return (AttributeList)this.invokeTemplate("getAttributes", params, true);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        params.addElement(new Parameter("attribute", Attribute.class, attribute, null));
        this.invokeTemplate("setAttribute", params, true);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        params.addElement(new Parameter("attribute", AttributeList.class, attributes, null));
        return (AttributeList)this.invokeTemplate("setAttributes", params, true);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws Throwable {
        Vector<Parameter> parameters = new Vector<Parameter>();
        parameters.addElement(new Parameter("objectname", ObjectName.class, name, null));
        parameters.addElement(new Parameter("operationname", String.class, operationName, null));
        parameters.addElement(new Parameter("params", Object[].class, params, null));
        parameters.addElement(new Parameter("signature", String[].class, signature, null));
        return this.invokeTemplate("invoke", parameters, true);
    }

    private Object invokeTemplate(String methodName, Vector params, boolean requiredSecHeader) throws Throwable {
        return this.invokeTemplate(methodName, params, requiredSecHeader, -1);
    }

    private Object invokeTemplate(String methodName, Vector params, boolean requiredSecHeader, int timeout) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeTemplate", methodName);
        }
        Object ret = null;
        try {
            ret = this.invokeTemplateOnce(methodName, params, requiredSecHeader, timeout);
        }
        catch (Exception ex) {
            if (IPCConnectorClient.isCertPathValidatorException(ex)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got CertPathValidatorException exception. Retrying");
                }
                this.offline = true;
                this.targetCertificate = null;
                this.kerberosPolicy = null;
                ret = this.invokeTemplateOnce(methodName, params, requiredSecHeader, timeout);
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeTemplate", methodName);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeTemplateOnce(String methodName, Vector params, boolean requiredSecHeader, int timeout) throws Throwable {
        Response resp;
        block36: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeTemplateOnce", methodName);
            }
            if (this.offline) {
                try {
                    this.reconnect();
                }
                catch (Throwable th) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeTemplate - failed", th);
                    }
                    if (!(th instanceof ConnectorNotAvailableException)) throw new ConnectorNotAvailableException(th);
                    throw th;
                }
            }
            final Call call = new Call();
            call.setSOAPMappingRegistry(this.smr);
            call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            call.setTargetObjectURI(SOAPActionURI);
            call.setMethodName(methodName);
            call.setParams(params);
            if (timeout < 0) {
                call.setTimeout(this.requestTimeout * 1000);
            } else {
                call.setTimeout(timeout);
            }
            SOAPContext context = call.getSOAPContext();
            if (context != null) {
                context.setProperty("JMXRemoteVersion", this.remoteJMXVersion);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invokeTemplate setting context " + this.remoteJMXVersion);
                }
            }
            GenericSerializer.setVersion(this.remoteJMXVersion);
            if (this.secEnabled) {
                Header header;
                final Properties sslProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                    }
                });
                if (requiredSecHeader && (header = this.getSecurityHeader(this.isInternal)) != null) {
                    call.setHeader(header);
                }
                try {
                    final HashMap<String, String> connectionInfo = new HashMap<String, String>();
                    connectionInfo.put("com.ibm.ssl.direction", "outbound");
                    connectionInfo.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                    connectionInfo.put("com.ibm.ssl.remoteHost", this.host);
                    connectionInfo.put("com.ibm.ssl.remotePort", this.port);
                    final String soapSslAlias = this.proxyProps.getProperty("sslConfig");
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (sslProps != null) {
                                    JSSEHelper.getInstance().setSSLPropertiesOnThread(sslProps);
                                } else {
                                    Properties ssl_props;
                                    String newSoapSslAlias = soapSslAlias;
                                    if (newSoapSslAlias == null) {
                                        newSoapSslAlias = SecurityHelper.getHelper().getClientSSLAlias();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "soapSslAlias: " + newSoapSslAlias);
                                    }
                                    if ((ssl_props = JSSEHelper.getInstance().getProperties(newSoapSslAlias, connectionInfo, null)) != null) {
                                        JSSEHelper.getInstance().setSSLPropertiesOnThread(ssl_props);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw pae.getException();
                    }
                    if (this.autoAcceptSigner) {
                        Tr.debug(tc, "autoAccettSignerForThisConnectionOnly");
                        RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
                    }
                }
                catch (SSLException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting SSL properties.", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.constructor", "687", this);
                }
            }
            if (!this.remoteJMXVersion.equals("1.0.0")) {
                call.setHeader(JMXVersionValidation.getJmxVersionHeader(call.getHeader(), this.remoteJMXVersion));
            }
            resp = null;
            try {
                try {
                    resp = (Response)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws SOAPException, ConnectorNotAvailableException {
                            Thread currThread = Thread.currentThread();
                            ClassLoader origThrCCL = currThread.getContextClassLoader();
                            GenericSerializer.setContextClassLoader(origThrCCL);
                            currThread.setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                Response res;
                                Response response = res = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                return response;
                            }
                            finally {
                                currThread.setContextClassLoader(origThrCCL);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    if (!e.equals(SOAPException.class)) throw e;
                    SOAPException se = (SOAPException)e;
                    throw se;
                }
                this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion(resp);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invokeTemplate response remoteJMXVersion " + this.remoteJMXVersion);
                }
                if (!this.secEnabled) break block36;
            }
            catch (SOAPException se) {
                try {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "723", this);
                    this.tested_ipaddr = null;
                    try {
                        this.offline = true;
                        this.reconnect();
                    }
                    catch (ConnectorNotAvailableException ex) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeTemplate - failed", new Object[]{methodName, se});
                    }
                    if (this.offline) {
                        throw new ConnectorNotAvailableException(se);
                    }
                    String str = nls.getFormattedMessage("ADMC0009E", new Object[]{methodName}, "Failed to make a SOAP call: {0}");
                    throw new ConnectorException(str, se);
                }
                catch (Throwable throwable) {
                    if (!this.secEnabled) throw throwable;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                JSSEHelper.getInstance().setOutboundConnectionInfo(null);
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    catch (PrivilegedActionException pae) {
                        FFDCFilter.processException((Throwable)pae.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "764", this);
                        throw new ConnectorException(pae.getException().getMessage(), pae.getException());
                    }
                }
            }
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException((Throwable)pae.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "764", this);
                throw new ConnectorException(pae.getException().getMessage(), pae.getException());
            }
        }
        if (resp.generatedFault()) {
            this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion(resp);
            Fault fault = resp.getFault();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeTemplate", methodName);
            }
            this.handleAdminFault(fault);
            return null;
        }
        Parameter result = resp.getReturnValue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeTemplate", methodName);
        }
        if (result == null) return null;
        return result.getValue();
    }

    private void handleAdminFault(Fault fault) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAdminFault");
        }
        String faultStr = fault.getFaultString();
        Throwable exc = null;
        try {
            exc = (Throwable)SOAPUtils.convertStringToObject(faultStr, this.remoteJMXVersion);
            exc = exc.fillInStackTrace();
        }
        catch (Throwable th) {
            FFDCFilter.processException(th, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "810", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error occurs while deserializing the received exception", th);
            }
            exc = new IllegalArgumentException(nls.getString("ADMC0043E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAdminFault", exc);
        }
        throw exc;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", listener);
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("filter", ConsolidatedFilter.class, filter, null));
        params.addElement(new Parameter("listener", PushNotificationListener.class, listener, null));
        ListenerIdentifier id = (ListenerIdentifier)this.invokeTemplate("addNotificationListener", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", id);
        }
        return id;
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerId);
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("listenerId", ListenerIdentifier.class, listenerId, null));
        this.invokeTemplate("removeNotificationListener", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", new Object[]{listenerId, filter});
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("listenerId", ListenerIdentifier.class, listenerId, null));
        params.addElement(new Parameter("fileter", ConsolidatedFilter.class, filter, null));
        this.invokeTemplate("resetFilter", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", new Object[]{id, batchSize});
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("listenerId", ListenerIdentifier.class, id, null));
        params.addElement(new Parameter("batchSize", Integer.class, batchSize, null));
        Notification[] result = (Notification[])this.invokeTemplate("pullNotifications", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications", result);
        }
        return result;
    }

    private Header createSOAPSecHeader(String username, String password) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSOAPSecHeader");
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "895", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), ex);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vec = new Vector<Element>();
        Element el = doc.createElement("username");
        Text nd = doc.createTextNode(username);
        el.appendChild(nd);
        vec.addElement(el);
        el = doc.createElement("password");
        nd = doc.createTextNode(password);
        el.appendChild(nd);
        vec.addElement(el);
        el = doc.createElement("LoginMethod");
        nd = doc.createTextNode("BasicAuth");
        el.appendChild(nd);
        vec.addElement(el);
        header.setHeaderEntries(vec);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSOAPSecHeader");
        }
        return header;
    }

    private Header getSecurityHeader(boolean isInternal) throws ConnectorException {
        Header header = null;
        header = isInternal ? this.processInternal() : this.processExternal();
        return header;
    }

    private Header createSOAPSecHeader(String token) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSOAPSecHeader");
        }
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "952", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), ex);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vec = new Vector<Element>();
        Element el = doc.createElement("token");
        Text nd = doc.createTextNode(token);
        el.appendChild(nd);
        vec.addElement(el);
        el = doc.createElement("LoginMethod");
        nd = doc.createTextNode("TokenBased");
        el.appendChild(nd);
        vec.addElement(el);
        header.setHeaderEntries(vec);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSOAPSecHeader");
        }
        return header;
    }

    private Header processExternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExternal");
        }
        Header header = null;
        if (this.kerberosPolicy == null && !AdminCertificateHelper.getInstance().isRSAPropagationEnabled() && SecurityHelper.isKerberosEnabled(this.proxyProps, this.isInternal)) {
            this.kerberosPolicy = SecurityHelper.retrieveKerberosPolicy(this.proxyProps, this.isInternal);
        }
        String realm = null;
        String spn = null;
        if (this.kerberosPolicy != null) {
            realm = this.kerberosPolicy.get_realm_name();
            spn = this.kerberosPolicy.get_spn_name();
        }
        if (!KerberosThreadManager.getInstance().isKerberosPolicyRetrievalInProcess().booleanValue() && this.authTarget != null && this.authTarget.length() > 0 && (this.authTarget.equalsIgnoreCase("KRB5") || this.authTarget.equalsIgnoreCase("Kerberos"))) {
            byte[] token = SecurityHelper.getKerberosToken(this.host, this.user, this.password, this.authTarget, this.loginSource, this.krb5Ccache, this.krb5Config, this.krb5Service, this.krb5RefreshingTicket, spn, realm);
            if (token == null) {
                throw new ConnectorException("Kerberos login probably failed; the token is null");
            }
            header = this.createSOAPSecHeader(Base64.encode(token));
        } else {
            if (this.user == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "SOAPConnectorClient - exception");
                }
                throw new ConnectorAuthenticationException(nls.getString("ADMC0035E", "no username specified"));
            }
            if (this.password == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "SOAPConnectorClient - exception");
                }
                throw new ConnectorAuthenticationException(nls.getString("ADMC0036E", "no password specified"));
            }
            header = this.createSOAPSecHeader(this.user, this.password);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExternal");
        }
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Header processInternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInternal");
        }
        Subject subject = null;
        Header header = null;
        subject = SecurityHelper.retrieveSubject();
        if (subject != null) {
            try {
                SecurityHelper.getActualSubject(subject);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processInternal - getActualSubject failed getting token Subject.");
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.processInternal", "1025", this);
                subject = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processInternal - Subject: ", subject);
        }
        if (subject != null) {
            WSSecurityContext ctx = SecurityHelper.getHelper().getWSSecurityContext();
            String realm = SecurityHelper.getHelper().getRealm();
            if (ctx != null) {
                String tokenStr = null;
                String serviceName = this.host;
                try {
                    if (this.targetCertificate == null && AdminCertificateHelper.getInstance().isRSAPropagationEnabled()) {
                        this.targetCertificate = SecurityHelper.retrieveRSACertificate(this.proxyProps);
                    }
                    RSATokenThreadManager.getInstance().setTargetCertificate(this.targetCertificate);
                    if (this.kerberosPolicy == null && !AdminCertificateHelper.getInstance().isRSAPropagationEnabled() && SecurityHelper.isKerberosEnabled(this.proxyProps, this.isInternal)) {
                        this.kerberosPolicy = SecurityHelper.retrieveKerberosPolicy(this.proxyProps, this.isInternal);
                    }
                    if (this.kerberosPolicy != null) {
                        realm = this.kerberosPolicy.get_realm_name();
                        serviceName = this.kerberosPolicy.get_spn_name();
                    }
                    byte[] token = ctx.initSecContext(subject, serviceName, realm);
                    tokenStr = Base64.encode(token);
                }
                catch (WSSecurityContextException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "fail to initialize the security context", ex);
                    }
                }
                finally {
                    RSATokenThreadManager.getInstance().setTargetCertificate(null);
                }
                if (tokenStr != null) {
                    header = this.createSOAPSecHeader(tokenStr);
                }
            } else {
                Tr.warning(tc, "ADMC0034W");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInternal");
        }
        return header;
    }

    private URL getUrl() throws ConnectorNotAvailableException {
        if (this.url == null) {
            String urlStr = this.protocol + "://" + this.host + ":" + this.port + "/";
            int p = Integer.parseInt(this.port);
            if (this.tested_ipaddr != null) {
                urlStr = this.protocol + "://" + this.tested_ipaddr + ":" + this.port + "/";
            } else {
                InetAddress[] all_inetaddrs = null;
                try {
                    all_inetaddrs = InetAddress.getAllByName(this.host);
                }
                catch (UnknownHostException e) {
                    throw new ConnectorNotAvailableException(e);
                }
                if (all_inetaddrs != null) {
                    Exception caughtException = null;
                    for (int i = 0; i < all_inetaddrs.length; ++i) {
                        try {
                            Socket s = new Socket(all_inetaddrs[i], p);
                            s.close();
                            this.tested_ipaddr = all_inetaddrs[i].getHostAddress();
                            if (this.tested_ipaddr.indexOf(58) > -1 && this.tested_ipaddr.indexOf(91) < 0) {
                                this.tested_ipaddr = "[" + this.tested_ipaddr + "]";
                            }
                            urlStr = this.protocol + "://" + this.tested_ipaddr + ":" + this.port + "/";
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "SOAPConnectorClient.getUrl, InetAddress No. " + i + ", url=" + urlStr);
                            break;
                        }
                        catch (Exception e) {
                            caughtException = e;
                            continue;
                        }
                    }
                    if (this.tested_ipaddr == null) {
                        throw new ConnectorNotAvailableException(nls.getFormattedMessage("ADMC0016E", new Object[]{this.host, this.port}, "Could not create SOAP Connector to connect to host {0} at port {1}"), caughtException);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "soap url: " + urlStr);
            }
            try {
                this.url = new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.SOAPConnectorClient", "1121", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "SOAPConnectorClient - failed", ex);
                }
                this.tested_ipaddr = null;
                throw new ConnectorNotAvailableException(ex);
            }
        }
        return this.url;
    }

    private Properties setupSslSetting(boolean internal) {
        String contextProvider;
        String keyStorePassword;
        String keyStoreType;
        String keyStore;
        String trustStorePassword;
        String trustStoreType;
        String trustStore;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupSslSetting", new Boolean(internal));
        }
        if ((trustStore = this.proxyProps.getProperty("javax.net.ssl.trustStore")) == null) {
            trustStore = this.proxyProps.getProperty("com.ibm.ssl.trustStore");
        }
        if ((trustStoreType = this.proxyProps.getProperty("javax.net.ssl.trustStoreType")) == null) {
            trustStoreType = this.proxyProps.getProperty("com.ibm.ssl.trustStoreType");
        }
        if ((trustStorePassword = this.proxyProps.getProperty("javax.net.ssl.trustStorePassword")) == null) {
            trustStorePassword = this.proxyProps.getProperty("com.ibm.ssl.trustStorePassword");
        }
        if ((keyStore = this.proxyProps.getProperty("javax.net.ssl.keyStore")) == null) {
            keyStore = this.proxyProps.getProperty("com.ibm.ssl.keyStore");
        }
        if ((keyStoreType = this.proxyProps.getProperty("javax.net.ssl.keyStoreType")) == null) {
            keyStoreType = this.proxyProps.getProperty("com.ibm.ssl.keyStoreType");
        }
        if ((keyStorePassword = this.proxyProps.getProperty("javax.net.ssl.keyStorePassword")) == null) {
            keyStorePassword = this.proxyProps.getProperty("com.ibm.ssl.keyStorePassword");
        }
        if ((contextProvider = this.proxyProps.getProperty("com.ibm.ssl.contextProvider")) == null) {
            contextProvider = this.proxyProps.getProperty("com.ibm.ssl.contextProvider");
        }
        SSLConfig config = null;
        if (keyStore != null || trustStore != null) {
            config = new SSLConfig(this.proxyProps);
            if (keyStore != null) {
                config.setProperty("com.ibm.ssl.keyStore", keyStore);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStore", keyStore);
                }
            }
            if (keyStorePassword != null) {
                config.setProperty("com.ibm.ssl.keyStorePassword", keyStorePassword);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
                }
            }
            if (keyStoreType != null) {
                config.setProperty("com.ibm.ssl.keyStoreType", keyStoreType);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStoreType", keyStoreType);
                }
            } else {
                config.setProperty("com.ibm.ssl.keyStoreType", "JKS");
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStoreType", "JKS");
                }
            }
            if (trustStore != null) {
                config.setProperty("com.ibm.ssl.trustStore", trustStore);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStore", trustStore);
                }
            }
            if (trustStorePassword != null) {
                config.setProperty("com.ibm.ssl.trustStorePassword", trustStorePassword);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
                }
            }
            if (trustStoreType != null) {
                config.setProperty("com.ibm.ssl.trustStoreType", trustStoreType);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStoreType", trustStoreType);
                }
            } else {
                config.setProperty("com.ibm.ssl.trustStoreType", "JKS");
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStoreType", "JKS");
                }
            }
            config.decodePasswords();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupSslSetting", config);
        }
        return config;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        if (query != null) {
            params.addElement(new Parameter("queryexp", query.getClass(), query, null));
        } else {
            params.addElement(new Parameter("queryexp", QueryExp.class, query, null));
        }
        return (Set)this.invokeTemplate("queryMBeans", params, true);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        return (ObjectInstance)this.invokeTemplate("getObjectInstance", params, true);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        return (ClassLoader)this.invokeTemplate("getClassLoaderFor", params, true);
    }

    public ClassLoader getClassLoader(ObjectName name) throws Throwable {
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("objectname", ObjectName.class, name, null));
        return (ClassLoader)this.invokeTemplate("getClassLoader", params, true);
    }

    public void addNotificationListener_1(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener1", new Object[]{name, listener, filter, handback});
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("name", ObjectName.class, name, null));
        params.addElement(new Parameter("listener", ObjectName.class, listener, null));
        params.addElement(new Parameter("filter", NotificationFilter.class, filter, null));
        params.addElement(new Parameter("handback", Object.class, handback, null));
        this.invokeTemplate("addNotificationListener", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener1");
        }
    }

    public void removeNotificationListener_4(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener4", new Object[]{name, listener, filter, handback});
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("name", ObjectName.class, name, null));
        params.addElement(new Parameter("listener", ObjectName.class, listener, null));
        params.addElement(new Parameter("filter", NotificationFilter.class, filter, null));
        params.addElement(new Parameter("handback", Object.class, handback, null));
        this.invokeTemplate("removeNotificationListener4", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener_2(ObjectName name, ObjectName listener) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener2", new Object[]{name, listener});
        }
        Vector<Parameter> params = new Vector<Parameter>();
        params.addElement(new Parameter("name", ObjectName.class, name, null));
        params.addElement(new Parameter("listener", ObjectName.class, listener, null));
        this.invokeTemplate("removeNotificationListener", params, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener2");
        }
    }

    private Object _addNotficationListener(Object[] args) throws Throwable {
        if (args == null) {
            return null;
        }
        if (args.length == 4 && args[0] instanceof ObjectName) {
            this.addNotificationListener_1((ObjectName)args[0], (ObjectName)args[1], (NotificationFilter)args[2], args[3]);
            return null;
        }
        return this.addNotificationListener((ConsolidatedFilter)args[0], (PushNotificationListener)args[1]);
    }

    private void _removeNotificationListener(Object[] args) throws Throwable {
        if (args == null) {
            return;
        }
        if (args.length == 4 && args[0] instanceof ObjectName) {
            this.removeNotificationListener_4((ObjectName)args[0], (ObjectName)args[1], (NotificationFilter)args[2], args[3]);
        } else if (args.length == 2 && args[0] instanceof ObjectName && args[1] instanceof ObjectName) {
            this.removeNotificationListener_2((ObjectName)args[0], (ObjectName)args[1]);
        } else {
            this.removeNotificationListener((ListenerIdentifier)args[0]);
        }
    }
}

