/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.rmi.RMIConnector;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteReceiver;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.AdminCertificateHelper;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.auth.rsatoken.RSATokenThreadManager;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RMIConnectorClient
implements AdminServiceProxy {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private RMIConnector connector;
    private RMINotificationListener rmiListener;
    private X509Certificate targetCertificate = null;
    private Properties proxyProps;
    private boolean online = false;

    public RMIConnectorClient(Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>" + this.getPropsString(props));
        }
        this.proxyProps = new Properties();
        this.proxyProps.setProperty("type", "RMI");
        this.proxyProps.setProperty("host", props.getProperty("host"));
        this.proxyProps.setProperty("port", props.getProperty("port"));
        if (props.getProperty("autoAcceptSignerForThisConnectionOnly") != null) {
            this.proxyProps.setProperty("autoAcceptSignerForThisConnectionOnly", props.getProperty("autoAcceptSignerForThisConnectionOnly"));
        }
        this.proxyProps.setProperty("securityEnabled", props.getProperty("securityEnabled", "false"));
        if (props.getProperty("isInternal") != null) {
            this.proxyProps.setProperty("isInternal", props.getProperty("isInternal"));
        }
        this.proxyProps.setProperty("com.ibm.websphere.naming.jndicache.cacheobject", "none");
        String host = this.proxyProps.getProperty("host", "localhost");
        if (host.indexOf(58) > -1 && host.indexOf(91) < 0) {
            host = "[" + host + "]";
        }
        String providerURL = "iiop://" + host + ":" + this.proxyProps.getProperty("port", "2809");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using PROVIDER_URL " + providerURL);
        }
        this.proxyProps.setProperty("java.naming.provider.url", providerURL);
        boolean securityEnabled = props.getProperty("username") != null & props.getProperty("password") != null;
        if (securityEnabled) {
            this.reconnect(props);
        } else {
            this.reconnect();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupSecurityCredentials(Properties props) throws ConnectorAuthenticationException {
        boolean external;
        boolean bl = external = new Boolean(props.getProperty("isInternal")) == false;
        if (external) {
            String username = props.getProperty("username");
            String password = props.getProperty("password");
            if (tc.isDebugEnabled() && username == null) {
                Tr.debug(tc, "username not specified");
            }
            if (tc.isDebugEnabled() && password == null) {
                Tr.debug(tc, "password not specified");
            }
            try {
                if (username == null || password == null) return;
                Subject subject = SecurityHelper.authenticate(username, password);
                SecurityHelper.setInvocationSubject(subject);
                return;
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to login", ex);
                }
                if (!tc.isEntryEnabled()) throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), ex);
                Tr.exit(tc, "<init> - exception");
                throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), ex);
            }
        } else {
            this.setupInternalSecurityCredentials();
        }
    }

    public RMIConnector getRMIConnector() {
        return this.connector;
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    private void reconnect() throws ConnectorException, ConnectorNotAvailableException {
        this.reconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(Properties prop) throws ConnectorException, ConnectorNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect " + this.getPropsString(prop));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in reconnect. Incoming subject:");
            this.printSubject();
        }
        try {
            String host;
            Properties env;
            block24: {
                env = new Properties();
                try {
                    if (!AdminCertificateHelper.getInstance().isRSAPropagationEnabled() || RSATokenThreadManager.getInstance().isCertificateRetrievalInProcess().booleanValue()) break block24;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "clearing the certificate cache");
                        }
                        host = this.proxyProps.getProperty("host");
                        String port = this.proxyProps.getProperty("port");
                        if (host != null && port != null) {
                            AdminCertificateHelper.getInstance().clearCertificateFromCache(host, port);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrieving the admin target certificate.");
                        }
                        RSATokenThreadManager.getInstance().setCertificateRetrievalInProcess();
                        this.targetCertificate = AdminCertificateHelper.getInstance().retrieveTargetCertificate(this.proxyProps);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Retrieved the following target certificate.", new Object[]{this.targetCertificate});
                        }
                    }
                    finally {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Finished retrieving the admin target certificate.");
                        }
                        RSATokenThreadManager.getInstance().unsetCertificateRetrievalInProcess();
                    }
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception setting up RSA token information.", new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.<init>", "271", this);
                    RSATokenThreadManager.getInstance().setTargetCertificate(null);
                }
            }
            host = this.proxyProps.getProperty("host", "localhost");
            if (host.indexOf(58) > -1 && host.indexOf(91) < 0) {
                host = "[" + host + "]";
            }
            env.put("java.naming.provider.url", "corbaloc:iiop:" + host + ":" + this.proxyProps.getProperty("port", "2809") + "/" + "WsnAdminNameService");
            InitialContext ic = new InitialContext(env);
            if (prop != null) {
                try {
                    ic.lookup("");
                    this.setupSecurityCredentials(prop);
                }
                catch (Exception e) {
                    throw new ConnectorException(e);
                }
            }
            String jndiName = "RMIConnector";
            String jndiNameWithSuffix = jndiName + this.proxyProps.getProperty("port");
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lookup for RMI stub using jndiName " + jndiNameWithSuffix);
                }
                this.connector = (RMIConnector)PortableRemoteObject.narrow((Object)ic.lookup(jndiNameWithSuffix), RMIConnector.class);
            }
            catch (NamingException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Try again, this time using jndiName " + jndiName);
                }
                this.connector = (RMIConnector)PortableRemoteObject.narrow((Object)ic.lookup(jndiName), RMIConnector.class);
            }
            this.online = true;
        }
        catch (NamingException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.reconnect", "237", this);
            this.online = false;
            throw new ConnectorNotAvailableException(ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy proxy) {
        PushRemoteReceiver rr = new PushRemoteReceiver(proxy);
        try {
            this.rmiListener = (RMINotificationListener)PortableRemoteObject.toStub((Remote)new RMINotificationListenerService(rr));
        }
        catch (RemoteException exc) {
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.createRemoteReceiver", "258", this);
        }
        return rr;
    }

    private void handleRemoteException(RemoteException exception) throws ConnectorException {
        this.online = false;
        throw new ConnectorException("RemoteException received", exception);
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isAlive");
        }
        if (!this.online) {
            this.reconnect();
        }
        Session retObj = null;
        try {
            retObj = this.connector.isAlive();
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.isAlive();
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isAlive", "292", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session isAlive(int timeout) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isAlive_i");
        }
        if (!this.online) {
            this.reconnect();
        }
        Session retObj = null;
        ContactThread contact = new ContactThread(this, Thread.currentThread());
        contact.start();
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException ie) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " Expected Exception Recieved", ie);
            }
        }
        finally {
            contact.setResponder(null);
            Thread.interrupted();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " Returned from nap");
        }
        if (contact.hasReturned()) {
            Throwable th = contact.getException();
            if (th != null) {
                throw new ConnectorException(th);
            }
        } else {
            throw new ConnectorException("Timeout Triggered, isAlive did not return in time");
        }
        retObj = contact.getSession();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Invoking isAlive_i", retObj);
        }
        return retObj;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryNames");
        }
        if (!this.online) {
            this.reconnect();
        }
        Set retObj = null;
        try {
            retObj = this.connector.queryNames(name, query);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.queryNames(name, query);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.queryNames", "326", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean internal = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            internal = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (internal) {
            this.setupInternalSecurityCredentials();
        }
        Object retObj = null;
        try {
            retObj = this.connector.getAttribute(name, attribute);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getAttribute(name, attribute);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttribute", "357", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean internal = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            internal = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (internal) {
            this.setupInternalSecurityCredentials();
        }
        AttributeList retObj = null;
        try {
            retObj = this.connector.getAttributes(name, attributes);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getAttributes(name, attributes);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttributes", "386", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean internal = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            internal = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (internal) {
            this.setupInternalSecurityCredentials();
        }
        try {
            this.connector.setAttribute(name, attribute);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                this.connector.setAttribute(name, attribute);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttribute", "417", this);
                this.handleRemoteException(re2);
            }
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean internal = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            internal = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (internal) {
            this.setupInternalSecurityCredentials();
        }
        AttributeList retObj = null;
        try {
            retObj = this.connector.setAttributes(name, attributes);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.setAttributes(name, attributes);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttributes", "445", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking invoke");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean internal = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            internal = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (internal) {
            this.setupInternalSecurityCredentials();
        }
        Object retObj = null;
        try {
            retObj = this.connector.invoke(name, operationName, params, signature);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.invoke(name, operationName, params, signature);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.invoke", "475", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDefaultDomain");
        }
        if (!this.online) {
            this.reconnect();
        }
        String retObj = null;
        try {
            retObj = this.connector.getDefaultDomain();
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getDefaultDomain();
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDefaultDomain", "503", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDomainName");
        }
        if (!this.online) {
            this.reconnect();
        }
        String retObj = null;
        try {
            retObj = this.connector.getDomainName();
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getDomainName();
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDomainName", "530", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanCount");
        }
        if (!this.online) {
            this.reconnect();
        }
        Integer retObj = null;
        try {
            retObj = this.connector.getMBeanCount();
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getMBeanCount();
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanCount", "557", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanInfo");
        }
        if (!this.online) {
            this.reconnect();
        }
        MBeanInfo retObj = null;
        try {
            retObj = this.connector.getMBeanInfo(name);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getMBeanInfo(name);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanInfo", "587", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public boolean isRegistered(ObjectName name) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isRegistered");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean retObj = false;
        try {
            retObj = this.connector.isRegistered(name);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.isRegistered(name);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isRegistered", "615", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isInstanceOf");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean retObj = false;
        try {
            retObj = this.connector.isInstanceOf(name, className);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.isInstanceOf(name, className);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isInstanceOf", "644", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking addNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        ListenerIdentifier retObj = null;
        try {
            if (listener != null) {
                RMINotificationListener rmiWrapper = this.createRMIWrapperForListener(listener);
                if (rmiWrapper != null) {
                    retObj = this.connector.addRMINotificationListener(filter, rmiWrapper);
                }
            } else {
                retObj = this.connector.addRMINotificationListener(filter, this.rmiListener);
            }
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.addRMINotificationListener(filter, this.rmiListener);
                if (listener != null) {
                    RMINotificationListener rmiWrapper = this.createRMIWrapperForListener(listener);
                    if (rmiWrapper != null) {
                        retObj = this.connector.addRMINotificationListener(filter, rmiWrapper);
                    }
                } else {
                    retObj = this.connector.addRMINotificationListener(filter, this.rmiListener);
                }
            }
            catch (RemoteException re22) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception received from connector.addRMINotificationListener:", re22);
                }
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.addNotificationListener", "716", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    private RMINotificationListener createRMIWrapperForListener(PushNotificationListener listener) throws RemoteException {
        RMINotificationListenerService rmiWrapper = null;
        try {
            rmiWrapper = new RMINotificationListenerService(listener);
        }
        catch (RemoteException exc) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "createRMIWrapperForListener:  Exception received:", exc);
            }
            FFDCFilter.processException((Throwable)exc, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.createRMIWrapperForListener", "765", this);
        }
        return rmiWrapper;
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking removeNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener(listenerId);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                this.connector.removeNotificationListener(listenerId);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "795", this);
                this.handleRemoteException(re2);
            }
        }
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking resetFilter");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.resetFilter(listenerId, filter);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                this.connector.resetFilter(listenerId, filter);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.resetFilter", "823", this);
                this.handleRemoteException(re2);
            }
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier id, Integer batchSize) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking pullNotifications");
        }
        if (!this.online) {
            this.reconnect();
        }
        Notification[] retObj = null;
        try {
            retObj = this.connector.pullNotifications(id, batchSize);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.pullNotifications(id, batchSize);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getEvents", "854", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getServerMBean");
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName retObj = null;
        try {
            retObj = this.connector.getServerMBean();
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.getServerMBean();
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getServerMBean", "882", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    private String getPropsString(Properties props) {
        String msg = "props: {";
        int i = 0;
        if (props == null) {
            msg = msg + "null";
        } else {
            Enumeration<?> vEnum = props.propertyNames();
            while (vEnum != null && vEnum.hasMoreElements()) {
                if (i > 0) {
                    msg = msg + ",";
                }
                ++i;
                String propName = (String)vEnum.nextElement();
                if (propName.equals("password") || propName.endsWith("Password")) {
                    msg = msg + " " + propName + "=" + "*****";
                    continue;
                }
                msg = msg + " " + propName + "=" + props.get(propName);
            }
        }
        msg = msg + "}";
        return msg;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryMBeans");
        }
        if (!this.online) {
            this.reconnect();
        }
        Set retObj = null;
        try {
            retObj = this.connector.queryMBeans(name, query);
        }
        catch (RemoteException re2) {
            this.reconnect();
            try {
                retObj = this.connector.queryMBeans(name, query);
            }
            catch (RemoteException re22) {
                FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.queryMBeans", "928", this);
                this.handleRemoteException(re2);
            }
        }
        return retObj;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", name);
        }
        if (!this.online) {
            this.reconnect();
        }
        ClassLoader retVal = null;
        try {
            retVal = this.connector.getClassLoaderFor(name);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getClassLoaderFor", "951", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", retVal);
        }
        return retVal;
    }

    public ClassLoader getClassLoader(ObjectName name) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", name);
        }
        if (!this.online) {
            this.reconnect();
        }
        ClassLoader retVal = null;
        try {
            retVal = this.connector.getClassLoader(name);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getClassLoader", "976", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", retVal);
        }
        return retVal;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", objectName);
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectInstance retVal = null;
        try {
            retVal = this.connector.getObjectInstance(objectName);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getObjectInstance", "1002", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", retVal);
        }
        return retVal;
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{name, listener, filter, handback});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.addNotificationListener(name, listener, filter, handback);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.addNotificationListener", "1029", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener_2", new Object[]{name, listener});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener_2(name, listener);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "1053", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener_2");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener_4", new Object[]{name, listener, filter, handback});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener_4(name, listener, filter, handback);
        }
        catch (RemoteException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "1077", this);
            this.handleRemoteException(re2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener_4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInternalSecurityCredentials() {
        block11: {
            boolean securityEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled"));
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupInternalSecurityCredentials " + securityEnabled);
            }
            if (!securityEnabled) {
                return;
            }
            if (this.targetCertificate == null) {
                this.targetCertificate = SecurityHelper.retrieveRSACertificate(this.proxyProps);
            }
            RSATokenThreadManager.getInstance().setTargetCertificate(this.targetCertificate);
            boolean autoAcceptSigner = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly"));
            if (autoAcceptSigner) {
                Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
            }
            Subject subject1 = null;
            try {
                subject1 = SecurityHelper.getInvocationSubject();
                if (subject1 == null) {
                    subject1 = SecurityHelper.getReceivedSubject();
                }
                if (subject1 != null) {
                    SecurityHelper.setInvocationSubject(subject1);
                    break block11;
                }
                Tr.service(tc, "ADMC0032W");
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception occurred setting invocation credential", ex);
                }
            }
        }
    }

    private void printSubject() {
        Subject subject1 = SecurityHelper.getInvocationSubject();
        Tr.debug(tc, "invocation subject is: ", subject1);
        if (subject1 == null) {
            subject1 = SecurityHelper.getReceivedSubject();
            Tr.debug(tc, "received subject is: ", subject1);
        }
    }

    class ContactThread
    extends Thread {
        boolean returned = false;
        Thread respond = null;
        RMIConnectorClient parent = null;
        Session session = null;
        Throwable except = null;

        ContactThread(RMIConnectorClient connector2, Thread res) {
            this.respond = res;
            this.parent = connector2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ContactThread.run()");
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " checking whether the process is alive ");
                }
                this.session = this.parent.isAlive();
                this.returned = true;
            }
            catch (ConnectorException ce) {
                FFDCFilter.processException((Throwable)ce, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.ContactThread", "1278", this);
                this.returned = true;
                this.except = ce;
            }
            catch (OutOfMemoryError oom) {
                FFDCFilter.processException((Throwable)oom, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.ContactThread", "1283", this);
                this.returned = true;
                this.except = oom;
            }
            catch (Throwable th) {
                FFDCFilter.processException(th, "com.ibm.ws.management.connector.160rmi.RMIConnectorClient.ContactThread", "1288", this);
                this.returned = true;
                this.except = null;
            }
            ContactThread contactThread = this;
            synchronized (contactThread) {
                if (this.respond != null) {
                    this.respond.interrupt();
                }
            }
        }

        synchronized void setResponder(Thread th) {
            this.respond = th;
        }

        synchronized Thread getResponder() {
            return this.respond;
        }

        boolean hasReturned() {
            return this.returned;
        }

        Session getSession() {
            return this.session;
        }

        Throwable getException() {
            return this.except;
        }
    }
}

