/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class JMXClassLoader
extends URLClassLoader {
    private static TraceComponent tc = Tr.register(JMXClassLoader.class, "Admin", "com.ibm.ws.management.resources.connector");
    private ClassLoader parentLdr;

    public JMXClassLoader(String path, ClassLoader classLoader) {
        super(new URL[0], classLoader);
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JMXClassLoader(String, ClassLoader)");
        }
        this.parentLdr = classLoader;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Parent class loader = " + classLoader);
        }
        if (!(file = new File(path)).isFile()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tmx4jTransform.jar not found in path " + path);
            }
            Tr.warning(tc, "Could not find tmx4jTransform.jar in " + path + " - Interoperability to older versions of WebSphere is disabled");
            FFDCFilter.processException((Throwable)new FileNotFoundException("Could not find tmx4jTransform.jar in " + path), "com.ibm.ws.management.connector.interop.JMXTransform", "1", this);
        }
        try {
            this.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.management.connector.interop.JMXTransform", "2", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JMXClassLoader(String, ClassLoader)");
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadClass " + name);
        }
        if ((cls = this.findLoadedClass(name)) == null) {
            try {
                cls = this.findClass(name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class " + name + " is loaded with JMXClassLoader ");
                }
            }
            catch (ClassNotFoundException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loading class " + name + " using ClassLoader delegation");
                }
                try {
                    Tr.debug(tc, "Loading class via " + this.parentLdr);
                    cls = this.parentLdr.loadClass(name);
                }
                catch (ClassNotFoundException cnf) {
                    ExtClassLoader extCl = ExtClassLoader.getInstance();
                    Tr.debug(tc, "CNF  - use current classloader " + extCl);
                    cls = extCl.loadClass(name);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadClass(" + name + ") " + cls);
        }
        return cls;
    }
}

