/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.management.configarchive.EARFileAccessor;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class EnhancedEarReader {
    public static final int FOLDER = 0;
    public static final int DOCUMENT = 1;
    public static final int BOTH = 2;
    public static final int FULL = -1;
    public static final int SELF = 0;
    public static final int ONE = 1;
    private static TraceComponent tc = Tr.register(EnhancedEarReader.class, "EnhancedEarReader", "com.ibm.ws.management.configarchive");

    public static boolean isEnhancedEar(EARFile ear) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnhancedEar (" + ear + ")");
        }
        boolean res = false;
        try {
            EARFileAccessor fa = new EARFileAccessor(ear);
            List fils = fa.listFolders("cells");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell folders = ", fils);
            }
            res = fils.size() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnhancedEar", new Boolean(res));
        }
        return res;
    }

    public static boolean isEnhancedEar(String earLocation) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnhancedEar (" + earLocation + ")");
        }
        boolean res = false;
        try {
            DefaultFileAccessor fa = new DefaultFileAccessor(new File(earLocation));
            List fils = fa.listFolders("cells");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell folders = ", fils);
            }
            if (fils.size() > 0) {
                res = fils.size() > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnhancedEar", new Boolean(res));
        }
        return res;
    }

    public static Resource getDeployment(EARFile ear) {
        XMIResourceImpl res;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDeployment (" + ear + ")");
            }
            res = null;
            try {
                EARFileAccessor fa = new EARFileAccessor(ear);
                String depUri = EnhancedEarReader.getDepUri(fa);
                if (depUri == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDeployment", res);
                    }
                    return res;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fa = ", fa);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri = ", depUri);
                }
                InputStream in = fa.load(depUri);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ins = ", in);
                }
                if (in != null) {
                    ResourceSetImpl resSet = new ResourceSetImpl();
                    res = new XMIResourceImpl();
                    res.setURI(URI.createURI("deployment.xml"));
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("DECLARE_XML", Boolean.FALSE);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading res = ", res);
                    }
                    res.load(in, options);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block11;
                e.printStackTrace();
                Tr.debug(tc, "failed  to get deployment.xml resource", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployment", res);
        }
        return res;
    }

    private static String getDepUri(FileAccessor fa) {
        String fileName;
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDepUri", fa);
        }
        String depUri = null;
        List lst = EnhancedEarReader.listFiles(fa, "", 1, -1);
        Object[] fils = lst.toArray();
        for (i = 0; i < fils.length; ++i) {
            String defaultDepUri;
            fileName = (String)fils[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matching", fileName);
            }
            if (!fileName.equals(defaultDepUri = "cells/defaultCell/applications/defaultApp/deployments/defaultApp/deployment.xml")) continue;
            depUri = fileName;
            break;
        }
        if (depUri != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDepUri", depUri);
            }
            return depUri;
        }
        for (i = 0; i < fils.length; ++i) {
            fileName = (String)fils[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matching", fileName);
            }
            if (!fileName.matches("cells/.*/applications/.*/deployments/.*/deployment.xml")) continue;
            depUri = fileName;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDepUri", depUri);
        }
        return depUri;
    }

    private static List listFiles(FileAccessor fa, String uri, int type, int depth) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + uri + " " + type + " " + depth + ")");
        }
        ArrayList result = new ArrayList();
        EnhancedEarReader.listFiles(fa, uri, type, depth, result);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles", result);
        }
        return result;
    }

    private static void listFiles(FileAccessor fa, String uri, int type, int depth, List result) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + uri + " " + type + " " + depth + ")");
        }
        if (depth == 0) {
            try {
                if (fa.exists(uri)) {
                    result.add(uri);
                }
            }
            catch (Exception e) {
                String msg = "";
                if (fa instanceof DefaultFileAccessor) {
                    DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                    msg = "listFiles (" + dfa.getRootDir().getPath() + File.separator + uri + ") failed with unexpected exception, " + e;
                } else {
                    msg = "listFiles (" + uri + ") failed with unexpected exception, " + e;
                }
                Tr.warning(tc, msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listFiles");
            }
            return;
        }
        List f = null;
        Object[] lst = null;
        if (type == 1 || type == 2) {
            try {
                f = fa.listFiles(uri);
            }
            catch (Exception e) {
                f = new ArrayList();
            }
            lst = f.toArray();
            for (int i = 0; i < lst.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + lst[i]);
                }
                result.add(lst[i]);
            }
        }
        f = null;
        try {
            f = fa.listFolders(uri);
        }
        catch (Exception e) {
            f = new ArrayList();
        }
        lst = f.toArray();
        for (int i = 0; i < lst.length; ++i) {
            if (type == 2 || type == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + lst[i]);
                }
                result.add(lst[i]);
            }
            if (depth == 1) continue;
            EnhancedEarReader.listFiles(fa, (String)lst[i], type, depth == -1 ? -1 : depth - 1, result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
    }
}

