/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class EARFileAccessor
extends FileAccessor {
    private EARFile earFile;
    private String configLocationURI = null;
    private static final char URI_SEPERATOR = '/';
    private static TraceComponent tc = Tr.register(EARFileAccessor.class, "EARFileAccessor", "com.ibm.ws.management.resources.bundle");

    public EARFileAccessor(EARFile earFile) {
        this.earFile = earFile;
        this.configLocationURI = "META-INF/ibmconfig";
        this.configLocationURI = this.configLocationURI.replace(File.separatorChar, '/');
    }

    public File getRootDir() {
        return null;
    }

    public void create(String uri, InputStream ins) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create (" + uri + " " + ins + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create");
        }
        throw new IOException("create method is not supported");
    }

    public void delete(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete (" + uri + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete");
        }
        throw new IOException("delete method is not supported");
    }

    public InputStream load(String relativeUri) throws IOException {
        String uri = this.configLocationURI + '/' + relativeUri;
        InputStream is = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load (" + uri + ")");
        }
        is = this.earFile.getInputStream(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
        return is;
    }

    public void save(String uri, InputStream ins) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save (" + uri + " " + ins + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save");
        }
        throw new IOException("save method is not supported");
    }

    public List listFolders(String parentUri) throws IOException {
        String uri = this.configLocationURI + '/' + parentUri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFolders (" + uri + ")");
        }
        List<String> lst = new ArrayList();
        String fileName = uri;
        EList elst = this.earFile.getFiles();
        if (elst != null) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] list = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])elst.toArray();
            for (int i = 0; i < list.length; ++i) {
                int k;
                int ch;
                String u;
                int j;
                if (!list[i].getDirectoryURI().startsWith(uri) || (j = (u = list[i].getURI()).indexOf(ch = 47, k = uri.length() + 1)) == -1 || lst.contains(u = u.substring(0, j))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding folder = ", u);
                }
                lst.add(u);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFolders");
        }
        lst = this.adjustPaths(lst);
        return lst;
    }

    public List listFiles(String parentUri) throws IOException {
        String uri = this.configLocationURI + '/' + parentUri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + uri + ")");
        }
        List<String> lst = new ArrayList();
        String fileName = uri;
        EList elst = this.earFile.getFiles();
        if (elst != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent = ", uri);
            }
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] list = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])elst.toArray();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectoryEntry() || !list[i].getDirectoryURI().equals(uri)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding file = ", list[i].getURI());
                }
                lst.add(list[i].getURI());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
        lst = this.adjustPaths(lst);
        return lst;
    }

    public boolean exists(String relativePath) throws IOException {
        String uri = this.configLocationURI + '/' + relativePath;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exists (" + uri + ")");
        }
        boolean ret = this.checkExists(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exists " + ret);
        }
        return ret;
    }

    public OutputStream getOutputStream(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + uri + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        throw new IOException("getOutputStream() is not supported");
    }

    public void makeDir(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeDir (" + uri + ")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeDir");
        }
    }

    private List adjustPaths(List lst) {
        ArrayList<String> paths = new ArrayList<String>(lst.size());
        for (String str : lst) {
            str = str.substring(this.configLocationURI.length() + 1);
            paths.add(str);
        }
        return paths;
    }

    private boolean checkExists(String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExists (" + uri + ")");
        }
        ArrayList lst = new ArrayList();
        EList elst = this.earFile.getFiles();
        if (elst != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parent = ", uri);
            }
            org.eclipse.jst.j2ee.commonarchivecore.internal.File[] list = (org.eclipse.jst.j2ee.commonarchivecore.internal.File[])elst.toArray();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getURI().startsWith(uri)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found file = ", list[i].getURI());
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExists");
        }
        return false;
    }
}

