/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.properties.resources;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.properties.resources.common.EnvVariables;
import com.ibm.ws.management.commands.properties.resources.common.PropertiesUtils;
import com.ibm.ws.management.commands.properties.resources.common.SectionedProperties;
import com.ibm.ws.management.commands.properties.resources.common.SectionedPropertiesHelper;
import com.ibm.ws.management.commands.properties.resources.mapping.SectionData;
import com.ibm.ws.management.commands.properties.resources.properties.Section;
import com.ibm.ws.management.wasresource.common.PropWASResource;
import com.ibm.ws.management.wasresource.common.UnknownResourceTypeException;
import com.ibm.ws.management.wasresource.common.WASResourceException;
import com.ibm.ws.management.wasresource.common.WASResourceInitializeException;
import com.ibm.ws.management.wasresource.common.WASResourceOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class Application
extends PropWASResource {
    private static final TraceComponent tc = Tr.register(Application.class, null, null);
    private AppManagement appManagement = null;

    public String getResourceType() {
        return "Application";
    }

    public void initialize(HashMap eprRefProps) throws WASResourceInitializeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{eprRefProps, this});
        }
        try {
            super.initialize(eprRefProps);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public List getResourceInstances(Session session, ObjectName scope, String containmentPath) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInstances", new Object[]{containmentPath, this});
        }
        List result = null;
        if (containmentPath == null || containmentPath.equals("")) {
            containmentPath = "Deployment";
        }
        result = containmentPath.equals("NONEXISTENTRESOURCE") ? super.getConfigResourceInstanceForCreate(containmentPath, false, this.getResourceType()) : super.getConfigResourceInstances(session, scope, containmentPath, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInstances", result);
        }
        return result;
    }

    public SectionedProperties[] getCreateTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCreateTemplateProperties");
        }
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        SectionedProperties sp = null;
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        String comments = sp.getComments();
        StringBuffer sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to install a new application on a given server.\n#\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        Properties props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("TargetServer", "targetServerName #required");
        props.setProperty("TargetNode", "targetNodeName #required");
        props.setProperty("EarFileLocation", "location of earfile #required");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to install a new application on a given cluster.\n#\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("TargetCluster", "targetClusterName #required");
        props.setProperty("EarFileLocation", "location of earfile #required");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application with a new file.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "add #required");
        props.setProperty("contentType", "file #required");
        props.setProperty("contentURI", "test.war/com/ibm/addMe.jsp #required (content uri in the application)");
        props.setProperty("contentFile", "c:/temp/addMe.jsp #required (actual file to updatewith)");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application by deleting a file.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "delete #required");
        props.setProperty("contentType", "file #required");
        props.setProperty("contentURI", "test.war/com/ibm/addMe.jsp #required (content uri in the application)");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application with a new module.\n#\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "add #required");
        props.setProperty("contentType", "moduleFile #required");
        props.setProperty("contentURI", "Increment.jar #required (content uri in the application)");
        props.setProperty("contentFile", "c:/apps/app1/Increment.jar #required (actual file to updatewith)");
        props.setProperty("deployEJB", "false #required");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application by deleting a module.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "delete #required");
        props.setProperty("contentType", "moduleFile #required");
        props.setProperty("contentURI", "test.war #required (content uri in the application)");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application with a partial ear file.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "update #required");
        props.setProperty("contentType", "partialapp #required");
        props.setProperty("contentFile", "c:/temp/MyApp/myAppPartial.zip #required (actual file to updatewith)");
        sp.setConfigProperties(props);
        spList.add(sp);
        sp = SectionedPropertiesHelper.getCreateSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        comments = sp.getComments();
        sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to update an application with a complete ear file.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        props = new Properties();
        props.setProperty("Name", "appName #required");
        props.setProperty("Update", "true #required");
        props.setProperty("operationType", "update #required");
        props.setProperty("contentType", "app #required");
        props.setProperty("contentFile", "c:/apps/app1/newApp1.ear #required (actual file to updatewith)");
        props.setProperty("useDefaultBindings", "true #required");
        sp.setConfigProperties(props);
        spList.add(sp);
        SectionedProperties[] sps = spList.toArray(new SectionedProperties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCreateTemplateProperties", sps);
        }
        return sps;
    }

    public SectionedProperties[] getDeleteTemplateProperties() throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeleteTemplateProperties");
        }
        ArrayList<SectionedProperties> spList = new ArrayList<SectionedProperties>();
        SectionedProperties sp = null;
        sp = SectionedPropertiesHelper.getDeleteSectionedProperties((String)"Application", (String)"Application", (String)"Deployment=");
        String comments = sp.getComments();
        StringBuffer sb = new StringBuffer(comments);
        sb = sb.append("\n# Use this section to uninstall an application.\n");
        sb = sb.append("# Update ResourceId field with appname ( ResourceId=Deployment=appName ) \n#\n");
        sp.setComments(sb.toString());
        Properties props = new Properties();
        props.setProperty("Name", "appName #required");
        sp.setConfigProperties(props);
        spList.add(sp);
        SectionedProperties[] sps = spList.toArray(new SectionedProperties[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeleteTemplateProperties", sps);
        }
        return sps;
    }

    public Properties getProperties() throws UnknownResourceTypeException, WASResourceException {
        SectionData sd;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        if (!(sd = (SectionData)this.getReferenceProperties().get("SECTIONS")).getType().equals("Application")) {
            return super.getProperties();
        }
        String cId = this.getConfigID();
        int inx = cId.lastIndexOf("/");
        int einx = cId.lastIndexOf("|");
        String appName = cId.substring(inx + 1, einx);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "section= " + sd);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props= " + sd.getPropertiesData());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props mapping= " + sd.getPropertiesToAttributesMapping());
        }
        String propName = sd.getPropertiesData()[0].getPropName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appName= " + appName + " propName = " + propName);
        }
        Properties props = this.getAppInfo(appName, propName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", props);
        }
        return props;
    }

    public String getProperty(String name) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigProperty", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigProperty");
        }
        return null;
    }

    public void setProperty(String name, String value) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperty", new Object[]{name, value});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperty");
        }
    }

    public String[] validateProperties(Properties props) throws UnknownResourceTypeException, WASResourceException {
        String[] result = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateProperties", props);
        }
        this.setProperties(props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateProperties");
        }
        return result;
    }

    public void setProperties(Properties prop) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", prop);
        }
        Section[] sections = (Section[])this.getReferenceProperties().get("SECTIONS");
        Section section = sections[0];
        String cType = (String)this.getReferenceProperties().get("RESOURCETYPE");
        if (cType != null && !cType.equals("Application")) {
            super.setProperties(prop);
            return;
        }
        Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
        Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
        if (prop.containsKey("Name")) {
            String appName = prop.getProperty("Name");
            if (create != null && create.booleanValue()) {
                if (this.appExists(appName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "setProperties: Application is already installed");
                    }
                    return;
                }
            } else if (delete != null && delete.booleanValue()) {
                if (!this.appExists(appName)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "setProperties: Application is alreay uninstalled");
                    }
                    return;
                }
            } else if (prop.containsKey("Update") && !this.appExists(appName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setProperties: Application does not exist");
                }
                throw new WASResourceException("Application does not exist " + appName);
            }
            this.createDeleteProperties(prop);
        } else if (delete == null || !delete.booleanValue()) {
            String skipApply;
            String taskName = prop.getProperty("taskName");
            String cId = this.getConfigID();
            int inx = cId.lastIndexOf("/");
            int einx = cId.lastIndexOf("|");
            String appName = null;
            if (inx >= 0 && einx > 0) {
                appName = cId.substring(inx + 1, einx);
            }
            if (!(appName == null || taskName == null || taskName.equals("AppDeploymentOptions") || (skipApply = (String)this.getReferenceProperties().get("SKIP_APPLICATION_DEPLOY")) != null && skipApply.equals("true"))) {
                this.setAppInfo(appName, taskName, prop);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public void createDeleteProperties(Properties prop) throws UnknownResourceTypeException, WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeleteProperties", prop);
        }
        Boolean create = (Boolean)this.getReferenceProperties().get("CREATERESOURCE");
        Boolean delete = (Boolean)this.getReferenceProperties().get("DELETERESOURCE");
        Boolean deleteAllContents = (Boolean)this.getReferenceProperties().get("DELETEALLCONTENTS");
        Properties[] props = (Properties[])this.getReferenceProperties().get("ALLSECTIONPROPERTIES");
        Hashtable<String, Object> options = new Hashtable<String, Object>(1);
        String appName = props[0].getProperty("Name");
        String update = props[0].getProperty("Update");
        String updateOperation = props[0].getProperty("operationType");
        String updateContentType = props[0].getProperty("contentType");
        String updateContentURI = props[0].getProperty("contentURI");
        String updateFileContentURI = props[0].getProperty("contentFile");
        String deployEJB = props[0].getProperty("deployEJB");
        String useDefaultBindings = props[0].getProperty("useDefaultBinding");
        String earLocation = props[0].getProperty("EarFileLocation");
        String targetNode = props[0].getProperty("TargetNode");
        String targetServer = props[0].getProperty("TargetServer");
        String targetCluster = props[0].getProperty("TargetCluster");
        String contextRoot = props[0].getProperty("contextRoot");
        Object targetMapping = null;
        String cellName = Application.getCellName();
        if (this.isValidating() && earLocation == null && update == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application.createDeleteProperties: Detected that we are trying to validate an application resource without an EarFileLocation or update flag.Assuming that the validation is for an app deletion section");
            }
            delete = new Boolean(true);
        }
        String serversForModules = "WebSphere:cell=" + cellName;
        options.put("cell.name", cellName);
        if (contextRoot != null) {
            options.put("contextroot", contextRoot);
        }
        if (delete != null && delete.booleanValue()) {
            try {
                this.performInstall("Uninstall", appName, earLocation, options, null, null, null);
            }
            catch (WASResourceOperationException e) {
                throw new WASResourceException((Throwable)e);
            }
        }
        try {
            if (update != null && update.equals("true")) {
                if (updateContentType.equals("file")) {
                    options.put("contenttype", "file");
                } else if (updateContentType.equals("modulefile")) {
                    options.put("contenttype", "modulefile");
                } else if (updateContentType.equals("partialapp")) {
                    options.put("contenttype", "partialapp");
                } else if (updateContentType.equals("app")) {
                    options.put("contenttype", "app");
                }
                if (deployEJB != null) {
                    options.put("deployejb.options", new Boolean(Boolean.getBoolean(deployEJB)));
                }
                if (useDefaultBindings != null) {
                    options.put("usedefaultbindings", new Boolean(Boolean.getBoolean(useDefaultBindings)));
                }
                this.performInstall("Update", appName, earLocation, options, updateContentURI, updateFileContentURI, updateOperation);
            } else {
                if (targetCluster != null) {
                    options.put("cluster.name", targetCluster);
                    serversForModules = serversForModules + ",cluster=" + targetCluster;
                } else if (targetNode != null) {
                    options.put("node.name", targetNode);
                    options.put("server.name", targetServer);
                    serversForModules = serversForModules + ",node=" + targetNode + ",server=" + targetServer;
                } else if (targetServer != null) {
                    throw new WASResourceException("Need both node and server for app install ");
                }
                this.performInstall("Install", appName, earLocation, options, null, null, null);
            }
        }
        catch (WASResourceOperationException e) {
            throw new WASResourceException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeleteProperties");
        }
    }

    public List queryRelationshipsByType(String type) {
        return new ArrayList();
    }

    public List getRelationships(String type, boolean recursive) {
        return new ArrayList();
    }

    public List getAllPropertyNames() {
        return new ArrayList();
    }

    private Properties getAppInfo(String appName, String propName) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppInfo", new Object[]{appName, propName});
        }
        Properties props = new Properties();
        try {
            Hashtable<String, Locale> optProps = new Hashtable<String, Locale>();
            optProps.put("app.client.locale", Locale.getDefault());
            AppManagement m = this.getAppMgr();
            Vector taskList = m.getApplicationInfo(appName, optProps, this.getSession().toString());
            for (int i = 0; i < taskList.size(); ++i) {
                AppDeploymentTask appDepTask = (AppDeploymentTask)taskList.get(i);
                String taskName = appDepTask.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "taskName ", taskName);
                }
                if (!taskName.equals(propName)) continue;
                props.setProperty("taskName", taskName);
                boolean[] mutables = appDepTask.getMutableColumns();
                String[] mutalbesString = new String[mutables.length];
                for (int k = 0; k < mutables.length; ++k) {
                    mutalbesString[k] = mutables[k] ? "true" : "false";
                }
                props.setProperty("mutables", this.getListValue(mutalbesString) + " #readonly");
                String[][] taskData = appDepTask.getTaskData();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "taskData ", taskData);
                }
                for (int j = 0; taskData != null && j < taskData.length; ++j) {
                    String pName = "row" + j;
                    String[] pValue = taskData[j];
                    String finalValue = null;
                    if (j == 0) {
                        finalValue = this.getListValue(pValue);
                        finalValue = finalValue + " #readonly";
                    } else {
                        finalValue = taskName.equals("MapModulesToServers") ? this.getListValue(pValue, true) : this.getListValue(pValue);
                    }
                    props.setProperty(pName, finalValue);
                }
            }
        }
        catch (Exception e) {
            throw new WASResourceOperationException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppInfo", props);
        }
        return props;
    }

    private void setAppInfo(String appName, String inTaskName, Properties props) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppInfo", new Object[]{appName, props});
        }
        try {
            Hashtable<String, Locale> optProps = new Hashtable<String, Locale>();
            optProps.put("app.client.locale", Locale.getDefault());
            AppManagement m = this.getAppMgr();
            Vector taskList = m.getApplicationInfo(appName, optProps, this.getSession().toString());
            boolean modified = false;
            for (int i = 0; i < taskList.size(); ++i) {
                AppDeploymentTask appDepTask = (AppDeploymentTask)taskList.get(i);
                String taskName = appDepTask.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "taskName ", taskName);
                }
                if (taskName.equals(inTaskName)) {
                    String[][] taskData = appDepTask.getTaskData();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "taskData ", taskData);
                    }
                    int propLen = props.size() - 1;
                    if (props.containsKey("mutables")) {
                        --propLen;
                    }
                    if (props.containsKey("taskName")) {
                        --propLen;
                    }
                    boolean dataChanged = false;
                    for (int j = 1; j < propLen + 1; ++j) {
                        String pName = "row" + j;
                        String propValue = props.getProperty(pName);
                        String[] pValue = this.getValues(propValue);
                        List indexList = this.getMatchingIndexList(pValue, appDepTask);
                        for (int k = 0; k < indexList.size(); ++k) {
                            Integer index = (Integer)indexList.get(k);
                            int inx = index;
                            if (this.taskDataChanged(taskData[inx], pValue, appDepTask.getMutableColumns(), inx)) {
                                dataChanged = true;
                            }
                            if (!dataChanged) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Data before ", this.convert(taskData[inx]));
                            }
                            this.setNewData(taskData[inx], pValue, appDepTask.getMutableColumns());
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Data changed to ", this.convert(taskData[inx]));
                        }
                    }
                    if (dataChanged) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Data set in appDepTask ");
                        }
                        appDepTask.setTaskData(taskData);
                        modified = true;
                    }
                }
                if (!modified) continue;
                m.setApplicationInfo(appName, optProps, this.getSession().toString(), taskList);
            }
        }
        catch (Exception e) {
            throw new WASResourceOperationException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppInfo");
        }
    }

    private void setNewData(String[] taskData, String[] newData, boolean[] mutables) {
        for (int i = 0; i < mutables.length; ++i) {
            if (!mutables[i]) continue;
            taskData[i] = newData[i];
        }
    }

    private String getListValue(String[] value) {
        return this.getListValue(value, false);
    }

    private String getListValue(String[] value, boolean variablize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListValue", value);
        }
        String result = "{";
        for (int i = 0; value != null && i < value.length; ++i) {
            String val = value[i];
            if (variablize && val != null && !val.equals("null") && val.startsWith("WebSphere:")) {
                EnvVariables varObject = (EnvVariables)this.getReferenceProperties().get("EnvironmentVariablesObject");
                val = PropertiesUtils.variablizeAppContext((String)val, (EnvVariables)varObject);
            }
            if (i != 0) {
                result = result + " ";
            }
            result = val == null ? result + "\"\"" : (val.contains(" ") ? result + "\"" + val + "\"" : (val.equals("") ? result + "\"\"" : result + val));
        }
        result = result + "}";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListValue", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void performInstall(String operation, String appName, String earLocation, Hashtable properties, String contentURI, String pathToContents, String updateType) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performInstall", new Object[]{operation, appName, earLocation, this});
        }
        File temp = null;
        AppInstallListener l = null;
        try {
            try {
                block29: {
                    AppManagement m;
                    block32: {
                        block31: {
                            File earFile;
                            if (!(!operation.equals("Install") || (earFile = new File(earLocation)).exists() && earFile.canRead())) {
                                TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
                                throw new AdminException(nls.getFormattedMessage("ADMA0176E", new Object[]{appName, earLocation}, "Application installation of {0} faild with PrivilegedActionException.  Ear file path is {1}."));
                            }
                            m = this.getAppMgr();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, operation + "ing J2EEAppAction...");
                            }
                            temp = File.createTempFile(appName, ".ear");
                            l = new AppInstallListener(appName, temp);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Created listener " + l);
                            }
                            AppInstallListener nls = l;
                            // MONITORENTER : nls
                            if (!operation.equals("Install")) break block31;
                            l.setWaitTarget("InstallApplication");
                            if (AdminServiceFactory.getAdminService() == null) {
                                m.installApplicationLocal(earLocation, appName, properties, l, this.getSession().toString());
                                break block29;
                            } else {
                                m.installApplication(earLocation, appName, properties, this.getSession().toString());
                            }
                            break block29;
                        }
                        if (!operation.equals("Update")) break block32;
                        l.setWaitTarget("UpdateApplication");
                        if (updateType != null || contentURI != null || pathToContents != null) {
                            if (AdminServiceFactory.getAdminService() == null) {
                                m.updateApplicationLocal(appName, contentURI, pathToContents, updateType, properties, l, this.getSession().toString());
                                break block29;
                            } else {
                                m.updateApplication(appName, contentURI, pathToContents, updateType, properties, this.getSession().toString());
                            }
                            break block29;
                        } else if (AdminServiceFactory.getAdminService() == null) {
                            m.redeployApplicationLocal(earLocation, appName, properties, l, this.getSession().toString());
                            break block29;
                        } else {
                            m.redeployApplication(earLocation, appName, properties, this.getSession().toString());
                        }
                        break block29;
                    }
                    if (operation.equals("Uninstall")) {
                        l.setWaitTarget("UninstallApplication");
                        if (AdminServiceFactory.getAdminService() == null) {
                            m.uninstallApplicationLocal(appName, properties, l, this.getSession().toString());
                        } else {
                            m.uninstallApplication(appName, properties, this.getSession().toString());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Start waiting for " + operation + " completion");
                }
                if (!l.isComplete()) {
                    try {
                        l.wait();
                    }
                    catch (InterruptedException ie) {
                        Tr.debug(tc, "Interrupted.  Continue...");
                    }
                }
                // MONITOREXIT : nls
                if (!l.isSuccess()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App operation " + operation + " failed.");
                    }
                    String msg = l.userError;
                    l = null;
                    throw new Exception("Application install/uninstall failed" + msg);
                }
                l = null;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.wasresource.resource.WebSphereDomain.performInstall", "100", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception while performinstall", e);
                }
                if (l == null) throw new WASResourceOperationException((Throwable)e);
                l.removeNotificationHandler();
                throw new WASResourceOperationException((Throwable)e);
            }
            Object var15_15 = null;
            if (temp != null && temp.exists()) {
                temp.delete();
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (temp == null) throw throwable;
            if (!temp.exists()) throw throwable;
            temp.delete();
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "performInstall");
    }

    private void installApplication(String appName, String earLocation, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installApplication", new Object[]{appName, earLocation, properties, this});
        }
        this.performInstall("Install", appName, earLocation, properties, null, null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "After InstallJ2EEAppAction");
        }
    }

    private void uninstallApplication(String appName, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installApplication", new Object[]{appName, properties, this});
        }
        this.performInstall("Uninstall", appName, "", properties, null, null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "After InstallJ2EEAppAction");
        }
    }

    private void updateApplication(String appName, String updateLocation, Hashtable properties) throws WASResourceOperationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplication", new Object[]{appName, updateLocation, properties, this});
        }
        this.performInstall("Update", appName, updateLocation, properties, null, null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplication");
        }
    }

    private AppManagement getAppMgr() throws WASResourceException {
        try {
            ConfigService cs = this.getConfigService();
            this.appManagement = cs instanceof ConfigServiceProxy ? AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)cs).getAdminClient()) : (AdminServiceFactory.getAdminService() == null ? AppManagementProxy.getLocalProxy() : AppManagementProxy.getJMXProxyForServer());
        }
        catch (Exception e) {
            throw new WASResourceException((Throwable)e);
        }
        return this.appManagement;
    }

    public static String getCellName() {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        String cellName = (adminService = AdminServiceFactory.getAdminService()) != null ? adminService.getCellName() : System.getProperty("local.cell");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", cellName);
        }
        return cellName;
    }

    private boolean appExists(String appName) throws WASResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appExists", appName);
        }
        boolean result = false;
        try {
            AppManagement m = this.getAppMgr();
            Hashtable<String, Locale> optProps = new Hashtable<String, Locale>();
            optProps.put("app.client.locale", Locale.getDefault());
            if (m.checkIfAppExists(appName, optProps, this.getSession().toString())) {
                result = true;
            }
        }
        catch (Exception e) {
            throw new WASResourceException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appExists", new Boolean(result));
        }
        return result;
    }

    private String[] getValues(String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValues", value);
        }
        String[] values = null;
        ArrayList<String> lst = new ArrayList<String>();
        String val = new String(value);
        int inx = val.indexOf("{");
        int einx = val.lastIndexOf("}");
        if (inx >= 0 && einx > 0) {
            val = val.substring(inx + 1, einx);
        }
        val = val.trim();
        int len = 0;
        int totlen = val.length();
        while (len < totlen) {
            String tok;
            int endIndex;
            if (val.startsWith("\"")) {
                endIndex = val.indexOf("\"", 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "inx = " + endIndex);
                }
                tok = val.substring(1, endIndex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tok = " + tok);
                }
                lst.add(tok);
                if ((len = len + tok.length() + 3) >= totlen) continue;
                val = val.substring(tok.length() + 3);
                continue;
            }
            endIndex = val.indexOf(" ");
            if (endIndex == -1) {
                endIndex = val.length();
            }
            tok = val.substring(0, endIndex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tok = " + tok);
            }
            lst.add(tok);
            if ((len = len + tok.length() + 1) >= totlen) continue;
            val = val.substring(tok.length() + 1);
        }
        values = lst.toArray(new String[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValues", values);
        }
        return values;
    }

    private boolean taskDataChanged(String[] taskData, String[] newData, boolean[] mutables, int i) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskDataChanged", new Object[]{this.convert(taskData), this.convert(newData), mutables, new Integer(i)});
        }
        boolean changed = true;
        if (this.dataSame(newData, taskData)) {
            changed = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskDataChanged", new Boolean(changed));
        }
        return changed;
    }

    private boolean dataSame(String[] newData, String[] oldData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dataSame", new Object[]{this.convert(newData), this.convert(oldData)});
        }
        boolean result = true;
        for (int i = 0; newData != null && i < newData.length; ++i) {
            String oldVal;
            String newVal = newData[i];
            String string = oldVal = oldData[i] == null ? "" : oldData[i];
            if (newVal.equals(oldVal)) continue;
            result = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dataSame", new Boolean(result));
        }
        return result;
    }

    private String[][] getTaskData(Properties props, int columns) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskData", new Object[]{props, new Integer(columns)});
        }
        String[][] returnData = null;
        if (props != null) {
            int rows = props.size() - 1;
            if (props.containsKey("mutables")) {
                --rows;
            }
            if (rows > 0) {
                returnData = new String[rows][];
                for (int i = 0; i < rows; ++i) {
                    String key = "row" + i;
                    returnData[i] = this.getValues(props.getProperty(key));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskData", this.convert(returnData));
        }
        return returnData;
    }

    private List getMatchingIndexList(String[] pValue, AppDeploymentTask task) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingIndexList", new Object[]{this.convert(pValue), task});
        }
        ArrayList<Integer> matchList = new ArrayList<Integer>();
        ArrayList<String> propNonMutables = new ArrayList<String>();
        boolean[] mutables = task.getMutableColumns();
        for (int i = 0; i < mutables.length; ++i) {
            if (mutables[i]) continue;
            propNonMutables.add(pValue[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "non mutable string in property ", this.listToString(propNonMutables));
        }
        String[][] taskData = task.getTaskData();
        for (int j = 0; taskData != null && j < taskData.length; ++j) {
            ArrayList<String> taskNonMutables = new ArrayList<String>();
            String[] tValue = taskData[j];
            for (int i = 0; i < mutables.length; ++i) {
                if (mutables[i]) continue;
                taskNonMutables.add(tValue[i]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "non mutable string in task ", this.listToString(taskNonMutables));
            }
            if (!this.listsMatch(propNonMutables, taskNonMutables)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matching row ", new Integer(j));
            }
            matchList.add(new Integer(j));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingIndexList", matchList);
        }
        return matchList;
    }

    private String listToString(List lst) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lst.size(); ++i) {
            sb = sb.append((String)lst.get(i)).append(":");
        }
        return sb.toString();
    }

    private boolean listsMatch(List lst1, List lst2) {
        boolean result = false;
        if (lst1.size() == lst2.size()) {
            result = true;
            for (int i = 0; i < lst1.size(); ++i) {
                String str2;
                String str1 = (String)lst1.get(i);
                if (str1.equals(str2 = (String)lst2.get(i)) || str1.equals("*")) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private String convert(String[][] table) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; table != null && i < table.length; ++i) {
            String[] row = table[i];
            for (int j = 0; row != null && j < row.length; ++j) {
                sb = sb.append(row[j]).append(",");
            }
            sb.append("#");
        }
        return sb.toString();
    }

    private String convert(String[] row) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; row != null && j < row.length; ++j) {
            sb = sb.append(row[j]).append(",");
        }
        return sb.toString();
    }

    private class AppInstallListener
    implements AppNotification.Listener,
    NotificationListener {
        private ObjectName appmgmtMBean = null;
        private String appName;
        private File earFile;
        private boolean success = false;
        private boolean complete = false;
        private String task = null;
        private String userError = null;
        private String waitTarget = null;

        public AppInstallListener(String appName, File earFile) {
            this.appName = appName;
            this.earFile = earFile;
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    Set match;
                    String process = adminService.getProcessName();
                    String node = adminService.getNodeName();
                    String query = "WebSphere:type=AppManagement,node=" + node + ",process=" + process + ",*";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "query", query);
                    }
                    if ((match = adminService.queryNames(new ObjectName(query), null)).size() >= 1) {
                        this.appmgmtMBean = (ObjectName)match.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appmgmtMBean", this.appmgmtMBean);
                        }
                        adminService.addNotificationListener(this.appmgmtMBean, this, null, null);
                    }
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", ex);
                }
                FFDCFilter.processException(ex, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "313");
            }
        }

        public void handleNotification(Notification notf, Object handback) {
            Object ud;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notf, handback, this});
            }
            if ((ud = notf.getUserData()) instanceof AppNotification) {
                this.appEventReceived((AppNotification)ud);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received irrelevant event", ud);
            }
            if (this.complete) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removed listener " + this);
                    }
                    AdminServiceFactory.getAdminService().removeNotificationListener(this.appmgmtMBean, this);
                }
                catch (Exception ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception", ex);
                    }
                    FFDCFilter.processException(ex, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "331");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification ev) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appEventReceived", ev);
            }
            String thisAppName = ev.props.getProperty("appname");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "thisAppName", thisAppName);
            }
            if (this.appName.equals(thisAppName)) {
                if (ev.taskStatus.equals("Completed")) {
                    this.success = true;
                    this.complete = true;
                    this.task = ev.taskName;
                } else if (ev.taskStatus.equals("Failed")) {
                    this.success = false;
                    this.complete = true;
                    this.task = ev.taskName;
                } else {
                    this.complete = false;
                }
                if (this.complete) {
                    if (ev.taskName.equals(this.waitTarget)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "", thisAppName);
                        }
                        this.waitTarget = null;
                        this.notifyAll();
                    } else if (this.waitTarget.equals("UpdateApplication") && ev.taskName.equals("InstallApplication")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "", thisAppName);
                        }
                        this.waitTarget = null;
                        this.notifyAll();
                    } else if (!this.success) {
                        this.waitTarget = null;
                        this.notifyAll();
                    } else {
                        this.complete = false;
                    }
                }
            }
            this.userError = ev.message;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appEventReceived");
            }
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String getTask() {
            return this.task;
        }

        public void setWaitTarget(String target) {
            this.waitTarget = target;
        }

        public void removeNotificationHandler() {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed listener " + this);
                }
                AdminServiceFactory.getAdminService().removeNotificationListener(this.appmgmtMBean, this);
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unexpected exception", ex);
                }
                FFDCFilter.processException(ex, "com.ibm.ws.management.configarchive.ConfigArchiveUtils.AppInstallListener", "331");
            }
        }
    }
}

