/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.cmdframework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.DownloadFile;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CustomProperties;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.MiscUtils;
import com.ibm.ws.util.ImplFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class CommandUtility {
    private static TraceComponent tc = Tr.register(CommandUtility.class, "CommandUtility", "com.ibm.ws.management.cmdframework");
    private static HashMap adminclientToMbeanMap = new HashMap();

    public static ObjectName getRemoteCmdMgrMbean(AdminClient inAdminClient) throws InstanceNotFoundException, ConnectorException {
        ObjectName remoteCmdMgrMbean;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteCmdMgrMbean");
        }
        if ((remoteCmdMgrMbean = (ObjectName)adminclientToMbeanMap.get(inAdminClient)) == null) {
            ObjectName match;
            block7: {
                match = null;
                ObjectName server = inAdminClient.getServerMBean();
                if (server == null) {
                    throw new InstanceNotFoundException(match.getCanonicalName());
                }
                String process = server.getKeyProperty("process");
                String objectNameString = "WebSphere:type=RemoteCommandMgr,process=" + process + ",*";
                try {
                    match = new ObjectName(objectNameString);
                }
                catch (MalformedObjectNameException ex) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Malformed object name");
                }
            }
            Set remoteCmdMgrMbeans = inAdminClient.queryNames(match, null);
            if (remoteCmdMgrMbeans.size() == 0) {
                throw new InstanceNotFoundException(match.getCanonicalName());
            }
            remoteCmdMgrMbean = (ObjectName)remoteCmdMgrMbeans.iterator().next();
            adminclientToMbeanMap.put(inAdminClient, remoteCmdMgrMbean);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteCmdMgrMbean");
        }
        return remoteCmdMgrMbean;
    }

    public static EObject clone(EObject source) {
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.setPreserveIds(false);
        copyGroup.add(source);
        EtoolsCopyUtility.createCopy(copyGroup);
        List objList = copyGroup.getCopiedRefObjects();
        if (objList.size() > 0) {
            return (EObject)objList.get(0);
        }
        return null;
    }

    static HashMap handleDownloadFileParamsBeforeExecute(AdminCommand cmd, AdminClient adminClient) throws Exception {
        HashMap downloadFiles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleDownloadFileParamsBeforeExecute", adminClient);
        }
        if ((downloadFiles = CommandUtility.getTypedParams(cmd, "com.ibm.websphere.management.cmdframework.DownloadFile")).size() > 0) {
            if (MiscUtils.isLocalAdminClient(adminClient)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "client is local");
                }
                Set entries = downloadFiles.entrySet();
                Iterator i$ = entries.iterator();
                while (i$.hasNext()) {
                    Map.Entry objEntry;
                    Map.Entry entry = objEntry = i$.next();
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    DownloadFile downloadFile = (DownloadFile)pair.origValue;
                    File localFile = new File(downloadFile.getPath());
                    String name = localFile.getName();
                    while (name.length() < 3) {
                        name = name + "C";
                    }
                    File scriptingTempDirectory = null;
                    if (AdminHelper.getPlatformHelper().isZOS()) {
                        String scriptingTempProperty = System.getProperty("user.install.root") + "/temp";
                        if (scriptingTempProperty != null) {
                            scriptingTempDirectory = new File(scriptingTempProperty);
                        }
                        if (tc.isDebugEnabled() && scriptingTempDirectory != null) {
                            Tr.debug(tc, "local client on ZOS Platform - using scripting temp directory " + scriptingTempDirectory.getCanonicalPath());
                        }
                    }
                    File tmpFile = File.createTempFile(name, null, scriptingTempDirectory);
                    String tempPath = tmpFile.getCanonicalPath();
                    tempPath = tempPath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempPath", tempPath);
                    }
                    pair.tempValue = new DownloadFile(tempPath);
                    cmd.setOrigParameterValue(paramName, pair.origValue);
                    cmd.setParameter(paramName, pair.tempValue);
                }
            } else {
                FileTransferClient transfer = CommandUtility.getTransfer(adminClient);
                String stagingDir = transfer.getServerStagingLocation();
                Set entries = downloadFiles.entrySet();
                for (Map.Entry entry : entries) {
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    DownloadFile downloadFile = (DownloadFile)pair.origValue;
                    File localFile = new File(downloadFile.getPath());
                    String tempFileName = System.currentTimeMillis() + localFile.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempFileName", tempFileName);
                    }
                    String tempPath = stagingDir + tempFileName;
                    tempPath = tempPath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempPath", tempPath);
                    }
                    pair.tempValue = new DownloadFile(tempFileName);
                    cmd.setParameter(paramName, new DownloadFile(tempPath));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleDownloadFileParamsBeforeExecute", downloadFiles);
        }
        return downloadFiles;
    }

    static void downloadFiles(AdminClient adminClient, HashMap downloadFiles) throws Exception {
        block12: {
            if (downloadFiles.size() <= 0) break block12;
            Set entries = downloadFiles.entrySet();
            if (MiscUtils.isLocalAdminClient(adminClient)) {
                Iterator i$ = entries.iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    DownloadFile downloadFile = (DownloadFile)pair.origValue;
                    File src = new File(((DownloadFile)pair.tempValue).getPath());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "src", src);
                    }
                    File dest = new File(((DownloadFile)pair.origValue).getPath());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dest", dest);
                    }
                    MiscUtils.copyFile(dest, src, true);
                }
            } else {
                FileTransferClient transfer = CommandUtility.getTransfer(adminClient);
                for (Map.Entry entry : entries) {
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    DownloadFile downloadFile = (DownloadFile)pair.origValue;
                    FileTransferOptions options = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
                    options.setDeleteSourceOnCompletion(true);
                    String src = ((DownloadFile)pair.tempValue).getPath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "src", src);
                    }
                    File dest = new File(((DownloadFile)pair.origValue).getPath());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "dest", dest);
                    }
                    transfer.downloadFile(src, dest.getAbsoluteFile(), options);
                }
            }
        }
    }

    static HashMap handleUploadFileParamsBeforeExecute(AdminCommand cmd, AdminClient adminClient) throws Exception {
        HashMap uploadFiles;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleUploadFileParamsBeforeExecute", adminClient);
        }
        if ((uploadFiles = CommandUtility.getTypedParams(cmd, "com.ibm.websphere.management.cmdframework.UploadFile")).size() > 0) {
            if (MiscUtils.isLocalAdminClient(adminClient)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "client is local");
                }
                Set entries = uploadFiles.entrySet();
                Iterator i$ = entries.iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    UploadFile uploadFile = (UploadFile)pair.origValue;
                    File localFile = new File(uploadFile.getPath());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localFile", localFile);
                    }
                    if (!localFile.exists()) {
                        throw new InvalidParameterValueException(cmd.getName(), paramName, uploadFile);
                    }
                    String fileName = localFile.getName();
                    String tempDirPath = MiscUtils.getTempDirPath();
                    File tempDir = new File(tempDirPath);
                    File tempFile = new File(tempDir, System.currentTimeMillis() + UploadFile.tempFileNameSeparator + fileName);
                    MiscUtils.copyFile(tempFile, localFile, false);
                    String tempPath = tempFile.getCanonicalPath();
                    tempPath = tempPath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempPath", tempPath);
                    }
                    cmd.setOrigParameterValue(paramName, pair.origValue);
                    cmd.setParameter(paramName, new UploadFile(tempPath));
                }
            } else {
                FileTransferClient transfer = CommandUtility.getTransfer(adminClient);
                String stagingDir = transfer.getServerStagingLocation();
                Set entries = uploadFiles.entrySet();
                for (Map.Entry entry : entries) {
                    String paramName = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "paramName", paramName);
                    }
                    ParamValuePair pair = (ParamValuePair)entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "pair", pair);
                    }
                    UploadFile uploadFile = (UploadFile)pair.origValue;
                    File localFile = new File(uploadFile.getPath());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "localFile", localFile);
                    }
                    String tempFileName = "upload/" + System.currentTimeMillis() + UploadFile.tempFileNameSeparator + localFile.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempFileName", tempFileName);
                    }
                    if (!localFile.exists()) {
                        throw new InvalidParameterValueException(cmd.getName(), paramName, uploadFile);
                    }
                    transfer.uploadFile(localFile, tempFileName);
                    String tempPath = stagingDir + tempFileName;
                    tempPath = tempPath.replace('\\', '/');
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "tempPath", tempPath);
                    }
                    cmd.setParameter(paramName, new UploadFile(tempPath));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleUploadFileParamsBeforeExecute", uploadFiles);
        }
        return uploadFiles;
    }

    private static HashMap getTypedParams(AdminCommand cmd, String type) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTypedParams", type);
        }
        EList paramMetadatas = cmd.getCommandMetadata().getParameters();
        HashMap<String, ParamValuePair> result = new HashMap<String, ParamValuePair>();
        for (ParameterMetadata paramMetadata : paramMetadatas) {
            Object val;
            if (!paramMetadata.getType().equals(type) || (val = cmd.getParameter(paramMetadata.getName())) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "detect DownloadFile parameter " + paramMetadata.getName() + " value is " + val);
            }
            result.put(paramMetadata.getName(), new ParamValuePair(val, null));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTypedParams", result);
        }
        return result;
    }

    private static FileTransferClient getTransfer(AdminClient adminClient) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransfer", adminClient);
        }
        Class<?> fileTransFacCls = Class.forName("com.ibm.ws.management.fileservice.FileTransferFactory");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "fileTransFacCls", fileTransFacCls);
        }
        Method method2 = fileTransFacCls.getMethod("getFileTransferClient", AdminClient.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "method", method2);
        }
        FileTransferClient transfer = (FileTransferClient)method2.invoke(null, adminClient);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransfer", transfer);
        }
        return transfer;
    }

    public static boolean isAsyncCmd(CommandMetadata metadata2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkAsyncCmd", metadata2);
        }
        boolean isAsync = false;
        EList customList = metadata2.getCustom();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "customList size " + customList.size());
        }
        for (int i = 0; i < customList.size(); ++i) {
            CustomProperties cp = (CustomProperties)customList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "customList property is " + cp);
            }
            String key = cp.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "key is " + key);
            }
            if (!key.equalsIgnoreCase("async")) continue;
            EList valueList = cp.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value list size is " + valueList.size());
            }
            if (valueList.size() <= 0) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value is " + (String)valueList.get(0));
            }
            isAsync = Boolean.valueOf((String)valueList.get(0));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkAsyncCmd", new Boolean(isAsync));
        }
        return isAsync;
    }

    private static class ParamValuePair {
        public Object origValue = null;
        public Object tempValue = null;

        public ParamValuePair(Object orig, Object temp) {
            this.origValue = orig;
            this.tempValue = temp;
        }

        public String toString() {
            return "ParamValuePair: origValue=" + this.origValue + ", tempValue=" + this.tempValue;
        }
    }
}

