/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.ApplicationbndFactoryImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.AppManagementHelper;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.BindJndiForEJBMessageBindingHelper;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.tools.UnmanagedNode;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.security.config.securitydomain.SecDomainHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateAppTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(ValidateAppTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final int[][] VERSIONS;

    public ValidateAppTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean performTask() throws AdminException {
        boolean result;
        block30: {
            Archive earFile;
            block31: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "performTask");
                }
                result = true;
                Vector<String> msgs = new Vector<String>();
                earFile = null;
                try {
                    try {
                        Hashtable nodeVersionTable;
                        block33: {
                            int rarVersion;
                            int earVersion;
                            int appVersion;
                            List options;
                            block32: {
                                options = null;
                                appVersion = 0;
                                earVersion = 0;
                                rarVersion = 0;
                                Hashtable moduleToServerMap = (Hashtable)this.scheduler.getProperties().get("moduleToServer");
                                nodeVersionTable = AppDeploymentUtil.getNodeVersionForAppTargets(moduleToServerMap, this.scheduler.getCellContext(), this.scheduler.getWorkSpace());
                                if (this.scheduler instanceof InstallScheduler || this.scheduler instanceof EditScheduler) {
                                    earFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile(false, true) : ((EditScheduler)this.scheduler).getEarFile();
                                    earVersion = EarUtils.getAppVersionForDeployment((EARFile)earFile);
                                    options = ValidateAppTask.getSelectedOptions((EARFile)earFile, this.scheduler.getProperties(), this.scheduler.getWorkSpace());
                                    this.validateMultiDomain(msgs, (EARFile)earFile, this.scheduler.getProperties());
                                    appVersion = ValidateAppTask.getAppVersion((EARFile)earFile, options);
                                    rarVersion = ValidateAppTask.getHighestRarVersion((EARFile)earFile);
                                    AppDeploymentInfo info = AppInstallHelper.getAppDeploymentInfo((EARFile)earFile);
                                    BindJndiForEJBMessageBindingHelper helper = new BindJndiForEJBMessageBindingHelper();
                                    AppDeploymentTask task = helper.createTask(null, "BindJndiForEJBMessageBinding");
                                    helper.prepareTask(info, task);
                                    Vector mdbMsgs = AppDeploymentUtil.MDBValidation(nodeVersionTable, moduleToServerMap, task);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Messages from MDBValidation: " + mdbMsgs);
                                    }
                                    msgs.addAll(mdbMsgs);
                                    Vector ejbMsgs = AppDeploymentUtil.validateLightweightEJBs((EARFile)earFile, nodeVersionTable);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Messages from LightweightEJBs validation: " + ejbMsgs);
                                    }
                                    msgs.addAll(ejbMsgs);
                                    this.validateAppTargets(msgs, moduleToServerMap);
                                    Vector envMsgs = AppDeploymentUtil.envEntryValidation((EARFile)earFile, this.getResourceBundle());
                                    for (int i = 0; i < envMsgs.size(); ++i) {
                                        String error = (String)envMsgs.elementAt(i);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "error " + error);
                                        }
                                        this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", error, null));
                                    }
                                }
                                Archive module = null;
                                if (!(this.scheduler instanceof UpdateScheduler)) break block32;
                                UpdateScheduler ush = (UpdateScheduler)this.scheduler;
                                if (!ush.getContentType().equals("modulefile") || ush.getOperation().equalsIgnoreCase("delete")) break block33;
                                module = ush.getContentAsArchive(true, false);
                                int moduleVersion = 0;
                                moduleVersion = module.isRARFile() ? ValidateAppTask.getOldModuleVersion(module) : ValidateAppTask.getModuleVersion(module);
                                Vector currentTargets = new Vector();
                                HashMap props = new HashMap();
                                earFile = this.getInfoForUpdate(ush, currentTargets, props);
                                if (props.containsKey("skipTargetValidation")) break block33;
                                options = ValidateAppTask.getSelectedOptions(this.scheduler.getProperties());
                                if (props.containsKey("useAutoLink")) {
                                    options.add("useAutoLink");
                                }
                                msgs.addAll(AppDeploymentUtil.appValidation(moduleVersion, moduleVersion, moduleVersion, options, nodeVersionTable, (EARFile)earFile, AppDeploymentUtil.getNodeVersionForAppTargets(currentTargets, this.scheduler.getCellContext().getName(), this.scheduler.getWorkSpace()), module, this.scheduler.getWorkSpace().getUserName()));
                                break block33;
                            }
                            Vector appmsg = AppDeploymentUtil.appValidation(rarVersion, earVersion, appVersion, options, nodeVersionTable, (EARFile)earFile, this.scheduler.getWorkSpace().getUserName());
                            for (int i = 0; i < appmsg.size(); ++i) {
                                String msg = (String)appmsg.get(i);
                                if (msgs.contains(msg)) continue;
                                msgs.add(msg);
                            }
                        }
                        this.validateTargetForRelationship(nodeVersionTable, msgs);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Messages from AppValidationTask: " + msgs);
                        }
                        if (nodeVersionTable != null) {
                            this.scheduler.getProperties().put("nodeVersionTable", nodeVersionTable);
                        }
                        try {
                            Vector vHelpers = new Vector();
                            ArrayList errors = new ArrayList();
                            ExtensionHelper.provideValidationExtensions(vHelpers);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Validation helpers are: " + vHelpers);
                            }
                            for (int i = 0; i < vHelpers.size(); ++i) {
                                AppManagementExtensions.AppValidationHelper h = (AppManagementExtensions.AppValidationHelper)vHelpers.elementAt(i);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Processing helper: " + h);
                                }
                                h.validateOperation_Required(this.scheduler, errors);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "validation errors = " + errors);
                            }
                            if (errors.size() > 0) {
                                msgs.addAll(errors);
                            }
                        }
                        catch (Throwable th) {
                            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "272", this);
                        }
                        if (msgs.size() == 0) {
                            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5058I", new Object[0]));
                            Object var19_25 = null;
                            if (earFile == null) break block30;
                            break block31;
                        }
                        StringBuffer concat = new StringBuffer();
                        int i = 0;
                        while (true) {
                            if (i >= msgs.size()) {
                                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5055E", new String[]{this.scheduler.getAppName(), concat.toString()}));
                            }
                            concat.append("\n" + (String)msgs.elementAt(i));
                            ++i;
                        }
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "performTask", "292", this);
                        if (th instanceof AdminException) {
                            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", th.getMessage(), null));
                            throw (AdminException)th;
                        }
                        String msg = AppUtils.getMessage(this.getResourceBundle(), "ADMA5057E", new String[]{th.toString()});
                        this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", msg, null));
                        throw new AdminException(th, msg);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_26 = null;
                    if (earFile != null && this.scheduler instanceof UpdateScheduler) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "closing ear");
                        }
                        earFile.close();
                    }
                    throw throwable;
                }
            }
            if (this.scheduler instanceof UpdateScheduler) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "closing ear");
                }
                earFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(result));
        }
        return result;
    }

    private static List getSelectedOptions(EARFile earFile, Hashtable tbl, WorkSpace ws) throws Exception {
        boolean autoLink;
        Resource r;
        List l;
        EnhancedEarConfigurator enh;
        boolean useBinaryConfig;
        boolean enhancedEarDisable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectedOptions", tbl);
        }
        boolean allAuthRealms = false;
        RoleAssignment newRa = ApplicationbndFactoryImpl.getActiveFactory().createRoleAssignment();
        if (newRa != null) {
            EList specialS;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found roleAssignment", newRa);
            }
            if ((specialS = newRa.getSpecialSubjects()) != null) {
                Iterator i = specialS.iterator();
                while (i.hasNext()) {
                    String name = ((Subject)i.next()).getName();
                    if (name.equalsIgnoreCase("ALLAUTHINTRUSTEDREALMS") || name.equalsIgnoreCase("AllAuthentictedInTrustedRealms")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found AllAuthentictedInTrustedRealms:", name);
                        }
                        allAuthRealms = true;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Didn't find AllAuthentictedInTrustedRealms:", name);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SpecialS is : ", specialS);
            }
        }
        ArrayList<String> options = new ArrayList<String>();
        boolean deployEJB = tbl.get("deployejb") != null && tbl.get("deployejb").equals(Boolean.TRUE);
        boolean preCompileJsp = tbl.get("preCompileJSPs") != null && tbl.get("preCompileJSPs").equals(Boolean.TRUE);
        boolean bl = enhancedEarDisable = tbl.get("enhancedEarDisableValidation") != null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enhancedEarDisable " + enhancedEarDisable);
        }
        boolean deployWS = tbl.get("deployws") != null && tbl.get("deployws").equals(Boolean.TRUE);
        boolean bl2 = useBinaryConfig = tbl.get("useMetaDataFromBinary") != null && tbl.get("useMetaDataFromBinary").equals(Boolean.TRUE);
        if (deployEJB) {
            options.add("deployejb");
        }
        if (preCompileJsp) {
            options.add("preCompileJSPs");
        }
        if (!enhancedEarDisable && (enh = new EnhancedEarConfigurator(ws, earFile, true, "default", "appName", "appName.ear_")).isEnhancedEar() && (l = enh.getDeploymentResources()).size() == 1 && !(r = (Resource)l.get(0)).getURI().toString().endsWith("deployment.xml")) {
            options.add("enhancedEar");
        }
        if (deployWS) {
            options.add("deployws");
        }
        if (useBinaryConfig) {
            options.add("useMetaDataFromBinary");
        }
        if (allAuthRealms) {
            options.add("role.all.auth.realms");
        }
        boolean bl3 = autoLink = tbl.get("useAutoLink") != null && tbl.get("useAutoLink").equals(Boolean.TRUE);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "autoLink: " + autoLink);
        }
        if (autoLink) {
            options.add("useAutoLink");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectedOptions", options);
        }
        return options;
    }

    private static List getSelectedOptions(Hashtable tbl) throws Exception {
        boolean deployWS;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectedOptions", tbl);
        }
        ArrayList<String> options = new ArrayList<String>();
        boolean deployEJB = tbl.get("deployejb") != null && tbl.get("deployejb").equals(Boolean.TRUE);
        boolean preCompileJsp = tbl.get("preCompileJSPs") != null && tbl.get("preCompileJSPs").equals(Boolean.TRUE);
        boolean bl = deployWS = tbl.get("deployws") != null && tbl.get("deployws").equals(Boolean.TRUE);
        if (deployEJB) {
            options.add("deployejb");
        }
        if (preCompileJsp) {
            options.add("preCompileJSPs");
        }
        if (deployWS) {
            options.add("deployws");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectedOptions", options);
        }
        return options;
    }

    private static int getAppVersion(EARFile earFile, List options) throws Exception {
        if (options.size() > 0) {
            for (int i = 0; i < options.size(); ++i) {
                String deplOption = (String)options.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deplOption: " + deplOption);
                }
                if (!deplOption.equals("deployejb") && !deplOption.equals("preCompileJSPs") && !deplOption.equals("enhancedEar") && !deplOption.equals("deployws") && !deplOption.equals("useMetaDataFromBinary")) continue;
                int appVersion = VERSIONS[VERSIONS.length - 1][0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AppVersion: " + appVersion);
                }
                return appVersion;
            }
        }
        int appVersion = EarUtils.getAppVersionForDeployment((EARFile)earFile);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AppVersion: " + appVersion);
        }
        return appVersion;
    }

    private static int getHighestRarVersion(EARFile earFile) throws Exception {
        int rarVersion = 99;
        int highestRarVersion = 15;
        List rarFiles = earFile.getRARFiles();
        if (rarFiles.size() > 0) {
            for (RARFile rar : rarFiles) {
                rarVersion = rar.getDeploymentDescriptor().getVersionID();
                if (rarVersion < highestRarVersion) continue;
                rarVersion = highestRarVersion;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the highest rar version " + rarVersion);
        }
        return rarVersion;
    }

    private static int getModuleVersion(Archive arc) throws Exception {
        ModuleFile moduleFile = null;
        if (arc instanceof ModuleFile) {
            moduleFile = (ModuleFile)arc;
        }
        return AppDeploymentUtil.getModuleVersion(moduleFile);
    }

    private static int getOldModuleVersion(Archive arc) throws Exception {
        ModuleFile moduleFile = null;
        if (arc instanceof ModuleFile) {
            moduleFile = (ModuleFile)arc;
        }
        int version = ((XMLResource)moduleFile.getDeploymentDescriptorResource()).getVersionID();
        return version;
    }

    private void validateMultiDomain(Vector msgs, EARFile ear, Hashtable tbl) throws Throwable {
        Object obj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMultiDomain", new Object[]{ear, tbl});
        }
        if (tbl != null && (obj = tbl.get("moduleToServer")) != null && obj instanceof Hashtable) {
            ObjectName query;
            ObjectName[] cells;
            Hashtable origData = (Hashtable)obj;
            Hashtable<String, String> modData = new Hashtable<String, String>();
            Enumeration keys = origData.keys();
            while (keys.hasMoreElements()) {
                String keyName = (String)keys.nextElement();
                if (keyName.contains("+")) {
                    modData.put(keyName.substring(0, keyName.indexOf("+")), (String)origData.get(keyName));
                    continue;
                }
                if (keyName.equals("*")) {
                    if (ear != null) {
                        List modules = ear.getModuleFiles();
                        for (ModuleFile mf : modules) {
                            if (mf == null) continue;
                            modData.put(mf.getName(), (String)origData.get(keyName));
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "WARNING:  EarFile is null!! Ignore and let other task fail", ear);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "WARNING:  Module name can't be read correctly becuase it doesn't have+ or * in it's key.", origData);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "updated modData:  ", modData);
            }
            String cellType = null;
            ConfigService cfgSrv = ConfigServiceFactory.getConfigService();
            Session session = new Session();
            if (cfgSrv == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configService is null!!!");
                }
                Properties props = new Properties();
                props.setProperty("location", "local");
                cfgSrv = ConfigServiceFactory.createConfigService(true, props);
            }
            if ((cells = cfgSrv.queryConfigObjects(session, null, query = ConfigServiceHelper.createObjectName(null, "Cell"), null)) != null && cells.length > 0) {
                ObjectName cell = cells[0];
                cellType = (String)cfgSrv.getAttribute(session, cell, "cellType");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cellType:  ", cellType);
            }
            String processType = null;
            processType = !cellType.equals("STANDALONE") ? "DeploymentManager" : "UnManagedProcess";
            if (AdminServiceFactory.getAdminService() != null) {
                processType = AdminServiceFactory.getAdminService().getProcessType();
            }
            String status = SecDomainHelper.validateMultiDomain(modData, cfgSrv, AppManagementImpl.isLocalMode(), processType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateMultiDomain", "status=" + status);
            }
            if (status != null) {
                if (status.startsWith("SECJ7783W")) {
                    this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Warning", status, null));
                } else if (status.startsWith("SECJ7782E")) {
                    this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", status, null));
                    msgs.addElement(status);
                }
            }
            if (cfgSrv != null) {
                cfgSrv.discard(session);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMultiDomain");
        }
    }

    private void validateTargetForRelationship(Hashtable nodeVersionTable, Vector msgs) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTargetForRelationship", new Object[]{nodeVersionTable});
        }
        Hashtable relTbl = (Hashtable)this.scheduler.getProperties().get("sharedLibRelationship");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "relTbl: " + relTbl);
        }
        if (relTbl != null && relTbl.size() > 0) {
            boolean check70Server = false;
            Enumeration keys = relTbl.keys();
            while (keys.hasMoreElements()) {
                String rels;
                String module = (String)keys.nextElement();
                Hashtable modRelTbl = (Hashtable)relTbl.get(module);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modRelTbl: " + modRelTbl);
                }
                if (AppUtils.isEmpty(rels = (String)modRelTbl.get("relationship"))) continue;
                check70Server = true;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "check for 7.0 server");
                break;
            }
            if (check70Server) {
                keys = nodeVersionTable.keys();
                while (keys.hasMoreElements()) {
                    List lstData = (List)nodeVersionTable.get(keys.nextElement());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "lstData =", lstData);
                    }
                    if (lstData == null) continue;
                    try {
                        List lstUnNode = new ArrayList();
                        lstUnNode = UnmanagedNode.listManagedNodes((Session)new Session(this.scheduler.getWorkSpace().getUserName(), true));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "List of managed node: ", lstUnNode);
                        }
                        for (int i = 0; i < lstData.size(); i += 4) {
                            String nodeName = (String)lstData.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "found nodeName =" + nodeName);
                            }
                            if (lstUnNode == null || lstUnNode.contains(nodeName)) {
                                int nodeVersion = Integer.parseInt((String)lstData.get(i + 1));
                                if (nodeVersion == 7) {
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "is a 7.x version node");
                                    continue;
                                }
                                msgs.add(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0201E", new String[]{nodeName, Integer.toString(nodeVersion)}));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Skipping Unmanaged Node: " + nodeName);
                        }
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "validateTargetForRelationship", "708", this);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTargetForRelationship");
        }
    }

    private void validateAppTargets(Vector<String> msgs, Hashtable<String, String> moduleToServerMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAppTargets", new String[]{"msgs=" + msgs, "moduleToServerMap=" + moduleToServerMap});
        }
        if (this.scheduler instanceof InstallScheduler) {
            boolean systemApp;
            InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
            String appName = this.scheduler.getAppName();
            Hashtable properties = this.scheduler.getProperties();
            String earPath = installScheduler.getEarPath();
            boolean bl = systemApp = AppManagementHelper.isSystemApp(earPath) || AppUtils.isSystemAppOption(properties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateAppTargets", "systemApp=" + systemApp);
            }
            if (!systemApp) {
                String message;
                HashSet<String> targetServers = new HashSet<String>();
                for (Map.Entry<String, String> entry : moduleToServerMap.entrySet()) {
                    String[] serverArray;
                    String module = entry.getKey();
                    String servers = entry.getValue();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validateAppTargets", new String[]{"module=" + module, "servers=" + servers});
                    }
                    for (String server : serverArray = servers.split("\\+")) {
                        targetServers.add(server);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validateAppTargets", "targetServers=" + targetServers);
                }
                String sessionId = this.scheduler.getWorkSpace().getUserName();
                Session session = new Session(sessionId, true);
                HashSet<String> targetServerTypes = new HashSet<String>();
                for (String targetServer : targetServers) {
                    try {
                        ObjectName objectName = new ObjectName(targetServer);
                        String nodeName = objectName.getKeyProperty("node");
                        String serverName = objectName.getKeyProperty("server");
                        if (nodeName == null || serverName == null) continue;
                        String serverType = AppUtils.getServerType(serverName, nodeName, session);
                        targetServerTypes.add(serverType);
                    }
                    catch (Exception e) {
                        RasUtils.logException((Throwable)e, tc, CLASS_NAME, "validateAppTargets", "776", this);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "validateAppTargets", "targetServerTypes=" + targetServerTypes);
                }
                if (targetServerTypes.contains("ADMIN_AGENT")) {
                    message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0204E", new String[]{appName, "ADMIN_AGENT"});
                    msgs.add(message);
                }
                if (targetServerTypes.contains("JOB_MANAGER")) {
                    message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0204E", new String[]{appName, "JOB_MANAGER"});
                    msgs.add(message);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateAppTargets");
        }
    }

    private EARFile getInfoForUpdate(UpdateScheduler ush, Vector servers, HashMap props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInfoForUpdate");
        }
        if (props == null) {
            props = new HashMap<String, Boolean>();
        }
        EARFile earFile = null;
        RepositoryContext rc = AppUtils.findAppContextFromConfig(ush.getAppName(), ush.getWorkSpace(), ush.getProperties());
        if (rc == null) {
            return earFile;
        }
        Resource res = ConfigRepoHelper.getAppDeploymentResource(rc);
        if (res != null) {
            Deployment depl = (Deployment)res.getContents().get(0);
            ApplicationDeployment appDepl = (ApplicationDeployment)depl.getDeployedObject();
            boolean isAutoLink = appDepl.isAutoLink();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isAutoLink=" + isAutoLink);
            }
            if (isAutoLink) {
                props.put("useAutoLink", Boolean.TRUE);
            }
            if (!appDepl.isZeroBinaryCopy() && !appDepl.isZeroEarCopy()) {
                earFile = ConfigRepoHelper.getEarFileForApp(ush.getWorkSpace(), rc, this.bundle, true);
                servers.addAll(ConfigRepoHelper.getServersForAppDeployment(appDepl, null, rc.getParent().getParent(), this.scheduler.getWorkSpace(), false));
            } else {
                props.put("skipTargetValidation", true);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInfoForUpdate", new String[]{"servers=" + servers, "props=" + props});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInfoForUpdate", earFile);
        }
        return earFile;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/ValidateAppTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.56");
        }
        CLASS_NAME = ValidateAppTask.class.getName();
        VERSIONS = new int[][]{{12, 5}, {13, 5}, {14, 6}, {50, 6}};
    }
}

