/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.process.ServiceContext;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class UpdateClusterTask
extends AbstractTask
implements NotificationListener {
    private static TraceComponent tc = Tr.register(UpdateClusterTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static int SERVER_STOPPED;
    private static int SERVER_FAILED_TO_STOP;
    private static int SERVER_NOT_STARTED;
    private String waitObject = null;
    private String waitTarget = null;
    private static final long WAIT_TIME = 600000L;
    private static final long APPEXP_WAIT_TIME = 60L;
    private static final String APPEXP_WAIT_PROP = "com.ibm.websphere.management.application.updatesync.appExpansionTimeout";
    private String waitResult = null;
    private boolean waitStarting = false;
    private int launchTimeout;
    private Map autoSyncMap = new HashMap();
    private int appSyncEvtCount;
    private Hashtable appExpWaitResult = null;
    private HashMap hAppTargetTab = new HashMap();

    public UpdateClusterTask() {
        this.waitObject = new String("UpdateClusterTaskWaitObject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask() throws AdminException {
        Iterator it22;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        try {
            try {
                Hashtable apps_servers = this.getTargetServers(((UpdateClusterScheduler)this.scheduler).getAppNames());
                if (apps_servers.isEmpty()) {
                    result = false;
                    this.sendNotification("ADMA8021I", "InProgress", this.scheduler.getAppName());
                    throw new AdminException("Target server for a given list of applications is not found");
                }
                Hashtable nodeAppsTbl = new Hashtable();
                Hashtable nodeServers = new Hashtable();
                this.getNodeSeversAndNodeAppsRelation(this.scheduler.getWorkSpace(), nodeAppsTbl, nodeServers, apps_servers);
                Enumeration en = nodeServers.keys();
                Set set = nodeServers.keySet();
                for (RepositoryContext nc : set) {
                    Boolean autoSync = this.getAutoSyncEnabled(nc.getName());
                    if (autoSync != null && Boolean.TRUE.equals(autoSync)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Disabling Sync for Node: " + nc.getName());
                        }
                        this.setAutoSyncEnabled(nc.getName(), Boolean.FALSE);
                    }
                    this.autoSyncMap.put(nc.getName(), autoSync);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performing cluster update" + nodeServers);
                }
                while (en.hasMoreElements()) {
                    RepositoryContext nc;
                    nc = (RepositoryContext)en.nextElement();
                    String nodeName = nc.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node Name: " + nodeName);
                    }
                    Hashtable serverTypes = this.getServerTypes(nc);
                    boolean zosPause = this.zosPauseResume(nc);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "For node " + nodeName + ", zosPauseNodes = " + zosPause);
                    }
                    Vector sc = (Vector)nodeServers.get(nc);
                    boolean serverStopSuccess = false;
                    Vector sc1 = new Vector(sc);
                    for (int i = 0; i < sc.size(); ++i) {
                        String serverName;
                        block58: {
                            block60: {
                                int status;
                                block59: {
                                    String serverType;
                                    serverName = ((RepositoryContext)sc.elementAt(i)).getName();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "stopping " + serverName);
                                    }
                                    if ((serverType = (String)serverTypes.get(serverName)) == null || !serverType.equals("APPLICATION_SERVER")) break block58;
                                    this.setClusterMemberEnabled((RepositoryContext)sc.elementAt(i), nc, Boolean.FALSE);
                                    if (!zosPause) break block59;
                                    status = this.pauseServer((RepositoryContext)sc.elementAt(i), nc.getName(), serverName);
                                    if (status == SERVER_STOPPED || status == SERVER_NOT_STARTED) {
                                        serverStopSuccess = true;
                                        if (status == SERVER_NOT_STARTED) {
                                            sc1.remove(sc.elementAt(i));
                                        }
                                        break block60;
                                    } else {
                                        serverStopSuccess = false;
                                        sc1.remove(sc.elementAt(i));
                                    }
                                    break block60;
                                }
                                status = this.stopServer(nc.getName(), serverName);
                                if (status == SERVER_STOPPED || status == SERVER_NOT_STARTED) {
                                    serverStopSuccess = true;
                                    if (status == SERVER_NOT_STARTED) {
                                        sc1.remove(sc.elementAt(i));
                                    }
                                } else {
                                    serverStopSuccess = false;
                                    sc1.remove(sc.elementAt(i));
                                }
                            }
                            if (serverStopSuccess) continue;
                            break;
                        }
                        Tr.audit(tc, "Server " + serverName + " is not an Application Server. This server will not be restarted during application ripple of application" + this.scheduler.getAppName() + ".");
                        sc1.remove(sc.elementAt(i));
                    }
                    if (!serverStopSuccess) continue;
                    if (zosPause) {
                        Thread.sleep(10000L);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "syncing  " + nc.getName());
                    }
                    this.sendNotification("ADMA8005I", "NodeSyncInitiated", nc.getName());
                    Hashtable appSyncResults = new Hashtable();
                    appSyncResults.put("Completed", new Vector());
                    appSyncResults.put("Failed", new Vector());
                    appSyncResults.put("InProgress", new Vector());
                    Vector apps_node = (Vector)nodeAppsTbl.get(nc.getName());
                    if (sc1.size() > 0) {
                        ((Vector)appSyncResults.get("InProgress")).addAll(apps_node);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Servers in the node will not be started; so app expansion wait is not required");
                    }
                    if (this.synchNode(nc.getName(), appSyncResults)) {
                        this.sendNotification("ADMA8006I", "NodeSyncComplete", nc.getName());
                        if (((Vector)appSyncResults.get("Completed")).size() <= 0 && ((Vector)appSyncResults.get("Failed")).size() <= 0 && ((Vector)appSyncResults.get("InProgress")).size() <= 0) {
                            this.sendNotification("ADMA8031I", "AppDistributionNode", new Object[]{"", nc.getName()});
                        } else {
                            for (int appidx = 0; appidx < apps_node.size(); ++appidx) {
                                String app_name = (String)apps_node.get(appidx);
                                if (((Vector)appSyncResults.get("Completed")).contains(app_name)) {
                                    this.sendNotification("ADMA8028I", "AppDistributionNode", new Object[]{app_name, nc.getName()});
                                    continue;
                                }
                                if (((Vector)appSyncResults.get("Failed")).contains(app_name)) {
                                    this.sendNotification("ADMA8029E", "AppDistributionNode", new Object[]{app_name, nc.getName()});
                                    continue;
                                }
                                if (!((Vector)appSyncResults.get("InProgress")).contains(app_name)) continue;
                                this.sendNotification("ADMA8030W", "AppDistributionNode", new Object[]{app_name, nc.getName()});
                            }
                        }
                    } else {
                        this.sendNotification("ADMA8011I", "NodeSyncFailed", nc.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "synced  " + nc.getName());
                    }
                    this.establishLaunchTimeout();
                    for (int i = 0; i < sc1.size(); ++i) {
                        String serverName = ((RepositoryContext)sc1.elementAt(i)).getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "starting " + serverName);
                        }
                        if (zosPause) {
                            this.sendNotification("ADMA8024I", "ServerStarting", serverName);
                            if (this.resumeServer((RepositoryContext)sc1.elementAt(i), nc.getName(), serverName)) {
                                this.sendNotification("ADMA8025I", "ServerStarted", serverName);
                                this.setClusterMemberEnabled((RepositoryContext)sc1.elementAt(i), nc, Boolean.TRUE);
                                continue;
                            }
                            result = false;
                            this.sendNotification("ADMA8027I", "ServerStartFailed", serverName);
                            continue;
                        }
                        this.sendNotification("ADMA8007I", "ServerStarting", serverName);
                        if (this.startServer(nc.getName(), serverName)) {
                            this.sendNotification("ADMA8008I", "ServerStarted", serverName);
                            if (!this.applicationsStarted(nc.getName(), serverName)) {
                                this.sendNotification("ADMA8020I", "InProgress", serverName);
                            }
                            this.setClusterMemberEnabled((RepositoryContext)sc1.elementAt(i), nc, Boolean.TRUE);
                            continue;
                        }
                        result = false;
                        this.sendNotification("ADMA8010I", "ServerStartFailed", serverName);
                    }
                    int delay = 60;
                    try {
                        String sdelay = System.getProperty("com.ibm.ws.management.application.clusterupdate.nodedelay");
                        if (sdelay != null) {
                            delay = Integer.parseInt(sdelay);
                        }
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " invalid delay specified, using default delay of 60 secs");
                        }
                        delay = 60;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "waiting for " + new Integer(delay) + " secs before rippling the next node");
                    }
                    if (delay > 0) {
                        Thread.sleep(delay * 1000);
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "done wait. Started ripple of next node");
                }
                Object var20_28 = null;
                Set sync2222 = this.autoSyncMap.entrySet();
                it22 = sync2222.iterator();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cluster Update of cluster failed for application " + this.scheduler.getAppName());
                }
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8014I", new String[]{this.scheduler.getAppName()}));
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), e});
                boolean bl = result = false;
                Object var20_29 = null;
                Set sync2222 = this.autoSyncMap.entrySet();
                Iterator it22 = sync2222.iterator();
                while (true) {
                    Boolean aSync;
                    if (!it22.hasNext()) {
                        return bl;
                    }
                    Map.Entry me = it22.next();
                    if (me == null || me.getValue() == null || !(me.getValue() instanceof Boolean) || (aSync = (Boolean)me.getValue()) == null || !Boolean.TRUE.equals(aSync)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Re-enabling Sync for Node: " + (String)me.getKey());
                    }
                    this.setAutoSyncEnabled((String)me.getKey(), aSync);
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_30 = null;
            Set sync2222 = this.autoSyncMap.entrySet();
            Iterator it22 = sync2222.iterator();
            while (true) {
                Boolean aSync;
                if (!it22.hasNext()) {
                    throw throwable;
                }
                Map.Entry me = it22.next();
                if (me == null || me.getValue() == null || !(me.getValue() instanceof Boolean) || (aSync = (Boolean)me.getValue()) == null || !Boolean.TRUE.equals(aSync)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Re-enabling Sync for Node: " + (String)me.getKey());
                }
                this.setAutoSyncEnabled((String)me.getKey(), aSync);
            }
        }
        while (it22.hasNext()) {
            Boolean aSync;
            Map.Entry me = it22.next();
            if (me == null || me.getValue() == null || !(me.getValue() instanceof Boolean) || (aSync = (Boolean)me.getValue()) == null || !Boolean.TRUE.equals(aSync)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Re-enabling Sync for Node: " + (String)me.getKey());
            }
            this.setAutoSyncEnabled((String)me.getKey(), aSync);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClusterMemberEnabled(RepositoryContext serverCtx, RepositoryContext nodeCtx, Boolean enable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClusterMemberEnabled", new Object[]{serverCtx, nodeCtx, enable});
        }
        URI uri = URI.createURI("server.xml");
        Resource resource = serverCtx.getResourceSet().getResource(uri, true);
        if (resource == null || resource.getContents() == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Nothing to do because resource.getContents returned null!!!!");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setClusterMemberEnabled");
            }
            return;
        }
        Server server_obj = (Server)resource.getContents().get(0);
        String clusterName = server_obj.getClusterName();
        String serverName = serverCtx.getName();
        String nodeName = nodeCtx.getName();
        ObjectName clustOn = this.getClusterObjectName(clusterName);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "ClusterMbean", new Object[]{clustOn});
        }
        if (clustOn != null) {
            try {
                String string = this.waitObject;
                synchronized (string) {
                    if (Boolean.TRUE.equals(enable)) {
                        AdminServiceFactory.getAdminService().invoke(clustOn, "setAvailable", new Object[]{serverName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
                    } else {
                        AdminServiceFactory.getAdminService().invoke(clustOn, "setUnavailable", new Object[]{serverName, nodeName}, new String[]{"java.lang.String", "java.lang.String"});
                    }
                }
            }
            catch (Exception e) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClusterMemberEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean getAutoSyncEnabled(String node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoSyncEnabled", new Object[]{node});
        }
        Boolean ret = null;
        ObjectName nodeOn = this.getNodesyncObjectName(node);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{nodeOn});
        }
        if (nodeOn != null) {
            try {
                String string = this.waitObject;
                synchronized (string) {
                    ret = (Boolean)AdminServiceFactory.getAdminService().invoke(nodeOn, "getAutoSyncEnabled", new Object[0], new String[0]);
                }
            }
            catch (Exception e) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean setAutoSyncEnabled(String node, Boolean set) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoSyncEnabled", new Object[]{node, set});
        }
        Boolean ret = null;
        ObjectName nodeOn = this.getNodesyncObjectName(node);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "NodeSyncMbean", new Object[]{nodeOn});
        }
        if (nodeOn != null) {
            try {
                String string = this.waitObject;
                synchronized (string) {
                    AdminServiceFactory.getAdminService().invoke(nodeOn, "setAutoSyncEnabled", new Object[]{set}, new String[]{Boolean.class.getName()});
                }
                ret = Boolean.TRUE;
            }
            catch (Exception e) {
                Tr.error(tc, "ADMA8015I", new Object[]{this.scheduler.getAppName(), e});
                ret = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", new Object[]{set});
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int stopServer(String node, String server) {
        int ret;
        block26: {
            ObjectName on;
            ObjectName nodeOn;
            block24: {
                int n;
                block25: {
                    ret = SERVER_STOPPED;
                    nodeOn = this.getNodeagentObjectName(node);
                    on = this.getServerObjectName(node, server);
                    if (on != null) break block24;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, server + " appears to be stopped");
                    }
                    n = SERVER_NOT_STARTED;
                    Object var11_9 = null;
                    try {
                        if (nodeOn != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(nodeOn, this);
                        }
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
                return n;
            }
            this.sendNotification("ADMA8003I", "ServerStopping", server);
            String id = "UpdateCluster:" + node + ":" + server;
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.process.stopped");
            filter.enableType("websphere.process.failed");
            filter.enableType("websphere.process.starting");
            filter.enableType("websphere.process.stopping");
            filter.enableType("websphere.process.running");
            AdminServiceFactory.getAdminService().addNotificationListener(nodeOn, this, (NotificationFilter)filter, (Object)id);
            String string = this.waitObject;
            synchronized (string) {
                AdminServiceFactory.getAdminService().invoke(on, "stop", new Object[0], new String[0]);
                this.waitTarget = server;
                this.waitObject.wait(600000L);
                if (this.waitTarget != null) {
                    Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{server}));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timed out waiting for server to stop ", new String[]{server});
                    }
                    ret = SERVER_FAILED_TO_STOP;
                }
            }
            Object var11_10 = null;
            try {
                if (nodeOn != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(nodeOn, this);
                }
                break block26;
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to remove notification listener");
                }
                break block26;
            }
            {
                catch (Exception e) {
                    Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8009I", new String[]{server}));
                    ret = SERVER_FAILED_TO_STOP;
                    Object var11_11 = null;
                    try {
                        if (nodeOn != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(nodeOn, this);
                        }
                        break block26;
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to remove notification listener");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Object var11_12 = null;
                    try {
                        if (nodeOn != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(nodeOn, this);
                        }
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
                throw throwable;
            }
        }
        Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8004I", new String[]{server, this.scheduler.getAppName()}));
        if (ret == SERVER_STOPPED) {
            this.sendNotification("ADMA8004I", "ServerStopped", server);
        } else {
            this.sendNotification("ADMA8009I", "ServerStopFailed", server);
        }
        return ret;
    }

    private int pauseServer(RepositoryContext serverCtx, String node, String server) {
        int ret = SERVER_FAILED_TO_STOP;
        URI uri = URI.createURI("server.xml");
        Resource resource = serverCtx.getResourceSet().getResource(uri, true);
        if (resource == null || resource.getContents() == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Nothing to do because resource.getContents returned null!!!!");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "pauseServer");
            }
            return ret;
        }
        Server server_obj = (Server)resource.getContents().get(0);
        String pauseCmd = "MODIFY " + server_obj.getShortName() + ",PAUSELISTENERS";
        ObjectName mvsServices = this.getMVSServericesObjectName(node);
        if (mvsServices != null) {
            this.sendNotification("ADMA8022I", "ServerStopping", server);
            try {
                AdminServiceFactory.getAdminService().invoke(mvsServices, "issueCommand", new Object[]{pauseCmd}, new String[]{String.class.getName()});
                ret = SERVER_STOPPED;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() successfull for node:server " + node + ":" + server);
                }
                this.sendNotification("ADMA8023I", "ServerStopped", server);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pauseServer() Exception invoking MVSServices MBean ");
                    e.printStackTrace();
                    this.sendNotification("ADMA8026I", "ServerStopFailed", server);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "pauseServer() could not find MVSServices MBean ");
            }
            ret = SERVER_NOT_STARTED;
        }
        return ret;
    }

    private boolean resumeServer(RepositoryContext serverCtx, String node, String server) {
        boolean ret;
        block9: {
            ret = false;
            URI uri = URI.createURI("server.xml");
            Resource resource = serverCtx.getResourceSet().getResource(uri, true);
            if (resource == null || resource.getContents() == null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Nothing to do because resource.getContents returned null!!!!");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeServer");
                }
                return ret;
            }
            Server server_obj = (Server)resource.getContents().get(0);
            String resumeCmd = "MODIFY " + server_obj.getShortName() + ",RESUMELISTENERS";
            ObjectName mvsServices = this.getMVSServericesObjectName(node);
            if (mvsServices != null) {
                try {
                    AdminServiceFactory.getAdminService().invoke(mvsServices, "issueCommand", new Object[]{resumeCmd}, new String[]{String.class.getName()});
                    ret = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() successfull for node:server " + node + ":" + server);
                    }
                    break block9;
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resumeServer() Exception invoking MVSServices MBean ");
                        e.printStackTrace();
                    }
                    break block9;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resumeServer() could not find MVSServices MBean ");
            }
        }
        return ret;
    }

    private boolean zosPauseResume(RepositoryContext nodeContext) {
        boolean zosPause;
        block21: {
            ServiceContext server;
            block20: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "zosPauseResume");
                }
                zosPause = false;
                server = null;
                try {
                    RepositoryContextType serverContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("servers");
                    Collection serverContexts = nodeContext.findContext(serverContextType);
                    for (RepositoryContext serverContext : serverContexts) {
                        String serverName = serverContext.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found Repository Context for " + serverName);
                        }
                        if (serverName == null || !serverName.equalsIgnoreCase("nodeagent")) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NodeAgent Server Repository Context found");
                        }
                        ResourceSet resourceSet = serverContext.getResourceSet();
                        Resource resource = null;
                        Object refId = null;
                        String fileName = "server.xml";
                        try {
                            if (!serverContext.isExtracted(fileName)) {
                                serverContext.extract(fileName, false);
                            }
                            resource = resourceSet.createResource(URI.createURI(fileName));
                            resource.load(new HashMap());
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Exception loading NodeAgent server.xml");
                            e.printStackTrace();
                            continue;
                        }
                        EList collection = resource.getContents();
                        for (Object obj : collection) {
                            if (!(obj instanceof Server)) continue;
                            server = (Server)obj;
                            break;
                        }
                        if (server == null) continue;
                        break;
                    }
                }
                catch (Exception ex) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "Exception finding NodeAgent Server object");
                    ex.printStackTrace();
                }
            }
            if (server == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to find NodeAgent server.xml");
                }
            } else {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found Server object in the NodeAgent server.xml file");
                    }
                    Service srvc2 = null;
                    List props = null;
                    EList list = server.getServices();
                    for (Service srvc2 : list) {
                        if (!(srvc2 instanceof AdminService)) continue;
                        props = srvc2.getProperties();
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug(tc, "Found AdminService properties " + props);
                        break;
                    }
                    for (Property p : props) {
                        String key = p.getName();
                        if (!"com.ibm.websphere.zos.rollout.pauseresume".equals(key) || !"true".equalsIgnoreCase(p.getValue())) continue;
                        zosPause = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Pause/Resume enabled");
                        }
                        break;
                    }
                }
                catch (Exception exc) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "Exception finding Pause/Resume property");
                    exc.printStackTrace();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zosPauseResume");
        }
        return zosPause;
    }

    private ObjectName getMVSServericesObjectName(String nodeName) {
        try {
            String q = "WebSphere:type=MVSServices,node=" + nodeName + ",*";
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ObjectName mvsservicesObjectName = (ObjectName)itr.next();
            return mvsservicesObjectName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting MVSServices object");
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean startServer(String node, String server) {
        boolean serverUp;
        block35: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "UpdateClusterTask.startServer node: " + node + " Server: " + server);
            }
            ObjectName nodeagent = this.getNodeagentObjectName(node);
            com.ibm.websphere.management.AdminService admin = AdminServiceFactory.getAdminService();
            NotificationFilterSupport filter = new NotificationFilterSupport();
            filter.enableType("websphere.process.running");
            filter.enableType("websphere.process.failed");
            filter.enableType("websphere.process.starting");
            String id = "UpdateCluster:" + node + ":" + server;
            try {
                this.waitResult = null;
                this.waitTarget = server;
                this.waitStarting = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "startServer adds listener & launches thread... " + id);
                }
                admin.addNotificationListener(nodeagent, this, (NotificationFilter)filter, (Object)id);
                LaunchThread launchThread = new LaunchThread(node, server, this.launchTimeout);
                String pKey = AdminContext.peek();
                launchThread.setProfileKey(pKey);
                launchThread.setDaemon(true);
                launchThread.start();
            }
            catch (Exception e) {
                block34: {
                    Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8010I", new String[]{server}));
                    try {
                        if (nodeagent != null) {
                            admin.removeNotificationListener(nodeagent, this);
                        }
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block34;
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
                return false;
            }
            serverUp = false;
            String e2 = this.waitObject;
            synchronized (e2) {
                if (!this.waitStarting) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait for STARTING status first....");
                    }
                    this.waitObject.wait();
                }
                if (this.waitResult == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for server to complete START: ", new String[]{server});
                    }
                    this.waitObject.wait(this.launchTimeout * 1000);
                    if (this.waitTarget != null) {
                        this.waitResult = "LaunchProcess timeout occurred.";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "timed out waiting for server to start ", new String[]{server});
                        }
                    }
                }
            }
            Object var11_14 = null;
            try {
                if (nodeagent != null) {
                    admin.removeNotificationListener(nodeagent, this);
                }
                break block35;
            }
            catch (Exception e3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to remove notification listener");
                }
                break block35;
            }
            {
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception while launchThread was waiting" + e);
                    }
                    this.waitResult = "Exception occurred while launchThread was waiting.";
                    e.printStackTrace();
                    Object var11_15 = null;
                    try {
                        if (nodeagent != null) {
                            admin.removeNotificationListener(nodeagent, this);
                        }
                        break block35;
                    }
                    catch (Exception e3) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to remove notification listener");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block36: {
                    Object var11_16 = null;
                    try {
                        if (nodeagent != null) {
                            admin.removeNotificationListener(nodeagent, this);
                        }
                    }
                    catch (Exception e3) {
                        if (!tc.isDebugEnabled()) break block36;
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
                throw throwable;
            }
        }
        if (this.waitResult != null) {
            if (this.waitResult.equals("websphere.process.running")) {
                serverUp = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "launchProcess result: " + this.waitResult);
            }
        }
        if (serverUp) {
            Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8008I", new String[]{server}));
        }
        return serverUp;
    }

    private boolean applicationsStarted(String nodeName, String server) {
        if (this.scheduler instanceof UpdateClusterScheduler) {
            String[] apps = ((UpdateClusterScheduler)this.scheduler).getAppNames();
            for (int i = 0; i < apps.length; ++i) {
                if (!this.isServerTheTarget(nodeName, server, apps[i]) || this.appStarted(nodeName, server, apps[i])) continue;
                return false;
            }
            return true;
        }
        return this.appStarted(nodeName, server, this.scheduler.getAppName());
    }

    private boolean appStarted(String nodeName, String server, String appName) {
        String q = "WebSphere:type=Application,node=" + nodeName + ",process=" + server + ",name=" + appName + ",*";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "appStarted: query = " + q);
        }
        try {
            ObjectName on = new ObjectName(q);
            int timeout = 180000;
            String strAppMbeanAvailableTimeOut = System.getProperty("com.ibm.websphere.management.application.UpdateAppOnCluster.AppMbeanAvailableTimeOut");
            if (null != strAppMbeanAvailableTimeOut && !strAppMbeanAvailableTimeOut.equals("")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the value for AppMbeanAvailableTimeOut", strAppMbeanAvailableTimeOut);
                }
                timeout = new Integer(strAppMbeanAvailableTimeOut) > 0 ? new Integer(strAppMbeanAvailableTimeOut) * 60 * 1000 : 180000;
            }
            int sleepTime = 10000;
            for (int loopTime = 0; loopTime <= timeout; loopTime += 10000) {
                if (AdminServiceFactory.getAdminService().queryNames(on, null).iterator().hasNext()) {
                    return true;
                }
                Thread.sleep(sleepTime);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.application.task.UpdateClusterTask.appStarted", "402", this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean synchNode(String node, Hashtable appsyncresults) {
        boolean ret;
        block37: {
            ObjectName on;
            long appexp_timeout;
            ObjectName notifOn;
            block36: {
                ret = false;
                notifOn = null;
                appexp_timeout = 0L;
                on = this.getNodesyncObjectName(node);
                if (((Vector)appsyncresults.get("InProgress")).size() > 0 && (notifOn = this.getNotificationServiceObjectName(node)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "NotificationService Mbean is not available, AppExpasion wait cannot be executed on the Node " + node);
                    }
                    ((Vector)appsyncresults.get("InProgress")).removeAllElements();
                }
                if (notifOn != null) {
                    String id = "UpdateCluster:updatesync:" + node;
                    NotificationFilterSupport filter = new NotificationFilterSupport();
                    filter.enableType("websphere.admin.appmgmt.sync");
                    try {
                        AdminServiceFactory.getAdminService().addNotificationListener(notifOn, this, (NotificationFilter)filter, (Object)id);
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to add notification listener");
                        }
                        notifOn = null;
                    }
                    appexp_timeout = (long)((Vector)appsyncresults.get("InProgress")).size() * 60L;
                    if (System.getProperty(APPEXP_WAIT_PROP) != null) {
                        String appexptout = System.getProperty(APPEXP_WAIT_PROP);
                        try {
                            appexp_timeout = Long.parseLong(appexptout);
                        }
                        catch (Exception ex) {
                            if (!tc.isDebugEnabled()) break block36;
                            Tr.debug(tc, "Invalid App expansion time out value - " + appexptout);
                            Tr.debug(tc, "Using default App expansion time out: " + appexp_timeout);
                        }
                    }
                }
            }
            String string = this.waitObject;
            synchronized (string) {
                this.waitTarget = "updatesync";
                this.appExpWaitResult = appsyncresults;
                this.appSyncEvtCount = ((Vector)appsyncresults.get("InProgress")).size();
                AdminServiceFactory.getAdminService().invoke(on, "sync", null, null);
                ret = true;
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8006I", new String[]{node, this.scheduler.getAppName()}));
                if (notifOn != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Entering into wait for app binaries expansion", "Wait time: " + appexp_timeout + "secs");
                    }
                    this.waitObject.wait(appexp_timeout * 1000L);
                    if (this.waitTarget != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppExpansion timed out");
                            if (((Vector)this.appExpWaitResult.get("InProgress")).size() > 0) {
                                Tr.debug(tc, "Following Apps expansions are not completed", ((Vector)this.appExpWaitResult.get("InProgress")).toArray());
                            }
                            if (((Vector)this.appExpWaitResult.get("Failed")).size() > 0) {
                                Tr.debug(tc, "Following Apps expansions are failed", ((Vector)this.appExpWaitResult.get("Failed")).toArray());
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AppExpansion competed successfully, for all applications");
                    }
                }
            }
            Object var14_14 = null;
            try {
                if (notifOn != null) {
                    AdminServiceFactory.getAdminService().removeNotificationListener(notifOn, this);
                }
                break block37;
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to remove notification listener");
                }
                break block37;
            }
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.management.application.task.UpdateClusterTask.syncNode", "981", this);
                    if (!ret) {
                        Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8011I", new String[]{node}));
                    } else if (e instanceof InterruptedException && tc.isDebugEnabled()) {
                        Tr.debug(tc, "app exp wait interrupted.");
                    }
                    Object var14_15 = null;
                    try {
                        if (notifOn != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(notifOn, this);
                        }
                        break block37;
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to remove notification listener");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block38: {
                    Object var14_16 = null;
                    try {
                        if (notifOn != null) {
                            AdminServiceFactory.getAdminService().removeNotificationListener(notifOn, this);
                        }
                    }
                    catch (Exception e2) {
                        if (!tc.isDebugEnabled()) break block38;
                        Tr.debug(tc, "Failed to remove notification listener");
                    }
                }
                throw throwable;
            }
        }
        return ret;
    }

    private ObjectName getServerObjectName(String nodeName, String serverName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerObjectName", new Object[]{nodeName, serverName});
        }
        String q = "WebSphere:type=Server,node=" + nodeName + ",process=" + serverName + ",*";
        try {
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerObjectName: return null");
                }
                return null;
            }
            ObjectName serverObjectName = (ObjectName)itr.next();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName", new Object[]{serverObjectName});
            }
            return serverObjectName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerObjectName: return null");
            }
            return null;
        }
    }

    private ObjectName getNodeagentObjectName(String nodeName) {
        try {
            String q = "WebSphere:type=NodeAgent,node=" + nodeName + ",*";
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ObjectName nodeagentObjectName = (ObjectName)itr.next();
            return nodeagentObjectName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            return null;
        }
    }

    private ObjectName getClusterObjectName(String cluster) {
        try {
            String q = "WebSphere:type=Cluster,name=" + cluster + ",*";
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ObjectName clusterObjectName = (ObjectName)itr.next();
            return clusterObjectName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            return null;
        }
    }

    private ObjectName getNodesyncObjectName(String nodeName) {
        try {
            String q = "WebSphere:type=NodeSync,node=" + nodeName + ",*";
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ObjectName nodesyncObjectName = (ObjectName)itr.next();
            return nodesyncObjectName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            return null;
        }
    }

    private ObjectName getNotificationServiceObjectName(String nodeName) {
        try {
            String q = "WebSphere:type=NotificationService,node=" + nodeName + ",process=nodeagent,*";
            ObjectName on = new ObjectName(q);
            Iterator itr = AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
            if (!itr.hasNext()) {
                return null;
            }
            ObjectName notifService_OName = (ObjectName)itr.next();
            return notifService_OName;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            return null;
        }
    }

    private void sendNotification(String msgKey, String event2, Object[] args) {
        AppNotification appNotify = this.createNotification(event2, msgKey, args);
        this.scheduler.propagateTaskEvent(appNotify);
    }

    private void sendNotification(String msgKey, String event2, String object) {
        this.sendNotification(msgKey, event2, new String[]{object, this.scheduler.getAppName()});
    }

    private Hashtable getTargetServers(String[] appNames) throws Exception {
        Hashtable apps_servers = new Hashtable();
        for (int i = 0; i < appNames.length; ++i) {
            String appName = appNames[i];
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(appName, this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (appContext == null) continue;
            ApplicationDeployment depl = ConfigRepoHelper.getAppDeploymentForApp(appContext);
            Vector notFound = new Vector();
            Vector svrs = ConfigRepoHelper.getServersForAppDeployment(depl, notFound, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), true);
            Vector vAllServers = ConfigRepoHelper.getAllServers(this.scheduler.getWorkSpace(), svrs);
            ArrayList<String> alAppTarget = new ArrayList<String>();
            for (int k = 0; k < vAllServers.size(); ++k) {
                alAppTarget.add(ConfigRepoHelper.getTargetString((RepositoryContext)vAllServers.elementAt(k), (String)null));
            }
            this.hAppTargetTab.put(appName, alAppTarget);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target servers are alAppTarget", alAppTarget);
            }
            if (notFound.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA8016I", new Object[]{notFound}));
                Tr.info(tc, AppUtils.getMessage(this.getResourceBundle(), "ADMA8016I", new Object[]{notFound}));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "target servers are " + svrs);
            }
            if (svrs.size() <= 0) continue;
            apps_servers.put(appName, new Vector(svrs));
        }
        return apps_servers;
    }

    private void getNodeSeversAndNodeAppsRelation(WorkSpace ws, Hashtable nodeAppsTbl, Hashtable nodeSvrsTbl, Hashtable apps_servers) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeSeversAndNodeAppsRelation");
        }
        Enumeration appNames = apps_servers.keys();
        while (appNames.hasMoreElements()) {
            String appName = (String)appNames.nextElement();
            Vector app_svrs = (Vector)apps_servers.get(appName);
            Hashtable node_servers = ConfigRepoHelper.getNodeServerRelation(ws, app_svrs);
            Enumeration nodeCtxs = node_servers.keys();
            while (nodeCtxs.hasMoreElements()) {
                RepositoryContext nodeCtx = (RepositoryContext)nodeCtxs.nextElement();
                String nodeName = nodeCtx.getName();
                Vector<String> node_apps = (Vector<String>)nodeAppsTbl.get(nodeName);
                if (node_apps == null) {
                    node_apps = new Vector<String>();
                    nodeAppsTbl.put(nodeName, node_apps);
                }
                if (!node_apps.contains(appName)) {
                    node_apps.add(appName);
                }
                Vector svrs = (Vector)node_servers.get(nodeCtx);
                Vector node_svrs = (Vector)nodeSvrsTbl.get(nodeCtx);
                if (node_svrs == null) {
                    node_svrs = new Vector();
                    nodeSvrsTbl.put(nodeCtx, node_svrs);
                }
                for (int j = 0; j < svrs.size(); ++j) {
                    if (node_svrs.contains(svrs.get(j))) continue;
                    node_svrs.add(svrs.get(j));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeAppsTbl ", nodeAppsTbl);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "nodeSvrsTbl ", nodeSvrsTbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeSeversAndNodeAppsRelation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notf, Object handback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification" + notf + " " + handback);
        }
        Properties props = null;
        if (notf == null) {
            return;
        }
        String type = notf.getType();
        Object ud = notf.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "got notification ", new Object[]{type, ud});
        }
        if (type.equals("websphere.process.stopped") || type.equals("websphere.process.failed") || type.equals("websphere.process.running") || type.equals("websphere.process.starting")) {
            if (ud != null) {
                props = (Properties)ud;
                String serverName = props.getProperty("processName");
                String string = this.waitObject;
                synchronized (string) {
                    if (serverName.equals(this.waitTarget)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "got notification " + type);
                        }
                        if (type.equals("websphere.process.starting")) {
                            this.waitStarting = true;
                        } else {
                            this.waitTarget = null;
                            this.waitResult = type;
                        }
                        this.waitObject.notifyAll();
                    }
                }
            }
        } else if (type.equals("websphere.admin.appmgmt.sync") && ud != null && ud instanceof AppNotification) {
            AppNotification appEvt = (AppNotification)ud;
            if (appEvt.taskName.equals(this.waitTarget) && (appEvt.taskStatus.equals("Completed") || appEvt.taskStatus.equals("Failed"))) {
                String appName = (String)appEvt.props.get("appname");
                String string = this.waitObject;
                synchronized (string) {
                    if (appName != null && ((Vector)this.appExpWaitResult.get("InProgress")).contains(appName)) {
                        --this.appSyncEvtCount;
                        ((Vector)this.appExpWaitResult.get("InProgress")).remove(appName);
                        if (appEvt.message.equals("completed")) {
                            ((Vector)this.appExpWaitResult.get("Completed")).add(appName);
                        }
                        if (appEvt.message.equals("failed")) {
                            ((Vector)this.appExpWaitResult.get("Failed")).add(appName);
                        }
                    }
                    if (this.appSyncEvtCount <= 0) {
                        this.waitTarget = null;
                        this.waitObject.notifyAll();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UpdateClusterTask::handleNotification");
        }
    }

    private Hashtable getServerTypes(RepositoryContext nodeCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTypes");
        }
        Hashtable<String, String> serverTypes = new Hashtable<String, String>();
        URI uri = URI.createURI("serverindex.xml");
        Resource resource = nodeCtx.getResourceSet().getResource(uri, true);
        if (resource == null || resource.getContents() == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Nothing to do because resource.getContents returned null!!!!");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerTypes");
            }
            return serverTypes;
        }
        ServerIndex doc = (ServerIndex)resource.getContents().get(0);
        EList servers = doc.getServerEntries();
        for (int j = 0; j < servers.size(); ++j) {
            ServerEntry s = (ServerEntry)servers.get(j);
            String name = s.getServerName();
            String type = s.getServerType();
            serverTypes.put(name, type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTypes");
        }
        return serverTypes;
    }

    private void establishLaunchTimeout() {
        Integer llaunchTimeout = UpdateClusterScheduler.DEFAULT_LAUNCH_TIMEOUT;
        Object time2 = this.scheduler.getProperties().get("LAUNCH_TIMEOUT");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "time", time2);
        }
        if (time2 != null && time2 instanceof Integer) {
            llaunchTimeout = (Integer)time2;
        }
        this.launchTimeout = llaunchTimeout;
    }

    private boolean isServerTheTarget(String NodeName, String ServerName, String AppName) {
        ArrayList alTargetList;
        String CellName;
        String strNodeName;
        block9: {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "isServerTheTarget: NodeName = " + NodeName + ":ServerName=" + ServerName + ":AppName=" + AppName + "");
            }
            strNodeName = NodeName;
            String strServerName = ServerName;
            String strAppName = AppName;
            CellName = new String();
            alTargetList = (ArrayList)this.hAppTargetTab.get(AppName);
            try {
                CellName = ((UpdateClusterScheduler)this.scheduler).getCellContext().getName();
                if (null == CellName) {
                    CellName = AdminServiceFactory.getAdminService().getCellName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The Value of CellName from AdminService in try is " + CellName);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Value of CellName from Scheduler is " + CellName);
                }
            }
            catch (Exception e) {
                CellName = AdminServiceFactory.getAdminService().getCellName();
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "The Value of CellName from AdminService is " + CellName);
            }
        }
        String q = "WebSphere:cell=" + CellName + ",node=" + strNodeName + ",server=" + ServerName;
        if (null != alTargetList && alTargetList.contains(q)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "isServerTheTarget:true");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "isServerTheTarget:false");
        }
        return false;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/UpdateClusterTask.java, WAS.admin.installapp.server, WASX.SERV1, ver. 1.8.1.16");
        }
        CLASS_NAME = UpdateClusterTask.class.getName();
        SERVER_STOPPED = 1;
        SERVER_FAILED_TO_STOP = 2;
        SERVER_NOT_STARTED = 3;
    }

    private class LaunchThread
    extends Thread {
        String launchNode;
        String launchServer;
        int timeout;
        protected String profileKey = null;

        public LaunchThread(String node, String server, int timeout) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "LaunchThread");
            }
            this.launchNode = node;
            this.launchServer = server;
            this.timeout = timeout;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LaunchThread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                boolean isPushedProfile = false;
                Object retVal = null;
                try {
                    try {
                        if (this.profileKey != null) {
                            isPushedProfile = AdminContext.push(this.profileKey);
                        }
                        Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                        retVal = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                LaunchThread.this.invokeUpdateCluster();
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        Exception ex = pae.getException();
                        Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception invoking launchProcess" + ex);
                        }
                        ex.printStackTrace();
                        Object var6_7 = null;
                        if (!isPushedProfile) return;
                        AdminContext.pop();
                        return;
                    }
                    catch (Exception e) {
                        Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception invoking launchProcess" + e);
                        }
                        Object var6_8 = null;
                        if (isPushedProfile) {
                            AdminContext.pop();
                        }
                        break block12;
                    }
                    Object var6_6 = null;
                    if (!isPushedProfile) break block12;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (isPushedProfile) {
                        AdminContext.pop();
                    }
                    throw throwable;
                }
                AdminContext.pop();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
        }

        private void invokeUpdateCluster() {
            com.ibm.websphere.management.AdminService admin = AdminServiceFactory.getAdminService();
            ObjectName nodeagent = UpdateClusterTask.this.getNodeagentObjectName(this.launchNode);
            ObjectName serverObj = UpdateClusterTask.this.getServerObjectName(this.launchNode, this.launchServer);
            Object started = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initiating launch for " + this.launchNode + "/" + this.launchServer);
                }
                AdminServiceFactory.getAdminService().invoke(nodeagent, "launchProcess", new Object[]{this.launchServer, new Integer(this.timeout)}, new String[]{"java.lang.String", "java.lang.Integer"});
            }
            catch (Exception e) {
                Tr.info(tc, AppUtils.getMessage(UpdateClusterTask.this.getResourceBundle(), "ADMA8010I", new String[]{this.launchServer}));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception invoking launchProcess" + e);
                }
                return;
            }
        }

        public void setProfileKey(String pKey) {
            this.profileKey = pKey;
        }
    }
}

