/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.commands.authzgroup.AuthzGroupUtil;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class UpdateAuthzGroupTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(UpdateAuthzGroupTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            Object obj;
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (this.scheduler instanceof UninstallSchedulerImpl && (obj = this.scheduler.getProperties().get("contenttype")) == null) {
                String appDep = appContext.getURI();
                appDep = appDep + "|deployment.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Uninstall ", appDep);
                }
                Session session = new Session(appContext.getWorkSpace().getUserName(), true);
                ConfigService cs = null;
                this.notifyAuthzGroup(cs, session, appDep, "Application");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
    }

    private void notifyAuthzGroup(ConfigService cs, Session session, String res, String type) throws Exception {
        final ConfigService csFinal = cs;
        final Session sessionFinal = session;
        final String resFinal = res;
        final String typeFinal = type;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AuthzGroupUtil.removeResourceFromAuthorizationGroup((ConfigService)csFinal, (Session)sessionFinal, (String)resFinal, (String)typeFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new AdminException(pae.getException());
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }
}

