/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SystemAppsConfigureTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(SystemAppsConfigureTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private RepositoryContext _appC = null;
    private static final String systemAppsFileName = "systemapps.xml";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        this._appC = null;
        try {
            Vector servers = null;
            RepositoryContext cellC = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            Hashtable props = this.scheduler.getProperties();
            servers = ConfigRepoHelper.getServerNames(AppUtils.getTargetStr(props), AppUtils.getTargetStr(props), false, cellC, this.scheduler.getWorkSpace());
            this.checkDeploymentXML();
            String nodes = this.updateSystemAppSIEntries(servers);
            AppNotification appNotify = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            Properties notificationProps = new Properties();
            if (nodes != null) {
                notificationProps.setProperty("nodes", nodes);
            }
            appNotify.setProperties(notificationProps);
            this.scheduler.propagateTaskEvent(appNotify);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "126", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), th.toString()}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
    }

    private void checkDeploymentXML() throws Exception {
        if (this.scheduler instanceof InstallScheduler && !this.scheduler.getProperties().containsKey("systemApp")) {
            AppUtils.dbg(tc, "check for deployment.xml");
            InstallScheduler iSch = (InstallScheduler)this.scheduler;
            EARFile ear = iSch.getEarFile(false, true);
            if (!ear.containsFile("deployment.xml")) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5111E"));
            }
        }
    }

    private String updateSystemAppSIEntries(Vector v) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSystemAppSIEntries: " + v);
        }
        Vector added = v;
        Hashtable ret = null;
        if (this.scheduler instanceof UninstallSchedulerImpl && (ret = this.updateSystemAppsXMLDocs(this._appC, this.scheduler.getWorkSpace(), added, false, this.getResourceBundle())) != null) {
            this.scheduler.getProperties().put("nodesvr.removed", ret);
        }
        if (this.scheduler instanceof InstallSchedulerImpl && (ret = this.updateSystemAppsXMLDocs(this._appC, this.scheduler.getWorkSpace(), added, true, this.getResourceBundle())) != null) {
            this.scheduler.getProperties().put("nodesvr.added", ret);
        }
        String s = "";
        if (ret != null) {
            RepositoryContext cellC = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            s = ConfigRepoHelper.getNodeStrFromNodeSvrTable(ret, cellC.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSystemAppSIEntries: " + s);
        }
        return s;
    }

    public Hashtable updateSystemAppsXMLDocs(RepositoryContext appC, WorkSpace ws, Vector svrs, boolean bAdd, ResourceBundle resBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSystemAppsXMLDocs: " + svrs);
        }
        Hashtable allNodes = ConfigRepoHelper.getNodeServerRelation(ws, svrs);
        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6018I", new Object[]{allNodes}));
        Hashtable indexDocs = this.getSystemAppsXMLDocs(ws, allNodes.keys());
        if (indexDocs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration en = allNodes.keys();
        Hashtable retVal = new Hashtable();
        String lastNode = "";
        String cellName = "";
        try {
            RepositoryContext cellC = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            cellC.extract("variables.xml", false);
            while (en.hasMoreElements()) {
                int i;
                RepositoryContext nc = (RepositoryContext)en.nextElement();
                nc.extract("variables.xml", false);
                Vector sc = (Vector)allNodes.get(nc);
                Vector<String> servers = new Vector<String>();
                for (int i2 = 0; i2 < sc.size(); ++i2) {
                    RepositoryContext svrC = (RepositoryContext)sc.elementAt(i2);
                    servers.addElement(svrC.getName());
                    svrC.extract("variables.xml", false);
                }
                Resource res = (Resource)indexDocs.get(nc);
                if (res.getContents().size() == 0) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{nc.getName()}));
                }
                ServerIndex top = (ServerIndex)res.getContents().get(0);
                ArrayList<String> retS = new ArrayList<String>();
                retVal.put(nc.getName(), retS);
                lastNode = nc.getName();
                cellName = nc.getParent().getName();
                AppUtils.dbg(tc, "xxx cellName = " + cellName);
                EList entries = top.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + nc.getName() + " are " + servers);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + nc.getName() + " are " + entries);
                }
                List serverNameEntries = ConfigRepoHelper.getServerNameForServerEntries(entries);
                if (bAdd) {
                    for (i = 0; i < servers.size(); ++i) {
                        if (serverNameEntries.contains(servers.get(i))) continue;
                        ConfigRepoHelper.createServerEntry(top, servers.get(i).toString());
                    }
                }
                entries = top.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + nc.getName() + " are " + entries);
                }
                for (i = 0; i < entries.size(); ++i) {
                    ServerEntry entry = (ServerEntry)entries.get(i);
                    if (!servers.contains(entry.getServerName())) continue;
                    if (bAdd) {
                        String deploymentNameOfThisApp = (String)this.scheduler.getProperties().get("appname");
                        EList deployedApps = entry.getDeployedApplications();
                        for (int k = 0; k < deployedApps.size(); ++k) {
                            String deploymentName = (String)deployedApps.get(k);
                            String appName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                            if (!(appName = appName.substring(0, appName.lastIndexOf(".ear"))).equals(deploymentNameOfThisApp)) continue;
                            throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
                        }
                        String deployedPath = ((InstallScheduler)this.scheduler).getEarPath().replace('\\', '/');
                        String configRoot = ws.getPath();
                        VariableMap vMap = AppUtils.createVarMap(configRoot, cellName, lastNode, entry.getServerName());
                        String expandedWasInstallRoot = vMap.expand("${WAS_INSTALL_ROOT}").replace('\\', '/');
                        AppUtils.dbg(tc, "configRoot = " + configRoot);
                        AppUtils.dbg(tc, "deployedPath = " + deployedPath);
                        AppUtils.dbg(tc, "${WAS_INSTALL_ROOT} = " + expandedWasInstallRoot);
                        if (deployedPath.toLowerCase().startsWith(expandedWasInstallRoot.toLowerCase())) {
                            String installRelativePath = null;
                            installRelativePath = expandedWasInstallRoot.endsWith("/") ? deployedPath.substring(expandedWasInstallRoot.length()) : deployedPath.substring(expandedWasInstallRoot.length() + 1);
                            AppUtils.dbg(tc, "installRelativePath = " + installRelativePath);
                            AppUtils.dbg(tc, "deployedPath startsWith matching ${WAS_INSTALL_ROOT} value");
                            deployedPath = "${WAS_INSTALL_ROOT}/" + installRelativePath;
                            AppUtils.dbg(tc, "new deployedPath = " + deployedPath);
                        }
                        deployedApps.add(deployedPath);
                        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6020I", new Object[]{appC, entry.getServerName(), nc.getName()}));
                    } else {
                        EList deployedApps = entry.getDeployedApplications();
                        String sitext = null;
                        boolean done = false;
                        for (int k = 0; k < deployedApps.size(); ++k) {
                            String appName;
                            String deploymentName = (String)deployedApps.get(k);
                            if (!deploymentName.endsWith(".ear")) continue;
                            String deployedAppName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                            if (!(deployedAppName = deployedAppName.substring(0, deployedAppName.lastIndexOf(".ear"))).equals(appName = this.scheduler.getAppName())) continue;
                            entry.getDeployedApplications().remove(k);
                            entry.eResource().save(new HashMap());
                            sitext = deploymentName;
                            done = true;
                        }
                        AppUtils.dbg(tc, AppUtils.getMessage(resBundle, "ADMA6021I", new Object[]{sitext, entry.getServerName(), nc.getName(), "" + done}));
                    }
                    retS.add(entry.getServerName());
                }
                HashMap options = new HashMap();
                res.save(options);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSystemAppsXMLDocs: " + retVal);
            }
            return retVal;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "updateSystemAppsXMLDocs", "368", this);
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, "Server Index update failed at  the last node of " + lastNode);
        }
    }

    private Hashtable getSystemAppsXMLDocs(WorkSpace ws, Enumeration en) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAppsXMLDocs");
        }
        Hashtable<RepositoryContext, Resource> retVal = new Hashtable<RepositoryContext, Resource>();
        while (en.hasMoreElements()) {
            RepositoryContext rCtx = (RepositoryContext)en.nextElement();
            AppUtils.dbg(tc, "rCtx.getPath()", rCtx.getPath());
            File systemappsXMLPath = new File(rCtx.getPath() + "/" + systemAppsFileName);
            if (!systemappsXMLPath.exists()) {
                Hashtable props = this.scheduler.getProperties();
                String cellName = props == null ? null : (String)props.get("cell.name");
                String nodeName = (String)props.get("node.name");
                rCtx.findContext("cells/" + cellName + "/nodes/" + nodeName);
                WorkSpaceFile wsf = null;
                if (nodeName != null) {
                    try {
                        wsf = rCtx.getFile(systemAppsFileName);
                    }
                    catch (Throwable t) {
                        Tr.warning(tc, "ADMA0164W", new Object[]{cellName, nodeName});
                    }
                }
                if (wsf != null) {
                    rCtx.extract(systemAppsFileName, false);
                } else {
                    ConfigRepoHelper.createSystemAppsXML(rCtx, ws, this.scheduler.getProperties());
                }
            }
            URI uri = URI.createURI(systemAppsFileName);
            Resource res = rCtx.getResourceSet().createResource(uri);
            HashMap options = new HashMap();
            res.load(options);
            if (res == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{systemAppsFileName, rCtx}));
            }
            retVal.put(rCtx, res);
        }
        Tr.debug(tc, "retVal: " + retVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAppsXMLDocs");
        }
        return retVal;
    }

    private void badError() {
        String errString = null;
        Tr.audit(tc, "bad error" + errString.length());
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/SystemAppsConfigureTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.9");
        }
        CLASS_NAME = SystemAppsConfigureTask.class.getName();
    }
}

