/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.ClassloaderFactory;
import com.ibm.websphere.models.config.classloader.ClassloaderPackage;
import com.ibm.websphere.models.config.classloader.LibraryRef;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.InstalledOptionalPackageMetaData;
import com.ibm.ws.runtime.ModuleManifestParser;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.util.service.VariableMap;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtil;
import com.ibm.ws.workspace.query.WorkSpaceQueryUtilFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledOptionalPackageTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(InstalledOptionalPackageTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public InstalledOptionalPackageTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        String appName = this.scheduler.getAppName();
        try {
            if (this.scheduler instanceof InstallScheduler) {
                this.install((InstallScheduler)this.scheduler, appName);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "not an install");
            }
            AppNotification notification = this.createNotification("Completed", "ADMA5053I", new String[]{appName});
            this.scheduler.propagateTaskEvent(notification);
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "performTask", "124", this);
            AppNotification notification = this.createNotification("Failed", "ADMA5054E", new String[]{appName, t.toString()});
            this.scheduler.propagateTaskEvent(notification);
            AdminException adminException = null;
            if (t instanceof AdminException) {
                adminException = (AdminException)t;
            } else {
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0105E");
                adminException = new AdminException(t, message);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(true));
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void install(InstallScheduler installScheduler, String appName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install", "appName=" + appName);
        }
        WorkSpace workSpace = this.scheduler.getWorkSpace();
        RepositoryContext appContext = AppUtils.findAppContextFromConfig(appName, workSpace, this.scheduler.getProperties());
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(appContext);
        Map<InstalledOptionalPackageMetaData, String> map = this.buildMap(applicationDeployment, workSpace);
        ArrayList<EARFile> moduleFiles = new ArrayList<EARFile>();
        EARFile earFile = installScheduler.getEarFile(false, true);
        moduleFiles.add(earFile);
        List modules = earFile.getModuleFiles();
        moduleFiles.addAll(modules);
        ArrayList<String> referencedLibraries = new ArrayList<String>();
        for (com.ibm.etools.commonarchive.ModuleFile moduleFile : moduleFiles) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "install", "moduleFile=" + moduleFile);
            }
            Object[] installedOptionalPackages = ModuleManifestParser.getInstalledOptionalPackageMetaData((ModuleFile)moduleFile, map);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "install", "installedOptionalPackages=" + Arrays.toString(installedOptionalPackages));
            }
            if (installedOptionalPackages == null) continue;
            for (Object metadata2 : installedOptionalPackages) {
                if (metadata2 == null || !metadata2.dependenciesAreSpecified() || !metadata2.specifiedDependenciesAreResolved()) continue;
                String libraryName = metadata2.getLibraryName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "install", "libraryName=" + libraryName);
                }
                if (libraryName == null || referencedLibraries.contains(libraryName)) continue;
                referencedLibraries.add(libraryName);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "install", "referencedLibraries=" + referencedLibraries);
        }
        if (!referencedLibraries.isEmpty()) {
            ClassloaderPackage classloaderPackage = (ClassloaderPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/classloader.xmi");
            ClassloaderFactory classloaderFactory = classloaderPackage.getClassloaderFactory();
            Classloader classloader = applicationDeployment.getClassloader();
            HashSet<String> existingLibraries = new HashSet<String>();
            EList libraries = classloader.getLibraries();
            for (LibraryRef libraryRef : libraries) {
                String libraryName2 = libraryRef.getLibraryName();
                existingLibraries.add(libraryName2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "install", "existingLibraries=" + existingLibraries);
            }
            boolean modified = false;
            for (String libraryName : referencedLibraries) {
                if (existingLibraries.contains(libraryName)) continue;
                existingLibraries.add(libraryName);
                modified = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "install", "create/add LibraryRef for " + libraryName);
                }
                LibraryRef libraryRef = classloaderFactory.createLibraryRef();
                libraryRef.setLibraryName(libraryName);
                libraries.add(libraryRef);
            }
            if (modified) {
                Resource resource = applicationDeployment.eResource();
                resource.setModified(true);
                resource.save(new HashMap());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    private Map<InstalledOptionalPackageMetaData, String> buildMap(ApplicationDeployment applicationDeployment, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildMap", new String[]{"applicationDeployment=" + applicationDeployment, "workSpace=" + workSpace});
        }
        HashMap<InstalledOptionalPackageMetaData, String> map = new HashMap<InstalledOptionalPackageMetaData, String>();
        WorkSpaceQueryUtil workspaceQueryUtil = WorkSpaceQueryUtilFactory.getUtil();
        AppManagement appManagement = this.scheduler.getAppManagement();
        Hashtable globalSettings = appManagement.getGlobalSettings();
        String configRoot = (String)globalSettings.get("Config Root for variable map");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "buildMap", "configRoot=" + configRoot);
        }
        HashMap installedOptionalPackages = new HashMap();
        RepositoryContext cellContext = this.scheduler.getCellContext();
        Vector servers = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, cellContext, workSpace, true);
        Vector serverContexts = ConfigRepoHelper.getAllServers(workSpace, servers);
        for (RepositoryContext serverContext : serverContexts) {
            com.ibm.ws.runtime.service.VariableMap variableMap = AppUtils.createVarMap(serverContext, configRoot);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "buildMap", new String[]{"serverContext=" + serverContext, "variableMap=" + variableMap});
            }
            Hashtable libraryData = workspaceQueryUtil.getLibraryData(serverContext);
            for (Map.Entry data : libraryData.entrySet()) {
                String libraryName = (String)data.getKey();
                List classpath = (List)data.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buildMap", new String[]{"libraryName=" + libraryName, "classpath=" + classpath});
                }
                installedOptionalPackages.clear();
                ModuleManifestParser.addInstalledOptionalPackages(installedOptionalPackages, (List)classpath, (String)libraryName, (VariableMap)variableMap);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buildMap", "installedOptionalPackages=" + installedOptionalPackages);
                }
                map.putAll(installedOptionalPackages);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildMap", map);
        }
        return map;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/InstalledOptionalPackageTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.9");
        }
        CLASS_NAME = InstalledOptionalPackageTask.class.getName();
    }
}

