/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DeleteSIEntryTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DeleteSIEntryTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    private boolean performTaskForSystemApp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTaskForSystemApp");
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTaskForSystemApp");
            }
            return AppUtils.isAnInstalledSystemApp(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties(), true);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTaskForSystemApp");
            }
            return false;
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        Object dest = null;
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        String nodeStr = "";
        try {
            RepositoryContext appContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (appContext == null) {
                return this.performTaskForSystemApp();
            }
            ApplicationDeployment depl = ConfigRepoHelper.getAppDeploymentForApp(appContext);
            Vector notFound = new Vector();
            Vector v = ConfigRepoHelper.getServersForAppDeployment(ConfigRepoHelper.getAppDeploymentForApp(appContext), notFound, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), false);
            if (notFound.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5042E", new Object[]{notFound}));
            }
            Hashtable retTable = ConfigRepoHelper.updateServerIndexDocs(appContext, this.scheduler.getWorkSpace(), v, false, this.getResourceBundle());
            nodeStr = ConfigRepoHelper.getNodeStrFromNodeSvrTable(retTable, this.scheduler.getCellContext().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeStr = " + nodeStr);
            }
            if (retTable != null) {
                this.scheduler.getProperties().put("nodesvr.removed", retTable);
            }
            AppNotification notification = this.createNotification("Completed", "ADMA5104I", new String[]{nodeStr});
            Properties notificationProps = new Properties();
            notificationProps.setProperty("nodes", nodeStr);
            notification.setProperties(notificationProps);
            this.scheduler.propagateTaskEvent(notification);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "performTask", "128", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5105E", new String[]{nodeStr}));
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, AppUtils.getMessage(this.getResourceBundle(), "ADMA0061E", new Object[]{dest}));
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/DeleteSIEntryTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.24");
        }
        CLASS_NAME = DeleteSIEntryTask.class.getName();
    }
}

