/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileJspTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(CompileJspTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String DESTINATION_DIRECTORY_NAME;
    private static final String CLASS_NAME_JSP_TOOLS_FACTORY_HELPER = "com.ibm.wsspi.jsp.tools.JspToolsFactoryHelper";
    private static final String METHOD_GET_JSP_TOOLS_FACTORY = "getJspToolsFactory";
    private static final String CLASS_NAME_JSP_TOOLS_FACTORY = "com.ibm.wsspi.jsp.tools.JspToolsFactory";
    private static final String METHOD_CREATE_JSP_TOOLS = "createJspTools";
    private static final String CLASS_NAME_JSP_TOOLS = "com.ibm.wsspi.jsp.tools.JspTools";
    private static final String METHOD_COMPILE_APP = "compileApp";
    private static final String METHOD_SET_CLASSPATH = "setClasspath";
    private static final String METHOD_SET_LOGGER = "setLogger";
    private Hashtable<String, ?> compileJspOptions = null;
    private String currentWar = "";

    public CompileJspTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        Hashtable properties = this.scheduler.getProperties();
        this.compileJspOptions = (Hashtable)properties.get("preCompileJSPs.options");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "performTask", "compileJspOptions=" + this.compileJspOptions);
        }
        if (this.compileJspOptions == null) {
            this.compileJspOptions = new Hashtable();
        }
        try {
            if (this.scheduler instanceof InstallScheduler) {
                this.install((InstallScheduler)this.scheduler);
            } else if (this.scheduler instanceof UpdateScheduler) {
                this.update((UpdateScheduler)this.scheduler);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "performTask", "unexpected scheduler; class=" + this.scheduler.getClass().getName());
                }
                assert (false) : "unexpected scheduler; class=" + this.scheduler.getClass().getName();
            }
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "performTask", "135", this);
            AppNotification notification = this.createNotification("Failed", "ADMA0021E", new String[]{t.toString()});
            this.scheduler.propagateTaskEvent(notification);
            if (t instanceof AdminException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "performTask", t.toString());
                }
                throw (AdminException)t;
            }
            String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0021E", new Object[]{t.toString()});
            AdminException adminException = new AdminException(t, message);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(true));
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(", compileJspOptions=");
        stringBuilder.append(this.compileJspOptions);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void install(InstallScheduler installScheduler) throws AdminException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install");
        }
        ArrayList<War> wars = new ArrayList<War>();
        String earPath = installScheduler.getEarPath();
        EARFile earFile = installScheduler.getEarFile(false, true);
        List warFiles = earFile.getWARFiles();
        for (WARFile warFile : warFiles) {
            String name = warFile.getName();
            String source = earPath + File.separator + name;
            String uri = warFile.getURI();
            Object classpath = this.compileJspOptions.get(uri);
            War war = new War(source, classpath);
            wars.add(war);
        }
        installScheduler.setEarPath(earPath);
        this.compileWars(wars);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    private void update(UpdateScheduler updateScheduler) throws AdminException, AppDeploymentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SaveFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        String source = null;
        Object classpath = null;
        String contentUri = updateScheduler.getContentURI();
        String contentType = updateScheduler.getContentType();
        if (contentType.equals("modulefile")) {
            source = updateScheduler.getContentPath();
            classpath = this.compileJspOptions.get(contentUri);
        } else if (contentType.equals("partialapp")) {
            String contentPath = updateScheduler.getContentPath();
            source = contentPath + File.separator + contentUri;
        }
        ArrayList<War> wars = new ArrayList<War>(1);
        War war = new War(source, classpath);
        wars.add(war);
        this.compileWars(wars);
        String originalContentType = updateScheduler.getOrigContentType();
        if (originalContentType.equals("modulefile")) {
            Archive archive = AppInstallHelper.getArchive(source, false, true, this.getResourceBundle(), false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "update", "collapsing " + archive.getURI());
            }
            archive.saveNoReopen();
            archive.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private void compileWars(List<War> wars) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compileWars", "wars=" + wars);
        }
        ArrayList successful = new ArrayList(wars.size());
        if (!wars.isEmpty()) {
            Class jspToolsFactoryHelperClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS_FACTORY_HELPER);
            Method getJspToolsFactoryMethod = jspToolsFactoryHelperClass.getMethod(METHOD_GET_JSP_TOOLS_FACTORY, null);
            Object jspToolsFactory = getJspToolsFactoryMethod.invoke(null, (Object[])null);
            Class jspToolsFactoryClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS_FACTORY);
            Method createJspToolsMethod = jspToolsFactoryClass.getMethod(METHOD_CREATE_JSP_TOOLS, String.class);
            Class jspToolsClass = CompileJspTask.loadClass(CLASS_NAME_JSP_TOOLS);
            Method compileAppMethod = jspToolsClass.getMethod(METHOD_COMPILE_APP, String.class);
            Method setClasspathMethod = jspToolsClass.getMethod(METHOD_SET_CLASSPATH, String.class);
            Method setLoggerMethod = jspToolsClass.getMethod(METHOD_SET_LOGGER, Logger.class);
            Logger logger = Logger.getLogger(CLASS_NAME, this.getResourceBundleName());
            for (War war : wars) {
                String source = war.getSource();
                this.currentWar = new File(source).getName();
                String destination = source + File.separator + DESTINATION_DIRECTORY_NAME;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "compileWars", new String[]{"currentWar=" + this.currentWar, "destination=" + destination});
                }
                Object jspTools = createJspToolsMethod.invoke(jspToolsFactory, destination);
                setLoggerMethod.invoke(jspTools, logger);
                Object classpath = war.getClasspath();
                if (classpath instanceof String) {
                    setClasspathMethod.invoke(jspTools, classpath);
                } else if (classpath != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "compileWars", "unexpected object type for classpath; class=" + classpath.getClass().getName());
                    }
                    assert (false) : "unexpected object type for classpath; class=" + classpath.getClass().getName();
                }
                Object result = compileAppMethod.invoke(jspTools, source);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "compileWars", "result=" + result);
                }
                AppNotification notification = null;
                notification = (Boolean)result != false ? this.createNotification("InProgress", "ADMA5003I", new String[]{this.currentWar}) : this.createNotification("InProgress", "ADMA5004W", new String[]{this.currentWar});
                this.scheduler.propagateTaskEvent(notification);
            }
            AppNotification notification = this.createNotification("Completed", "ADMA0215I", null);
            this.scheduler.propagateTaskEvent(notification);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "compileWars", "no JSPs to compile");
            }
            AppNotification notification = this.createNotification("Completed", "ADMA0214W", null);
            this.scheduler.propagateTaskEvent(notification);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compileWars");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class loadClass(String className) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadClass", "className=" + className);
        }
        Class<?> classObject = null;
        try {
            try {
                classObject = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                ExtClassLoader extClassLoader = ExtClassLoader.getInstance();
                if (extClassLoader == null) {
                    RasUtils.logException(e, tc, CLASS_NAME, "loadClass", "386");
                    throw e;
                }
                classObject = Class.forName(className, true, ExtClassLoader.getInstance());
                Object var5_3 = null;
                if (!tc.isEntryEnabled()) return classObject;
                Tr.exit(tc, "loadClass", classObject);
                return classObject;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "loadClass", classObject);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return classObject;
        Tr.exit(tc, "loadClass", classObject);
        return classObject;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/CompileJspTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.29");
        }
        CLASS_NAME = CompileJspTask.class.getName();
        DESTINATION_DIRECTORY_NAME = "WEB-INF" + File.separator + "classes";
    }

    private static final class War {
        private final String source;
        private final Object classpath;

        public War(String source, Object classpath) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "War.<init>", new String[]{"source=" + source, "classpath=" + classpath});
            }
            this.source = source;
            this.classpath = classpath;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "War.<init>");
            }
        }

        public String getSource() {
            return this.source;
        }

        public Object getClasspath() {
            return this.classpath;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
            stringBuilder.append("[source=");
            stringBuilder.append(this.source);
            stringBuilder.append(", classpath=");
            stringBuilder.append(this.classpath);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

