/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.Hashtable;

public class BackupAppTask
extends AbstractTask {
    private static final TraceComponent tc = Tr.register(BackupAppTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public BackupAppTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        boolean result = true;
        Hashtable properties = this.scheduler.getProperties();
        Object zeroEarCopy = properties.get("zeroEarCopy");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "performTask", "zeroEarCopy=" + zeroEarCopy);
        }
        if (zeroEarCopy == null) {
            if (this.scheduler instanceof InstallScheduler) {
                this.install((InstallScheduler)this.scheduler);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performTask", "unexpected scheduler; class=" + this.scheduler.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask", Boolean.toString(result));
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void install(InstallScheduler installScheduler) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "install");
        }
        String newPath = null;
        try {
            RepositoryContext cellContext = this.scheduler.getCellContext();
            RepositoryContext context = AppUtils.findContext("applications", AppUtils.getAppBinDirName(this.scheduler), cellContext.getName(), cellContext, this.scheduler.getWorkSpace(), false);
            Hashtable properties = this.scheduler.getProperties();
            String earName = EditionHelper.getAppEarName(this.scheduler.getAppName(), properties);
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(context.getPath());
            stringBuilder.append(File.separator);
            stringBuilder.append(earName);
            newPath = stringBuilder.toString();
            File file = new File(newPath);
            File parentFile = file.getParentFile();
            parentFile.mkdirs();
            if (tc.isDebugEnabled()) {
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA5037I", new String[]{newPath});
                Tr.debug(tc, "install", message);
            }
            EARFile earFile = installScheduler.getEarFile(false, true);
            earFile.saveAs(newPath);
            if (installScheduler instanceof InstallSchedulerImpl) {
                ((InstallSchedulerImpl)installScheduler).setEarPath(newPath, false);
            } else {
                installScheduler.setEarPath(newPath);
            }
            if (tc.isDebugEnabled()) {
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA5038I", new String[]{newPath});
                Tr.debug(tc, "install", message);
            }
            context.notifyChanged(0, earName);
            AppNotification notification = this.createNotification("Completed", "ADMA5001I", new String[]{newPath});
            this.scheduler.propagateTaskEvent(notification);
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "performTask", "192", this);
            AppNotification notification = this.createNotification("Failed", "ADMA5002E", new String[]{newPath, t.toString()});
            this.scheduler.propagateTaskEvent(notification);
            AdminException adminException = null;
            if (t instanceof AdminException) {
                adminException = (AdminException)t;
            } else {
                String message = AppUtils.getMessage(this.getResourceBundle(), "ADMA0020E", new Object[]{newPath});
                adminException = new AdminException(t, message);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask", adminException);
            }
            throw adminException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "install");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/task/BackupAppTask.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.27");
        }
        CLASS_NAME = BackupAppTask.class.getName();
    }
}

