/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.websphere.models.config.nodeagent.ConfigSynchronizationService;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.CommonAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.ChangeProcessor;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class AppDataMgr {
    private static TraceComponent tc = Tr.register(AppDataMgr.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    static String CELLNAME_Str_KEY;
    public static String APPNAME_Str_KEY;
    static String EAR_EARFile_KEY;
    static String EARURI_Str_KEY;
    public static final String EAR_EARMODIFIEDTYPE_Str_KEY = "EARMODIFIEDTYPE_KEY";
    public static String DEPL_DEPLURL_Str_KEY;
    static String DEPL_DEPLMODIFIEDTYPE_Str_KEY;
    static String DELTA_DELTList_KEY;
    static String FILE_FILEList_KEY;
    static String DEPL_DEPLOYOBJ_ApplicationDeployment_KEY;
    public static String DEPL_CTXIDFORSECURITY_Str_KEY;
    static String DEPL_WARCLPOLICY_Str_KEY;
    static String DEPL_ZEROBINCPY_boo_KEY;
    static String DEPL_ZEROEARCPY_boo_KEY;
    public static String DEPL_DISTENABLED_boo_KEY;
    public static String BINURL_Str_KEY;
    public static String FILEPERMISSION_Str_KEY;
    public static String VARIABLEMAP_KEY;
    private AppDataImpl _cachedAD;
    private AppDataImpl _newAD;
    private ConfigRepository _repo;
    private String _appName;
    private String _cellName;
    EARFile _earFile;
    private Hashtable _files;
    private Hashtable _deltas;
    String _earURI = null;
    String _deplURI = null;
    String _earChangeType;
    String _deplChangeType;
    Hashtable _props;
    String markerName = null;
    private static Logger logger;
    private static String _nodeName;
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String SERVS_CONTEXT = "servers/";
    private static final String enableWTOMessage = "com.ibm.websphere.management.application.expand.wto";
    private String _binariesURL;
    private String _binariesLocation;

    public AppDataMgr(String appname, String cellname, ConfigRepository repo, VariableMap varMap) {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDataMgr: appname= " + appname + " cellname= " + cellname + " repo= " + repo + " varMap = " + varMap);
        }
        this._repo = repo;
        this._appName = appname;
        this._cellName = cellname;
        this._earChangeType = "DOCSNOCHANGE_KEY";
        this._deplChangeType = "DOCSNOCHANGE_KEY";
        this._earURI = AppSyncUtils.getBinName(appname, cellname);
        this._deplURI = AppSyncUtils.getDeplURI(appname, cellname);
        this._files = new Hashtable();
        this._files.put("DOCSADDED_KEY", new ArrayList());
        this._files.put("DOCSREMOVED_KEY", new ArrayList());
        this._files.put("DOCSMODIFIED_KEY", new ArrayList());
        this._deltas = new Hashtable();
        this._deltas.put("DOCSADDED_KEY", new ArrayList());
        this._deltas.put("DOCSREMOVED_KEY", new ArrayList());
        this._cachedAD = new AppDataImpl(null, this._appName);
        this._newAD = new AppDataImpl(null, this._appName);
        this._cachedAD.setSibling(this._newAD);
        this._newAD.setSibling(this._cachedAD);
        if (AdminHelper.getPlatformHelper().isZOS()) {
            logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.management.resources.AppDeploymentMessages");
        }
        if ((adminService = AdminServiceFactory.getAdminService()) != null) {
            _nodeName = adminService.getNodeName();
            if (adminService.getProcessType().equals("NodeAgent")) {
                this.createMarkerFile();
            }
        }
        this._props = new Hashtable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDataMgr");
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public Hashtable getProps() {
        return this._props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup() {
        block15: {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cleanup");
            }
            String binurl = (String)this._props.get("expansionFailue");
            this._props.remove("expansionFailue");
            if (this.markerName != null) {
                if (binurl == null) {
                    boolean b = new File(this.markerName).delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deletedmarker " + this.markerName + " ret=" + b);
                    }
                } else {
                    if (this.checkExpandErrorsToWTO()) {
                        this.logWTO("cleanup", "ADMA7101E", new Object[]{this._earURI, binurl, _nodeName});
                    }
                    Tr.audit(tc, "ADMA7101E", new Object[]{this._earURI, binurl, _nodeName});
                    ByteArrayInputStream inputStream = null;
                    try {
                        try {
                            inputStream = new ByteArrayInputStream(binurl.getBytes());
                            AppUtils.copyFile(inputStream, this.markerName);
                        }
                        catch (Throwable t) {
                            RasUtils.logException(t, tc, CLASS_NAME, "cleanup", "220", this, new Object[]{"markerName=" + this.markerName, "binurl=" + binurl});
                            Object var5_7 = null;
                            AppUtils.closeInputStream(inputStream);
                            break block15;
                        }
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        AppUtils.closeInputStream(inputStream);
                        throw throwable;
                    }
                    AppUtils.closeInputStream(inputStream);
                }
            }
        }
        try {
            if (this._earFile != null) {
                this._earFile.close();
            }
            ApplicationDeployment appDepl = null;
            if (this._newAD != null && (appDepl = (ApplicationDeployment)this._newAD.getProperties().remove(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY)) != null) {
                appDepl.eResource().unload();
            }
            if (this._cachedAD == null) return;
            ApplicationDeployment appDepl_c = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
            if (appDepl_c == null) return;
            if (appDepl_c.eResource() == null) return;
            if (appDepl_c.equals(appDepl)) return;
            appDepl_c.eResource().unload();
            return;
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in cleanup: " + th);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "addAppDocument", "246", this);
        }
    }

    public void addAppDocument(String uri, String type, VariableMap map) {
        if (AppSyncUtils.isPathToDeploymentxml(uri, this._cellName)) {
            if (!"DOCSADDED_KEY".equals(type)) {
                this.updateDeplData(map);
            }
            this._deplChangeType = type;
        } else if (AppSyncUtils.isPathToEar(uri, this._cellName)) {
            this._earChangeType = type;
        } else if (AppSyncUtils.isPathToDeltaxml(uri)) {
            if (type.equals("DOCSMODIFIED_KEY")) {
                type = "DOCSADDED_KEY";
            }
            ((List)this._deltas.get(type)).add(uri);
        } else {
            ((List)this._files.get(type)).add(uri);
        }
    }

    public AppData getCachedAD() {
        if (this._cachedAD._dataTbl == null) {
            return null;
        }
        return this._cachedAD;
    }

    public AppData getNewAD() {
        if (this._newAD._dataTbl == null) {
            return null;
        }
        return this._newAD;
    }

    public void postProcess(VariableMap map, boolean isL, ResourceBundle resBundle) {
        this.postProcess(map, null, null, isL, resBundle);
    }

    public void postProcess(VariableMap map, Hashtable newSIMap, Hashtable cachedSIMap, boolean isL, ResourceBundle resBundle) {
        this.updateDeplData(map);
        if (this._cachedAD._dataTbl == null && this._newAD._dataTbl == null) {
            Tr.warning(tc, "Ready to sync, however the app data objects have not been completely populated.");
        }
        if (newSIMap != null && newSIMap.get(this._appName) != null || cachedSIMap != null && cachedSIMap.get(this._appName) != null) {
            this.normalizeBinariesURL(map);
        }
        String cRoot = (String)this._repo.getConfig().get("was.repository.root");
        try {
            String earPath = cRoot + '/' + this._earURI;
            if (this._newAD.isZeroEarCpy()) {
                earPath = cRoot + '/' + this._deplURI;
                earPath = earPath.substring(0, earPath.length() - "/deployment.xml".length());
            }
            if (!new File(earPath).exists() && !new File(earPath = this._cachedAD.getBinURL()).exists()) {
                earPath = this._newAD.getBinURL();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear path = " + earPath);
            }
            if (new File(earPath).exists()) {
                this.setLooseInfo();
                this._earFile = AppInstallHelper.getEarFile(earPath, false, true, resBundle, this._binariesURL, this._binariesLocation);
                this._cachedAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
                this._newAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
            }
        }
        catch (Throwable e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to get ear:" + e);
            }
            if (isL) {
                e.printStackTrace(System.out);
            }
            RasUtils.logException(e, tc, CLASS_NAME, "postProcess", "336", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "creating chg processor");
        }
        ChangeProcessor chg = new ChangeProcessor(this._earFile, isL, cRoot);
        chg.init(this._earURI, this._earChangeType, this._deplURI, this._deplChangeType, this._deltas, this._files);
        ApplicationDeployment oldDepl = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        ApplicationDeployment newDepl = (ApplicationDeployment)this._newAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        if (AppSyncUtils.isRecycleAppAsV5(this._repo, this._cellName)) {
            chg.processDeltaAsV5(oldDepl, newDepl, this._cachedAD.getBinURL(), this._newAD.getBinURL());
        } else {
            chg.processDelta(oldDepl, newDepl, this._cachedAD.getBinURL(), this._newAD.getBinURL());
        }
        this._props.put("filestbl", chg.getPatialStruct());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "" + chg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear = " + this._earFile);
        }
        this._cachedAD.setChangeProcessor(chg);
        this._newAD.setChangeProcessor(chg);
        if (this._earFile != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "closing ear " + this._earFile);
            }
            this._earFile.close();
        }
    }

    public void processVarChanged(String oldVal, String newVal) {
        this._cachedAD.getChangeProcessor().setRecycle(1);
        this._cachedAD.getChangeProcessor().setOp(65536);
        this._cachedAD.getProperties().put(BINURL_Str_KEY, oldVal);
        this._newAD.getProperties().put(BINURL_Str_KEY, newVal);
    }

    private void updateDeplData(VariableMap varMap) {
        Tr.debug(tc, "updateDeplData:" + varMap);
        if (!"DOCSREMOVED_KEY".equals(this._deplChangeType)) {
            try {
                Hashtable<String, Object> tbl = new Hashtable<String, Object>();
                Resource depl = null;
                depl = AppSyncUtils.getResource(this._repo, this._deplURI, "deployment.xml");
                ApplicationDeployment appdepl = ConfigRepoHelper.getAppDeploymentForApp(depl);
                tbl.put(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY, appdepl);
                boolean isDistrib = appdepl.isEnableDistribution();
                boolean isZeroBinCpy = appdepl.isZeroBinaryCopy();
                boolean isZeroEarCpy = appdepl.isZeroEarCopy();
                String clPolicyStr = ClassLoaderPolicy.SINGLE_LITERAL.equals(appdepl.getWarClassLoaderPolicy()) ? AppConstants.APPDEPL_CLASSLOADERPOLICY_SINGLE : AppConstants.APPDEPL_CLASSLOADERPOLICY_MULTIPLE;
                String appContextIDForSecurity = appdepl.getAppContextIDForSecurity();
                String url = appdepl.getBinariesURL();
                String filePermission = appdepl.getFilePermission();
                if (filePermission == null) {
                    filePermission = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755";
                }
                tbl.put(FILEPERMISSION_Str_KEY, filePermission);
                AppUtils.dbg(tc, "filepermission: " + filePermission);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binaryURL: " + url + ", isDistrib: " + isDistrib + ", isZeroBinCpy:" + isZeroBinCpy + ", isZeroEarCpy:" + isZeroBinCpy + ", clPolicy:" + clPolicyStr + ", appContextIDForSecurity:" + appContextIDForSecurity);
                }
                if (appContextIDForSecurity != null) {
                    tbl.put(DEPL_CTXIDFORSECURITY_Str_KEY, appContextIDForSecurity);
                }
                tbl.put(VARIABLEMAP_KEY, varMap);
                tbl.put(BINURL_Str_KEY, url);
                tbl.put(DEPL_WARCLPOLICY_Str_KEY, clPolicyStr);
                tbl.put(DEPL_DISTENABLED_boo_KEY, new Boolean(isDistrib));
                tbl.put(DEPL_ZEROBINCPY_boo_KEY, new Boolean(isZeroBinCpy));
                tbl.put(DEPL_ZEROEARCPY_boo_KEY, new Boolean(isZeroEarCpy));
                this._newAD._dataTbl = tbl;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updateDeplData failed: " + e);
                }
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "updateDeplData", "434", this);
            }
        }
        if (this._cachedAD._dataTbl == null && this._newAD._dataTbl != null) {
            this._cachedAD._dataTbl = this._newAD._dataTbl;
        } else if (this._newAD._dataTbl == null && this._cachedAD._dataTbl != null) {
            this._newAD._dataTbl = this._cachedAD._dataTbl;
        } else if (this._newAD._dataTbl == null && this._cachedAD._dataTbl == null) {
            AdminException e = new AdminException("AppDataMgr _newAD and _cachedAD are both uninitialized.  Neither contain meaninful data for sync.");
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "updateDeplData", "451", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createMarkerFile() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createMarkerFile");
            }
            String userInstallRoot = System.getProperty("user.install.root");
            this.markerName = CommonAppUtils.getAppSyncMarkerLocation(userInstallRoot, this._appName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "createMarkerFile", "markerName=" + this.markerName);
            }
            ByteArrayInputStream inputStream = null;
            try {
                try {
                    inputStream = new ByteArrayInputStream("0".getBytes());
                    AppUtils.copyFile(inputStream, this.markerName);
                }
                catch (Exception e) {
                    RasUtils.logException(e, tc, CLASS_NAME, "createMarkerFile", "476", this, new Object[]{"markerName=" + this.markerName});
                    Object var5_4 = null;
                    AppUtils.closeInputStream(inputStream);
                    break block7;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                AppUtils.closeInputStream(inputStream);
                throw throwable;
            }
            AppUtils.closeInputStream(inputStream);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMarkerFile");
        }
    }

    public void normalizeBinariesURL(VariableMap map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeBinariesURL", map);
        }
        if (this._newAD._dataTbl != null && this._newAD.getBinURL() != null) {
            String newADbinurl = this._newAD.getBinURL();
            newADbinurl = AppSyncUtils.normalizeBinaryPath(map, newADbinurl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_newAD.binURL: " + newADbinurl);
            }
            this._newAD.getProperties().put(BINURL_Str_KEY, newADbinurl);
        }
        if (this._cachedAD._dataTbl != null && this._cachedAD.getBinURL() != null) {
            String cachedADbinurl = this._cachedAD.getBinURL();
            cachedADbinurl = AppSyncUtils.normalizeBinaryPath(map, cachedADbinurl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_cachedAD.binURL: " + cachedADbinurl);
            }
            this._cachedAD.getProperties().put(BINURL_Str_KEY, cachedADbinurl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeBinariesURL");
        }
    }

    public String toString() {
        return ">>AppDataMgr: \ncachedAD = " + this._cachedAD + "\n" + "newAD = " + this._newAD + "\n" + "earfile: " + this._earFile + "\n" + "files: " + this._files + "\n" + "deltas: " + this._deltas + "\n" + "earURI: " + this._earURI + "\n" + "earChangeType: " + this._earChangeType + "\n" + "deplURI: " + this._deplURI + "\n" + "deplChange: " + this._deplChangeType + "\n" + "<<AppDataMgr \n";
    }

    private void logWTO(String sourceMethod, String msg, Object[] data) {
        LoggerHelper.addExtension(logger, "handler_preference", "operator");
        logger.logp(WsLevel.INFO, CLASS_NAME, sourceMethod, msg, data);
        LoggerHelper.removeExtension(logger, "handler_preference");
    }

    private boolean checkExpandErrorsToWTO() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkExpandErrorsToWTO");
        }
        boolean enable = false;
        Server server = null;
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(enable));
            }
            return enable;
        }
        if (AdminServiceFactory.getAdminService() == null || !AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "Not NodeAgent, checkExpandErrorsToWTO = " + new Boolean(enable));
            }
            return enable;
        }
        try {
            String nameNA = AdminHelper.getInstance().getNodeAgentName(_nodeName);
            String urlName = CELLS_CONTEXT + this._cellName + "/" + NODES_CONTEXT + _nodeName + "/" + SERVS_CONTEXT + nameNA + "/server.xml";
            Resource res = AppSyncUtils.getResource(this._repo, urlName, "server.xml");
            EList resContents = res.getContents();
            for (int i = 0; i < resContents.size(); ++i) {
                Object resource = resContents.get(i);
                if (!(resource instanceof Server)) continue;
                server = (Server)resource;
                break;
            }
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to find Node Agent Server object for node " + _nodeName);
            }
            RasUtils.logException(th, tc, CLASS_NAME, "updateDeplData", "586", this);
        }
        if (server == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(enable));
            }
            return enable;
        }
        EList components = server.getComponents();
        if (components == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpandErrorsToWTO", "Failed to find Server Components, checkExpandErrorsToWTO = " + new Boolean(enable));
            }
            return enable;
        }
        block3: for (Component s : components) {
            if (!(s instanceof NodeAgent)) continue;
            NodeAgent na = (NodeAgent)s;
            ConfigSynchronizationService syncCfg = na.getFileSynchronizationService();
            EList props = syncCfg.getProperties();
            if (props == null) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Failed to find FileSynch Server Properties");
                break;
            }
            for (Property p : props) {
                String key = p.getName();
                if (!enableWTOMessage.equals(key)) continue;
                if (!"true".equalsIgnoreCase(p.getValue())) break block3;
                enable = true;
                break block3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkExpandErrorsToWTO", "checkExpandErrorsToWTO = " + new Boolean(enable));
        }
        return enable;
    }

    private void setLooseInfo() {
        this._binariesURL = null;
        this._binariesLocation = null;
        ApplicationDeployment appDeploy = this.getDeploymentXML();
        if (appDeploy != null) {
            for (Property deploymentProperty : appDeploy.getProperties()) {
                if (deploymentProperty == null || !deploymentProperty.getName().equals("was.loose.config")) continue;
                this._binariesURL = appDeploy.getBinariesURL();
                this._binariesLocation = deploymentProperty.getValue();
                this._binariesURL = this.expandVariable(this._binariesURL);
            }
        }
    }

    protected String expandVariable(String var) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariable", var);
        }
        VariableMap variableMap = null;
        String result = var;
        try {
            variableMap = WsServiceRegistry.getService(this, VariableMap.class);
            if (variableMap != null) {
                result = variableMap.expand(var);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariable", result);
        }
        return result;
    }

    private ApplicationDeployment getDeploymentXML() {
        ApplicationDeployment appdepl;
        block2: {
            Resource depl = AppSyncUtils.getResource(this._repo, this._deplURI, "deployment.xml");
            appdepl = null;
            try {
                appdepl = ConfigRepoHelper.getAppDeploymentForApp(depl);
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block2;
                Tr.entry(tc, "AppDataMgr: getDeploymentXML could not find deployment.xml");
            }
        }
        return appdepl;
    }

    public boolean getExpandSynchronously() {
        boolean result;
        block2: {
            result = false;
            Resource depl = AppSyncUtils.getResource(this._repo, this._deplURI, "deployment.xml");
            ApplicationDeployment appdepl = null;
            try {
                appdepl = ConfigRepoHelper.getAppDeploymentForApp(depl);
                result = appdepl.isExpandSynchronously();
            }
            catch (Exception e) {
                if (!tc.isEntryEnabled()) break block2;
                Tr.entry(tc, "AppDataMgr: getDeploymentXML could not find deployment.xml");
            }
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/sync/AppDataMgr.java, WAS.admin.installapp.sync, WAS70.SERV1, q0834.18, ver. 1.26.1.9");
        }
        CLASS_NAME = AppDataMgr.class.getName();
        CELLNAME_Str_KEY = "CELLNAME_KEY";
        APPNAME_Str_KEY = "APPNAME_KEY";
        EAR_EARFile_KEY = "EAR_KEY";
        EARURI_Str_KEY = "EARURI_KEY";
        DEPL_DEPLURL_Str_KEY = "DEPLURL_KEY";
        DEPL_DEPLMODIFIEDTYPE_Str_KEY = "DEPLMODIFIEDTYPE_KEY";
        DELTA_DELTList_KEY = "DELTLIST_KEY";
        FILE_FILEList_KEY = "FILELIST_KEY";
        DEPL_DEPLOYOBJ_ApplicationDeployment_KEY = "OLDDEPLOY_KEY";
        DEPL_CTXIDFORSECURITY_Str_KEY = "CTXIDFORSECURITY_KEY";
        DEPL_WARCLPOLICY_Str_KEY = "WARPOLCY_KEY";
        DEPL_ZEROBINCPY_boo_KEY = "ZEROBINCPY_KEY";
        DEPL_ZEROEARCPY_boo_KEY = "ZEROEARCPY_KEY";
        DEPL_DISTENABLED_boo_KEY = "DIST_KEY";
        BINURL_Str_KEY = "BINURL_KEY";
        FILEPERMISSION_Str_KEY = "filepermission";
        VARIABLEMAP_KEY = "VARIABLEMAP_KEY";
        logger = null;
        _nodeName = null;
    }

    private class AppDataImpl
    implements AppData {
        private Hashtable _dataTbl;
        private String _appName;
        private ChangeProcessor _cp;
        private AppDataImpl _myOnlySibling;
        private EARFile _earFile;

        AppDataImpl(Hashtable tbl, String an) {
            this._dataTbl = tbl;
            this._appName = an;
        }

        void setSibling(AppDataImpl impl) {
            this._myOnlySibling = impl;
        }

        void setEARFile(EARFile e) {
            this._earFile = e;
        }

        void setChangeProcessor(ChangeProcessor chg) {
            this._cp = chg;
        }

        ChangeProcessor getChangeProcessor() {
            return this._cp;
        }

        public Hashtable getProperties() {
            return this._dataTbl;
        }

        public String getAppContextIDForSecurity() {
            return (String)this.fetchData(DEPL_CTXIDFORSECURITY_Str_KEY, true);
        }

        public String getAppName() {
            return this._appName;
        }

        public String getBinURL() {
            return (String)this.fetchData(BINURL_Str_KEY, true);
        }

        public String getDeplURI() {
            return this._cp.getDeploymentURI();
        }

        public EARFile getEAR() {
            return (EARFile)this.fetchData(EAR_EARFile_KEY, true);
        }

        public String getEarURI() {
            return this._cp.getEarURI();
        }

        public String getWarClPolicy() {
            return (String)this.fetchData(DEPL_WARCLPOLICY_Str_KEY, true);
        }

        public boolean isDistEnabled() {
            Boolean b = (Boolean)this.fetchData(DEPL_DISTENABLED_boo_KEY, true);
            if (b == null) {
                return true;
            }
            return b;
        }

        public boolean isZeroBinCpy() {
            Boolean b = (Boolean)this.fetchData(DEPL_ZEROBINCPY_boo_KEY, true);
            if (b == null) {
                return false;
            }
            return b;
        }

        public boolean isZeroEarCpy() {
            Boolean b = (Boolean)this.fetchData(DEPL_ZEROEARCPY_boo_KEY, true);
            if (b == null) {
                return false;
            }
            return b;
        }

        public String getDeploymentURI() {
            return this._cp.getDeploymentURI();
        }

        public String getDeploymentURIChangeType() {
            return this._cp.getDeploymentURIChangeType();
        }

        public String getEarURIChangeType() {
            return this._cp.getEarURIChangeType();
        }

        public List getModulesToRecycle() {
            return this._cp.getModulesToRecycle();
        }

        public List getModulesToStart() {
            return this._cp.getModulesToStart();
        }

        public List getModulesToStop() {
            return this._cp.getModulesToStop();
        }

        public int getOperations() {
            return this._cp.getOperations();
        }

        public Hashtable getPartialUpdateDetails() {
            return this._cp.getPartialUpdateDetails();
        }

        public int getRecycleMode() {
            return this._cp.getRecycleMode();
        }

        Object fetchData(String key, boolean ask) {
            Object result = null;
            try {
                result = this._dataTbl.get(key);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
            if (ask && this._myOnlySibling._dataTbl != null) {
                return this._myOnlySibling.fetchData(key, false);
            }
            return result;
        }

        public String toString() {
            return ">>> - AppData: " + this._appName + ", props=" + this._dataTbl;
        }

        public Hashtable getFileChangesInRepository() {
            return this._cp.getFileChangesInRepository();
        }

        public Hashtable getPartialUpdateModuleDetails() {
            return this._cp.getPartialUpdateModuleDetails();
        }
    }
}

