/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.status.DeploymentStatusImpl;
import com.ibm.ws.management.util.RasUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProgressObjectImpl
implements ProgressObject {
    private static final String DEFAULT_STATUS_MESSAGE_ID = "progress.object.message";
    private static TraceComponent tc = Tr.register(ProgressObjectImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String CLASS_NAME;
    private final CommandType command;
    private final ActionType action = ActionType.EXECUTE;
    private volatile StateType state = null;
    private final ResourceBundle resourceBundle;
    private volatile int eventCounter = 0;
    private volatile String message = null;
    private volatile String defaultMessage = null;
    private final Set<ProgressListener> progressListeners = Collections.synchronizedSet(new HashSet());
    private final List<TargetModuleID> successfulTargetModules = Collections.synchronizedList(new ArrayList());
    private final List<TargetModuleID> failedTargetModules = Collections.synchronizedList(new ArrayList());

    public ProgressObjectImpl(CommandType command) {
        this(command, StateType.RUNNING);
    }

    public ProgressObjectImpl(CommandType command, StateType state) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new String[]{"command=" + command, "state=" + state});
        }
        this.command = command;
        this.state = state;
        Hashtable prefs = DeploymentManagerImpl.getLocalePrefs();
        Locale locale = (Locale)prefs.get("app.client.locale");
        this.resourceBundle = AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    @Override
    public DeploymentStatus getDeploymentStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentStatus");
        }
        String statusMessage = null;
        if (this.message == null) {
            if (this.defaultMessage == null) {
                this.defaultMessage = !this.successfulTargetModules.isEmpty() && this.failedTargetModules.isEmpty() ? AppUtils.getMessage(this.resourceBundle, "ADMJ1011I", new Object[]{this.command.toString(), ProgressObjectImpl.getModuleNames(this.successfulTargetModules)}) : (this.successfulTargetModules.isEmpty() && !this.failedTargetModules.isEmpty() ? AppUtils.getMessage(this.resourceBundle, "ADMJ1012E", new Object[]{this.command.toString(), ProgressObjectImpl.getModuleNames(this.failedTargetModules)}) : (!this.successfulTargetModules.isEmpty() && !this.failedTargetModules.isEmpty() ? AppUtils.getMessage(this.resourceBundle, "ADMJ1013W", new Object[]{this.command.toString(), ProgressObjectImpl.getModuleNames(this.successfulTargetModules), ProgressObjectImpl.getModuleNames(this.failedTargetModules)}) : AppUtils.getMessage(this.resourceBundle, DEFAULT_STATUS_MESSAGE_ID, new Object[]{this.command.toString(), this.state.toString()})));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getDeploymentStatus", "defaultMessage=" + this.defaultMessage);
                }
            }
            statusMessage = this.defaultMessage;
        } else {
            statusMessage = this.message;
        }
        DeploymentStatusImpl deploymentStatus = new DeploymentStatusImpl(this.command, this.action, this.state, statusMessage);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentStatus", deploymentStatus);
        }
        return deploymentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TargetModuleID[] getResultTargetModuleIDs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResultTargetModuleIDs");
        }
        Object[] resultTargetModules = null;
        List<TargetModuleID> list = this.successfulTargetModules;
        synchronized (list) {
            int size = this.successfulTargetModules.size();
            resultTargetModules = this.successfulTargetModules.toArray(new TargetModuleID[size]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResultTargetModuleIDs", Arrays.toString(resultTargetModules));
        }
        return resultTargetModules;
    }

    @Override
    public ClientConfiguration getClientConfiguration(TargetModuleID targetModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientConfiguration", "targetModule=" + targetModule);
        }
        ClientConfiguration clientConfiguration = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientConfiguration", clientConfiguration);
        }
        return clientConfiguration;
    }

    @Override
    public boolean isCancelSupported() {
        return false;
    }

    @Override
    public void cancel() throws OperationUnsupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel");
        }
        String message = AppUtils.getMessage(this.resourceBundle, "ADMJ1006E");
        OperationUnsupportedException e = new OperationUnsupportedException(message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel", e.toString());
        }
        throw e;
    }

    @Override
    public boolean isStopSupported() {
        return false;
    }

    @Override
    public void stop() throws OperationUnsupportedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        String message = AppUtils.getMessage(this.resourceBundle, "ADMJ1005E");
        OperationUnsupportedException e = new OperationUnsupportedException(message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop", e.toString());
        }
        throw e;
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProgressListener", "listener=" + listener);
        }
        this.progressListeners.add(listener);
        if (StateType.COMPLETED.equals(this.state) || StateType.FAILED.equals(this.state)) {
            DeploymentStatus deploymentStatus = this.getDeploymentStatus();
            ProgressEvent progressEvent = new ProgressEvent(this, null, deploymentStatus);
            this.notifyListener(listener, progressEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProgressListener");
        }
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeProgressListener", "listener=" + listener);
        }
        this.progressListeners.remove(listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeProgressListener");
        }
    }

    public boolean setFinalStateAndNotify(StateType state) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFinalStateAndNotify", "state=" + state);
        }
        boolean complete = false;
        this.decreaseEventCount();
        if (this.eventCounter < 1) {
            this.state = state;
            DeploymentStatus deploymentStatus = this.getDeploymentStatus();
            this.notifyListeners(null, deploymentStatus);
            complete = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFinalStateAndNotify", Boolean.toString(complete));
        }
        return complete;
    }

    public void setMessage(String messageId, Object[] arguments) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessage", "message=" + this.message);
        }
        this.message = AppUtils.getMessage(this.resourceBundle, messageId, arguments);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessage");
        }
    }

    public void setTranslatedMessage(String message) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTranslatedMessage", "message=" + message);
        }
        this.message = message;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTranslatedMessage");
        }
    }

    public void setState(StateType state) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setState", "state=" + state);
        }
        this.state = state;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setState");
        }
    }

    public synchronized boolean isLast() {
        return this.eventCounter <= 1;
    }

    public void sendModuleEvent(TargetModuleID targetModule, StateType state, String messageId, Object[] arguments) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendModuleEvent", new String[]{"targetModule=" + targetModule, "state=" + state, "messageId=" + messageId, "arguments=" + Arrays.toString(arguments)});
        }
        String message = AppUtils.getMessage(this.resourceBundle, messageId, arguments);
        this.sendTranslatedModuleEvent(targetModule, state, message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendModuleEvent");
        }
    }

    public void sendTranslatedModuleEvent(TargetModuleID targetModule, StateType state, String message) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendTranslatedModuleEvent", new String[]{"targetModule=" + targetModule, "state=" + state, "message=" + message});
        }
        DeploymentStatusImpl moduleDeploymentStatus = new DeploymentStatusImpl(this.command, this.action, state, message);
        this.notifyListeners(targetModule, moduleDeploymentStatus);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendTranslatedModuleEvent");
        }
    }

    public synchronized void increaseEventCount() {
        ++this.eventCounter;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "increaseEventCount", "eventCounter=" + this.eventCounter);
        }
    }

    public synchronized void decreaseEventCount() {
        --this.eventCounter;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "decreaseEventCount", "eventCounter=" + this.eventCounter);
        }
    }

    public void addSuccessfulResult(TargetModuleID targetModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSuccessfulResult", "targetModule=" + targetModule);
        }
        this.successfulTargetModules.add(targetModule);
        this.defaultMessage = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSuccessfulResult");
        }
    }

    public void addFailedResult(TargetModuleID targetModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFailedResult", "targetModule=" + targetModule);
        }
        this.failedTargetModules.add(targetModule);
        this.defaultMessage = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFailedResult");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[command=");
        stringBuilder.append(this.command);
        stringBuilder.append(", action=");
        stringBuilder.append(this.action);
        stringBuilder.append(", state=");
        stringBuilder.append(this.state);
        stringBuilder.append(", resourceBundle=");
        stringBuilder.append(this.resourceBundle);
        stringBuilder.append(", eventCounter=");
        stringBuilder.append(this.eventCounter);
        stringBuilder.append(", message=");
        stringBuilder.append(this.message);
        stringBuilder.append(", defaultMessage=");
        stringBuilder.append(this.defaultMessage);
        stringBuilder.append(", progressListeners=");
        stringBuilder.append(this.progressListeners);
        stringBuilder.append(", successfulTargetModules=");
        stringBuilder.append(this.successfulTargetModules);
        stringBuilder.append(", failedTargetModules=");
        stringBuilder.append(this.failedTargetModules);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String getModuleNames(List<TargetModuleID> modules) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleNames", "modules=" + modules);
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        Iterator<TargetModuleID> i = modules.iterator();
        while (i.hasNext()) {
            TargetModuleID module = i.next();
            String applicationName = ((TargetModuleIDImpl)module).getApplicationName();
            Target target = module.getTarget();
            String serverName = ((TargetImpl)target).getServerName();
            stringBuilder.append(applicationName);
            stringBuilder.append(" - ");
            stringBuilder.append(serverName);
            if (!i.hasNext()) continue;
            stringBuilder.append(',');
        }
        String moduleNames = stringBuilder.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleNames", moduleNames);
        }
        return moduleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(TargetModuleID targetModule, DeploymentStatus state) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyListeners", new String[]{"targetModule=" + targetModule, "state=" + state});
        }
        ProgressEvent progressEvent = new ProgressEvent(this, targetModule, state);
        Set<ProgressListener> set = this.progressListeners;
        synchronized (set) {
            for (ProgressListener listener : this.progressListeners) {
                this.notifyListener(listener, progressEvent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyListeners");
        }
    }

    private void notifyListener(ProgressListener progressListener, ProgressEvent progressEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyListener", new String[]{"progressListener=" + progressListener, "progressEvent=" + progressEvent});
        }
        try {
            progressListener.handleProgressEvent(progressEvent);
        }
        catch (Throwable t) {
            RasUtils.logException(t, tc, CLASS_NAME, "notifyListener", "577", this);
            Tr.warning(tc, "ADMJ1020E", new Object[]{t});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyListener");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/j2ee/deploy/spi/status/ProgressObjectImpl.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.9");
        }
        CLASS_NAME = ProgressObjectImpl.class.getName();
    }
}

