/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi.factories;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.management.application.j2ee.deploy.spi.DeploymentManagerImpl;
import java.util.StringTokenizer;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    private static TraceComponent tc = Tr.register(DeploymentFactoryImpl.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.J2eeDeploymentMessages");
    private static final String VERSION = "1.0";
    private static final int PARAM_LENGTH = 6;
    private static final int DEPLOYER = 0;
    private static final int NAME = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private static final int CONN_TYPE = 4;
    private static final int MODE = 5;

    public boolean handlesURI(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handlesURI", uri);
        }
        String[] uriParts = this.parseURI(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handlesURI");
        }
        return this.isValid(uriParts);
    }

    private String[] parseURI(String uri) {
        String token;
        String[] parts = new String[6];
        String uriMain = null;
        String uriParams = null;
        if (uri.indexOf("?") > 0) {
            uriMain = uri.substring(0, uri.indexOf("?"));
            uriParams = uri.substring(uri.indexOf("?") + 1, uri.length());
        } else {
            uriMain = uri;
        }
        StringTokenizer tokenizer = new StringTokenizer(uriMain, ":");
        for (int i = 0; tokenizer.hasMoreTokens() && i < 4; ++i) {
            token = tokenizer.nextToken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "token", token);
            }
            parts[i] = token;
        }
        if (uriParams != null) {
            tokenizer = new StringTokenizer(uriParams, "?");
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "token", token);
                }
                if (token.startsWith("connectorType=")) {
                    parts[4] = token.substring(token.indexOf("=") + 1, token.length());
                    continue;
                }
                if (!token.startsWith("mode=")) continue;
                parts[5] = token.substring(token.indexOf("=") + 1, token.length());
            }
        }
        return parts;
    }

    private boolean isValid(String[] uriParts) {
        boolean valid = false;
        if ("deployer".equals(uriParts[0]) && "WebSphere".equals(uriParts[1]) && uriParts[2] != null && uriParts[2].length() > 0 && uriParts[3] != null && uriParts[3].length() > 0) {
            try {
                int port = Integer.parseInt(uriParts[3]);
                valid = true;
            }
            catch (NumberFormatException nfe) {
                Tr.error(tc, "ADMJ1000E", uriParts);
            }
        }
        return valid;
    }

    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeploymentManager", new Object[]{uri, userName, password});
        }
        String[] uriParts = this.parseURI(uri);
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1001E", new Object[]{uri}, "The URI is not valid."));
        }
        DeploymentManagerImpl appDM = null;
        try {
            appDM = new DeploymentManagerImpl();
            appDM.connect(uriParts[2], uriParts[3], uriParts[4], userName, password);
        }
        catch (Exception e2) {
            DeploymentManagerCreationException e2;
            Tr.error(tc, "ADMJ1002E", e2);
            if (!(e2 instanceof DeploymentManagerCreationException)) {
                e2 = new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1002E", new Object[]{e2.getMessage()}, "An error occurred creating the deployment manager."));
            }
            throw (DeploymentManagerCreationException)e2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeploymentManager");
        }
        return appDM;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDisconnectedDeploymentManager", new Object[]{uri});
        }
        String[] uriParts = this.parseURI(uri);
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(nls.getFormattedMessage("ADMJ1001E", new Object[]{uri}, "The URI is not valid."));
        }
        DeploymentManagerImpl appDM = new DeploymentManagerImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDisconnectedDeploymentManager");
        }
        return appDM;
    }

    public String getDisplayName() {
        return nls.getString("j2ee.deployer.name");
    }

    public String getProductVersion() {
        return VERSION;
    }
}

