/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.j2ee.deploy.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import java.util.Hashtable;
import javax.enterprise.deploy.model.DDBean;

public class J2EEDeployUtil {
    private static TraceComponent tc = Tr.register(J2EEDeployUtil.class, "Admin", "com.ibm.ws.management.resources.J2eeDeploymentMessages");

    public static void moduleTask2DC(AppDeploymentTask task, DConfigBeanImpl dcImpl, String moduleURI, int uriColumn) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{moduleURI}, new int[]{uriColumn});
    }

    public static void ejbTask2DC(AppDeploymentTask task, DConfigBeanImpl dcImpl, String moduleURI, String artifactXPath, int[] cols) {
        DDBean nameDD = dcImpl.getDDBean().getChildBean("ejb-name")[0];
        DDBean[] ddBeans = dcImpl.getDDBean().getChildBean(artifactXPath);
        for (int i = 0; i < ddBeans.length; ++i) {
            J2EEDeployUtil.task2DC(task, dcImpl, new String[]{moduleURI, nameDD.getText(), ddBeans[i].getText()}, cols);
        }
    }

    public static void task2DC(AppDeploymentTask task, DConfigBeanImpl dcImpl, String[] vals, int[] cols) {
        J2EEDeployUtil.task2DC(task, dcImpl, vals, cols, true);
    }

    public static void task2DC(AppDeploymentTask task, DConfigBeanImpl dcImpl, String[] vals, int[] cols, boolean firstURICol) {
        String[][] data;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "task2DC: " + task.getName() + dcImpl + " module: " + vals[0] + " col=" + cols[0]);
            for (int i = 1; i < vals.length; ++i) {
                Tr.debug(tc, "val= " + vals[i] + " col = " + cols[i]);
            }
        }
        if ((data = task.getTaskData()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null data .. exiting");
            }
            return;
        }
        for (int i = 1; i < data.length; ++i) {
            boolean foundMatch = true;
            for (int j = 0; j < vals.length; ++j) {
                String colVal = data[i][cols[j]];
                if (j == 0 && firstURICol) {
                    colVal = util.getModuleUriFromUriString(colVal);
                }
                if (colVal.equals(vals[j])) continue;
                foundMatch = false;
                break;
            }
            if (!foundMatch) continue;
            J2EEDeployUtil.addTaskRow(task, i, dcImpl);
            break;
        }
    }

    public static void addTaskRow(AppDeploymentTask task, int i, DConfigBeanImpl dcImpl) {
        String[][] data = task.getTaskData();
        Hashtable<String, String> tblP = new Hashtable<String, String>();
        Hashtable<String, String> tblC = new Hashtable<String, String>();
        tblC.put("taskName", task.getName());
        tblP.put("taskName", task.getName());
        for (int j = 0; j < data[i].length; ++j) {
            if (task.isHiddenColumn(j)) continue;
            if (!task.getMutableColumns(j)) {
                tblC.put(data[0][j], data[i][j]);
            }
            tblP.put(data[0][j], data[i][j] != null ? data[i][j] : "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding task data - " + tblP);
        }
        dcImpl.addTaskData(tblP, tblC);
    }

    public static void allTaskData2DC(AppDeploymentTask task, DConfigBeanImpl dcImpl) {
        String[][] data = task.getTaskData();
        if (data == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null data in allTaskData2DC");
            }
            return;
        }
        for (int row = 1; row < data.length; ++row) {
            J2EEDeployUtil.addTaskRow(task, row, dcImpl);
        }
    }

    public static void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        int match = J2EEDeployUtil.getMatchingRowIndex(task, keys);
        if (match < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No matching row for " + task.getName() + ", keys=" + keys);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Matching row for " + task.getName() + " = " + match);
        }
        String[][] data = task.getTaskData();
        for (int i = 0; i < data[0].length; ++i) {
            String s;
            if (task.isHiddenColumn(i) || !task.getMutableColumns(i) || (s = (String)props.get(data[0][i])) == null) continue;
            data[match][i] = s;
        }
        try {
            task.setTaskData(data);
        }
        catch (AppDeploymentException ex) {
            Tr.warning(tc, "ADMJ0005W", new Object[]{ex, task.getName()});
        }
    }

    private static int getMatchingRowIndex(AppDeploymentTask task, Hashtable keys) {
        String[][] data = task.getTaskData();
        if (data == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null data for " + task.getName());
            }
            return -1;
        }
        for (int row = 1; row < data.length; ++row) {
            boolean foundMatch = true;
            for (int col = 0; col < data[0].length; ++col) {
                if (task.isHiddenColumn(col) || task.getMutableColumns(col) || J2EEDeployUtil.eqStr(keys.get(data[0][col]), data[row][col])) continue;
                foundMatch = false;
                break;
            }
            if (!foundMatch) continue;
            return row;
        }
        return -1;
    }

    private static boolean eqStr(Object o1, Object o2) {
        if (AppUtils.isEmpty((String)o1) && AppUtils.isEmpty((String)o2)) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }
}

