/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.ClientModuleRef;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.ws.management.application.dfltbndngs.utils.ResRef;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class GetAllResourceRefs {
    static TraceComponent tc = Tr.register(GetAllResourceRefs.class, null, "com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceRefs");
    EARFile ear = null;
    private boolean created = false;

    public GetAllResourceRefs(EARFile ear) {
        this.ear = ear;
    }

    public GetAllResourceRefs(EARFile ear, boolean create) {
        this.ear = ear;
        this.created = create;
    }

    public Vector execute() throws Exception {
        Vector result = new Vector();
        List wars = this.ear.getWebModuleRefs();
        for (int i = 0; i < wars.size(); ++i) {
            WebModuleRef webModuleRef = (WebModuleRef)wars.get(i);
            EList resRefBindings = webModuleRef.getWebAppBinding().getResRefBindings();
            EList resRefs = webModuleRef.getWebApp().getResourceRefs();
            this.addResRef(resRefs, resRefBindings, webModuleRef.getModule().getUri(), null, result);
        }
        List ejbjars = this.ear.getEJBModuleRefs();
        for (int i = 0; i < ejbjars.size(); ++i) {
            EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbjars.get(i);
            EJBJarFile ejbJarFile = (EJBJarFile)ejbModuleRef.getModuleFile();
            EJBJar ejbJar = ejbModuleRef.getEJBJar();
            if (ejbJar != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "DD version: " + AppDeploymentUtil.getModuleVersion(ejbJarFile));
            }
            if (ejbJar != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing " + ejbJar);
                }
                EJBJarBinding ejbJarBinding = ejbModuleRef.getEJBJarBinding();
                EList ejbs = ejbJar.getEnterpriseBeans();
                for (int j = 0; j < ejbs.size(); ++j) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                    EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                    EList resRefBindings = ejbBindings.getResRefBindings();
                    EList resRefs = ejb.getResourceRefs();
                    this.addResRef(resRefs, resRefBindings, ejbModuleRef.getModule().getUri(), ejb.getName(), result);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "GetAllResourceRefs.execute(): ejbModuleRef.getEJBJar() is null");
        }
        List clientJars = this.ear.getClientModuleRefs();
        for (int i = 0; i < clientJars.size(); ++i) {
            ClientModuleRef clientModuleRef = (ClientModuleRef)clientJars.get(i);
            EList resRefBindings = clientModuleRef.getApplicationClientBinding().getResourceRefs();
            EList resRefs = clientModuleRef.getApplicationClient().getResourceRefs();
            this.addResRef(resRefs, resRefBindings, clientModuleRef.getModule().getUri(), null, result);
        }
        return result;
    }

    void addResRef(Collection resRefs, Collection resRefBindings, String moduleName, String componentName, Vector result) {
        Iterator resourceRefs = resRefs.iterator();
        while (resourceRefs.hasNext()) {
            ResourceRefBinding rrb;
            ResRef pkg = new ResRef();
            ResourceRef ref = (ResourceRef)resourceRefs.next();
            Iterator refBindings = resRefBindings.iterator();
            boolean found = false;
            while (refBindings.hasNext()) {
                rrb = (ResourceRefBinding)refBindings.next();
                if (rrb.getBindingResourceRef() == null || !rrb.getBindingResourceRef().equals(ref)) continue;
                found = true;
                pkg.setBinding(rrb);
            }
            if (!found) {
                rrb = CommonbndFactoryImpl.getActiveFactory().createResourceRefBinding();
                rrb.setBindingResourceRef(ref);
                resRefBindings.add(rrb);
                pkg.setBinding(rrb);
            }
            if (this.created) continue;
            pkg.setModule(moduleName);
            pkg.setComponent(componentName);
            result.addElement(pkg);
        }
    }
}

