/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.ResourceRefMapElement;
import java.util.Properties;
import java.util.Vector;

public class DefaultStrategy
implements BindingStrategy {
    static TraceComponent tc = Tr.register(DefaultStrategy.class, null, "com.ibm.ws.management.resources.BindEarCmd");
    public static final int DEFAULT_MODE = 0;
    public static final int UNIQUE_NAMES_MODE = 1;
    public static final String JNDIPREFIX_ACTSPEC = "eis/";
    public static final String JNDIPREFIX_ADMINOBJECT = "eis/";
    private DataSourceBinding defaultDataSourceBinding = null;
    private ConnectionFactoryBinding defaultConnectionFactoryBinding = null;
    protected Preferences preferences = null;
    private int mode = 0;
    protected Properties _ejbNameMap = new Properties();
    protected Properties _ejbHomeMap = new Properties();
    protected Vector _duplicateHomes = new Vector();

    public DefaultStrategy() {
        this.preferences = new Preferences();
    }

    public DefaultStrategy(Preferences preferences) {
        this.preferences = preferences;
    }

    public String toString() {
        return "DefaultStrategy{ prefs=" + this.preferences.toString() + ", mode=" + this.mode + " }";
    }

    public String getEJBBinding(EjbId ejbInfo, String defaultName, BindingStrategy.WarningCollaborator warningCollaborator) {
        String localHomeInterface;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultName});
        }
        String result = null;
        String ejbName = this.toValidIdentifier(ejbInfo.getEjbName());
        result = defaultName != null && !this.preferences.getForceBindings() ? defaultName : this.preferences.getEjbJndiPrefix() + "/" + ejbName;
        if (this._ejbNameMap.getProperty(ejbInfo.getEjbName()) == null) {
            this._ejbNameMap.setProperty(ejbInfo.getEjbName(), result);
        } else {
            warningCollaborator.logWarning("BNDEAR0005", new Object[]{ejbInfo.getEjbName()});
        }
        String homeInterface = ejbInfo.getHomeInterface();
        if (homeInterface != null) {
            if (this._ejbHomeMap.getProperty(homeInterface) == null) {
                this._ejbHomeMap.setProperty(homeInterface, result);
            } else {
                this._duplicateHomes.add(homeInterface);
            }
        }
        if ((localHomeInterface = ejbInfo.getLocalHomeInterface()) != null) {
            if (this._ejbHomeMap.getProperty(localHomeInterface) == null) {
                this._ejbHomeMap.setProperty(localHomeInterface, result);
            } else {
                this._duplicateHomes.add(localHomeInterface);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getEJBBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultName, "result=" + result});
        }
        return result;
    }

    public DataSourceBinding getEJBDatasourceBinding(EjbId ejbInfo, DataSourceBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaults});
        }
        DataSourceBinding result = null;
        switch (this.getMode()) {
            case 1: {
                String ejbName = this.toValidIdentifier(ejbInfo.getEjbName());
                result = new DataSourceBinding(ejbName + ".datasource", ejbName + ".user", ejbName + ".password", ejbName + ".loginCfg", ejbName + ".authProps");
                break;
            }
            default: {
                result = defaults;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBDatasourceBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getEJBRefBinding(EjbId ejbInfo, String defaultBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultBinding});
        }
        String result = null;
        if (defaultBinding != null && !this.preferences.getForceBindings()) {
            result = defaultBinding;
        } else {
            String ejbLink = ejbInfo.getEjbLink();
            if (ejbLink != null) {
                result = this._ejbNameMap.getProperty(ejbLink);
                if (result == null && ejbLink.indexOf(35) >= 0) {
                    String shortName = ejbLink.substring(ejbLink.lastIndexOf(35) + 1);
                    result = this._ejbNameMap.getProperty(shortName);
                }
                if (result == null) {
                    warningCollaborator.logWarning("BNDEAR0006", new Object[]{ejbLink});
                }
            }
            if (result == null && ejbInfo.getHomeInterface() != null) {
                result = this._ejbHomeMap.getProperty(ejbInfo.getHomeInterface());
                if (result == null) {
                    warningCollaborator.logWarning("BNDEAR0007", new Object[]{ejbInfo.getHomeInterface()});
                }
                if (this._duplicateHomes.contains(ejbInfo.getHomeInterface())) {
                    warningCollaborator.logWarning("BNDEAR0008", new Object[]{ejbInfo.getHomeInterface()});
                }
            }
            if (result == null && ejbInfo.getLocalHomeInterface() != null) {
                result = this._ejbHomeMap.getProperty(ejbInfo.getLocalHomeInterface());
                if (result == null) {
                    warningCollaborator.logWarning("BNDEAR0007", new Object[]{ejbInfo.getLocalHomeInterface()});
                }
                if (this._duplicateHomes.contains(ejbInfo.getLocalHomeInterface())) {
                    warningCollaborator.logWarning("BNDEAR0008", new Object[]{ejbInfo.getLocalHomeInterface()});
                }
            }
            if (result == null && ejbInfo.getEjbName() != null) {
                String ejbName = this.toValidIdentifier(ejbInfo.getEjbName());
                result = this.preferences.getEjbJndiPrefix() + "/" + ejbName;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getEJBRefBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaultBinding, "result=" + result});
        }
        return result;
    }

    public ResourceRefMapElement getResourceRefBinding(String resourceRefName, String resourceType, String moduleName, String componentName, String defaultBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        ResourceRefMapElement result = defaultBinding != null && !this.preferences.getForceBindings() ? new ResourceRefMapElement(defaultBinding, null, null) : new ResourceRefMapElement(resourceRefName, null, null);
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getResourceRefBinding", new Object[]{"refName=" + resourceRefName, "type=" + resourceType, "module=" + moduleName, "component=" + componentName, "default=" + defaultBinding, "result=" + result});
        }
        return result;
    }

    public String getVirtualHost(String defaultBinding, String moduleName, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result = null;
        result = defaultBinding != null && !defaultBinding.trim().equals("") && !this.preferences.getForceBindings() ? defaultBinding : this.preferences.getVirtualHost();
        return result;
    }

    public DataSourceBinding getDefaultDatasourceBindings(String ejbJarName, DataSourceBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDatasourceBindings", new Object[]{"ejbJarName=" + ejbJarName, "defaults=" + defaults});
        }
        DataSourceBinding result = null;
        if (defaults != null && defaults.getJndiName() != null && !this.preferences.getForceBindings()) {
            result = defaults;
        } else {
            switch (this.getMode()) {
                case 1: {
                    result = new DataSourceBinding(ejbJarName + ".datasource", ejbJarName + ".user", ejbJarName + ".password", ejbJarName + ".loginCfg", ejbJarName + ".authProps");
                    break;
                }
                default: {
                    result = this.getDefaultDataSourceBinding();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDatasource", new Object[]{"ejbJarName=" + ejbJarName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getResourceEnvRefBinding(String resourceEnvRefName, String resourceType, String moduleName, String componentName, String defaultBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result;
        String string = result = defaultBinding != null && !this.preferences.getForceBindings() ? defaultBinding : resourceEnvRefName;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getResourceEnvRefBinding", new Object[]{"resRefName=" + resourceEnvRefName, "type=" + resourceType, "module=" + moduleName, "component=" + componentName, "default=" + defaultBinding, "result=" + result});
        }
        return result;
    }

    public String getMessageDestinationRefBinding(String mdRefName, String linkName, String moduleName, String componentName, String preExistingBinding, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result;
        String string = preExistingBinding != null && !this.preferences.getForceBindings() ? preExistingBinding : (result = linkName != null ? linkName : mdRefName);
        if (preExistingBinding == null || this.preferences.getForceBindings()) {
            result = "eis/" + result;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getMessageDestinationRefBinding", new Object[]{"mdRefName=" + mdRefName, "module=" + moduleName, "component=" + componentName, "default=" + preExistingBinding, "result=" + result});
        }
        return result;
    }

    private DataSourceBinding getDefaultDataSourceBinding() {
        if (this.defaultDataSourceBinding == null) {
            this.defaultDataSourceBinding = new DataSourceBinding(this.preferences.getDefaultDataSourceJndiName(), this.preferences.getDefaultDataSourceUser(), this.preferences.getDefaultDataSourcePassword(), this.preferences.getDefaultDataSourceLoginCfg(), this.preferences.getDefaultDataSourceAuthProps());
        }
        return this.defaultDataSourceBinding;
    }

    private ConnectionFactoryBinding getDefaultConnectionFactoryBinding() {
        if (this.defaultConnectionFactoryBinding == null) {
            this.defaultConnectionFactoryBinding = new ConnectionFactoryBinding(this.preferences.getDefaultConnectionFactoryJndiName(), this.preferences.getDefaultConnectionFactoryResAuth(), this.preferences.getDefaultConnectionFactoryLoginCfg(), this.preferences.getDefaultConnectionFactoryAuthProps());
        }
        return this.defaultConnectionFactoryBinding;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setPreferences(Preferences prefs) {
        this.preferences = prefs;
        this.defaultDataSourceBinding = null;
    }

    public ConnectionFactoryBinding getDefaultConnectionFactoryBindings(String ejbJarName, ConnectionFactoryBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJarName=" + ejbJarName, "defaults=" + defaults});
        }
        ConnectionFactoryBinding result = null;
        if (defaults != null && defaults.getJndiName() != null && !this.preferences.getForceBindings()) {
            result = defaults;
        } else {
            switch (this.getMode()) {
                case 1: {
                    result = new ConnectionFactoryBinding(ejbJarName + ".connFactory", Preferences.RES_AUTH_PER_CONN_FACT, ejbJarName + ".loginCfg", ejbJarName + ".authProps");
                    break;
                }
                default: {
                    result = this.getDefaultConnectionFactoryBinding();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConnectionFactoryBindings", new Object[]{"ejbJarName=" + ejbJarName, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public ConnectionFactoryBinding getEJBConnectionFactoryBinding(EjbId ejbInfo, ConnectionFactoryBinding defaults, BindingStrategy.WarningCollaborator warningCollaborator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbInfo, "default=" + defaults});
        }
        ConnectionFactoryBinding result = null;
        switch (this.getMode()) {
            case 1: {
                String ejbName = ejbInfo.getEjbName();
                result = new ConnectionFactoryBinding(ejbName + ".connfact", Preferences.RES_AUTH_PER_CONN_FACT, ejbName + ".loginCfg", ejbName + ".authProps");
                break;
            }
            default: {
                result = defaults;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJBConnectionFactoryBinding", new Object[]{"ejbInfo=" + ejbInfo, "defaults=" + defaults, "result=" + result});
        }
        return result;
    }

    public String getMDBListenerPort(String mdbName, String defaultListener, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result = null;
        result = defaultListener != null && !this.preferences.getForceBindings() ? defaultListener : this.toValidIdentifier(mdbName) + "Port";
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getMDBListenerPort", new Object[]{"mdbName=" + mdbName, "default=" + defaultListener, "result=" + result});
        }
        return result;
    }

    public String getMDBActivationSpec(String mdbName, String defaultJNDI, boolean bCreate, BindingStrategy.WarningCollaborator warningCollaborator) {
        String result = null;
        if (defaultJNDI != null && !this.preferences.getForceBindings()) {
            result = defaultJNDI;
        } else if (bCreate) {
            result = "eis/" + this.toValidIdentifier(mdbName);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getMDBListenerPort", new Object[]{"mdbName=" + mdbName, "default=" + defaultJNDI, "result=" + result});
        }
        return result;
    }

    String toValidIdentifier(String s) {
        char[] chars = s.trim().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public static void main(String[] args) {
        DefaultStrategy d = new DefaultStrategy();
        String s = d.toValidIdentifier(" this; lt<&gt; is #$!@ing \ntest  \t");
        System.out.println(s);
    }
}

