/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs;

import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.impl.CommonbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPResAuthType;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndFactory;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndPackage;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.impl.EjbbndFactoryImpl;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.ws.management.application.client.DataSourceFor20CMPBeansHelper;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.BindingStrategy;
import com.ibm.ws.management.application.dfltbndngs.ConnectionFactoryBinding;
import com.ibm.ws.management.application.dfltbndngs.CustomizeableStrategy;
import com.ibm.ws.management.application.dfltbndngs.DataSourceBinding;
import com.ibm.ws.management.application.dfltbndngs.DefaultStrategy;
import com.ibm.ws.management.application.dfltbndngs.EjbId;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.dfltbndngs.StrategyExporter;
import com.ibm.ws.management.application.dfltbndngs.utils.EJBRefPkg;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceEnvRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllResourceRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetAllVirtualHosts;
import com.ibm.ws.management.application.dfltbndngs.utils.GetEjbRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.GetMessageDestinationRefs;
import com.ibm.ws.management.application.dfltbndngs.utils.MessageDestinationRefPkg;
import com.ibm.ws.management.application.dfltbndngs.utils.ResEnvRef;
import com.ibm.ws.management.application.dfltbndngs.utils.ResRef;
import com.ibm.ws.management.util.RasUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class BindEarCmd
implements BindingStrategy.WarningCollaborator {
    static TraceComponent tc = Tr.register(BindEarCmd.class, null, "com.ibm.ws.management.application.dfltbndngs.BindEarCmd");
    private static final String CLASS_NAME;
    private EARFile ear = null;
    private BindingStrategy strategy = null;
    private Vector warnings = null;
    private ResourceBundle nlsBundle = null;
    private Preferences preferences = null;
    private boolean isCreateMode = false;

    public String toString() {
        return "BindEarCmd{ ear=" + this.ear + ", strategy=" + this.strategy + "}";
    }

    public BindEarCmd() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>()");
        }
        this.preferences = new Preferences();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>()", this.toString());
        }
    }

    public BindEarCmd(EARFile ear) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile)", ear);
        }
        this.ear = ear;
        this.strategy = new DefaultStrategy();
        this.preferences = new Preferences();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile)", this.toString());
        }
    }

    public BindEarCmd(EARFile ear, boolean create) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile)", ear);
        }
        this.ear = ear;
        this.isCreateMode = create;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile)", this.toString());
        }
    }

    public BindEarCmd(EARFile ear, Preferences preferences) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>(EARFile,Preferences)", new Object[]{ear, preferences});
        }
        this.ear = ear;
        this.preferences = preferences;
        if (preferences.getStrategyFile() == null || preferences.getStrategyFile().length() == 0 || preferences.getStrategyFile().equalsIgnoreCase("default")) {
            this.strategy = new DefaultStrategy(preferences);
        } else {
            this.strategy = new CustomizeableStrategy(preferences);
            if (!preferences.getStrategyFile().equals("_NULL_")) {
                try {
                    ((CustomizeableStrategy)this.strategy).parse(preferences.getStrategyFile());
                }
                catch (Throwable t) {
                    RasUtils.logException(t, tc, CLASS_NAME, "<init>", "186", this);
                    t.printStackTrace();
                    throw new IllegalStateException("error enabling custom strategy");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>(EARFile,Preferences)", this.toString());
        }
    }

    public EARFile getEar() {
        return this.ear;
    }

    public void setEar(EARFile ear) {
        this.ear = ear;
    }

    public BindingStrategy getStrategy() {
        return this.strategy;
    }

    public boolean bind() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bind", this.toString());
        }
        this.warnings = new Vector();
        this.bindEjbs();
        this.bindResourceRefs();
        this.bindResourceEnvRefs();
        this.bindEjbRefs();
        if (!this.isCreateMode) {
            this.bindVirtualHosts();
        }
        this.bindMessageDestinationRefs();
        if (!this.isCreateMode && this.preferences.getExportFile() != null) {
            StrategyExporter exporter = new StrategyExporter(this.preferences, this.ear);
            exporter.export();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bind", this.warnings.toString());
        }
        return this.warnings.size() == 0;
    }

    public Collection getWarnings() {
        return this.warnings;
    }

    public void logWarning(String key, Object[] args) {
        Tr.warning(tc, key, args);
        if (this.nlsBundle == null) {
            this.nlsBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.BindEarCmd");
        }
        this.warnings.add(MessageFormat.format(this.nlsBundle.getString(key), args));
    }

    protected void bindEjbs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbs");
        }
        try {
            List ejbModuleRefs = this.getEar().getEJBModuleRefs();
            for (int i = 0; i < ejbModuleRefs.size(); ++i) {
                EJBModuleRef ejbModuleRef = (EJBModuleRef)ejbModuleRefs.get(i);
                EJBJarFile ejbJarFile = (EJBJarFile)ejbModuleRef.getModuleFile();
                EJBJar ejbJar = ejbModuleRef.getEJBJar();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ejbJar: " + ejbJar);
                }
                if (ejbJar != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "DD version: " + AppDeploymentUtil.getModuleVersion(ejbJarFile));
                }
                if (ejbJar != null) {
                    EJBJarBinding ejbJarBinding = ejbModuleRef.getEJBJarBinding();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "bindEjbs - found EJB jar", new Object[]{"ejbJar=" + ejbJarFile.getName()});
                    }
                    if (ejbJarBinding == null) {
                        ejbJarBinding = EjbbndFactoryImpl.getActiveFactory().createEJBJarBinding();
                        ejbJarBinding.setEjbJar(ejbJar);
                    }
                    if (AppDeploymentUtil.getModuleVersion(ejbJarFile) == 12) {
                        this.bindEjbJarDefaultDatasource(ejbJarFile, ejbJarBinding);
                    } else {
                        this.bindEjbJarDefaultDatasource(ejbJarFile, ejbJarBinding);
                        this.bindEjbJarDefaultConnectionFactory(ejbJarFile, ejbJarBinding);
                    }
                    boolean isEE5 = AppDeploymentUtil.isEE5SchemaDD(ejbJarFile);
                    EList ejbs = ejbJar.getEnterpriseBeans();
                    for (int j = 0; j < ejbs.size(); ++j) {
                        EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                        if (ejb.isMessageDriven()) {
                            this.bindMdb((MessageDriven)ejb, ejbJarBinding);
                            continue;
                        }
                        if (isEE5) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "BindEarCmd.bindEjbs: ejbModuleRef.getEJBJar() is EJB 3.0 DD. Skipping binding of: " + ejbModuleRef.getUri());
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "BindEarCmd.bindEjbs:  Process binding of: " + ejbModuleRef.getUri());
                        }
                        this.bindNonMdb(ejb, ejbJarBinding, ejbJar);
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "BindEarCmd.bindEjbs: ejbModuleRef.getEJBJar() is nullSkipping binding of: " + ejbModuleRef.getUri());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindEjbs");
            }
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "bindEjbs", "380", this);
            Tr.error(tc, "BNDEAR0000", ex.getMessage());
            throw new BindingError("couldnt bind EJBs", ex);
        }
    }

    protected void bindMdb(MessageDriven mdb, EJBJarBinding ejbJarBinding) throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMdb", new Object[]{"mdb=" + mdb, "ejbBinding=" + ejbJarBinding});
        }
        MessageDrivenBeanBinding binding = (MessageDrivenBeanBinding)ejbJarBinding.getEJBBinding(mdb);
        EList ejbBindings = ejbJarBinding.getEjbBindings();
        if (binding == null) {
            EjbbndFactory bindingFactory = ((EjbbndPackage)EPackage.Registry.INSTANCE.getEPackage("ejbbnd.xmi")).getEjbbndFactory();
            binding = bindingFactory.createMessageDrivenBeanBinding();
            binding.setEnterpriseBean(mdb);
            binding.setModuleBinding(ejbJarBinding);
            ejbBindings.add(binding);
        }
        if (this.isCreateMode) {
            return;
        }
        String strPreferExisting = System.getProperty("com.ibm.websphere.management.application.dfltbndng.mdb.preferexisting");
        Tr.debug(tc, "The Value of strPreferExisting" + strPreferExisting);
        String jndiName = binding.getActivationSpecJndiName();
        String listenerPort = binding.getListenerInputPortName();
        Tr.debug(tc, "The Value of jndiName" + jndiName);
        Tr.debug(tc, "The Value of listenerPort" + listenerPort);
        if (strPreferExisting == null || !strPreferExisting.equalsIgnoreCase("true") || (jndiName == null || jndiName.equals("")) && (listenerPort == null || listenerPort.equals(""))) {
            String customProp = "com.ibm.websphere.management.application.dfltbndng.mdb.preferMDBCustomBindingsExclusive";
            boolean preferCustomBnd = "true".equalsIgnoreCase(System.getProperty(customProp));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prefer custom bnd flag for MDB = " + preferCustomBnd);
            }
            if ((jndiName = this.getStrategy().getMDBActivationSpec(mdb.getName(), jndiName, ((XMLResource)ejbJarBinding.getEjbJar().eResource()).getVersionID() > 13, this)) != null) {
                binding.setActivationSpecJndiName(jndiName);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "bindMdb", new Object[]{"mdb=" + mdb, "ejbBinding=" + ejbJarBinding, "jndiName=" + jndiName});
            }
            if (jndiName != null && preferCustomBnd) {
                binding.setListenerInputPortName(null);
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "preferMDBCustomBindingsExclusive is set and act spec jndi is non null so setting lport to null");
                }
            }
            if (jndiName == null) {
                listenerPort = this.getStrategy().getMDBListenerPort(mdb.getName(), listenerPort, this);
                binding.setListenerInputPortName(listenerPort);
                if (preferCustomBnd) {
                    if (((XMLResource)ejbJarBinding.getEjbJar().eResource()).getVersionID() > 13) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EJb2.1 so set act spec jndi to null");
                        }
                        binding.setActivationSpecJndiName(null);
                        binding.setDestinationJndiName(null);
                    } else if (this.getStrategy() instanceof CustomizeableStrategy && ((CustomizeableStrategy)this.getStrategy()).hasMDBListenerPortCustom(mdb.getName())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EJb2.0 and has listener port in custom so setting act spec to null");
                        }
                        binding.setActivationSpecJndiName(null);
                        binding.setDestinationJndiName(null);
                    }
                }
            }
        }
    }

    protected void bindNonMdb(EnterpriseBean ejb, EJBJarBinding ejbJarBinding, EJBJar ejbJar) throws BindingError {
        boolean isCMP1X;
        EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
        EList ejbBindings = ejbJarBinding.getEjbBindings();
        if (ejbBinding == null) {
            ejbBinding = EjbbndFactoryImpl.getActiveFactory().createEnterpriseBeanBinding();
            ejbBinding.setEnterpriseBean(ejb);
            ejbBinding.setModuleBinding(ejbJarBinding);
            ejbBindings.add(ejbBinding);
        }
        boolean isCMP = ejb.isEntity() && ((Entity)ejb).isContainerManagedEntity();
        boolean bl = isCMP1X = isCMP && ejb.getVersionID() == 11;
        if (isCMP) {
            if (isCMP1X) {
                BasicAuthData auth;
                ResourceRefBinding datasource = ejbBinding.getDatasource();
                if (datasource == null) {
                    datasource = CommonbndFactoryImpl.getActiveFactory().createResourceRefBinding();
                    ejbBinding.setDatasource(datasource);
                }
                if ((auth = (BasicAuthData)datasource.getDefaultAuth()) == null) {
                    auth = CommonbndFactoryImpl.getActiveFactory().createBasicAuthData();
                    datasource.setDefaultAuth(auth);
                }
            } else {
                CMPConnectionFactoryBinding connFactBinding = ejbBinding.getCmpConnectionFactory();
                if (connFactBinding == null) {
                    connFactBinding = EjbbndFactoryImpl.getActiveFactory().createCMPConnectionFactoryBinding();
                    ejbBinding.setCmpConnectionFactory(connFactBinding);
                }
            }
        }
        if (this.isCreateMode) {
            return;
        }
        String jndiName = ejbBinding.getJndiName();
        String ejbName = ejb.getName();
        String ejbHome = ejb.getHomeInterfaceName();
        String ejbRemote = ejb.getRemoteInterfaceName();
        String ejbLocalHome = ejb.getLocalHomeInterfaceName();
        String ejbLocal = ejb.getLocalInterfaceName();
        EjbId ejbInfo = new EjbId(ejbName, ejbHome, ejbRemote, ejbLocalHome, ejbLocal, null);
        jndiName = this.getStrategy().getEJBBinding(ejbInfo, jndiName, this);
        ejbBinding.setJndiName(jndiName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindEjb - bound EJB", new Object[]{"ejbInfo=" + ejbInfo, "jndiName=" + jndiName});
        }
        if (isCMP) {
            if (isCMP1X) {
                if (!(this.bindCmpToDataSource((Entity)ejb, ejbBinding) || ejbJarBinding.getDefaultDatasource() != null && ejbJarBinding.getDefaultDatasource().getJndiName() != null && ejbJarBinding.getDefaultDatasource().getJndiName().trim().length() != 0)) {
                    this.logWarning("BNDEAR0010", new Object[]{ejbName});
                }
            } else if (!(this.bindCmpToConnectionFactory((Entity)ejb, ejbBinding) || ejbJarBinding.getDefaultCMPConnectionFactory() != null && ejbJarBinding.getDefaultCMPConnectionFactory().getJndiName() != null && ejbJarBinding.getDefaultCMPConnectionFactory().getJndiName().trim().length() != 0)) {
                this.logWarning("BNDEAR0009", new Object[]{ejbName});
            }
        }
    }

    protected boolean bindCmpToDataSource(Entity ejb, EnterpriseBeanBinding ejbBinding) throws BindingError {
        boolean result = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindCmpToDataSource", new Object[]{"ejb=" + ejb, "ejbBinding=" + ejbBinding});
        }
        ResourceRefBinding datasource = ejbBinding.getDatasource();
        BasicAuthData auth = (BasicAuthData)datasource.getDefaultAuth();
        String ejbName = ejb.getName();
        String ejbHome = ejb.getHomeInterfaceName();
        String ejbRemote = ejb.getRemoteInterfaceName();
        String ejbLocalHome = ejb.getLocalHomeInterfaceName();
        String ejbLocal = ejb.getLocalInterfaceName();
        EjbId ejbInfo = new EjbId(ejbName, ejbHome, ejbRemote, ejbLocalHome, ejbLocal, null);
        DataSourceBinding dsBinding = new DataSourceBinding(datasource.getJndiName(), auth.getUserId(), auth.getPassword(), datasource.getLoginConfigurationName(), null);
        dsBinding = this.getStrategy().getEJBDatasourceBinding(ejbInfo, dsBinding, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindCmpToDataSource - binding info:", new Object[]{"ejbInfo=" + ejbInfo, "binding=" + dsBinding});
        }
        if (dsBinding.getJndiName() == null || dsBinding.getJndiName().trim().length() == 0) {
            result = false;
        } else {
            datasource.setJndiName(dsBinding.getJndiName());
            if (dsBinding.getLoginCfg() != null) {
                datasource.setLoginConfigurationName(dsBinding.getLoginCfg());
            }
            ejbBinding.setDatasource(datasource);
            CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
            if (dsBinding.getLoginCfg() != null && dsBinding.getAuthProps() != null) {
                this.setUpProps(commonFact, datasource, dsBinding.getLoginCfg(), dsBinding.getAuthProps());
            }
            if (dsBinding.getUser() != null) {
                auth.setUserId(dsBinding.getUser());
                auth.setPassword(dsBinding.getPassword());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindCmpToDataSource", new Object[]{"ejb=" + ejb, "ejbBinding=" + ejbBinding});
        }
        return result;
    }

    protected boolean bindCmpToConnectionFactory(Entity ejb, EnterpriseBeanBinding ejbBinding) throws BindingError {
        boolean result = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindCmpToConnectionFactory", new Object[]{"ejb=" + ejb, "ejbBinding=" + ejbBinding});
        }
        CMPConnectionFactoryBinding connFactBinding = ejbBinding.getCmpConnectionFactory();
        String ejbName = ejb.getName();
        String ejbHome = ejb.getHomeInterfaceName();
        String ejbRemote = ejb.getRemoteInterfaceName();
        String ejbLocalHome = ejb.getLocalHomeInterfaceName();
        String ejbLocal = ejb.getLocalInterfaceName();
        int resAuth = 0;
        if (connFactBinding.getResAuth() != null) {
            resAuth = connFactBinding.getResAuth().getValue();
        }
        EjbId ejbInfo = new EjbId(ejbName, ejbHome, ejbRemote, ejbLocalHome, ejbLocal, null);
        ConnectionFactoryBinding cfBinding = new ConnectionFactoryBinding(connFactBinding.getJndiName(), resAuth, connFactBinding.getLoginConfigurationName(), null);
        cfBinding = this.getStrategy().getEJBConnectionFactoryBinding(ejbInfo, cfBinding, this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "bindCmpToConnectionFactory - binding info:", new Object[]{"ejbInfo=" + ejbInfo, "binding=" + cfBinding});
        }
        if (cfBinding.getJndiName() == null || cfBinding.getJndiName().trim().length() == 0) {
            result = false;
        } else {
            CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
            connFactBinding.setJndiName(cfBinding.getJndiName());
            connFactBinding.setResAuth(CMPResAuthType.get(cfBinding.getResAuth()));
            if (cfBinding.getLoginCfg() != null) {
                connFactBinding.setLoginConfigurationName(cfBinding.getLoginCfg());
            }
            if (cfBinding.getLoginCfg() != null && cfBinding.getAuthProps() != null) {
                DataSourceFor20CMPBeansHelper.setUpProps(commonFact, connFactBinding, cfBinding.getLoginCfg(), cfBinding.getAuthProps());
            }
            ejbBinding.setCmpConnectionFactory(connFactBinding);
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindCmpToConnectionFactory", new Object[]{"ejb=" + ejb, "ejbBinding=" + ejbBinding});
        }
        return result;
    }

    protected void bindEjbJarDefaultConnectionFactory(EJBJarFile ejbJarFile, EJBJarBinding ejbJarBinding) throws BindingError {
        CMPConnectionFactoryBinding connFactBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultConnectionFactory", new Object[]{"ejbJar=" + ejbJarFile, "bnd=" + ejbJarBinding});
        }
        if ((connFactBinding = ejbJarBinding.getDefaultCMPConnectionFactory()) == null && ejbJarFile.getDeploymentDescriptor().getContainerManagedBeans().size() > 0) {
            EList ejbs = ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbs: " + ejbs);
            }
            boolean hasCMPs = false;
            if (ejbs != null) {
                for (int j = 0; j < ejbs.size(); ++j) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb name: " + ejb.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb version: " + ejb.getVersionID());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb CMP: " + ejb.isContainerManagedEntity());
                    }
                    if (!ejb.isContainerManagedEntity()) continue;
                    if (((ContainerManagedEntity)ejb).isVersion2_X() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "contains 2.0 or above CMPs");
                    }
                    hasCMPs = true;
                    break;
                }
            }
            if (hasCMPs) {
                connFactBinding = EjbbndFactoryImpl.getActiveFactory().createCMPConnectionFactoryBinding();
                ejbJarBinding.setDefaultCMPConnectionFactory(connFactBinding);
            }
        }
        if (this.isCreateMode || connFactBinding == null) {
            return;
        }
        String strLoginCfg = null;
        int resAuth = 0;
        if (connFactBinding.getResAuth() != null) {
            resAuth = connFactBinding.getResAuth().getValue();
        }
        if (connFactBinding.getLoginConfigurationName() != null) {
            strLoginCfg = connFactBinding.getLoginConfigurationName();
        }
        ConnectionFactoryBinding defaults = new ConnectionFactoryBinding(connFactBinding.getJndiName(), resAuth, strLoginCfg, null);
        defaults = this.getStrategy().getDefaultConnectionFactoryBindings(ejbJarFile.getName(), defaults, this);
        if (defaults.getJndiName() != null) {
            CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
            connFactBinding.setJndiName(defaults.getJndiName());
            connFactBinding.setResAuth(CMPResAuthType.get(defaults.getResAuth()));
            if (defaults.getLoginCfg() != null) {
                connFactBinding.setLoginConfigurationName(defaults.getLoginCfg());
            }
            if (defaults.getLoginCfg() != null && defaults.getAuthProps() != null) {
                DataSourceFor20CMPBeansHelper.setUpProps(commonFact, connFactBinding, defaults.getLoginCfg(), defaults.getAuthProps());
            }
            ejbJarBinding.setDefaultCMPConnectionFactory(connFactBinding);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultConnectionFactory", new Object[]{"ejbJar=" + ejbJarFile, "bnd=" + ejbJarBinding, "values=" + defaults});
        }
    }

    protected void bindEjbJarDefaultDatasource(EJBJarFile ejbJarFile, EJBJarBinding ejbJarBinding) throws BindingError {
        ResourceRefBinding defaultDatasource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultDatasource", new Object[]{"ejbJar=" + ejbJarFile, "bnd=" + ejbJarBinding});
        }
        if ((defaultDatasource = ejbJarBinding.getDefaultDatasource()) == null && ejbJarFile.getDeploymentDescriptor().getContainerManagedBeans().size() > 0) {
            EList ejbs = ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbs: " + ejbs);
            }
            boolean hasCMPs = false;
            if (ejbs != null) {
                for (int j = 0; j < ejbs.size(); ++j) {
                    EnterpriseBean ejb = (EnterpriseBean)ejbs.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb name: " + ejb.getName());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb version: " + ejb.getVersionID());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb CMP: " + ejb.isContainerManagedEntity());
                    }
                    if (!ejb.isContainerManagedEntity() || !((ContainerManagedEntity)ejb).isVersion1_X()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "contains 1.0 CMPs");
                    }
                    hasCMPs = true;
                    break;
                }
            }
            if (hasCMPs) {
                defaultDatasource = CommonbndFactoryImpl.getActiveFactory().createResourceRefBinding();
                ejbJarBinding.setDefaultDatasource(defaultDatasource);
            }
        }
        BasicAuthData auth = null;
        if (defaultDatasource != null && (auth = (BasicAuthData)defaultDatasource.getDefaultAuth()) == null) {
            auth = CommonbndFactoryImpl.getActiveFactory().createBasicAuthData();
            defaultDatasource.setDefaultAuth(auth);
        }
        if (this.isCreateMode || defaultDatasource == null) {
            return;
        }
        DataSourceBinding dsBinding = new DataSourceBinding(defaultDatasource.getJndiName(), auth.getUserId(), auth.getPassword(), defaultDatasource.getLoginConfigurationName(), null);
        dsBinding = this.getStrategy().getDefaultDatasourceBindings(ejbJarFile.getName(), dsBinding, this);
        if (dsBinding.getJndiName() != null) {
            defaultDatasource.setJndiName(dsBinding.getJndiName());
        }
        if (dsBinding.getLoginCfg() != null) {
            defaultDatasource.setLoginConfigurationName(dsBinding.getLoginCfg());
        }
        CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
        CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
        if (dsBinding.getLoginCfg() != null && dsBinding.getAuthProps() != null) {
            this.setUpProps(commonFact, defaultDatasource, dsBinding.getLoginCfg(), dsBinding.getAuthProps());
        }
        if (dsBinding.getUser() != null) {
            auth.setUserId(dsBinding.getUser());
            auth.setPassword(dsBinding.getPassword());
            defaultDatasource.setDefaultAuth(auth);
        }
        ejbJarBinding.setDefaultDatasource(defaultDatasource);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbJarDefaultDatasource", new Object[]{"ejbJar=" + ejbJarFile, "bnd=" + ejbJarBinding});
        }
    }

    protected void bindEjbRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindEjbRefs");
        }
        GetEjbRefs cmd = new GetEjbRefs(this.getEar(), this.isCreateMode);
        try {
            Iterator ejbRefs = cmd.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindEjbRefs");
                }
                return;
            }
            if (ejbRefs.hasNext()) {
                while (ejbRefs.hasNext()) {
                    EJBRefPkg pkg = (EJBRefPkg)ejbRefs.next();
                    String jndiName = pkg.getRefBinding().getJndiName();
                    String ejbRefName = pkg.getRefBinding().getBindingEjbRef().getName();
                    String ejbHome = pkg.getRefBinding().getBindingEjbRef().getHome();
                    String ejbRemote = pkg.getRefBinding().getBindingEjbRef().getRemote();
                    String ejbLink = pkg.getRefBinding().getBindingEjbRef().getLink();
                    EjbId ejbInfo = new EjbId(ejbRefName, ejbHome, ejbRemote, null, null, ejbLink);
                    jndiName = this.getStrategy().getEJBRefBinding(ejbInfo, jndiName, this);
                    pkg.getRefBinding().setJndiName(jndiName);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "<ejb-ref> binding", new Object[]{"package=" + pkg.getQualifier(), "ref=java:comp/env/" + ejbRefName, "jndiName=" + jndiName});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no ejbs refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindEjbRefs");
            }
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "bindEjbRefs", "999", this);
            Tr.error(tc, "BNDEAR0001", ex.getMessage());
            throw new BindingError("couldnt bind EJB refs", ex);
        }
    }

    protected void bindResourceRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindResourceRefs");
        }
        try {
            GetAllResourceRefs allResRefs = new GetAllResourceRefs(this.getEar(), this.isCreateMode);
            Iterator resourceRefs = allResRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindResourceRefs");
                }
                return;
            }
            if (resourceRefs.hasNext()) {
                while (resourceRefs.hasNext()) {
                    ResRef pkg = (ResRef)resourceRefs.next();
                    String jndiName = pkg.getBinding().getJndiName();
                    String refName = pkg.getBinding().getBindingResourceRef().getName();
                    String refType = pkg.getBinding().getBindingResourceRef().getType();
                    String refModule = pkg.getModule();
                    String refComp = pkg.getComponent();
                    jndiName = this.getStrategy().getResourceRefBinding((String)refName, (String)refType, (String)refModule, (String)refComp, (String)jndiName, (BindingStrategy.WarningCollaborator)this).jndiName;
                    String loginCfg = this.getStrategy().getResourceRefBinding((String)refName, (String)refType, (String)refModule, (String)refComp, (String)jndiName, (BindingStrategy.WarningCollaborator)this).loginCfg;
                    String authProps = this.getStrategy().getResourceRefBinding((String)refName, (String)refType, (String)refModule, (String)refComp, (String)jndiName, (BindingStrategy.WarningCollaborator)this).authProps;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<res-ref> binding", new Object[]{"module=" + refModule, "ref=java:comp/env/" + refName, "type=" + refType, "jndi=" + jndiName});
                    }
                    pkg.getBinding().setJndiName(jndiName);
                    if (loginCfg != null) {
                        pkg.getBinding().setLoginConfigurationName(loginCfg);
                    }
                    CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
                    CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
                    if (loginCfg == null || authProps == null) continue;
                    this.setUpProps(commonFact, pkg.getBinding(), loginCfg, authProps);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no resource refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindResourceRefs");
            }
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "bindResourceRefs", "1074", this);
            Tr.error(tc, "BNDEAR0002", ex.getMessage());
            throw new BindingError("couldnt bind resource refs", ex);
        }
    }

    protected void bindResourceEnvRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindResourceEnvRefs");
        }
        try {
            GetAllResourceEnvRefs allResEnvRefs = new GetAllResourceEnvRefs(this.getEar(), this.isCreateMode);
            Iterator resourceEnvRefs = allResEnvRefs.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindResourceEnvRefs");
                }
                return;
            }
            if (resourceEnvRefs.hasNext()) {
                while (resourceEnvRefs.hasNext()) {
                    ResEnvRef pkg = (ResEnvRef)resourceEnvRefs.next();
                    String jndiName = pkg.getBinding().getJndiName();
                    String refName = pkg.getBinding().getBindingResourceEnvRef().getName();
                    String refType = pkg.getBinding().getBindingResourceEnvRef().getTypeName();
                    String refModule = pkg.getModule();
                    String refComp = pkg.getComponent();
                    jndiName = this.getStrategy().getResourceEnvRefBinding(refName, refType, refModule, refComp, jndiName, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<res-env-ref> binding", new Object[]{"module=" + refModule, "ref=java:comp/env/" + refName, "type=" + refType, "jndi=" + jndiName});
                    }
                    pkg.getBinding().setJndiName(jndiName);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no resource env refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindResourceEnvRefs");
            }
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "bindResourceEnvRefs", "1134", this);
            Tr.error(tc, "BNDEAR0003", ex.getMessage());
            throw new BindingError("couldnt bind resource env refs", ex);
        }
    }

    protected void bindMessageDestinationRefs() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMessageDestinationRefs");
        }
        try {
            GetMessageDestinationRefs cmd = new GetMessageDestinationRefs(this.getEar(), this.isCreateMode);
            Iterator mdRefs = cmd.execute().iterator();
            if (this.isCreateMode) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "bindMessageDestinationRefs");
                }
                return;
            }
            if (mdRefs.hasNext()) {
                while (mdRefs.hasNext()) {
                    MessageDestinationRefPkg pkg = (MessageDestinationRefPkg)mdRefs.next();
                    String refName = pkg.getRefBinding().getBindingMessageDestinationRef().getName();
                    String linkName = pkg.getRefBinding().getBindingMessageDestinationRef().getLink();
                    String refModule = pkg.getModule();
                    String refComp = pkg.getComponent();
                    String jndiName = pkg.getRefBinding().getJndiName();
                    jndiName = this.getStrategy().getMessageDestinationRefBinding(refName, linkName, refModule, refComp, jndiName, this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "<message-destination-ref> binding", new Object[]{"module=" + refModule, "ref=java:comp/env/" + refName, "jndi=" + jndiName});
                    }
                    pkg.getRefBinding().setJndiName(jndiName);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no message destination refs found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindMessageDestinationRefs");
            }
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "bindMessageDestinationRefs", "1184", this);
            Tr.error(tc, "BNDEAR0003", ex.getMessage());
            throw new BindingError("couldnt bind message destination refs", ex);
        }
    }

    protected void bindVirtualHosts() throws BindingError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindVirtualHosts");
        }
        GetAllVirtualHosts cmd = new GetAllVirtualHosts(this.getEar());
        try {
            Iterator webAppBindings = cmd.execute().iterator();
            if (webAppBindings.hasNext()) {
                while (webAppBindings.hasNext()) {
                    GetAllVirtualHosts.VirtualHostInfo info = (GetAllVirtualHosts.VirtualHostInfo)webAppBindings.next();
                    WebAppBinding bnd = info.webAppBinding;
                    String virtualHost = bnd.getVirtualHostName();
                    virtualHost = this.getStrategy().getVirtualHost(virtualHost, info.moduleName, this);
                    bnd.setVirtualHostName(virtualHost);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "bindVirtualHosts");
            }
        }
        catch (Throwable ex) {
            RasUtils.logException(ex, tc, CLASS_NAME, "bindVirtualHosts", "1229", this);
            Tr.error(tc, "BNDEAR0004", ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void setUpProps(CommonbndFactory commonFact, ResourceRefBinding rrb, String loginConfig, String auth) {
        EList props = rrb.getProperties();
        if (props.size() > 0) {
            props.clear();
        }
        Property prop = null;
        Object attrList = null;
        if (loginConfig != null && loginConfig.equals("DefaultPrincipalMapping")) {
            prop = commonFact.createProperty();
            prop.setName("com.ibm.mapping.authDataAlias");
            prop.setValue(auth);
            prop.setDescription("description");
            props.add(prop);
            return;
        }
        String pStr = auth;
        String[] ps = new String[]{pStr};
        if (pStr.indexOf(43) != -1) {
            ps = pStr.split("\\+");
        }
        for (int ii = 0; ii < ps.length; ++ii) {
            prop = commonFact.createProperty();
            ObjectName o = null;
            try {
                o = new ObjectName(ps[ii]);
                String w = null;
                w = o.getKeyProperty("name");
                prop.setName(w);
                w = o.getKeyProperty("value");
                if (w.equals("\"\"")) {
                    w = "";
                }
                prop.setValue(w);
                w = o.getKeyProperty("description");
                prop.setDescription(w);
                props.add(prop);
                continue;
            }
            catch (MalformedObjectNameException ex) {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Ignoring Exception: ", ex);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/dfltbndngs/BindEarCmd.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.19.1.10");
        }
        CLASS_NAME = BindEarCmd.class.getName();
    }
}

