/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.dsextensions.PropertyType;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class util {
    private static TraceComponent tc = Tr.register(util.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static AppDeploymentTaskMessages appMessages = new AppDeploymentTaskMessages();
    public static final String UNPROTECTED_METHOD_KEY = "unprotectedMethod";
    public static final String PROTECTED_METHOD_KEY = "protectedMethod";

    public static String getModuleName(AppDeploymentInfo appInstallInfo, EObject refObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleName");
        }
        String displayName = null;
        if (refObject instanceof EJBJar) {
            displayName = ((EJBJar)refObject).getDisplayName();
        } else if (refObject instanceof WebApp) {
            displayName = ((WebApp)refObject).getDisplayName();
        } else if (refObject instanceof Connector) {
            displayName = ((Connector)refObject).getDisplayName();
        }
        if (displayName == null || displayName.equals("")) {
            displayName = appInstallInfo.getModuleForDD(refObject).getUri();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleName");
        }
        return displayName;
    }

    public static String formUriString(AppDeploymentInfo appInstallInfo, EObject refObject1, EObject refObject2) throws AppDeploymentException {
        String ddUri = util.getDDUri(refObject2);
        return appInstallInfo.getModuleForDD(refObject1).getUri() + "," + ddUri;
    }

    public static String formUriString(AppDeploymentInfo appInstallInfo, EObject refObject) throws AppDeploymentException {
        String ddUri = util.getDDUri(refObject);
        return appInstallInfo.getModuleForDD(refObject).getUri() + "," + ddUri;
    }

    private static String getDDUri(EObject refObject) {
        String uri;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDDUri", new Object[]{refObject});
        }
        if ((uri = refObject.eResource().getURI().toString()).matches(".*_merged.xml")) {
            uri = uri.substring(0, uri.indexOf("_merged.xml")) + ".xml";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDDUri", new Object[]{uri});
        }
        return uri;
    }

    public static String[] separateUriString(String uriString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "separateUriString");
        }
        String[] uri = null;
        int sep = uriString.indexOf(",");
        if (sep > 0) {
            uri = new String[]{uriString.substring(0, sep), uriString.substring(sep + 1, uriString.length())};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "separateUriString");
        }
        return uri;
    }

    public static String getModuleUriFromUriString(String uriString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleUriFromUriString");
        }
        String moduleUri = null;
        int sep = uriString.indexOf(",");
        if (sep > 0) {
            moduleUri = uriString.substring(0, sep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleUriFromUriString");
        }
        return moduleUri;
    }

    public static String getDDUriFromUriString(String uriString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDDUriFromUriString");
        }
        String ddUri = null;
        int sep = uriString.indexOf(",");
        if (sep > 0) {
            ddUri = uriString.substring(sep + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDDUriFromUriString");
        }
        return ddUri;
    }

    public static boolean compareUriString(AppDeploymentInfo appInstallInfo, EObject refObject, String uriString) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareUriString");
        }
        boolean compare = true;
        String compareUriString = util.formUriString(appInstallInfo, refObject);
        if (!compareUriString.equals(uriString)) {
            compare = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareUriString");
        }
        return compare;
    }

    public static String[][] buildTaskData(Vector data, int columns) {
        String[][] taskData = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildTaskData");
        }
        if (data.size() > columns) {
            int rows = data.size() / columns;
            taskData = new String[rows][columns];
            int i = 0;
            for (int j = 0; j < rows; ++j) {
                for (int k = 0; k < columns; ++k) {
                    taskData[j][k] = (String)data.elementAt(i++);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildTaskData");
        }
        return taskData;
    }

    public static String[][] buildAndSortTaskData(Vector data, int columns, int sortColumn) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAndSortTaskData");
        }
        String[][] taskData = util.buildTaskData(data, columns);
        String[] temp = null;
        if (taskData != null) {
            for (int i = 1; i < taskData.length; ++i) {
                for (int j = i + 1; j < taskData.length; ++j) {
                    if (taskData[j].length < sortColumn || taskData[i].length < sortColumn || taskData[j][sortColumn].compareTo(taskData[i][sortColumn]) >= 0) continue;
                    temp = taskData[j];
                    taskData[j] = taskData[i];
                    taskData[i] = temp;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAndSortTaskData");
        }
        return taskData;
    }

    public static String mapBooleanToNLSKey(Boolean value) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapBooleanToNLSKey");
        }
        String ret = "AppDeploymentOption.No";
        if (value.booleanValue()) {
            ret = "AppDeploymentOption.Yes";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapBooleanToNLSKey");
        }
        return ret;
    }

    public static Hashtable buildConfigHashtable(String[][] taskData, int nonMutableSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildConfigHashtable");
        }
        Hashtable configTbl = new Hashtable();
        for (int j = 1; j < taskData.length; ++j) {
            Hashtable<String, Object> tbl = new Hashtable<String, Object>();
            for (int i = nonMutableSize; i < taskData[0].length; ++i) {
                if (taskData[j][i] != null) {
                    if (taskData[j][i].equals("AppDeploymentOption.Yes")) {
                        tbl.put(taskData[0][i], Boolean.TRUE);
                        continue;
                    }
                    if (taskData[j][i].equals("AppDeploymentOption.No")) {
                        tbl.put(taskData[0][i], Boolean.FALSE);
                        continue;
                    }
                    tbl.put(taskData[0][i], taskData[j][i]);
                    continue;
                }
                tbl.put(taskData[0][i], "");
            }
            configTbl.put(util.createUniqueModuleNameFromUriString(taskData[j][nonMutableSize - 1]), tbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildConfigHashtable");
        }
        return configTbl;
    }

    public static String createUniqueModuleName(String ddUri, String moduleUri) {
        return moduleUri + "+" + ddUri;
    }

    public static String getModuleURIFromUniqueName(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleUriFromUniqueName");
        }
        String moduleUri = s;
        int sep = s.indexOf("+");
        if (sep > 0) {
            moduleUri = s.substring(0, sep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleUriFromUniqueName");
        }
        return moduleUri;
    }

    public static String getDDURIFromUniqueName(String s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleUriFromUriString");
        }
        String ddUri = "";
        int sep = s.indexOf("+");
        if (sep > 0) {
            ddUri = s.substring(sep + 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleUriFromUriString");
        }
        return ddUri;
    }

    public static String createUniqueModuleNameFromUriString(String uriString) {
        return util.createUniqueModuleName(util.getDDUriFromUriString(uriString), util.getModuleUriFromUriString(uriString));
    }

    private static AppDeploymentMessages getAppMessages(AppDeploymentTask t) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppMessages");
        }
        AppDeploymentMessages msg = null;
        if (t != null) {
            msg = t.getTaskMessages();
        }
        if (msg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default appMessages");
            }
            msg = appMessages;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppMessages");
        }
        return msg;
    }

    public static String getGoalTitle(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getGoalTitle(key);
    }

    public static String getGoalMessage(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getGoalMessage(key);
    }

    public static String getEmptyTaskMessage(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getEmptyTaskMessage(key);
    }

    public static String getDisableTaskMessage(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getDisableTaskMessage(key);
    }

    public static String getColumnName(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getColumnName(key, null);
    }

    public static String getMessage(AppDeploymentTask t, String key) {
        return util.getAppMessages(t).getMessage(key);
    }

    public static Hashtable getMethods(AppDeploymentTask t, EJBJar jar, EnterpriseBean ejb) throws AppDeploymentException {
        Hashtable allMethods;
        Vector unprotectedMethods;
        Vector protectedMethods;
        block21: {
            block20: {
                block19: {
                    block18: {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "getMethods");
                        }
                        protectedMethods = new Vector();
                        unprotectedMethods = new Vector();
                        allMethods = new Hashtable();
                        try {
                            JavaClass localInterface = ejb.getLocalInterface();
                            if (localInterface != null) {
                                Method[] localMethods = localInterface.listMethodExtended();
                                util.scanMethods(jar, ejb, localMethods, protectedMethods, unprotectedMethods, 3);
                            }
                        }
                        catch (NullPointerException ex) {
                            throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0035E"), ejb.getDisplayName()), ex);
                        }
                        catch (AccessControlException acex) {
                            if (!tc.isEntryEnabled()) break block18;
                            Tr.debug(tc, "Exception Received: " + acex.getMessage(), acex);
                        }
                    }
                    try {
                        JavaClass homeInterface = ejb.getHomeInterface();
                        if (homeInterface != null) {
                            Method[] homeMethods = homeInterface.listMethodExtended();
                            util.scanMethods(jar, ejb, homeMethods, protectedMethods, unprotectedMethods, 2);
                        }
                    }
                    catch (NullPointerException ex) {
                        throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0036E"), ejb.getDisplayName()), ex);
                    }
                    catch (AccessControlException acex) {
                        if (!tc.isEntryEnabled()) break block19;
                        Tr.debug(tc, "Exception Received: " + acex.getMessage(), acex);
                    }
                }
                try {
                    JavaClass localHomeInterface = ejb.getLocalHomeInterface();
                    if (localHomeInterface != null) {
                        Method[] localHomeMethods = localHomeInterface.listMethodExtended();
                        util.scanMethods(jar, ejb, localHomeMethods, protectedMethods, unprotectedMethods, 4);
                    }
                }
                catch (NullPointerException ex) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0037E"), ejb.getDisplayName()), ex);
                }
                catch (AccessControlException acex) {
                    if (!tc.isEntryEnabled()) break block20;
                    Tr.debug(tc, "Exception Received: " + acex.getMessage(), acex);
                }
            }
            try {
                JavaClass remoteInterface = ejb.getRemoteInterface();
                if (remoteInterface != null) {
                    Method[] remoteMethods = ejb.getRemoteInterface().listMethodExtended();
                    util.scanMethods(jar, ejb, remoteMethods, protectedMethods, unprotectedMethods, 1);
                }
            }
            catch (NullPointerException ex) {
                throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0038E"), ejb.getDisplayName()), ex);
            }
            catch (AccessControlException acex) {
                if (!tc.isEntryEnabled()) break block21;
                Tr.debug(tc, "Exception Received: " + acex.getMessage(), acex);
            }
        }
        allMethods.put(UNPROTECTED_METHOD_KEY, unprotectedMethods);
        allMethods.put(PROTECTED_METHOD_KEY, protectedMethods);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMethods");
        }
        return allMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable getMethods(AppDeploymentTask t, EJBJar jar, EnterpriseBean ejb, EJBJarFile jFile) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMethods", new Object[]{t, jar, ejb, jFile});
        }
        Vector protectedMethods = new Vector();
        Vector unprotectedMethods = new Vector();
        Hashtable allMethods = new Hashtable();
        ProtectionDomain cachedPD = null;
        ProtectionDomain pd = null;
        try {
            try {
                pd = util.getProtectedDomainForEJBJar(jFile);
                cachedPD = ((ArchiveImpl)((Object)jFile)).getProtectionDomain();
                if (pd != null) {
                    ((ArchiveImpl)((Object)jFile)).setProtectionDomain(pd);
                }
                try {
                    JavaClass localInterface = ejb.getLocalInterface();
                    if (localInterface != null) {
                        Method[] localMethods = localInterface.listMethodExtended();
                        util.scanMethods(jar, ejb, localMethods, protectedMethods, unprotectedMethods, 3);
                    }
                }
                catch (NullPointerException ex) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0035E"), ejb.getDisplayName()), ex);
                }
                try {
                    JavaClass homeInterface = ejb.getHomeInterface();
                    if (homeInterface != null) {
                        Method[] homeMethods = homeInterface.listMethodExtended();
                        util.scanMethods(jar, ejb, homeMethods, protectedMethods, unprotectedMethods, 2);
                    }
                }
                catch (NullPointerException ex) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0036E"), ejb.getDisplayName()), ex);
                }
                try {
                    JavaClass localHomeInterface = ejb.getLocalHomeInterface();
                    if (localHomeInterface != null) {
                        Method[] localHomeMethods = localHomeInterface.listMethodExtended();
                        util.scanMethods(jar, ejb, localHomeMethods, protectedMethods, unprotectedMethods, 4);
                    }
                }
                catch (NullPointerException ex) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0037E"), ejb.getDisplayName()), ex);
                }
                try {
                    JavaClass remoteInterface = ejb.getRemoteInterface();
                    if (remoteInterface != null) {
                        Method[] remoteMethods = ejb.getRemoteInterface().listMethodExtended();
                        util.scanMethods(jar, ejb, remoteMethods, protectedMethods, unprotectedMethods, 1);
                    }
                }
                catch (NullPointerException ex) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0038E"), ejb.getDisplayName()), ex);
                }
                Object var12_16 = null;
                ((ArchiveImpl)((Object)jFile)).setProtectionDomain(cachedPD);
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to list methods." + th);
                }
                Object var12_17 = null;
                ((ArchiveImpl)((Object)jFile)).setProtectionDomain(cachedPD);
            }
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            ((ArchiveImpl)((Object)jFile)).setProtectionDomain(cachedPD);
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unprotectedMethods: " + unprotectedMethods);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "protectedMethods: " + protectedMethods);
        }
        allMethods.put(UNPROTECTED_METHOD_KEY, unprotectedMethods);
        allMethods.put(PROTECTED_METHOD_KEY, protectedMethods);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMethods");
        }
        return allMethods;
    }

    private static ProtectionDomain getProtectedDomainForEJBJar(EJBJarFile ejbFile) {
        ProtectionDomain pd = null;
        if (ejbFile == null) {
            return null;
        }
        String ejbPath = null;
        URL ejbURL = null;
        CodeSource CS = null;
        try {
            ejbPath = ejbFile.getEARFile().getAbsolutePath() + File.separator + ejbFile.getURI();
            StringBuffer tmpBuf = new StringBuffer(ejbPath);
            ejbURL = new URL("file", "", tmpBuf.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "code source URL=" + ejbURL);
            }
            CS = new CodeSource(ejbURL, (Certificate[])null);
            DynamicPolicy dPolicy = DynamicPolicyFactory.getInstance();
            if (dPolicy != null) {
                pd = dPolicy.getProtectionDomain(CS);
            }
        }
        catch (Throwable th) {
            Tr.debug(tc, "Protection Domain cannot be Obtained for " + ejbURL + "exception is" + th);
        }
        return pd;
    }

    protected static void scanMethods(EJBJar jar, EnterpriseBean ejb, Method[] methods, Vector protectedMethods, Vector unprotectedMethods, int methodType) {
        AssemblyDescriptor adesc;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanMethods");
        }
        if ((adesc = jar.getAssemblyDescriptor()) == null) {
            adesc = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            jar.setAssemblyDescriptor(adesc);
        }
        EList permissions = jar.getAssemblyDescriptor().getMethodPermissions();
        Vector<List> elementLists = new Vector<List>();
        for (MethodPermission nextPermission : permissions) {
            List selectedElements = nextPermission.getMethodElements(ejb);
            if (selectedElements == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "No method found for " + jar.getDisplayName());
                continue;
            }
            elementLists.add(selectedElements);
        }
        ExcludeList excludeList = jar.getAssemblyDescriptor().getExcludeList();
        EList excludeElements = excludeList == null ? null : excludeList.getMethodElements();
        for (int methodNo = 0; methodNo < methods.length; ++methodNo) {
            Method nextMethod = methods[methodNo];
            Iterator elementListIterator = elementLists.iterator();
            boolean located = false;
            while (!located && elementListIterator.hasNext()) {
                List nextElementList = (List)elementListIterator.next();
                located = util.containsMethod(nextElementList, ejb, nextMethod);
            }
            if (!located && excludeElements != null) {
                located = util.containsMethod(excludeElements, ejb, nextMethod);
            }
            if (located) {
                protectedMethods.add(nextMethod);
                continue;
            }
            Vector<Object> mVector = new Vector<Object>();
            mVector.add(nextMethod);
            mVector.add(new Integer(methodType));
            unprotectedMethods.add(mVector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanMethods");
        }
    }

    public static boolean containsMethod(List methodElements, EnterpriseBean ejb, Method method2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsMethod");
        }
        boolean located = false;
        Iterator elementIterator = methodElements.iterator();
        while (!located && elementIterator.hasNext()) {
            MethodElement nextElement = (MethodElement)elementIterator.next();
            if (nextElement.getName().equals("*")) {
                located = true;
                continue;
            }
            boolean bl = located = nextElement.getEnterpriseBean() == ejb && nextElement.nameAndParamsEquals(method2);
            if (!located) {
                boolean bl2 = located = nextElement.getEnterpriseBean() == ejb && nextElement.represents(method2);
            }
            if (located) continue;
            located = nextElement.getSignature().equals(method2.getMethodElementSignature());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsMethod");
        }
        return located;
    }

    public static void addMethod(MethodPermission permission, EnterpriseBean ejb, Method method2, int methodType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMethod");
        }
        MethodElement element = util.createElement(ejb, method2, methodType);
        permission.getMethodElements().add(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMethod");
        }
    }

    public static void addMethod(MethodPermission permission, EnterpriseBean ejb, Method method2, Vector roles, int methodType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMethod");
        }
        util.addMethod(permission, ejb, method2, methodType);
        EList permissionRoles = permission.getRoles();
        if (roles != null) {
            int numRoles = roles.size();
            for (int roleNo = 0; roleNo < numRoles; ++roleNo) {
                SecurityRole nextRole = (SecurityRole)roles.elementAt(roleNo);
                permissionRoles.add(nextRole);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMethod");
        }
    }

    public static MethodElement createElement(EnterpriseBean ejb, Method method2, int methodType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createElement");
        }
        EjbFactory factory = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
        MethodElement element = factory.createMethodElement();
        element.setEnterpriseBean(ejb);
        element.setDescription("generatedAllMethodsDescription");
        element.setName("*");
        element.initializeFromSignature(method2.getMethodElementSignature());
        element.setType(MethodElementKind.get(methodType));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createElement");
        }
        return element;
    }

    public static void addMethodPermission(AssemblyDescriptor assemblyDescriptor, MethodPermission permission) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addMethodPermission");
        }
        permission.setAssemblyDescriptor(assemblyDescriptor);
        assemblyDescriptor.getMethodPermissions().add(permission);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addMethodPermission");
        }
    }

    public static Vector findMatchingSecurityRoles(AssemblyDescriptor assemblyDescriptor, String securityRoleNames) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMatchingSecurityRoles");
        }
        EList securityRoles = assemblyDescriptor.getSecurityRoles();
        Iterator roleIterator = securityRoles.iterator();
        Vector<SecurityRole> roles = new Vector<SecurityRole>();
        StringTokenizer roleNameTokens = new StringTokenizer(securityRoleNames, ",");
        while (roleNameTokens.hasMoreTokens()) {
            String roleName = roleNameTokens.nextToken();
            boolean found = false;
            while (roleIterator.hasNext()) {
                SecurityRole nextRole = (SecurityRole)roleIterator.next();
                if (nextRole.getRoleName() == null || !nextRole.getRoleName().equals(roleName)) continue;
                roles.addElement(nextRole);
                found = true;
                break;
            }
            if (found || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Not able to find matching security role for role name " + roleName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMatchingSecurityRoles");
        }
        return roles;
    }

    public static String getJ2EEAppVersion(AppDeploymentInfo appInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJ2EEAppVersion");
        }
        String ret = appInfo.getJ2EEAppVersion();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Return J2EE version: " + ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJ2EEAppVersion");
        }
        return ret;
    }

    public static void printAttributeList(String[] names, AttributeList attrList) {
        StringBuffer nameBuf = new StringBuffer("\nName list: \n");
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                nameBuf.append(names[i]).append(",");
            }
        }
        StringBuffer buf = new StringBuffer("\nAttribute list: \n");
        util.printAttributeList(attrList, buf);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "printAttributeList " + buf.toString());
        }
    }

    private static StringBuffer printAttributeList(AttributeList attrList, StringBuffer buf) {
        buf.append('{');
        for (Attribute attr : attrList) {
            buf.append('{').append(attr.getName()).append(',');
            util.printAttributeValue(attr.getValue(), buf);
            buf.append('}');
        }
        buf.append('}');
        return buf;
    }

    private static StringBuffer printAttributeValue(Object val, StringBuffer buf) {
        if (val instanceof AttributeList) {
            util.printAttributeList((AttributeList)val, buf);
        } else if (val instanceof List) {
            buf.append('{');
            Iterator iter = ((List)val).iterator();
            while (iter.hasNext()) {
                util.printAttributeValue(iter.next(), buf);
                if (!iter.hasNext()) continue;
                buf.append(',');
            }
            buf.append('}');
        } else {
            buf.append(val);
        }
        return buf;
    }

    public static String getPropertiesInString(List props) {
        String ret = "";
        if (props.size() != 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < props.size(); ++i) {
                Property prop = (Property)props.get(i);
                if (i != 0) {
                    buf.append("+");
                }
                buf.append("WebSphere:");
                buf.append("name=" + prop.getName());
                String val = prop.getValue();
                if ("".equals(val)) {
                    val = "\"\"";
                }
                buf.append(",value=" + val);
                String des = prop.getDescription();
                if (des == null) continue;
                buf.append(",description=" + des);
            }
            ret = buf.toString();
        }
        return ret;
    }

    public static String getExtendedDSName(AppDeploymentInfo appInstallInfo, String moduleName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtendedDSName", new Object[]{appInstallInfo, moduleName});
        }
        String retName = appInstallInfo.getAppDisplayName() + "#" + moduleName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtendedDSName", new Object[]{retName});
        }
        return retName;
    }

    public static String getExtendedDSName(AppDeploymentInfo appInstallInfo, EObject ddObject, String beanName, String resRefName) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExtendedDSName", new Object[]{ddObject, beanName, resRefName});
        }
        String retName = "";
        retName = !AppUtils.isEmpty(beanName) ? appInstallInfo.getModuleForDD(ddObject).getUri() + "#" + beanName + "#" + resRefName : appInstallInfo.getModuleForDD(ddObject).getUri() + "#" + resRefName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExtendedDSName", new Object[]{retName});
        }
        return retName;
    }

    public static String getPropertyTypeInString(List props) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyTypeInString", new Object[]{props});
        }
        String ret = "";
        if (props.size() != 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < props.size(); ++i) {
                if (i != 0) {
                    buf.append("+");
                }
                PropertyType propType = (PropertyType)props.get(i);
                buf.append(propType.getName());
                buf.append("=");
                buf.append(propType.getValue());
            }
            ret = buf.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyTypeInString", new Object[]{ret});
        }
        return ret;
    }

    public static Properties getStrToProps(String dsPropStr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStrToProps", new Object[]{dsPropStr});
        }
        Properties dsProps = new Properties();
        if (!AppUtils.isEmpty(dsPropStr)) {
            String[] props = new String[]{dsPropStr};
            if (dsPropStr.indexOf(43) != -1) {
                props = dsPropStr.split("\\+");
            }
            for (int i = 0; i < props.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing prop = " + props[i]);
                }
                ObjectName o = null;
                try {
                    o = new ObjectName("WebSphere:" + props[i]);
                }
                catch (MalformedObjectNameException ex) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "object name exception, ignore exception");
                    continue;
                }
                Hashtable propKeys = o.getKeyPropertyList();
                if (propKeys == null || propKeys.size() <= 0) continue;
                Enumeration keys = propKeys.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "saving key " + key);
                    }
                    dsProps.setProperty(key, (String)propKeys.get(key));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStrToProps", new Object[]{dsProps});
        }
        return dsProps;
    }

    public static boolean isValidExtendedDSStr(String dsPropStr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidExtendedDSStr", new Object[]{dsPropStr});
        }
        boolean valid = true;
        if (!AppUtils.isEmpty(dsPropStr)) {
            String[] props = new String[]{dsPropStr};
            if (dsPropStr.indexOf(43) != -1) {
                props = dsPropStr.split("\\+");
            }
            for (int i = 0; valid && i < props.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "parsing prop = " + props[i]);
                }
                ObjectName o = null;
                try {
                    o = new ObjectName("WebSphere:" + props[i]);
                    continue;
                }
                catch (MalformedObjectNameException ex) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "object name exception, set valid to false");
                    }
                    valid = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidExtendedDSStr", new Object[]{new Boolean(valid)});
        }
        return valid;
    }

    public static boolean isExtendedDSStrTheSame(String dsProp1, String dsProp2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExtendedDSStrTheSame", new Object[]{dsProp1, dsProp2});
        }
        boolean same = true;
        if (!AppUtils.isEmpty(dsProp1) && AppUtils.isEmpty(dsProp2) || AppUtils.isEmpty(dsProp1) && !AppUtils.isEmpty(dsProp2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "one string is empty");
            }
            same = false;
        } else if (!AppUtils.isEmpty(dsProp1) && !AppUtils.isEmpty(dsProp2)) {
            if (!util.getStrToProps(dsProp1).equals(util.getStrToProps(dsProp2))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "strings not equal");
                }
                same = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "strings are equal");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "both strings are empty");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExtendedDSStrTheSame", new Object[]{new Boolean(same)});
        }
        return same;
    }
}

