/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client.driver;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTaskMessages;
import com.ibm.ws.management.application.AppUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class UninstallApp
implements AppNotification.Listener,
NotificationListener {
    public static final String USEJMX = "usejmx";
    private static final String TRACE_PROP = "com.ibm.ejs.ras.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ejs.ras.traceFile";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String TYPE = "conntype";
    public static final String HOST_DEFAULT = "localhost";
    public static final String PORT_DEFAULT = "8880";
    public static final String TYPE_DEFAULT = "SOAP";
    public static final String TIMEOUT = "timeout";
    private static ResourceBundle resBundle;
    public static final int TIMEOUT_DEFAULT = 300;
    private static boolean bOSGIWAIT;
    private static final long MAX_WAIT_TIME = 600000L;
    private final String waitObject = "waitObject";
    private static TraceComponent tc;
    private static Vector lSide;
    private static Vector rSide;
    private Hashtable argOptions;
    private ObjectName on;
    AdminClient soapClient;
    private String appName;
    private AppDeploymentMessages msgs = new AppDeploymentTaskMessages();

    public static void main(String[] args) {
        if (args.length < 1 || args[0].equals("")) {
            UninstallApp.displayHelp();
            System.exit(0);
        }
        UninstallApp.setTrace();
        resBundle = AppUtils.getBundle(null);
        String appName = args[0];
        Hashtable cmdLine = UninstallApp.parseCmdLine(args);
        UninstallApp.dbg("");
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6051I"));
        UninstallApp app = new UninstallApp(appName, cmdLine);
        app.uninstall();
    }

    public static void osgimain(String[] args) throws Exception {
        bOSGIWAIT = true;
        UninstallApp.main(args);
    }

    private static void setTrace() {
        String spec = System.getProperty(TRACE_PROP);
        if (spec == null || spec.trim().equals("")) {
            return;
        }
        String traceOutput = "stdout";
        String tracefile = System.getProperty(TRACE_FILE_PROP);
        if (tracefile != null) {
            traceOutput = "named file";
        }
        ManagerAdmin.configureClientTrace(spec, traceOutput, tracefile, true, null, false);
    }

    private static void dbg(Object o) {
        System.out.println(o);
    }

    private static void errorAndExit(String errorMsg) {
        System.out.println(errorMsg);
        System.exit(-1);
    }

    private static void createOptionsText(boolean lonly) {
        lSide = new Vector();
        if (!lonly) {
            rSide = new Vector();
        }
        lSide.addElement("was.install.root");
        if (!lonly) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("config.root");
        if (!lonly) {
            rSide.addElement(" -- deprecated");
        }
        lSide.addElement("node.name");
        if (!lonly) {
            rSide.addElement("node (default is hostname)");
        }
        lSide.addElement("cell.name");
        if (!lonly) {
            rSide.addElement("cell (default is BaseApplicationServerCell)");
        }
        lSide.addElement("server.name");
        if (!lonly) {
            rSide.addElement("server (default is server1)");
        }
        lSide.addElement("cluster.name");
        if (!lonly) {
            rSide.addElement("cluster");
        }
        lSide.addElement(USEJMX);
        if (!lonly) {
            rSide.addElement("(performs installation by calling AppManagementMBean)");
        }
        lSide.addElement(HOST);
        if (!lonly) {
            rSide.addElement("host name used for -usejmx option, default is localhost");
        }
        lSide.addElement(PORT);
        if (!lonly) {
            rSide.addElement("port num used for -usejmx option, default is 8880");
        }
        lSide.addElement(TYPE);
        if (!lonly) {
            rSide.addElement("conntype used for -usejmx option, default is SOAP");
        }
        lSide.addElement(TIMEOUT);
        if (!lonly) {
            rSide.addElement("timeout (sec) to wait for JMX events, default is 300, -1 for no timeout");
        }
    }

    private static void displayHelp() {
        UninstallApp.dbg("Usage syntax is: UninstallApp applicationName [[-option.name optionValue]...]");
        UninstallApp.dbg("");
        UninstallApp.dbg("Valid options are:");
        UninstallApp.dbg("==================");
        UninstallApp.createOptionsText(false);
        for (int i = 0; i < lSide.size(); ++i) {
            UninstallApp.dbg("\t-" + lSide.elementAt(i) + " " + rSide.elementAt(i));
        }
        UninstallApp.dbg("");
        UninstallApp.dbg("==================");
        UninstallApp.dbg("");
        UninstallApp.dbg("For example: ");
        UninstallApp.dbg("UninstallApp sampleApp -[usejmx]");
    }

    private static String fixPath(String s) {
        if (s == null) {
            return null;
        }
        String retVal = s;
        if (File.separatorChar == '/') {
            retVal = retVal.replace('\\', File.separatorChar);
        }
        if (File.separatorChar == '\\') {
            retVal = retVal.replace('/', File.separatorChar);
        }
        return retVal;
    }

    private static Hashtable parseCmdLine(String[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseCmdLine");
        }
        Hashtable<String, Object> cmdLine = new Hashtable<String, Object>();
        UninstallApp.createOptionsText(true);
        for (int i = 1; i < args.length; ++i) {
            String key;
            if (!args[i].startsWith("-")) {
                UninstallApp.errorAndExit("Usage error: expected option name beginning with \"-\"; found " + args[i]);
            }
            if (!lSide.contains(key = args[i].substring(1, args[i].length()))) {
                UninstallApp.errorAndExit("Invalid option: " + key);
            }
            if (key.equals(USEJMX)) {
                cmdLine.put(key, new Boolean(true));
                continue;
            }
            String val = args[i + 1];
            cmdLine.put(key, val);
            ++i;
        }
        if (cmdLine.get(USEJMX) != null) {
            if (cmdLine.get(HOST) == null) {
                cmdLine.put(HOST, HOST_DEFAULT);
            }
            if (cmdLine.get(PORT) == null) {
                cmdLine.put(PORT, PORT_DEFAULT);
            }
            if (cmdLine.get(TYPE) == null) {
                cmdLine.put(TYPE, TYPE_DEFAULT);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseCmdLine");
        }
        return cmdLine;
    }

    public UninstallApp(String aName, Hashtable cmdLine) {
        this.appName = aName;
        this.argOptions = cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void uninstall() {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uninstall");
            }
            try {
                this.printOptions(this.argOptions);
                if (this.argOptions.get(USEJMX) == null) {
                    block16: {
                        UninstallApp.dbg("");
                        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6052I"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating local AppManagementImpl");
                        }
                        AppManagement m = AppManagementFactory.createLocalAppManagementImpl();
                        String string = "waitObject";
                        // MONITORENTER : "waitObject"
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Before uninstallApplication");
                        }
                        m.uninstallApplicationLocal(this.appName, this.argOptions, this, null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "After uninstallApplication");
                        }
                        try {
                            if (bOSGIWAIT) {
                                "waitObject".wait(600000L);
                            }
                        }
                        catch (InterruptedException ie) {
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug(tc, "Interrupted; time to work.");
                        }
                    }
                    // MONITOREXIT : string
                    break block17;
                }
                Properties config = new Properties();
                config.put(HOST, (String)this.argOptions.get(HOST));
                config.put(PORT, (String)this.argOptions.get(PORT));
                config.put("type", (String)this.argOptions.get(TYPE));
                this.soapClient = AdminClientFactory.createAdminClient(config);
                this.on = this.getObjectName(this.soapClient);
                UninstallApp.dbg("App Management object name = " + this.on);
                boolean added = false;
                try {
                    NotificationFilterSupport myFilter = new NotificationFilterSupport();
                    myFilter.enableType("websphere.admin.appmgmt");
                    this.soapClient.addNotificationListener(this.on, this, (NotificationFilter)myFilter, (Object)("Uninstall:" + this.appName));
                    added = true;
                }
                catch (Throwable th) {
                    UninstallApp.dbg("Error: Could not add listener to JMX MBean: " + th);
                }
                this.soapClient.invoke(this.on, "uninstallApplication", new Object[]{this.appName, this.argOptions, null}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"});
                UninstallApp.dbg("After invoking uninstallApplication.");
                boolean bDone = this.waitForTimeout((String)this.argOptions.get(TIMEOUT));
                if (!bDone) break block17;
                UninstallApp.dbg("Operation timed out.");
                if (added) {
                    this.soapClient.removeNotificationListener(this.on, this);
                }
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception is " + ex);
                }
                UninstallApp.errorAndExit(ex.getMessage());
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "uninstall");
    }

    private ObjectName getObjectName(AdminClient cl) throws Exception {
        ObjectName x;
        int i;
        ObjectName on1 = new ObjectName("WebSphere:type=AppManagement,*");
        Iterator it = cl.queryNames(on1, null).iterator();
        Vector v = new Vector();
        while (it.hasNext()) {
            v.addElement(it.next());
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            ObjectName _on = (ObjectName)v.elementAt(0);
            UninstallApp.dbg("App Management object name = " + _on);
            return _on;
        }
        for (i = 0; i < v.size(); ++i) {
            x = (ObjectName)v.elementAt(i);
            if (!x.getKeyProperty("process").equals("dmgr")) continue;
            ObjectName _on = x;
            UninstallApp.dbg("App Management object name = " + _on);
            return _on;
        }
        for (i = 0; i < v.size(); ++i) {
            x = (ObjectName)v.elementAt(i);
            if (!x.getKeyProperty("process").equals(x.getKeyProperty("node"))) continue;
            UninstallApp.dbg("App Management object name = " + x);
            return x;
        }
        ObjectName _on = (ObjectName)v.elementAt(0);
        UninstallApp.dbg("App Management object name = " + _on);
        return _on;
    }

    private boolean waitForTimeout(String tim) {
        try {
            int timeout = 300;
            if (tim != null) {
                timeout = new Integer(tim);
            }
            if (timeout == -1) {
                return false;
            }
            int interval = 5;
            while (timeout > 0) {
                Thread.sleep(interval * 1000);
                timeout -= interval;
                UninstallApp.dbg("..");
            }
            return true;
        }
        catch (Throwable th) {
            UninstallApp.dbg("Error in waiting for JMX events.." + th);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error in waiting for JMX events.. " + th);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void appEventReceived(AppNotification ev) {
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6053I") + ev);
        if (!ev.taskStatus.equals("Completed")) {
            if (!ev.taskStatus.equals("Failed")) return;
        }
        if (this.soapClient != null) {
            try {
                this.soapClient.removeNotificationListener(this.on, this);
            }
            catch (Throwable th) {
                UninstallApp.dbg("Error removing listener: " + th);
            }
        }
        if (bOSGIWAIT) {
            String string = "waitObject";
            // MONITORENTER : "waitObject"
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got STATUS_COMPLETED");
            }
            "waitObject".notify();
            // MONITOREXIT : string
        }
        UninstallApp.dbg(AppUtils.getMessage(resBundle, "ADMA6009I"));
        if (this.soapClient == null) return;
        System.exit(0);
    }

    public void handleNotification(Notification notf, Object handback) {
        if (notf == null) {
            UninstallApp.dbg("!! JMX event Recd: (handback obj= " + handback + "): " + "Notification object is null");
            return;
        }
        Object ud = notf.getUserData();
        UninstallApp.dbg("!! JMX event Recd: (handback obj= " + handback + "): " + ud);
        if (ud instanceof AppNotification) {
            this.appEventReceived((AppNotification)ud);
        }
    }

    private void printOptions(Hashtable appO) {
        UninstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
        Enumeration keys = appO.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            UninstallApp.dbg("");
            UninstallApp.dbg(key + " ----> " + appO.get(key));
        }
        UninstallApp.dbg("*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_");
    }

    static {
        bOSGIWAIT = false;
        tc = Tr.register(UninstallApp.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    }
}

