/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DataHolder;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class PropertyBasedConfigHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(PropertyBasedConfigHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static List<String> taskNameList = new ArrayList<String>();
    private static final int totalColumns = 2;
    public static final int varNameColumn = 0;
    public static final int varValueColumn = 1;
    public static final String TaskName = "PropertyBasedConfig";
    private static final String[] colNames = new String[]{"variable.name", "variable.value"};

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask", taskName);
        }
        try {
            return new WASDeploymentTask(appController, taskName, colNames, new boolean[]{false, true}, new boolean[]{false, true}, new boolean[]{false, false});
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask", new Object[]{appInstallInfo, t});
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        DataHolder dh = t.getAppDeploymentController().getDataHolder();
        ArrayList keyNames = new ArrayList();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (t.getAppDeploymentController() != null) {
            long mode = t.getAppDeploymentController().getDeploymentMode();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deployMode: " + mode);
            }
            if ((mode & 0x110L) != 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "task disabled in edit mode, do not display by setTaskData to null");
                }
                t.setTaskData(null);
                t.setIsTaskDisabled(true);
                return;
            }
        }
        if (appInstallInfo instanceof ArchiveDeploymentInfo) {
            try {
                if (!((ArchiveDeploymentInfo)appInstallInfo).containsURI(null, "META-INF/ibm-was-config.props") && tc.isEntryEnabled()) {
                    Tr.debug(tc, "No property based config file was found.");
                }
                InputStream is = ((ArchiveDeploymentInfo)appInstallInfo).getInputStream(null, "META-INF/ibm-was-config.props");
                String[] vars = ConfigPropertiesHelper.getVariables((InputStream)is);
                is.close();
                if (dh.getProps() == null || dh.getPropFile().isEmpty()) {
                    is = ((ArchiveDeploymentInfo)appInstallInfo).getInputStream(null, "META-INF/ibm-was-config.props");
                    Properties p = new Properties();
                    p.load(is);
                    dh.setPropFile(p);
                    is.close();
                    is = ((ArchiveDeploymentInfo)appInstallInfo).getInputStream(null, "META-INF/ibm-was-config.props");
                    String strResourceType = "Application";
                    dh.setProps(ConfigPropertiesHelper.getPropertiesByResourceType((InputStream)is, (String)strResourceType));
                    is.close();
                }
                if (vars != null) {
                    HashMap<String, String> vm = dh.getVariableMap();
                    if (vm == null || vm.size() < 0) {
                        vm = new HashMap();
                    }
                    for (int i = 0; i < vars.length; ++i) {
                        vm.put(vars[i], null);
                    }
                    dh.setVariableMap(vm);
                }
                if (dh.getProps() != null && dh.getProps().size() > 0) {
                    Enumeration<String> e = dh.getProps().keys();
                    while (e.hasMoreElements()) {
                        taskNameList.add(e.nextElement());
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "prepareTask");
                }
            }
            catch (AppDeploymentException ioex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No property based config file was found in the archive.");
                }
            }
            catch (Throwable th) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Following throwable received in prepare task:", th);
                }
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Get Variable data for following variable keys", taskNameList);
            }
            for (String strKey : taskNameList) {
                Hashtable taskValue = new Hashtable();
                taskValue = dh.getProps().get(strKey);
                HashMap<String, Object> tuplet = dh.getKeyVariableTuplet();
                if (tuplet == null || tuplet.size() < 0) {
                    tuplet = new HashMap();
                }
                if (taskValue != null) {
                    Enumeration e = taskValue.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String[] strVar = ConfigPropertiesHelper.getVariables((String[])((String[])taskValue.get(key)));
                        if (strVar == null || strVar.length <= 0) continue;
                        if (tuplet.containsKey(strKey)) {
                            String[] var;
                            String[] initValue = (String[])tuplet.get(strKey);
                            if (initValue != null) {
                                String s;
                                int i$;
                                var = new String[initValue.length + strVar.length];
                                int count = 0;
                                String[] arr$ = initValue;
                                int len$ = arr$.length;
                                for (i$ = 0; i$ < len$; ++i$) {
                                    var[count] = s = arr$[i$];
                                    ++count;
                                }
                                arr$ = strVar;
                                len$ = arr$.length;
                                for (i$ = 0; i$ < len$; ++i$) {
                                    var[count] = s = arr$[i$];
                                    ++count;
                                }
                            } else {
                                var = strVar;
                            }
                            tuplet.put(strKey, var);
                            continue;
                        }
                        tuplet.put(strKey, strVar);
                    }
                }
                dh.setKeyVariableTuplet(tuplet);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "prepareTask props:", dh.getProps());
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "keyVariableTuplet:", dh.getKeyVariableTuplet());
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Found following variables", dh.getVariableMap());
            }
            if (dh.getVariableMap() != null && dh.getVariableMap().size() > 0) {
                Set<String> keys = dh.getVariableMap().keySet();
                for (String key : keys) {
                    if (key.startsWith("!{") && key.endsWith("}")) {
                        key = key.substring(2, key.length() - 1);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "updated key:", key);
                    }
                    data.addElement(key);
                    data.add("");
                }
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask", new Object[]{appInstallInfo, t});
        }
        if (t.isTaskDisabled()) {
            return;
        }
        DataHolder dh = t.getAppDeploymentController().getDataHolder();
        if (dh != null && dh.getVariableMap() != null) {
            HashMap<String, String> data = dh.getVariableMap();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "variable map:  ", data);
            }
            if (data.containsValue("") || data.containsValue(null)) {
                ResourceBundle resBundle = AppUtils.getBundle("com.ibm.ws.management.resources.AppDeploymentMessages", Locale.getDefault());
                throw new AppDeploymentException(AppUtils.getMessage(resBundle, "ADMA9010E"), new Throwable());
            }
            Hashtable<String, Serializable> ht = new Hashtable<String, Serializable>();
            ht.put("isProcessedOnClient", Boolean.valueOf(true));
            ht.put("variableMap", dh.getVariableMap());
            appInstallInfo.getAppOptions().put("PropertyBasedConfigHelper", ht);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        return null;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
    }
}

