/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MetadataCompleteForModulesHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(MetadataCompleteForModulesHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"module", "uri", "lockDeploymentDescriptor"};
    static final int moduleColumn = 0;
    static final int urlColumn = 1;
    static final int lockDDColumn = 2;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "MetadataCompleteForModules", cols, new boolean[]{false, false, false}, new boolean[]{false, false, true}, new boolean[]{false, false, false}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask: task data already set.");
            }
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("EJB3JAR_DD");
        Vector wars = appInstallInfo.getModuleConfig("WEB25WAR_DD");
        this.addData(ejbJars, data, appInstallInfo);
        this.addData(wars, data, appInstallInfo);
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void addData(Vector modules, Vector data, AppDeploymentInfo appInfo) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addData", new Object[]{modules, data});
        }
        for (int i = 0; i < modules.size(); ++i) {
            EObject module = (EObject)modules.elementAt(i);
            boolean isMetadataComplete = false;
            if (module instanceof EJBJar) {
                isMetadataComplete = ((EJBJar)module).isMetadataComplete();
            } else if (module instanceof WebApp) {
                isMetadataComplete = ((WebApp)module).isMetadataComplete();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module " + module + " isMetadataComplete: " + isMetadataComplete);
            }
            if (isMetadataComplete) continue;
            data.addElement(util.getModuleName(appInfo, module));
            data.addElement(util.formUriString(appInfo, module));
            data.addElement("false");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addData");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            for (int i = 1; i < data.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "lock DD is set to " + data[i][2] + " for module " + data[i][1]);
                }
                if (!data[i][2].equalsIgnoreCase("true")) continue;
                EObject matchingModule = this.foundMatchingModule(data[i], appInstallInfo.getModuleConfig("EJB3JAR_DD"), appInstallInfo);
                if (matchingModule == null) {
                    matchingModule = this.foundMatchingModule(data[i], appInstallInfo.getModuleConfig("WEB25WAR_DD"), appInstallInfo);
                }
                if (matchingModule == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "cannot found matching module for data " + data[i][1]);
                    continue;
                }
                if (matchingModule instanceof EJBJar) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "metadata complete is set to true for jar");
                    }
                    ((EJBJar)matchingModule).setMetadataComplete(true);
                    continue;
                }
                if (!(matchingModule instanceof WebApp)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "metadata complete is set to true for war");
                }
                ((WebApp)matchingModule).setMetadataComplete(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private EObject foundMatchingModule(String[] data, Vector modules, AppDeploymentInfo appInstallInfo) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "foundMatchingModule", new Object[]{data, modules});
        }
        EObject matchingModule = null;
        for (int i = 0; i < modules.size(); ++i) {
            EObject module = (EObject)modules.elementAt(i);
            if (!util.getModuleName(appInstallInfo, module).equals(data[0]) || !util.compareUriString(appInstallInfo, module, data[1])) continue;
            matchingModule = module;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "found matching module " + module);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "foundMatchingModule", new Object[]{matchingModule});
        }
        return matchingModule;
    }
}

