/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.wsspi.profile.WSProfile;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapModulesToServersHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(MapModulesToServersHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    private String getCellName(Hashtable options) {
        String cell = (String)options.get("cell.name");
        if (AppUtils.isEmpty(cell)) {
            String host = AppDeploymentInfo.getLocalHost();
            return host == null ? "BaseApplicationServerCell" : host;
        }
        return cell;
    }

    private String createDefaultCNSName(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultCNSName");
        }
        Hashtable options = appInstallInfo.getAppOptions();
        String depTarget = (String)options.get("target");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "depl target option specified = " + depTarget);
        }
        if (!AppUtils.isEmpty(depTarget)) {
            return depTarget;
        }
        String ret = null;
        String cell = (String)options.get("cell.name");
        String server = (String)options.get("server.name");
        String node = (String)options.get("node.name");
        String cluster = (String)options.get("cluster.name");
        String host = null;
        if (AppUtils.isEmpty(cell) || AppUtils.isEmpty(node)) {
            host = AppDeploymentInfo.getLocalHost();
        }
        if (AppUtils.isEmpty(cell)) {
            String string = cell = host != null ? host : "BaseApplicationServerCell";
        }
        if (AppUtils.isEmpty(node)) {
            String string = node = host != null ? host : "DefaultNode";
        }
        if (AppUtils.isEmpty(server)) {
            if (System.getProperty("os.name").equals("OS/400")) {
                server = "server1";
                AppDeploymentController cont = t.getAppDeploymentController();
                if (cont != null && (AdminServiceFactory.getAdminService() == null || cont.getAdminClient() == null)) {
                    try {
                        String pp = AppManagementBaseFactory.getTempExtractDir();
                        String pName = pp.substring(0, pp.length() - 7);
                        File path = new File(pName);
                        server = WSProfile.getProfileName((File)path);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "profile path=" + path + " server=" + server);
                        }
                    }
                    catch (Exception ex) {}
                }
            } else {
                server = "server1";
            }
        }
        ret = !AppUtils.isEmpty(cluster) ? "WebSphere:cell=" + cell + ",cluster=" + cluster : "WebSphere:cell=" + cell + ",node=" + node + ",server=" + server;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, ret);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultCNSName");
        }
        return ret;
    }

    private String getCNSName(Hashtable mToServerTbl, String uri, String def) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNSName");
        }
        if (mToServerTbl == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCNSName: no tbl " + def);
            }
            return def;
        }
        String s = (String)mToServerTbl.get(util.createUniqueModuleNameFromUriString(uri));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uri: " + uri + " sName: " + s);
        }
        if (s == null) {
            s = def;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNSName: " + s);
        }
        return s;
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        AppDeploymentMessages msg;
        String uri;
        int i;
        AppDeploymentController controller;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Hashtable mToServerTbl = (Hashtable)appInstallInfo.getAppOptions().get("moduleToServer");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mod2svr in prefs: " + mToServerTbl);
        }
        if (mToServerTbl == null) {
            mToServerTbl = new Hashtable();
        }
        if ((controller = t.getAppDeploymentController()) == null || (controller.getDeploymentMode() & 0x110L) != 0L) {
            try {
                ApplicationDeployment appDepl;
                boolean process = true;
                if (controller != null) {
                    process = controller.getSelectedOptions().contains("processEmbeddedConfig");
                }
                if ((appDepl = ((ArchiveDeploymentInfo)appInstallInfo).getAppDeploymentObject(process)) != null) {
                    String cell = null;
                    if (controller == null) {
                        Hashtable props = appInstallInfo.getAppOptions();
                        cell = (String)props.get("cell.name");
                        cell = AppManagementImpl.getCellName();
                    } else {
                        cell = this.getCellName(appInstallInfo.getAppOptions());
                    }
                    Hashtable m2s2 = ConfigRepoHelper.getCNP((String)appInstallInfo.getAppOptions().get("EditModuleOnly"), appDepl, cell);
                    Enumeration keys = m2s2.keys();
                    while (keys.hasMoreElements()) {
                        Object k = keys.nextElement();
                        if (mToServerTbl.get(k) != null) continue;
                        mToServerTbl.put(k, m2s2.get(k));
                    }
                }
            }
            catch (Throwable th) {
                RasUtils.logException(th, tc, CLASS_NAME, "prepareTask", "232", this);
                Tr.warning(tc, "Unable to get deployment.xml from EAR: " + th);
            }
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector rars = appInstallInfo.getModuleConfig("RAR_DD");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        boolean v7_or_plus = !"5".equals(t.getCallerVersion()) && !"6".equals(t.getCallerVersion());
        String defaultCNS = this.createDefaultCNSName(appInstallInfo, t);
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        for (i = 0; i < ejbJars.size(); ++i) {
            data.addElement(util.getModuleName(appInstallInfo, (EJBJar)ejbJars.elementAt(i)));
            uri = util.formUriString(appInstallInfo, (EObject)ejbJars.elementAt(i));
            data.addElement(uri);
            data.addElement(this.getCNSName(mToServerTbl, uri, defaultCNS));
            if (!v7_or_plus) continue;
            data.addElement("" + ((XMLResource)((EObject)ejbJars.elementAt(i)).eResource()).getVersionID());
            data.addElement("moduletype.ejb");
            msg = t.getTaskMessages();
            if (msg != null) {
                data.addElement(msg.getMessage("moduletype.ejb"));
                continue;
            }
            data.addElement(null);
        }
        for (i = 0; i < wars.size(); ++i) {
            data.addElement(util.getModuleName(appInstallInfo, (WebApp)wars.elementAt(i)));
            uri = util.formUriString(appInstallInfo, (EObject)wars.elementAt(i));
            data.addElement(uri);
            data.addElement(this.getCNSName(mToServerTbl, uri, defaultCNS));
            if (!v7_or_plus) continue;
            data.addElement("" + ((XMLResource)((EObject)wars.elementAt(i)).eResource()).getVersionID());
            data.addElement("moduletype.web");
            msg = t.getTaskMessages();
            if (msg != null) {
                data.addElement(msg.getMessage("moduletype.web"));
                continue;
            }
            data.addElement(null);
        }
        for (i = 0; i < rars.size(); ++i) {
            data.addElement(util.getModuleName(appInstallInfo, (Connector)rars.elementAt(i)));
            uri = util.formUriString(appInstallInfo, (EObject)rars.elementAt(i));
            data.addElement(uri);
            data.addElement(this.getCNSName(mToServerTbl, uri, defaultCNS));
            if (!v7_or_plus) continue;
            data.addElement("" + ((XMLResource)((EObject)rars.elementAt(i)).eResource()).getVersionID());
            data.addElement("moduletype.connector");
            msg = t.getTaskMessages();
            if (msg != null) {
                data.addElement(msg.getMessage("moduletype.connector"));
                continue;
            }
            data.addElement(null);
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            Hashtable tbl = new Hashtable();
            AppDeploymentController controller = t.getAppDeploymentController();
            tbl = controller.getServerTable();
            appInstallInfo.getAppOptions().put("moduleToServer", tbl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/MapModulesToServersHelper.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.25.2.4");
        }
        CLASS_NAME = MapModulesToServersHelper.class.getName();
    }
}

