/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.client.util;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapEnvEntryForWebModHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(MapEnvEntryForWebModHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"webModule", "uri", "prop.name", "prop.type", "prop.description", "prop.value"};
    static final int moduleColumn = 0;
    static final int uriColumn = 1;
    static final int envNameColumn = 2;
    static final int envTypeColumn = 3;
    static final int envDescColumn = 4;
    static final int envValueColumn = 5;
    private String[] taskValidateErrorMessages;

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, "MapEnvEntryForWebMod", cols, new boolean[]{false, false, false, false, false, false}, new boolean[]{false, false, false, false, false, true}, new boolean[]{false, false, false, false, false, false}, true);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepareTask: task data already set.");
            }
            return;
        }
        Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        for (i = 0; i < wars.size(); ++i) {
            WebApp web = (WebApp)wars.elementAt(i);
            String moduleName = util.getModuleName(appInstallInfo, web);
            String uri = util.formUriString(appInstallInfo, web);
            web = (WebApp)AppDeploymentUtil.getDeploymentDescriptorXMLOnly(appInstallInfo, web);
            EList elist = web.getEnvEntries();
            for (int j = 0; j < elist.size(); ++j) {
                EnvEntry env = (EnvEntry)elist.get(j);
                data.addElement(moduleName);
                data.addElement(uri);
                data.addElement(env.getName());
                data.addElement(env.getType().toString());
                data.addElement(env.getDescription());
                data.addElement(env.getValue());
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            String[][] data = t.getTaskData();
            Vector wars = appInstallInfo.getModuleConfig("WAR_DD");
            int indx = 1;
            for (int i = 0; i < wars.size(); ++i) {
                WebApp web = (WebApp)wars.elementAt(i);
                web = (WebApp)AppDeploymentUtil.getDeploymentDescriptorXMLOnly(appInstallInfo, web);
                EList elist = web.getEnvEntries();
                for (int j = 0; j < elist.size(); ++j) {
                    EnvEntry env = (EnvEntry)elist.get(j);
                    String value = data[indx][5];
                    env.setValue(value);
                    ++indx;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

