/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.EnsureMethodProtectionFor10EJB;
import com.ibm.ws.management.application.client.util;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EnsureMethodProtectionFor10EJBHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(EnsureMethodProtectionFor10EJBHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        if (appInstallInfo instanceof PartialDeploymentInfo) {
            t.setTaskData(util.buildTaskData(data, colNames.length));
            return;
        }
        for (i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            EJBJarFile jFile = (EJBJarFile)appInstallInfo.getModuleFileForDD(jar);
            if (((XMLResource)jar.eResource()).getVersionID() >= 13) continue;
            boolean jarAdded = false;
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EList ejbBindings = ejbJarBinding.getEjbBindings();
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                Hashtable allMethods = util.getMethods(t, jar, ejb, jFile);
                Vector localUnprotectedMethods = (Vector)allMethods.get("unprotectedMethod");
                if (localUnprotectedMethods.size() == 0 || jarAdded) continue;
                data.addElement(util.getModuleName(appInstallInfo, jar));
                data.addElement(util.formUriString(appInstallInfo, jar));
                data.addElement("AppDeploymentOption.No");
                jarAdded = true;
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (appInstallInfo instanceof PartialDeploymentInfo) {
            return;
        }
        if (!t.isTaskEmpty()) {
            Hashtable<String, EJBJarBinding> uriForDD = new Hashtable<String, EJBJarBinding>();
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            for (int i = 0; i < ejbJarBindings.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EJBJar jar = ejbJarBinding.getEjbJar();
                if (jar == null || ((XMLResource)jar.eResource()).getVersionID() >= 13) continue;
                uriForDD.put(util.formUriString(appInstallInfo, jar), ejbJarBinding);
            }
            String[][] taskData = t.getTaskData();
            for (int j = 0; j < taskData.length; ++j) {
                EnsureMethodProtectionFor10EJB cfr_ignored_0 = (EnsureMethodProtectionFor10EJB)t;
                if (!"AppDeploymentOption.Yes".equals(taskData[j][2])) {
                    EnsureMethodProtectionFor10EJB cfr_ignored_1 = (EnsureMethodProtectionFor10EJB)t;
                    if (!"methodProtection.denyAllPermission".equals(taskData[j][2])) continue;
                }
                Method matchingUnprotectedMethod = null;
                EnsureMethodProtectionFor10EJB cfr_ignored_2 = (EnsureMethodProtectionFor10EJB)t;
                EJBJarBinding ejbJarBinding = (EJBJarBinding)uriForDD.get(taskData[j][1]);
                if (ejbJarBinding == null) {
                    if (!tc.isDebugEnabled()) continue;
                    EnsureMethodProtectionFor10EJB cfr_ignored_3 = (EnsureMethodProtectionFor10EJB)t;
                    Tr.debug(tc, "Not able to find binding for uri " + taskData[j][1]);
                    continue;
                }
                String[] matchingTaskData = taskData[j];
                EJBJar jar = ejbJarBinding.getEjbJar();
                EJBJarFile jFile = (EJBJarFile)appInstallInfo.getModuleFileForDD(jar);
                MethodPermission denyAllPermission = null;
                Vector denyAllRole = null;
                EList ejbBindings = ejbJarBinding.getEjbBindings();
                for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                    Hashtable allMethods = util.getMethods(t, jar, ejb, jFile);
                    Vector unprotectedMethods = (Vector)allMethods.get("unprotectedMethod");
                    for (int k = 0; k < unprotectedMethods.size(); ++k) {
                        Vector unprotectedMethod = (Vector)unprotectedMethods.elementAt(k);
                        if (unprotectedMethod.size() <= 0) continue;
                        matchingUnprotectedMethod = (Method)unprotectedMethod.elementAt(0);
                        int methodType = unprotectedMethod.size() > 1 ? (Integer)unprotectedMethod.elementAt(1) : 0;
                        if (denyAllPermission == null) {
                            denyAllPermission = this.createDenyAllPermission(t, jar.getAssemblyDescriptor());
                        }
                        if (denyAllRole == null && (denyAllRole = util.findMatchingSecurityRoles(jar.getAssemblyDescriptor(), "DenyAllRole")).size() == 0) {
                            denyAllRole = this.createDenyAllRole(t, jar.getAssemblyDescriptor());
                        }
                        util.addMethod(denyAllPermission, ejb, matchingUnprotectedMethod, denyAllRole, methodType);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private MethodPermission createDenyAllPermission(AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDenyAllPermission");
        }
        EjbFactory factory = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory();
        MethodPermission methodPermission = factory.createMethodPermission();
        methodPermission.setDescription(util.getMessage(t, "method.permission.deny.all.permission.description"));
        util.addMethodPermission(assemblyDescriptor, methodPermission);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDenyAllPermission");
        }
        return methodPermission;
    }

    private Vector createDenyAllRole(AppDeploymentTask t, AssemblyDescriptor assemblyDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDenyAllRole");
        }
        CommonFactory factory = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory();
        SecurityRole role = factory.createSecurityRole();
        role.setRoleName("DenyAllRole");
        role.setDescription(util.getMessage(t, "method.permission.deny.all.role.description"));
        Vector<SecurityRole> roleV = new Vector<SecurityRole>();
        roleV.addElement(role);
        assemblyDescriptor.getSecurityRoles().add(role);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDenyAllRole");
        }
        return roleV;
    }
}

