/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndPackage;
import com.ibm.ejs.models.base.bindings.commonbnd.Property;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.DataSourceFor10CMPBeans;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class DataSourceFor10CMPBeansHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(DataSourceFor10CMPBeansHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        int appVersion = ((XMLResource)appInstallInfo.getApplication().eResource()).getVersionID();
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            if (jar.getContainerManagedBeans().size() <= 0) continue;
            this.getEJB1_0DataSource(appInstallInfo, ejbJarBinding, jar, data, appVersion, t.getCallerVersion());
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void getEJB1_0DataSource(AppDeploymentInfo appInstallInfo, EJBJarBinding ejbJarBinding, EJBJar jar, Vector data, int appVersion, String callerVersion) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEJB1_0DataSource");
        }
        EList ejbBindings = ejbJarBinding.getEjbBindings();
        boolean isBindingAdded = false;
        for (int j = 0; j < ejbBindings.size(); ++j) {
            EnterpriseBeanBinding ejbBinding = (EnterpriseBeanBinding)ejbBindings.get(j);
            EnterpriseBean ejb = ejbBinding.getEnterpriseBean();
            if (ejb == null) continue;
            if (ejb.eIsProxy()) {
                Tr.warning(tc, "ADMA0091E", new String[]{ejbBindings.get(j).toString(), ejbJarBinding.eResource().getURI().toString(), appInstallInfo.getModuleFileForDD(jar).getURI(), ejb.toString()});
                continue;
            }
            if (ejb.getVersionID() != 11 || !ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity()) continue;
            ResourceRefBinding dataSource = ejbBinding.getDatasource();
            if (dataSource == null) {
                Tr.warning(tc, "DataSource has not been created for the binding yet. This might be caused by the broken binding file that has extra entry. module is " + util.getModuleName(appInstallInfo, jar) + " ejb is " + ejb.getName());
                continue;
            }
            int jarVersion = ((XMLResource)jar.eResource()).getVersionID();
            data.addElement(Integer.toString(appVersion));
            data.addElement(Integer.toString(jarVersion));
            data.addElement(util.getModuleName(appInstallInfo, jar));
            data.addElement(ejb.getName());
            data.addElement(util.formUriString(appInstallInfo, jar));
            data.addElement(dataSource.getJndiName());
            if (dataSource.getDefaultAuth() != null) {
                data.addElement(((BasicAuthData)dataSource.getDefaultAuth()).getUserId());
                data.addElement(((BasicAuthData)dataSource.getDefaultAuth()).getPassword());
            } else {
                data.addElement("");
                data.addElement("");
            }
            if ("5".equals(callerVersion)) continue;
            String lc = dataSource.getLoginConfigurationName();
            data.addElement(lc);
            EList props = dataSource.getProperties();
            Object prop = null;
            String pp = "";
            if (props != null && props.size() != 0) {
                pp = lc != null && lc.equals("DefaultPrincipalMapping") ? ((Property)props.get(0)).getValue() : util.getPropertiesInString(props);
            }
            data.addElement(pp);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEJB1_0DataSource");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            CommonbndPackage commonPkg = (CommonbndPackage)EPackage.Registry.INSTANCE.getEPackage("commonbnd.xmi");
            CommonbndFactory commonFact = commonPkg.getCommonbndFactory();
            for (int i = 0; i < ejbJarBindings.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EList ejbBindings = ejbJarBinding.getEjbBindings();
                for (EnterpriseBean ejb : ((EJBJar)appInstallInfo.getModuleConfig("JAR_DD").elementAt(i)).getEnterpriseBeans()) {
                    if (ejb.getVersionID() != 11 || !ejb.isContainerManagedEntity()) continue;
                    String[] matchingTaskData = null;
                    String[][] taskData = t.getTaskData();
                    for (int j = 0; j < taskData.length; ++j) {
                        EJBJar jar = (EJBJar)appInstallInfo.getModuleConfig("JAR_DD").elementAt(i);
                        DataSourceFor10CMPBeans cfr_ignored_0 = (DataSourceFor10CMPBeans)t;
                        if (taskData[j].length <= 4) continue;
                        DataSourceFor10CMPBeans cfr_ignored_1 = (DataSourceFor10CMPBeans)t;
                        if (!ejb.getName().equals(taskData[j][3])) continue;
                        DataSourceFor10CMPBeans cfr_ignored_2 = (DataSourceFor10CMPBeans)t;
                        if (!util.compareUriString(appInstallInfo, jar, taskData[j][4])) continue;
                        matchingTaskData = taskData[j];
                        break;
                    }
                    if (matchingTaskData == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Not matching task data for ejb " + ejb.getName());
                        continue;
                    }
                    EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
                    DataSourceFor10CMPBeans cfr_ignored_3 = (DataSourceFor10CMPBeans)t;
                    if (matchingTaskData.length <= 5) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Wrong task data format " + taskData);
                        }
                        Object[] objectArray = new Object[2];
                        DataSourceFor10CMPBeans cfr_ignored_4 = (DataSourceFor10CMPBeans)t;
                        objectArray[0] = matchingTaskData[3];
                        DataSourceFor10CMPBeans cfr_ignored_5 = (DataSourceFor10CMPBeans)t;
                        objectArray[1] = matchingTaskData[2];
                        throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0027E"), objectArray), null);
                    }
                    DataSourceFor10CMPBeans cfr_ignored_6 = (DataSourceFor10CMPBeans)t;
                    ejbBinding.getDatasource().setJndiName((String)matchingTaskData[5]);
                    DataSourceFor10CMPBeans cfr_ignored_7 = (DataSourceFor10CMPBeans)t;
                    if (matchingTaskData.length > 7) {
                        if (ejbBinding.getDatasource().getDefaultAuth() != null) {
                            DataSourceFor10CMPBeans cfr_ignored_8 = (DataSourceFor10CMPBeans)t;
                            ((BasicAuthData)ejbBinding.getDatasource().getDefaultAuth()).setUserId(matchingTaskData[6]);
                            DataSourceFor10CMPBeans cfr_ignored_9 = (DataSourceFor10CMPBeans)t;
                            ((BasicAuthData)ejbBinding.getDatasource().getDefaultAuth()).setPassword(matchingTaskData[7]);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Wrong task data format " + matchingTaskData);
                        }
                        Object[] objectArray = new Object[2];
                        DataSourceFor10CMPBeans cfr_ignored_10 = (DataSourceFor10CMPBeans)t;
                        objectArray[0] = matchingTaskData[3];
                        DataSourceFor10CMPBeans cfr_ignored_11 = (DataSourceFor10CMPBeans)t;
                        objectArray[1] = matchingTaskData[2];
                        throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0028E"), objectArray), null);
                    }
                    if ("5".equals(t.getCallerVersion())) continue;
                    String lName = null;
                    String prop = null;
                    DataSourceFor10CMPBeans cfr_ignored_12 = (DataSourceFor10CMPBeans)t;
                    if (matchingTaskData.length > 8) {
                        DataSourceFor10CMPBeans cfr_ignored_13 = (DataSourceFor10CMPBeans)t;
                        lName = matchingTaskData[8];
                        if (lName != null && !lName.trim().equals("")) {
                            ejbBinding.getDatasource().setLoginConfigurationName(lName);
                        } else {
                            ejbBinding.getDatasource().unsetLoginConfigurationName();
                            EList props = ejbBinding.getDatasource().getProperties();
                            if (props.size() > 0) {
                                props.clear();
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No loginCOnfigname for" + ejb.getName());
                    }
                    DataSourceFor10CMPBeans cfr_ignored_14 = (DataSourceFor10CMPBeans)t;
                    if (matchingTaskData.length > 9) {
                        DataSourceFor10CMPBeans cfr_ignored_15 = (DataSourceFor10CMPBeans)t;
                        prop = matchingTaskData[9];
                        if (prop == null || prop.trim().equals("")) continue;
                        this.setUpProps(commonFact, ejbBinding.getDatasource(), lName, prop);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No properties date for  " + ejb.getName());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB)) {
            return null;
        }
        Hashtable<String, String> tbl = new Hashtable<String, String>();
        tbl.put(ModuleType.EJB.toString(), "/ejb-jar/enterprise-beans/entity[cmp-version='1.x']/ejb-name");
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{uri, dcImpl.getDDBean().getText()}, new int[]{4, 3});
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    private void setUpProps(CommonbndFactory commonFact, ResourceRefBinding rrb, String loginConfig, String auth) {
        EList props = rrb.getProperties();
        if (props.size() > 0) {
            props.clear();
        }
        Property prop = null;
        Object attrList = null;
        if (loginConfig != null && loginConfig.equals("DefaultPrincipalMapping")) {
            prop = commonFact.createProperty();
            prop.setName("com.ibm.mapping.authDataAlias");
            prop.setValue(auth);
            prop.setDescription("description");
            props.add(prop);
            return;
        }
        String pStr = auth;
        String[] ps = new String[]{pStr};
        if (pStr.indexOf(43) != -1) {
            ps = pStr.split("\\+");
        }
        for (int ii = 0; ii < ps.length; ++ii) {
            prop = commonFact.createProperty();
            ObjectName o = null;
            try {
                o = new ObjectName(ps[ii]);
                String w = null;
                w = o.getKeyProperty("name");
                prop.setName(w);
                w = o.getKeyProperty("value");
                if (w.equals("\"\"")) {
                    w = "";
                }
                prop.setValue(w);
                w = o.getKeyProperty("description");
                prop.setDescription(w);
                props.add(prop);
                continue;
            }
            catch (MalformedObjectNameException ex) {
                // empty catch block
            }
        }
    }
}

