/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.util.RasUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomActivationPlanHelper
implements AppDeploymentTaskValidate {
    private static TraceComponent tc = Tr.register(CustomActivationPlanHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String[] COL_NAMES;
    public static final int MODULE_COLUMN = 0;
    public static final int URI_COLUMN = 1;
    public static final int ADD_PLAN_COLUMN = 2;
    public static final int REMOVE_PLAN_COLUMN = 3;
    public static final int TOTAL_COLUMNS = 4;
    private static final String MALFORMED_ON_COMPS = "malformedObjectNameComponents";
    private static final String BAD_FORMAT_COMPS = "incorrectFormatComponents";
    private static final String BAD_DOMAIN_COMPS = "incorrectDomainComponents";
    private static final String BAD_SPEC_NAME_COMPS = "incorrectSpecNameComponents";

    @Override
    public AppDeploymentTask createTask(AppDeploymentController controller, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(controller, "CustomActivationPlan", COL_NAMES, new boolean[]{false, false, false, false}, new boolean[]{false, false, true, true}, new boolean[]{false, false, false, false}, false);
        }
        catch (Exception ex) {
            RasUtils.logException((Throwable)ex, tc, CLASS_NAME, "creatTask", "143", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    @Override
    public void prepareTask(AppDeploymentInfo info, AppDeploymentTask task) throws AppDeploymentException {
        String[] colNames;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        Vector<String> data = new Vector<String>();
        for (String column : colNames = task.getColumnNames()) {
            data.addElement(column);
        }
        AppDeploymentController controller = task.getAppDeploymentController();
        if (controller != null && (controller.getDeploymentMode() & 0x110L) != 0L && tc.isDebugEnabled()) {
            Tr.debug(tc, "===> " + (Properties)info.getAppOptions().get("META-INF/ibm-application-runtime.props"));
        }
        Vector ejbJars = info.getModuleConfig("JAR_DD");
        for (Object ejbDDInfo : ejbJars) {
            data.addElement(util.getModuleName(info, (EJBJar)ejbDDInfo));
            String uri = util.formUriString(info, (EObject)ejbDDInfo);
            data.addElement(uri);
            data.addElement(this.getComps(task, info, uri, ".ibmadd"));
            data.addElement(this.getComps(task, info, uri, ".ibmremove"));
        }
        Vector wars = info.getModuleConfig("WAR_DD");
        for (Object warDDInfo : wars) {
            data.addElement(util.getModuleName(info, (WebApp)warDDInfo));
            String uri = util.formUriString(info, (EObject)warDDInfo);
            data.addElement(uri);
            data.addElement(this.getComps(task, info, uri, ".ibmadd"));
            data.addElement(this.getComps(task, info, uri, ".ibmremove"));
        }
        Vector rars = info.getModuleConfig("RAR_DD");
        for (Object rarDDInfo : rars) {
            data.addElement(util.getModuleName(info, (Connector)rarDDInfo));
            String uri = util.formUriString(info, (EObject)rarDDInfo);
            data.addElement(uri);
            data.addElement(this.getComps(task, info, uri, ".ibmadd"));
            data.addElement(this.getComps(task, info, uri, ".ibmremove"));
        }
        task.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private String getComps(AppDeploymentTask task, AppDeploymentInfo info, String uri, String suffix) {
        String comps;
        Properties props;
        AppDeploymentController controller = task.getAppDeploymentController();
        if (controller != null && (controller.getDeploymentMode() & 0x110L) != 0L && (props = (Properties)info.getAppOptions().get("META-INF/ibm-application-runtime.props")) != null && (comps = props.getProperty("com.ibm.ws.runtime.components." + util.getModuleUriFromUriString(uri) + suffix)) != null) {
            return comps;
        }
        return "";
    }

    @Override
    public void completeTask(AppDeploymentInfo info, AppDeploymentTask t) throws AppDeploymentException {
        String[][] data;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if ((data = t.getTaskData()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "completeTask - null data");
            }
            return;
        }
        Hashtable<String, List<ObjectName>> addPlan = new Hashtable<String, List<ObjectName>>();
        Hashtable<String, List<ObjectName>> removePlan = new Hashtable<String, List<ObjectName>>();
        for (int i = 1; i < data.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, data[i][1] + ", " + data[i][2] + ", " + data[i][3]);
            }
            String addComponentsFromUserInput = data[i][2];
            List<ObjectName> objectNamesToBeAdded = this.getAddRemoveComponents(addComponentsFromUserInput);
            addPlan.put(util.createUniqueModuleNameFromUriString(data[i][1]), objectNamesToBeAdded);
            String removeComponentsFromUserInput = data[i][3];
            List<ObjectName> objectNamesToBeRemoved = this.getAddRemoveComponents(removeComponentsFromUserInput);
            removePlan.put(util.createUniqueModuleNameFromUriString(data[i][1]), objectNamesToBeRemoved);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "addPlan: " + addPlan + "\nremovePlan: " + removePlan);
        }
        if (addPlan.size() > 0) {
            info.getAppOptions().put("activation.plan.add", addPlan);
        }
        if (removePlan.size() > 0) {
            info.getAppOptions().put("activation.plan.remove", removePlan);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private List<ObjectName> getAddRemoveComponents(String addRemoveComponents) {
        String[] tokens;
        ArrayList<ObjectName> objectNamesToBeAddedRemoved = new ArrayList<ObjectName>();
        for (String token : tokens = addRemoveComponents.split("\\+")) {
            ObjectName objectName = null;
            if (token.trim().equals("")) continue;
            try {
                objectName = new ObjectName(token);
                assert (objectName != null) : "Objectname should never be null because validate method should have caught this case";
                objectNamesToBeAddedRemoved.add(objectName);
            }
            catch (MalformedObjectNameException monex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught malformed objectname while adding or removing runtime provisioning component: " + token);
                }
                RasUtils.logException((Throwable)monex, tc, CLASS_NAME, "completeTask", "323", this);
            }
        }
        return objectNamesToBeAddedRemoved;
    }

    @Override
    public String[] validate(AppDeploymentTask t, AppDeploymentInfo info) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        String[] taskValidateErrorMessages = null;
        try {
            String[][] taskData = t.getTaskData();
            if (taskData != null) {
                Hashtable<String, Vector<String>> userInputErrorMessages = new Hashtable<String, Vector<String>>();
                Vector<String> errorMessages = new Vector<String>();
                for (int i = 1; i < taskData.length; ++i) {
                    String addComponentsFromUserInput = taskData[i][2];
                    String[] addTokens = addComponentsFromUserInput.split("\\+");
                    this.checkComps(addTokens, userInputErrorMessages);
                    String removeComponentsFromUserInput = taskData[i][3];
                    String[] removeTokens = removeComponentsFromUserInput.split("\\+");
                    this.checkComps(removeTokens, userInputErrorMessages);
                }
                if (userInputErrorMessages.containsKey(MALFORMED_ON_COMPS)) {
                    errorMessages.addElement(MessageFormat.format(util.getMessage(t, "ADMA9011E"), userInputErrorMessages.get(MALFORMED_ON_COMPS).toString()));
                }
                if (userInputErrorMessages.containsKey(BAD_FORMAT_COMPS)) {
                    errorMessages.addElement(MessageFormat.format(util.getMessage(t, "ADMA9013E"), userInputErrorMessages.get(BAD_FORMAT_COMPS).toString()));
                }
                if (userInputErrorMessages.containsKey(BAD_DOMAIN_COMPS)) {
                    errorMessages.addElement(MessageFormat.format(util.getMessage(t, "ADMA9014E"), userInputErrorMessages.get(BAD_DOMAIN_COMPS).toString()));
                }
                if (userInputErrorMessages.containsKey(BAD_SPEC_NAME_COMPS)) {
                    errorMessages.addElement(MessageFormat.format(util.getMessage(t, "ADMA9015E"), userInputErrorMessages.get(BAD_SPEC_NAME_COMPS).toString()));
                }
                if (errorMessages != null && errorMessages.size() > 0) {
                    taskValidateErrorMessages = new String[errorMessages.size()];
                    errorMessages.toArray(taskValidateErrorMessages);
                }
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "validate", "388", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return taskValidateErrorMessages;
    }

    private void checkComps(String[] comps, Hashtable<String, Vector<String>> table) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkComps");
        }
        for (String comp : comps) {
            if (comp.trim().equals("")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking COMPONENT: " + comp);
            }
            try {
                Vector<Object> incorrectSpecNameComponents;
                ObjectName addComps = new ObjectName(comp);
                if (addComps.isPattern() || addComps.getKeyPropertyList().size() != 1) {
                    Vector<Object> incorrectFormatComponents;
                    if (!table.containsKey(BAD_FORMAT_COMPS)) {
                        incorrectFormatComponents = new Vector<String>();
                        incorrectFormatComponents.addElement(comp);
                        table.put(BAD_FORMAT_COMPS, incorrectFormatComponents);
                        continue;
                    }
                    incorrectFormatComponents = table.get(BAD_FORMAT_COMPS);
                    incorrectFormatComponents.addElement(comp);
                    continue;
                }
                if (!addComps.getDomain().equals("WebSphere")) {
                    Vector<Object> incorrectDomainComponents;
                    if (!table.containsKey(BAD_DOMAIN_COMPS)) {
                        incorrectDomainComponents = new Vector<String>();
                        incorrectDomainComponents.addElement(comp);
                        table.put(BAD_DOMAIN_COMPS, incorrectDomainComponents);
                    } else {
                        incorrectDomainComponents = table.get(BAD_DOMAIN_COMPS);
                        incorrectDomainComponents.addElement(comp);
                    }
                }
                if (addComps.getKeyProperty("specname") != null) continue;
                if (!table.containsKey(BAD_SPEC_NAME_COMPS)) {
                    incorrectSpecNameComponents = new Vector<String>();
                    incorrectSpecNameComponents.addElement(comp);
                    table.put(BAD_SPEC_NAME_COMPS, incorrectSpecNameComponents);
                    continue;
                }
                incorrectSpecNameComponents = table.get(BAD_SPEC_NAME_COMPS);
                incorrectSpecNameComponents.addElement(comp);
            }
            catch (MalformedObjectNameException monex) {
                Vector<Object> malformedObjectNamedComponents;
                if (!table.containsKey(MALFORMED_ON_COMPS)) {
                    malformedObjectNamedComponents = new Vector<String>();
                    malformedObjectNamedComponents.addElement(comp);
                    table.put(MALFORMED_ON_COMPS, malformedObjectNamedComponents);
                    continue;
                }
                malformedObjectNamedComponents = table.get(MALFORMED_ON_COMPS);
                malformedObjectNamedComponents.addElement(comp);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkComps");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/client/CustomActivationPlanHelper.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.5");
        }
        CLASS_NAME = CustomActivationPlanHelper.class.getName();
        COL_NAMES = new String[]{"module", "uri", "activation.plan.add", "activation.plan.remove"};
    }
}

