/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.commonext.CommonextFactory;
import com.ibm.ejs.models.base.extensions.commonext.CommonextPackage;
import com.ibm.ejs.models.base.extensions.commonext.IsolationLevelKind;
import com.ibm.ejs.models.base.extensions.commonext.ResourceRefExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.client.CorrectOracleIsolationLevel;
import com.ibm.ws.management.application.client.util;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class CorrectOracleIsolationLevelHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(CorrectOracleIsolationLevelHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        this.prepareForEJB(appInstallInfo, data);
        this.prepareForWAR(appInstallInfo, data);
        String[][] taskData = util.buildTaskData(data, colNames.length);
        t.setTaskData(taskData);
        ((CorrectOracleIsolationLevel)t).saveTaskData(taskData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private void prepareForEJB(AppDeploymentInfo appInstallInfo, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector ejbJarExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            EJBJarExtension ext = (EJBJarExtension)ejbJarExtensions.elementAt(i);
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                Iterator iter = ejb.getResourceRefs().iterator();
                while (iter.hasNext()) {
                    this.getIsolationLevel(appInstallInfo, (ResourceRef)iter.next(), ejbBindings.getResRefBindings(), ext, jar, data);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareForEJB");
        }
    }

    private void prepareForWAR(AppDeploymentInfo appInstallInfo, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareForWAR");
        }
        Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
        Vector webAppBindings = appInstallInfo.getModuleConfig("WAR_BND");
        Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
        for (int i = 0; i < webAppBindings.size(); ++i) {
            WebApp webApp = (WebApp)webApps.get(i);
            WebAppBinding webAppBinding = (WebAppBinding)webAppBindings.get(i);
            WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(i);
            Iterator iter = webApp.getResourceRefs().iterator();
            while (iter.hasNext()) {
                this.getIsolationLevel(appInstallInfo, (ResourceRef)iter.next(), webAppBinding.getResRefBindings(), webAppExt, webApp, data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareForWAR");
        }
    }

    private void getIsolationLevel(AppDeploymentInfo appInstallInfo, ResourceRef resRef, List resRefBnds, EObject extRefObject, EObject ddRefObject, Vector data) throws AppDeploymentException {
        ResourceRefBinding resRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsolationLevel");
        }
        if ((resRefBinding = this.findResRefBinding(resRef, resRefBnds)) == null) {
            return;
        }
        if (((XMLResource)resRef.eResource()).getVersionID() >= 13) {
            ResourceRefExtension extension2 = this.findExtension(extRefObject, resRef);
            IsolationLevelKind isolationLevel = null;
            if (extension2 != null) {
                isolationLevel = extension2.getIsolationLevel();
            }
            if (isolationLevel == null || isolationLevel.getValue() != 2 && isolationLevel.getValue() != 8) {
                this.addTaskData(appInstallInfo, ddRefObject, resRef, resRefBinding, isolationLevel == null ? null : new Integer(isolationLevel.getValue()), data);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsolationLevel");
        }
    }

    private ResourceRefExtension findExtension(EObject refObject, ResourceRef resRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findExtension");
        }
        ResourceRefExtension resRefExt = null;
        if (refObject != null && resRef != null) {
            if (refObject instanceof EJBJarExtension) {
                resRefExt = this.findExtension((EJBJarExtension)refObject, resRef);
            } else if (refObject instanceof WebAppExtension) {
                resRefExt = this.findExtension((WebAppExtension)refObject, resRef);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown ref object: " + refObject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findExtension");
        }
        return resRefExt;
    }

    private ResourceRefExtension findExtension(EJBJarExtension ext, ResourceRef resRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findExtension");
        }
        ResourceRefExtension foundResourceRefExtension = null;
        if (resRef != null && ext != null) {
            block0: for (EnterpriseBeanExtension ejbExtension : ext.getEjbExtensions()) {
                for (ResourceRefExtension nextResourceRefExtension : ejbExtension.getResourceRefExtensions()) {
                    ResourceRef nextResourceRef = nextResourceRefExtension.getResourceRef();
                    if (nextResourceRef != resRef) continue;
                    foundResourceRefExtension = nextResourceRefExtension;
                    continue block0;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findExtension");
        }
        return foundResourceRefExtension;
    }

    private ResourceRefExtension findExtension(WebAppExtension ext, ResourceRef resRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findExtension");
        }
        ResourceRefExtension foundResourceRefExtension = null;
        if (resRef != null && ext != null) {
            for (ResourceRefExtension nextResourceRefExtension : ext.getResourceRefExtensions()) {
                ResourceRef nextResourceRef = nextResourceRefExtension.getResourceRef();
                if (nextResourceRef != resRef) continue;
                foundResourceRefExtension = nextResourceRefExtension;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findExtension");
        }
        return foundResourceRefExtension;
    }

    private EnterpriseBeanExtension findExtension(EJBJarExtension ext, EnterpriseBean ejb) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findExtension");
        }
        EnterpriseBeanExtension foundEjbExtension = null;
        if (ejb != null && ext != null) {
            for (EnterpriseBeanExtension ejbExtension : ext.getEjbExtensions()) {
                if (ejbExtension.getEnterpriseBean() != ejb) continue;
                foundEjbExtension = ejbExtension;
                break;
            }
        }
        return foundEjbExtension;
    }

    private ResourceRefBinding findResRefBinding(ResourceRef resRef, List resRefBnds) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findResRefBinding");
        }
        ResourceRefBinding foundResRefBinding = null;
        for (int j = 0; foundResRefBinding == null && j < resRefBnds.size(); ++j) {
            ResourceRefBinding rrb = (ResourceRefBinding)resRefBnds.get(j);
            if (rrb.getBindingResourceRef() != resRef) continue;
            foundResRefBinding = rrb;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findResRefBinding");
        }
        return foundResRefBinding;
    }

    private void addTaskData(AppDeploymentInfo appInstallInfo, EObject refObject, ResourceRef resRef, ResourceRefBinding resRefBinding, Integer isolationLevel, Vector data) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTaskData");
        }
        data.addElement(util.getModuleName(appInstallInfo, refObject));
        data.addElement(resRef.getName());
        data.addElement(resRefBinding.getJndiName());
        if (isolationLevel != null) {
            data.addElement(isolationLevel.toString());
        } else {
            data.addElement("");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTaskData");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            this.completeForEJB(appInstallInfo, t);
            this.completeForWAR(appInstallInfo, t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void completeForEJB(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeForEJB");
        }
        Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector ejbJarExtensions = appInstallInfo.getModuleConfig("JAR_EXT");
        for (int i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = (EJBJar)ejbJars.elementAt(i);
            EJBJarExtension ext = (EJBJarExtension)ejbJarExtensions.elementAt(i);
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                EnterpriseBeanBinding ejbBindings = ejbJarBinding.getEJBBinding(ejb);
                Iterator iter = ejb.getResourceRefs().iterator();
                while (iter.hasNext()) {
                    this.findIsolationLevel(appInstallInfo, t, (ResourceRef)iter.next(), ejbBindings.getResRefBindings(), ext, jar, ejb);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeForEJB");
        }
    }

    private void completeForWAR(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeForWAR");
        }
        Vector webApps = appInstallInfo.getModuleConfig("WAR_DD");
        Vector webAppBindings = appInstallInfo.getModuleConfig("WAR_BND");
        Vector webAppExtensions = appInstallInfo.getModuleConfig("WAR_EXT");
        for (int i = 0; i < webAppBindings.size(); ++i) {
            WebApp webApp = (WebApp)webApps.get(i);
            WebAppBinding webAppBinding = (WebAppBinding)webAppBindings.get(i);
            WebAppExtension webAppExt = (WebAppExtension)webAppExtensions.get(i);
            Iterator iter = webApp.getResourceRefs().iterator();
            while (iter.hasNext()) {
                this.findIsolationLevel(appInstallInfo, t, (ResourceRef)iter.next(), webAppBinding.getResRefBindings(), webAppExt, webApp, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareForWAR");
        }
    }

    private void findIsolationLevel(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, ResourceRef resRef, List resRefBnds, EObject extRefObject, EObject ddRefObject, EnterpriseBean ejb) throws AppDeploymentException {
        ResourceRefBinding resRefBinding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findIsolationLevel");
        }
        if ((resRefBinding = this.findResRefBinding(resRef, resRefBnds)) == null) {
            return;
        }
        String[] matchingTaskData = this.findTaskData(appInstallInfo, t, resRef, resRefBinding, ddRefObject);
        if (matchingTaskData == null) {
            return;
        }
        ResourceRefExtension extension2 = this.findExtension(extRefObject, resRef);
        IsolationLevelKind isolationLevel = null;
        if (extension2 != null) {
            isolationLevel = extension2.getIsolationLevel();
        }
        CorrectOracleIsolationLevel task = (CorrectOracleIsolationLevel)t;
        if (matchingTaskData.length > CorrectOracleIsolationLevel.isolationLevelColumn) {
            String taskDataIsolationLevel = matchingTaskData[CorrectOracleIsolationLevel.isolationLevelColumn];
            try {
                if (Integer.valueOf(taskDataIsolationLevel) != 2 && Integer.valueOf(taskDataIsolationLevel) != 8) {
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0025E"), resRef.getName(), util.getModuleName(appInstallInfo, ddRefObject)), null);
                }
                if (extension2 == null) {
                    extension2 = this.createResourceRefExtension(appInstallInfo, resRef, extRefObject, ddRefObject, ejb);
                }
                extension2.setIsolationLevel(IsolationLevelKind.get(Integer.parseInt(taskDataIsolationLevel)));
            }
            catch (NumberFormatException ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Isolation level not in number format: " + taskDataIsolationLevel + " " + ex);
                }
                throw new AppDeploymentException(MessageFormat.format(util.getMessage(t, "ADMA0026E"), taskDataIsolationLevel), ex);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Missing isolation level column for resource ref " + resRef.getName() + " for module " + util.getModuleName(appInstallInfo, ddRefObject));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findIsolationLevel");
        }
    }

    private ResourceRefExtension createResourceRefExtension(AppDeploymentInfo appInstallInfo, ResourceRef resRef, EObject extRefObject, EObject ddRefObject, EnterpriseBean ejb) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResourceRefExtension");
        }
        CommonextFactory factory = ((CommonextPackage)EPackage.Registry.INSTANCE.getEPackage("commonext.xmi")).getCommonextFactory();
        ResourceRefExtension resourceRefExtension = factory.createResourceRefExtension();
        resourceRefExtension.setResourceRef(resRef);
        if (ejb != null) {
            this.addResourceRefExtension(appInstallInfo, (EJBJar)ddRefObject, (EJBJarExtension)extRefObject, ejb, resourceRefExtension);
        } else if (ddRefObject instanceof WebApp) {
            this.addResourceRefExtension(appInstallInfo, (WebApp)ddRefObject, (WebAppExtension)extRefObject, resourceRefExtension);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResourceRefExtension");
        }
        return resourceRefExtension;
    }

    private void addResourceRefExtension(AppDeploymentInfo appInstallInfo, EJBJar jar, EJBJarExtension ext, EnterpriseBean ejb, ResourceRefExtension resRefExt) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceRefExtension");
        }
        EnterpriseBeanExtension ejbExtension = null;
        EJBJarExtension ejbJarExtension = ext;
        ejbExtension = this.findExtension(ejbJarExtension, ejb);
        if (ejbExtension == null) {
            EjbextFactory factory = ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
            ejbExtension = ejb.isEntity() ? factory.createEntityExtension() : factory.createSessionExtension();
            ejbExtension.setEnterpriseBean(ejb);
            ejbExtension.setEjbJarExtension(ejbJarExtension);
            ejbJarExtension.getEjbExtensions().add(ejbExtension);
        }
        ejbExtension.getResourceRefExtensions().add(resRefExt);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceRefExtension");
        }
    }

    private void addResourceRefExtension(AppDeploymentInfo appInstallInfo, WebApp webApp, WebAppExtension ext, ResourceRefExtension resourceRefExtension) throws AppDeploymentException {
        WebAppExtension webAppExtension = ext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addResourceRefExtension");
        }
        webAppExtension.getResourceRefExtensions().add(resourceRefExtension);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addResourceRefExtension");
        }
    }

    private String[] findTaskData(AppDeploymentInfo appInstallInfo, AppDeploymentTask t, ResourceRef resRef, ResourceRefBinding resRefBinding, EObject refObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findTaskData");
        }
        CorrectOracleIsolationLevel task = (CorrectOracleIsolationLevel)t;
        String[] matchingTaskData = null;
        String[][] taskData = t.getTaskData();
        for (int j = 0; j < taskData.length; ++j) {
            if (taskData[j].length <= CorrectOracleIsolationLevel.jndiColumn) continue;
            if (!resRef.getName().equals(taskData[j][CorrectOracleIsolationLevel.refBindingColumn])) continue;
            if (!util.getModuleName(appInstallInfo, refObject).equals(taskData[j][CorrectOracleIsolationLevel.moduleColumn])) continue;
            if (!resRefBinding.getJndiName().equals(taskData[j][CorrectOracleIsolationLevel.jndiColumn])) continue;
            matchingTaskData = taskData[j];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findTaskData");
        }
        return matchingTaskData;
    }
}

