/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.BindJndiForEJBNonMessageBinding;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class BindJndiForEJBNonMessageBindingHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper {
    private static TraceComponent tc = Tr.register(BindJndiForEJBNonMessageBindingHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String helperClass = this.getClass().getName();
            int index = helperClass.lastIndexOf("Helper");
            Class<?> taskClass = Class.forName(helperClass.substring(0, index));
            Constructor<?> constructor = taskClass.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appController);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        for (i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = ejbJarBinding.getEjbJar();
            for (EnterpriseBean ejb : jar.getEnterpriseBeans()) {
                if (ejb.isMessageDriven()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "home interface name: " + ejb.getHomeInterfaceName());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "local home interface name: " + ejb.getLocalHomeInterfaceName());
                }
                EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
                data.addElement(util.getModuleName(appInstallInfo, jar));
                data.addElement(ejb.getName());
                data.addElement(util.formUriString(appInstallInfo, jar));
                data.addElement(ejbBinding.getJndiName());
                if (colNames.length <= 4) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module version is " + jar.getVersionID());
                }
                data.addElement(Integer.toString(jar.getVersionID()));
                if (jar.getVersionID() >= 30) {
                    data.addElement(ejbBinding.getLocalHomeBindingName());
                    data.addElement(ejbBinding.getRemoteHomeBindingName());
                    continue;
                }
                data.addElement("");
                data.addElement("");
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!t.isTaskEmpty()) {
            Vector ejbJars = appInstallInfo.getModuleConfig("JAR_DD");
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("JAR_BND");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbJarBindings.size(): " + ejbJarBindings.size());
            }
            for (int i = 0; i < ejbJars.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EJBJar ejbJar = (EJBJar)ejbJars.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jar: " + ejbJar);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binding: " + ejbJarBinding);
                }
                for (EnterpriseBean ejb : ejbJar.getEnterpriseBeans()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ejb: " + ejb);
                    }
                    if (ejb.isMessageDriven()) continue;
                    String[] matchingTaskData = null;
                    String[][] taskData = t.getTaskData();
                    for (int j = 0; j < taskData.length; ++j) {
                        BindJndiForEJBNonMessageBinding cfr_ignored_0 = (BindJndiForEJBNonMessageBinding)t;
                        if (taskData[j].length <= 2) continue;
                        BindJndiForEJBNonMessageBinding cfr_ignored_1 = (BindJndiForEJBNonMessageBinding)t;
                        if (!ejb.getName().equals(taskData[j][1])) continue;
                        BindJndiForEJBNonMessageBinding cfr_ignored_2 = (BindJndiForEJBNonMessageBinding)t;
                        if (!util.compareUriString(appInstallInfo, ejbJar, taskData[j][2])) continue;
                        matchingTaskData = taskData[j];
                        break;
                    }
                    if (matchingTaskData == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No matching task data for ejb " + ejb.getName());
                        continue;
                    }
                    BindJndiForEJBNonMessageBinding cfr_ignored_3 = (BindJndiForEJBNonMessageBinding)t;
                    void jndi = matchingTaskData[3];
                    EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jndi for ejb: " + (String)jndi);
                    }
                    if (!AppUtils.isEmpty((String)jndi)) {
                        ejbBinding.setJndiName((String)jndi);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "set jndi");
                        }
                    } else if (!AppUtils.isEmpty(ejbBinding.getJndiName())) {
                        ejbBinding.setJndiName(null);
                    }
                    BindJndiForEJBNonMessageBinding cfr_ignored_4 = (BindJndiForEJBNonMessageBinding)t;
                    if (matchingTaskData.length <= 6) continue;
                    BindJndiForEJBNonMessageBinding cfr_ignored_5 = (BindJndiForEJBNonMessageBinding)t;
                    void localHomeJndi = matchingTaskData[5];
                    BindJndiForEJBNonMessageBinding cfr_ignored_6 = (BindJndiForEJBNonMessageBinding)t;
                    String remoteHomeJndi = matchingTaskData[6];
                    if (!AppUtils.isEmpty((String)localHomeJndi)) {
                        ejbBinding.setLocalHomeBindingName((String)localHomeJndi);
                    } else if (ejbBinding.isSetLocalHomeBindingName()) {
                        ejbBinding.unsetLocalHomeBindingName();
                    }
                    if (!AppUtils.isEmpty(remoteHomeJndi)) {
                        ejbBinding.setRemoteHomeBindingName(remoteHomeJndi);
                        continue;
                    }
                    if (!ejbBinding.isSetRemoteHomeBindingName()) continue;
                    ejbBinding.unsetRemoteHomeBindingName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB)) {
            return null;
        }
        Hashtable tbl = new Hashtable();
        Vector<String> v = new Vector<String>();
        v.addElement("/ejb-jar/enterprise-beans/entity");
        v.addElement("/ejb-jar/enterprise-beans/session");
        tbl.put(ModuleType.EJB.toString(), v);
        return tbl;
    }

    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{uri, dcImpl.getDDBean().getChildBean("ejb-name")[0].getText()}, new int[]{2, 1});
    }

    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }
}

