/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EjbbndPackage;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.Interface;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.WASDeploymentTask;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.BindJndiForEJBNonMessageBinding;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.DConfigBeanImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeployUtil;
import com.ibm.ws.management.application.j2ee.deploy.spi.J2EEDeploymentHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindJndiForEJBBusinessHelper
implements AppDeploymentTaskHelper,
J2EEDeploymentHelper,
AppDeploymentTaskValidate {
    private static TraceComponent tc = Tr.register(BindJndiForEJBBusinessHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] cols = new String[]{"EJBModule", "EJB", "uri", "ejbBusinessInterface", "ejbBusinessInterfaceJndi"};
    public static final int ejbModuleColumn = 0;
    public static final int ejbColumn = 1;
    public static final int uriColumn = 2;
    public static final int interfaceClassNameColumn = 3;
    public static final int jndiColumn = 4;

    @Override
    public AppDeploymentTask createTask(AppDeploymentController appController, String taskName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            return new WASDeploymentTask(appController, taskName, cols, new boolean[]{false, false, false, false, false}, new boolean[]{false, false, false, false, true}, new boolean[]{false, false, false, false, false}, false);
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + ex);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    @Override
    public void prepareTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask for BindJndiForEJBBusiness");
        }
        if (t.getTaskData() != null) {
            return;
        }
        Vector ejbJarBindings = appInstallInfo.getModuleConfig("EJB3JAR_BND");
        Vector<String> data = new Vector<String>();
        String[] colNames = t.getColumnNames();
        for (i = 0; i < colNames.length; ++i) {
            data.addElement(colNames[i]);
        }
        for (i = 0; i < ejbJarBindings.size(); ++i) {
            EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
            EJBJar jar = ejbJarBinding.getEjbJar();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jar: " + jar);
            }
            Iterator iterator = jar.getEnterpriseBeans().iterator();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "has ejb: " + iterator.hasNext());
            }
            while (iterator.hasNext()) {
                EnterpriseBean ejb = (EnterpriseBean)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ejb: " + ejb);
                }
                if (ejb.isMessageDriven()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "skipping message driver bean");
                    continue;
                }
                if (!ejb.isSession()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "is a session bean");
                }
                EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "binding: " + ejbBinding);
                }
                Session session = (Session)ejb;
                String moduleName = util.getModuleName(appInstallInfo, jar);
                String uri = util.formUriString(appInstallInfo, jar);
                EList interfaces = ejbBinding.getInterfaces();
                this.addInterfaceData(moduleName, ejb.getName(), uri, session.getLocalBusinessInterfaces(), data, interfaces);
                this.addInterfaceData(moduleName, ejb.getName(), uri, session.getRemoteBusinessInterfaces(), data, interfaces);
            }
        }
        t.setTaskData(util.buildTaskData(data, colNames.length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    @Override
    public void completeTask(AppDeploymentInfo appInstallInfo, AppDeploymentTask t) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask for BindJndiForEJBBusiness");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isTaskEmpty: " + t.isTaskEmpty());
        }
        if (!t.isTaskEmpty()) {
            Vector ejbJarBindings = appInstallInfo.getModuleConfig("EJB3JAR_BND");
            for (int i = 0; i < ejbJarBindings.size(); ++i) {
                EJBJarBinding ejbJarBinding = (EJBJarBinding)ejbJarBindings.elementAt(i);
                EJBJar jar = ejbJarBinding.getEjbJar();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jar: " + jar);
                }
                Iterator iterator = jar.getEnterpriseBeans().iterator();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "has ejb: " + iterator.hasNext());
                }
                while (iterator.hasNext()) {
                    EnterpriseBean ejb = (EnterpriseBean)iterator.next();
                    if (ejb.isMessageDriven()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "skipping message driver bean");
                        continue;
                    }
                    if (!ejb.isSession()) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "skipping non session bean");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "is a session bean");
                    }
                    EnterpriseBeanBinding ejbBinding = ejbJarBinding.getEJBBinding(ejb);
                    List<String[]> matchingTaskDataList = this.getMatchingTaskData(appInstallInfo, t, ejb.getName(), jar);
                    if (matchingTaskDataList == null || matchingTaskDataList.size() == 0) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "No matching task data for ejb " + ejb.getName());
                        continue;
                    }
                    for (int j = 0; j < matchingTaskDataList.size(); ++j) {
                        String[] matchingTaskData = matchingTaskDataList.get(j);
                        Interface matchingInterfaceBinding = this.getMatchingInterfaceBinding(matchingTaskData, ejbBinding);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "matching interface binding: " + matchingInterfaceBinding);
                        }
                        if (matchingInterfaceBinding != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "jndi name for business interface: " + matchingTaskData[4]);
                            }
                            if (AppUtils.isEmpty(matchingTaskData[4])) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "business interface jndi is reset to null");
                                }
                                ejbBinding.getInterfaces().remove(matchingInterfaceBinding);
                                continue;
                            }
                            if (!matchingTaskData[4].equals(matchingInterfaceBinding.getBindingName())) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "setting business interface jndi to new value " + matchingTaskData[4]);
                                }
                                matchingInterfaceBinding.setBindingName(matchingTaskData[4]);
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "same jndi value. No change");
                            continue;
                        }
                        if (AppUtils.isEmpty(matchingTaskData[4])) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "creating a business interface binding");
                        }
                        Interface busInterface = ((EjbbndPackage)EPackage.Registry.INSTANCE.getEPackage("ejbbnd.xmi")).getEjbbndFactory().createInterface();
                        busInterface.setBindingName(matchingTaskData[4]);
                        busInterface.setClassName(matchingTaskData[3]);
                        ejbBinding.getInterfaces().add(busInterface);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }

    private void addInterfaceData(String moduleName, String ejbName, String uri, List businessInterfaces, Vector data, List interfaceBindings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInterfaceData", new Object[]{moduleName, ejbName, uri, businessInterfaces, data, interfaceBindings});
        }
        for (int j = 0; j < businessInterfaces.size(); ++j) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "business interface: " + businessInterfaces.get(j));
            }
            data.addElement(moduleName);
            data.addElement(ejbName);
            data.addElement(uri);
            data.addElement(((JavaClass)businessInterfaces.get(j)).getJavaName());
            boolean found = false;
            for (int k = 0; k < interfaceBindings.size(); ++k) {
                if (!((JavaClass)businessInterfaces.get(j)).getJavaName().equals(((Interface)interfaceBindings.get(k)).getClassName())) continue;
                data.addElement(((Interface)interfaceBindings.get(k)).getBindingName());
                found = true;
                break;
            }
            if (found) continue;
            data.addElement("");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInterfaceData");
        }
    }

    private List<String[]> getMatchingTaskData(AppDeploymentInfo appInstallInfo, AppDeploymentTask task, String ejbName, EObject jar) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingTaskData", new Object[]{appInstallInfo, task, ejbName});
        }
        ArrayList<String[]> matchingTaskData = new ArrayList<String[]>();
        String[][] taskData = task.getTaskData();
        for (int j = 0; j < taskData.length; ++j) {
            if (taskData[j].length <= 2 || !ejbName.equals(taskData[j][1]) || !util.compareUriString(appInstallInfo, jar, taskData[j][2])) continue;
            matchingTaskData.add(taskData[j]);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingTaskData", new Object[]{matchingTaskData});
        }
        return matchingTaskData;
    }

    private Interface getMatchingInterfaceBinding(String[] matchingTaskData, EnterpriseBeanBinding ejbBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingInterfaceBinding", new Object[]{matchingTaskData, ejbBinding});
        }
        EList bindings = ejbBinding.getInterfaces();
        Interface matchingInterfaceBinding = null;
        for (int k = 0; k < bindings.size(); ++k) {
            if (!matchingTaskData[3].equals(((Interface)bindings.get(k)).getClassName())) continue;
            matchingInterfaceBinding = (Interface)bindings.get(k);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingInterfaceBinding", new Object[]{matchingInterfaceBinding});
        }
        return matchingInterfaceBinding;
    }

    @Override
    public Hashtable getXPathInfo(Vector allTypes) {
        if (!allTypes.contains(ModuleType.EJB)) {
            return null;
        }
        Hashtable tbl = new Hashtable();
        Vector<String> v = new Vector<String>();
        v.addElement("/ejb-jar/enterprise-beans/session");
        tbl.put(ModuleType.EJB.toString(), v);
        return tbl;
    }

    @Override
    public void taskData2DCBean(AppDeploymentTask task, DConfigBeanImpl dcImpl, String uri) {
        J2EEDeployUtil.task2DC(task, dcImpl, new String[]{uri, dcImpl.getDDBean().getChildBean("ejb-name")[0].getText()}, new int[]{2, 1});
    }

    @Override
    public void dcBean2TaskData(AppDeploymentTask task, Hashtable keys, Hashtable props) {
        J2EEDeployUtil.dcBean2TaskData(task, keys, props);
    }

    @Override
    public String[] validate(AppDeploymentTask task, AppDeploymentInfo taskinfo) {
        String[][] taskData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{task, taskinfo});
        }
        String[] taskValidateErrorMessages = null;
        if ("BindJndiForEJBBusiness".equals(task.getName()) && (taskData = task.getTaskData()) != null) {
            BindJndiForEJBNonMessageBinding ejbJndiTask = null;
            try {
                ejbJndiTask = (BindJndiForEJBNonMessageBinding)task.getAppDeploymentController().getTaskByName("BindJndiForEJBNonMessageBinding", false);
            }
            catch (Exception ex) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when calling getTaskByName: " + ex);
                }
                ejbJndiTask = null;
            }
            if (ejbJndiTask == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "task BindJndiForEJBNonMessageBinding is null");
                }
            } else {
                int i;
                Vector<String> errorMessages = new Vector<String>();
                block2: for (i = 1; i < taskData.length; ++i) {
                    if (AppUtils.isEmpty(taskData[i][4])) continue;
                    String[][] ejbJndiTaskData = ejbJndiTask.getTaskData();
                    for (int j = 1; j < ejbJndiTaskData.length; ++j) {
                        if (!taskData[i][1].equals(ejbJndiTaskData[j][1]) || !taskData[i][2].equals(ejbJndiTaskData[j][2])) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "jndiColumn for business: " + taskData[i][4]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "jndiColumn for bean: " + ejbJndiTaskData[j][3]);
                        }
                        if (AppUtils.isEmpty(ejbJndiTaskData[j][3])) continue block2;
                        String error = MessageFormat.format(util.getMessage(task, "ADMA0206E"), util.getGoalTitle(ejbJndiTask, ejbJndiTask.getName()), taskData[i][3], util.getGoalTitle(task, task.getName()), taskData[i][1], taskData[i][0]);
                        errorMessages.addElement(error);
                        continue block2;
                    }
                }
                if (errorMessages != null && errorMessages.size() > 0) {
                    taskValidateErrorMessages = new String[errorMessages.size()];
                    for (i = 0; i < errorMessages.size(); ++i) {
                        taskValidateErrorMessages[i] = (String)errorMessages.elementAt(i);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return taskValidateErrorMessages;
    }
}

