/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ArchiveSchedulerImpl;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.application.task.ActivationPlan;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DeltaDataTask;
import com.ibm.ws.management.application.task.PropBasedConfigTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;

public class UpdateSchedulerImpl
extends ArchiveSchedulerImpl
implements UpdateScheduler {
    private static TraceComponent tc = Tr.register(UpdateSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private boolean inPreUpdate = true;
    private String _contentURI;
    private String _operation;
    private String _origContentType;
    private List _deltaContents;
    private boolean isZeroBinCopy = false;

    public UpdateSchedulerImpl(String aName, String contURI, String pathToCont, String op, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        super(pathToCont, aName, tbl, appM, notf);
        this.appTaskName = "UpdateApplication";
        this._contentType = (String)tbl.get("contenttype");
        this._contentURI = contURI;
        if (this._contentURI != null) {
            this._contentURI = this._contentURI.replace('\\', '/');
        }
        this._operation = op;
        this._origContentType = this._contentType;
        this._deltaContents = new ArrayList();
    }

    public String getOperation() {
        return this._operation;
    }

    public String getContentPath() {
        return super.getArchivePath();
    }

    public void setContentPath(String newPath) throws AdminException {
        super.setArchivePath(newPath);
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getOrigContentType() {
        return this._origContentType;
    }

    public void setContentType(String s) throws AdminException {
        if (s == null || s.equals(this.getContentType())) {
            return;
        }
        if (!this.inPreUpdate) {
            throw new AdminException("ContentType can only be set in pre update phase.");
        }
        this._contentType = s;
        this.setContentPath(this.getContentPath());
    }

    public Archive getContentAsArchive() throws AdminException {
        if (!(this.isZeroBinCopy || this._contentType.equals("app") || this._contentType.equals("modulefile"))) {
            return null;
        }
        return super.getArchive();
    }

    public Archive getContentAsArchive(boolean useReflection, boolean readOnly) throws AdminException {
        if (!(this.isZeroBinCopy || this._contentType.equals("app") || this._contentType.equals("modulefile"))) {
            return null;
        }
        return super.getArchive(useReflection, readOnly);
    }

    public String getContentURI() {
        return this._contentURI;
    }

    protected AppNotification createCompletionEvent(boolean bSuccess) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCompletionEvent");
        }
        String msg = "Update of " + this.appName + " has ended.";
        AppNotification notf = new AppNotification("UpdateApplication", "", bSuccess ? "Completed" : "Failed", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompletionEvent");
        }
        return notf;
    }

    protected AppNotification createStartEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createStartEvent");
        }
        String msg = "Update of " + this.appName + " has started.";
        AppNotification notf = new AppNotification("UpdateApplication", "", "InProgress", "", msg);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createStartEvent");
        }
        return notf;
    }

    protected String getJMXEventType() {
        return "websphere.admin.appmgmt.update";
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        try {
            this.validateParams(this.getProperties(), this._contentURI, this._pathToContent, this._operation);
        }
        catch (AdminException ae) {
            String msg = "";
            if (this.resBundle != null) {
                msg = AppUtils.getMessage(this.resBundle, "ADMA0169E", new String[]{this.appName});
            }
            this.propagateTaskEvent(new AppNotification("UpdateApplication", "", "InProgress", "", msg + ae.getMessage()));
            throw ae;
        }
        this.tasks = new Vector();
        DefaultTaskProvider dtp = new DefaultTaskProvider();
        dtp.providePreUpdateTasks(this.tasks, this);
        this.tasks = ExtensionHelper.processServerPreUpdateExtensions(this.properties, this.tasks, this);
        this.inPreUpdate = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    protected void performCleanup(boolean bSuccess) throws Exception {
        super.performCleanup(bSuccess);
        if (!bSuccess && !this.amIWorkSpaceOwner) {
            String msg = "An update application operation failed and the configuration session could not be restored to its state before the operation was initiated.  The configuration session is in an inconsistent state, and changes made in the session should be discarded.";
            if (this.resBundle != null) {
                msg = AppUtils.getMessage(this.resBundle, "ADMA0185W");
            }
            AppNotification notf = new AppNotification("UpdateApplication", "", "Warning", "", msg);
            this.propagateTaskEvent(notf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateParams(Hashtable props, String contentURI, String pathToContent, String op) throws Exception {
        RepositoryContext rc;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "op " + op);
        }
        if ((rc = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties())) == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
        }
        boolean contentUriIsNull = AppUtils.isEmpty(contentURI);
        boolean pathToContentIsNull = AppUtils.isEmpty(pathToContent);
        String cType = (String)props.get("contenttype");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cType " + cType);
        }
        if (ConfigRepoHelper.getAppDeploymentForApp(rc).isZeroBinaryCopy()) {
            this._pathToContent = ConfigRepoHelper.getAbsoluteBinariesURL(rc, this.getWorkSpace());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "_pathToContent " + this._pathToContent);
            }
            if (!new File(this._pathToContent).exists()) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0174E", new Object[0]));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No other validation for zero binary copy");
            }
            this.isZeroBinCopy = true;
            if (!AppUtils.isEmpty(cType)) return;
            return;
        }
        if (!contentUriIsNull) {
            this._contentURI = contentURI.replace('\\', '/');
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_contentURI " + this._contentURI);
        }
        if (AppUtils.isEmpty(cType) || !cType.equals("app") && !cType.equals("file") && !cType.equals("partialapp") && !cType.equals("modulefile")) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0130E", new String[]{cType, this.appName}));
        }
        if (!(cType.equals("partialapp") || !AppUtils.isEmpty(op) && (op.equalsIgnoreCase("add") || op.equalsIgnoreCase("addupdate") || op.equalsIgnoreCase("delete") || op.equalsIgnoreCase("update")))) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0132E", new String[]{op, this.appName}));
        }
        if ("delete".equals(this._operation) && (cType.equals("file") || cType.equals("modulefile"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Remove jsp precompile or ejbdeploy flags for delete");
            }
            this.getProperties().remove("preCompileJSPs");
            this.getProperties().remove("deployejb");
        }
        if (cType.equals("partialapp")) {
            if (pathToContentIsNull) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0131E", new String[0]));
            }
            File f = new File(pathToContent);
            if (f.exists()) return;
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0165E", new String[]{pathToContent}));
        }
        if (op.equals("add") || op.equals("addupdate") || op.equals("update")) {
            File f;
            if (contentUriIsNull) throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0133E"));
            if (pathToContentIsNull) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0133E"));
            }
            if (cType.equals("modulefile")) {
                int indx = contentURI.indexOf(File.separator);
                String dir = null;
                if (indx > 0) {
                    dir = contentURI.substring(0, indx);
                } else {
                    indx = contentURI.indexOf("/");
                    if (indx > 0) {
                        dir = contentURI.substring(0, indx);
                    }
                }
                if (dir != null) {
                    if (dir.endsWith(".ear")) throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + contentURI + "'  for modulefile update has syntax error. Please make sure it contains the module uri only. ");
                    if (dir.endsWith(".jar")) throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + contentURI + "'  for modulefile update has syntax error. Please make sure it contains the module uri only. ");
                    if (dir.endsWith(".war")) throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + contentURI + "'  for modulefile update has syntax error. Please make sure it contains the module uri only. ");
                    if (dir.endsWith(".rar")) {
                        throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + contentURI + "'  for modulefile update has syntax error. Please make sure it contains the module uri only. ");
                    }
                }
            }
            if (!(f = new File(pathToContent)).exists()) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0134E", new String[]{pathToContent, this.appName}));
            }
        } else if (op.equalsIgnoreCase("delete") && contentUriIsNull) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0135E"));
        }
        Archive ear = null;
        try {
            block36: {
                try {
                    boolean zeroEarCopy = ConfigRepoHelper.getAppDeploymentForApp(rc).isZeroEarCopy();
                    ear = !zeroEarCopy ? ConfigRepoHelper.getEarFileFromBinaries(rc, this.getWorkSpace(), this.resBundle, true) : ConfigRepoHelper.getEarFileFromDeployment(this.getWorkSpace(), rc);
                    if ("modulefile".equals(cType) && "addupdate".equals(op)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "For ModuleFile::ADDUPDATE case lets decide if ADD or UPDATE");
                        }
                        this._operation = this.containsModuleFile((EARFile)ear, contentURI) ? "update" : "add";
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "For ModuleFile::ADDUPDATE case changed operation to " + this._operation);
                        }
                    }
                    if ("modulefile".equals(cType) && "delete".equals(op)) {
                        this.checkRemoveLastModule((EARFile)ear, contentURI);
                    }
                    if (!zeroEarCopy || contentURI.matches("META-INF/[^/]*|WEB-INF/[^/]*|.*wsdl|META-INF/wsdl/.*|WEB-INF/wsdl/.*")) {
                        this.checkDuplicate((EARFile)ear, contentURI, op);
                    }
                    if (!"add".equals(op) && !"update".equals(op) && !"delete".equals(op) || !zeroEarCopy || !cType.equals("modulefile")) break block36;
                    this.checkDuplicateForZeroEarCopy((EARFile)ear, contentURI, op);
                }
                catch (Throwable t) {
                    if (t instanceof AdminException) {
                        throw (AdminException)t;
                    }
                    RasUtils.logException(t, tc, CLASS_NAME, "validateParams", "495", this);
                    Object var12_16 = null;
                    if (ear == null) return;
                    ear.close();
                    return;
                }
            }
            Object var12_15 = null;
            if (ear == null) return;
            ear.close();
            return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (ear == null) throw throwable;
            ear.close();
            throw throwable;
        }
    }

    private boolean containsModuleFile(EARFile ear, String uri) throws Exception {
        EList l = ear.getModuleRefs();
        for (int i = 0; i < l.size(); ++i) {
            if (!((ModuleRef)l.get(i)).getUri().equals(uri)) continue;
            return true;
        }
        return false;
    }

    private void checkDuplicate(EARFile ear, String uri, String op) throws AdminException {
        Object[] o = null;
        try {
            o = AppUtils.getContainerAndOffset(ear, uri);
        }
        catch (Exception e) {
            throw new AdminException("ERROR: " + e.getMessage());
        }
        Container c = (Container)o[0];
        String offset = (String)o[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "container = " + c + " , offset = " + offset);
        }
        if (c.containsFile(offset)) {
            if ("add".equals(op)) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{uri, op}));
            }
        } else {
            EList l = c.getFiles();
            boolean find = false;
            String offsetDir = offset + "/";
            if (!offsetDir.endsWith("/")) {
                offsetDir = offset + "/";
            }
            if (l != null) {
                for (int i = 0; i < l.size(); ++i) {
                    org.eclipse.jst.j2ee.commonarchivecore.internal.File f = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)l.get(i);
                    if (f.getURI().indexOf(offsetDir) == -1) continue;
                    if ("update".equals(op) || "addupdate".equals(op)) {
                        throw new AdminException("Parameter validation failure for " + this.appName + ". The contentURI '" + offset + "'  for file update points to the directory. Directory can not be replaced by a single file.");
                    }
                    if ("add".equals(op)) {
                        throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{uri, op}));
                    }
                    find = true;
                    break;
                }
            }
            if (!find && ("update".equals(op) || "delete".equals(op))) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0167E", new Object[]{uri, op}));
            }
        }
    }

    private void checkDuplicateForZeroEarCopy(EARFile ear, String uri, String op) throws AdminException {
        EList l = ear.getModuleRefs();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search uri: " + uri);
        }
        for (int i = 0; i < l.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri: " + ((ModuleRef)l.get(i)).getUri());
            }
            if (l.size() != 1 || !((ModuleRef)l.get(0)).getUri().equals(uri)) continue;
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0168E", new Object[]{uri}));
        }
        try {
            boolean containsUri = this.containsModuleFile(ear, uri);
            if (containsUri) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contains " + uri);
                }
                if ("add".equals(op)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0166E", new Object[]{uri, op}));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not contains " + uri);
                }
                if ("update".equals(op) || "delete".equals(op)) {
                    throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0167E", new Object[]{uri, op}));
                }
            }
        }
        catch (AdminException ae) {
            throw ae;
        }
        catch (Throwable t) {
            throw new AdminException(t);
        }
    }

    private void checkRemoveLastModule(EARFile ear, String uri) throws AdminException {
        EList l = ear.getModuleRefs();
        if (l.size() == 1 && ((ModuleRef)l.get(0)).getUri().equals(uri)) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0168E", new Object[]{uri}));
        }
    }

    protected AbstractTask getNextTask() throws AdminException {
        if (this.inPreUpdate && this.nextTaskNum >= this.tasks.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Preupdate phase is over . gather update tasks");
            }
            this.inPreUpdate = false;
            Vector t = new Vector();
            DefaultTaskProvider dtp = new DefaultTaskProvider();
            dtp.provideUpdateTasks(t, this);
            try {
                t = ExtensionHelper.processServerUpdateExtensions(this.properties, t, this);
                CDFBridgeExtensionHelper.processServerUpdateExtensions(this.properties, t, this);
            }
            catch (AppDeploymentException ex) {
                throw new AdminException(ex, "");
            }
            t.addElement(new ActivationPlan());
            t.addElement(new PropBasedConfigTask());
            t.addElement(new DeltaDataTask());
            this.tasks.addAll(t);
            Object var1_1 = null;
        }
        return super.getNextTask();
    }

    public void notifyDeltaUpdate(String uri, String type) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notifyDeltaUpdate: " + uri + ", " + type);
        }
        this._deltaContents.add(uri);
        this._deltaContents.add(type);
    }

    public List getDeltaContents() {
        return this._deltaContents;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/UpdateSchedulerImpl.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.32");
        }
        CLASS_NAME = UpdateSchedulerImpl.class.getName();
    }
}

