/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.application.AppUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ResourceLookup {
    private static TraceComponent tc = Tr.register(ResourceLookup.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    static final String RES_SCOPE = "scope";
    static final String RES_TYPE = "type";
    static final String RES_VALUE = "value";
    static final String RES_INDEX = "index";

    public static List searchResources(String appName, Hashtable prefs, String wID, Vector tasks) throws AdminException {
        String taskname;
        int ii;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchResources(" + appName + "," + prefs + "," + wID + ")");
        }
        ArrayList result = new ArrayList();
        ResourceBundle resBundle = AppUtils.getBundle(prefs);
        Hashtable appList = new Hashtable(5);
        String cellname = System.getProperty("local.cell");
        if (cellname == null) {
            cellname = AdminServiceFactory.getAdminService().getCellName();
        }
        Hashtable pp = prefs;
        if (prefs == null) {
            pp = new Hashtable();
        }
        String[][] restbl = AppUtils.getResourceTable();
        int tsize = restbl.length;
        Object moduleURI = null;
        AppDeploymentTask installTask = null;
        boolean found = false;
        Hashtable<String, String> scopeTbl = new Hashtable<String, String>();
        String column = restbl[0][0];
        String mtask = restbl[0][1];
        String type = restbl[0][2];
        String attribute = restbl[0][3];
        for (ii = 0; ii < tasks.size(); ++ii) {
            installTask = (AppDeploymentTask)tasks.elementAt(ii);
            taskname = installTask.getName();
            String scope = null;
            String module = null;
            if (!taskname.equals(mtask)) continue;
            String[] colNames = installTask.getColumnNames();
            String[][] taskData = installTask.getTaskData();
            if (taskData == null) break;
            for (int i = 1; i < taskData.length; ++i) {
                module = taskData[i][0];
                scope = taskData[i][2];
                scopeTbl.put(module, scope);
            }
            break;
        }
        for (ii = 0; ii < tasks.size(); ++ii) {
            installTask = (AppDeploymentTask)tasks.elementAt(ii);
            taskname = installTask.getName();
            for (int n = 1; n < tsize; ++n) {
                column = restbl[n][0];
                mtask = restbl[n][1];
                type = restbl[n][2];
                attribute = restbl[n][3];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyName= " + column + " mtask: " + mtask + " attr: " + attribute + " colm: " + column + "type=" + type);
                }
                if (!taskname.equals(mtask)) continue;
                String[] colNames = installTask.getColumnNames();
                String[][] taskData = installTask.getTaskData();
                if (taskData == null) continue;
                int col = colNames.length;
                int matchCol = -1;
                int moduleCol = -1;
                for (int mm = 0; mm < col; ++mm) {
                    if ("module".equals(colNames[mm])) {
                        moduleCol = mm;
                    }
                    if ("EJBModule".equals(colNames[mm])) {
                        moduleCol = mm;
                    }
                    if ("webModule".equals(colNames[mm])) {
                        moduleCol = mm;
                    }
                    if (!column.equals(colNames[mm])) continue;
                    matchCol = mm;
                }
                if (matchCol == -1) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "column found " + appName + "  task: " + taskname + "Colnm: " + column);
                }
                if (taskData == null) continue;
                boolean matched = true;
                for (int i = 1; i < taskData.length; ++i) {
                    String value = taskData[i][matchCol];
                    if (value == null) continue;
                    String module = "Cell";
                    if (moduleCol != -1) {
                        module = taskData[i][moduleCol];
                    }
                    Tr.debug(tc, "Module = " + module + " value= " + value);
                    String scope = (String)scopeTbl.get(module);
                    if (scope == null) {
                        scope = "WebSphere:cell=" + cellname;
                    }
                    Hashtable<String, String> resObj = new Hashtable<String, String>();
                    resObj.put(RES_SCOPE, scope);
                    resObj.put(RES_TYPE, type);
                    resObj.put(RES_VALUE, value);
                    resObj.put(RES_INDEX, Integer.toString(n));
                    result.add(resObj);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchResources returns : " + result);
        }
        return result;
    }

    public static List convertRefToConfigID(String appName, List resources, Hashtable prefs, String wID) throws AdminException {
        String nname;
        ObjectName nodeObj;
        int j;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertRefToConfigID(" + resources + "." + wID);
        }
        if (resources == null) {
            return null;
        }
        ResourceBundle resBundle = AppUtils.getBundle(prefs);
        String[][] restbl = AppUtils.getResourceTable();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>();
        Session session = new Session();
        Hashtable<String, ObjectName> cellNameTbl = new Hashtable<String, ObjectName>();
        List cells = ResourceLookup.listObjects(configService, session, "Cell", null);
        Hashtable nodeTbl = new Hashtable();
        Hashtable serverTbl = new Hashtable();
        Properties prop = null;
        for (int i = 0; i < cells.size(); ++i) {
            ObjectName cellObj = (ObjectName)cells.get(i);
            prop = ConfigServiceHelper.getObjectLocation(cellObj);
            String cname = prop.getProperty("cell");
            cellNameTbl.put(cname, cellObj);
            Hashtable<String, ObjectName> ntbl = new Hashtable<String, ObjectName>();
            Hashtable stbl = new Hashtable();
            ObjectName[] nodes = null;
            try {
                nodes = configService.getRelationship(session, cellObj, "Node");
            }
            catch (ConfigServiceException e) {
                throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA00119E", new Object[]{cname, "ConfigServiceException"}));
            }
            catch (ConnectorException e) {
                throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA00119E", new Object[]{cname, "ConnectorException"}));
            }
            for (j = 0; j < nodes.length; ++j) {
                nodeObj = nodes[j];
                prop = ConfigServiceHelper.getObjectLocation(nodeObj);
                nname = prop.getProperty("node");
                ntbl.put(nname, nodeObj);
                Hashtable<String, ObjectName> srvTbl = new Hashtable<String, ObjectName>();
                ObjectName[] servers = null;
                try {
                    servers = configService.getRelationship(session, nodeObj, "Server");
                }
                catch (ConfigServiceException e1) {
                    throw new AdminException(e1, AppUtils.getMessage(resBundle, "ADMA00120E", new Object[]{nname, "ConfigServiceException"}));
                }
                catch (ConnectorException e1) {
                    throw new AdminException(e1, AppUtils.getMessage(resBundle, "ADMA00120E", new Object[]{nname, "ConnectorException"}));
                }
                for (int k = 0; k < servers.length; ++k) {
                    Hashtable sstbl = new Hashtable();
                    ObjectName serverObj = servers[i];
                    prop = ConfigServiceHelper.getObjectLocation(serverObj);
                    String sname = prop.getProperty("server");
                    srvTbl.put(sname, serverObj);
                }
                stbl.put(nname, srvTbl);
            }
            nodeTbl.put(cname, ntbl);
            serverTbl.put(cname, stbl);
        }
        Hashtable clusterTbl = new Hashtable();
        for (int i = 0; i < cells.size(); ++i) {
            ObjectName cellObj = (ObjectName)cells.get(i);
            prop = ConfigServiceHelper.getObjectLocation(cellObj);
            String cname = prop.getProperty("cell");
            Hashtable<String, ObjectName> ctbl = new Hashtable<String, ObjectName>();
            ObjectName[] clusters = null;
            try {
                clusters = configService.getRelationship(session, cellObj, "ServerCluster");
            }
            catch (ConfigServiceException e) {
                throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA00121E", new Object[]{cname, "ConfigServiceException"}));
            }
            catch (ConnectorException e) {
                throw new AdminException(e, AppUtils.getMessage(resBundle, "ADMA00121E", new Object[]{cname, "ConnectorException"}));
            }
            for (j = 0; j < clusters.length; ++j) {
                nodeObj = clusters[j];
                nname = nodeObj.getKeyProperty("name");
                ctbl.put(nname, nodeObj);
            }
            clusterTbl.put(cname, ctbl);
        }
        ObjectName app = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Deployment");
        try {
            ObjectName[] deployments = configService.queryConfigObjects(session, null, pattern, null);
            ObjectName depl = null;
            for (int i = 0; i < deployments.length; ++i) {
                depl = deployments[i];
                AttributeList attrList = configService.getAttributes(session, depl, new String[]{"deployedObject"}, false);
                ObjectName appdepl = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deployedObject");
                String url = (String)ConfigServiceHelper.getAttributeValue(attrList = configService.getAttributes(session, appdepl, new String[]{"binariesURL"}, false), "binariesURL");
                if (url.indexOf(appName) == -1) continue;
                app = depl;
            }
        }
        catch (ConfigServiceException e1) {
            throw new AdminException(e1, AppUtils.getMessage(resBundle, "ADMA00122E", new Object[]{appName, "ConfigServiceException"}));
        }
        catch (AttributeNotFoundException e1) {
            throw new AdminException(e1, AppUtils.getMessage(resBundle, "ADMA00122E", new Object[]{appName, "AttributeNotFoundException"}));
        }
        catch (ConnectorException e1) {
            throw new AdminException(e1, AppUtils.getMessage(resBundle, "ADMA00122E", new Object[]{appName, "ConnectorException"}));
        }
        for (int i = 0; i < resources.size(); ++i) {
            Hashtable resObj = (Hashtable)resources.get(i);
            int index = -1;
            index = Integer.parseInt((String)resObj.get(RES_INDEX));
            String column = restbl[index][0];
            String mtask = restbl[index][1];
            String type = restbl[index][2];
            String attribute = restbl[index][3];
            String value = (String)resObj.get(RES_VALUE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resouce[" + i + "] type= " + type + " attribute " + attribute + " value " + value);
            }
            List objs = null;
            objs = ResourceLookup.listObjects(configService, session, type, app);
            ObjectName obj = ResourceLookup.searchObj(configService, session, objs, attribute, value);
            if (obj != null) continue;
            String scope = (String)resObj.get(RES_SCOPE);
            String[] ps = new String[]{scope};
            if (scope.indexOf(43) != -1) {
                ps = scope.split("\\+");
            }
            for (int ii = 0; ii < ps.length; ++ii) {
                ObjectName scopeObj = null;
                try {
                    scopeObj = new ObjectName(ps[ii]);
                }
                catch (MalformedObjectNameException ex) {
                    continue;
                }
                String cname = scopeObj.getKeyProperty("cell");
                String nname2 = scopeObj.getKeyProperty("node");
                String sname = scopeObj.getKeyProperty("server");
                String clname = scopeObj.getKeyProperty("cluster");
                if (cname == null) continue;
                ObjectName cObj = (ObjectName)cellNameTbl.get(cname);
                Hashtable ntbl = (Hashtable)nodeTbl.get(cname);
                Hashtable srvtbl = (Hashtable)serverTbl.get(cname);
                Hashtable cltbl = (Hashtable)clusterTbl.get(cname);
                ObjectName nObj = (ObjectName)ntbl.get(nname2);
                if (nname2 == null) {
                    if (clname != null) {
                        ObjectName sObj = (ObjectName)cltbl.get(clname);
                        objs = ResourceLookup.listObjects(configService, session, type, sObj);
                        obj = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                        if (obj != null) {
                            if (result.contains(obj)) continue;
                            result.add(obj);
                            continue;
                        }
                        obj = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                        if (obj == null || result.contains(obj)) continue;
                        result.add(obj);
                        continue;
                    }
                    objs = ResourceLookup.listObjects(configService, session, type, cObj);
                    obj = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                    if (obj == null || result.contains(obj)) continue;
                    result.add(obj);
                    continue;
                }
                if (sname != null) {
                    nObj = (ObjectName)ntbl.get(nname2);
                    Hashtable stbl = (Hashtable)srvtbl.get(nname2);
                    ObjectName sObj = (ObjectName)stbl.get(sname);
                    objs = ResourceLookup.listObjects(configService, session, type, sObj);
                    obj = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                    if (obj != null) {
                        if (result.contains(obj)) continue;
                        result.add(obj);
                        continue;
                    }
                    objs = ResourceLookup.listObjects(configService, session, type, nObj);
                    ObjectName objn = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                    if (objn != null) {
                        if (result.contains(objn)) continue;
                        result.add(objn);
                        continue;
                    }
                    objs = ResourceLookup.listObjects(configService, session, type, cObj);
                    ObjectName objc = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                    if (objc == null || result.contains(objc)) continue;
                    result.add(objc);
                    continue;
                }
                objs = ResourceLookup.listObjects(configService, session, type, nObj);
                ObjectName objn = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                if (objn != null) {
                    if (result.contains(objn)) continue;
                    result.add(objn);
                    continue;
                }
                objs = ResourceLookup.listObjects(configService, session, type, cObj);
                ObjectName objc = ResourceLookup.searchObj(configService, session, objs, attribute, value);
                if (objc == null || result.contains(objn)) continue;
                result.add(objn);
            }
        }
        Object depl = null;
        List libs = null;
        try {
            AttributeList attrList = configService.getAttributes(session, app, new String[]{"deployedObject"}, false);
            ObjectName dobj = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "deployedObject");
            attrList = configService.getAttributes(session, dobj, new String[]{"classloader"}, false);
            ObjectName cl = (ObjectName)ConfigServiceHelper.getAttributeValue(attrList, "classloader");
            attrList = configService.getAttributes(session, cl, new String[]{"libraries"}, false);
            libs = (List)ConfigServiceHelper.getAttributeValue(attrList, "libraries");
        }
        catch (ConfigServiceException ex) {
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA00124E", new Object[]{appName, "ConfigServiceException"}));
        }
        catch (AttributeNotFoundException ex) {
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA00124E", new Object[]{appName, "AttributeNotFoundException"}));
        }
        catch (ConnectorException ex) {
            throw new AdminException(ex, AppUtils.getMessage(resBundle, "ADMA00124E", new Object[]{appName, "ConnectorException"}));
        }
        if (libs != null) {
            for (int i = 0; i < libs.size(); ++i) {
                ObjectName ll = (ObjectName)libs.get(i);
                if (result.contains(ll)) continue;
                result.add(ll);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertRefToConfigID returns " + result);
        }
        return result;
    }

    private static ObjectName searchObj(ConfigService configService, Session session, List objList, String attr, String value) {
        if (objList == null) {
            return null;
        }
        for (int j = 0; j < objList.size(); ++j) {
            ObjectName obj = (ObjectName)objList.get(j);
            String oo = null;
            try {
                oo = (String)configService.getAttribute(session, obj, attr);
            }
            catch (ConfigServiceException e1) {
                Tr.warning(tc, "ADMA0123W", new Object[]{attr, obj, e1});
            }
            catch (ConnectorException e1) {
                Tr.warning(tc, "ADMA0123W", new Object[]{attr, obj, e1});
            }
            if (oo == null || !oo.equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static List listObjects(ConfigService configService, Session session, String type, ObjectName scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list for type " + type + " in scope " + scope);
        }
        ArrayList objs = new ArrayList();
        ObjectName typeON = null;
        ObjectName scopeON = scope;
        Hashtable<String, String> table = new Hashtable<String, String>();
        ObjectName[] oList = null;
        table.put("_Websphere_Config_Data_Type", type);
        try {
            typeON = new ObjectName("WebSphere", table);
        }
        catch (MalformedObjectNameException ex) {
            Tr.event(tc, "Caught exception creating object name for " + type + "; exception: " + ex);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "About to call queryConfigObjects.");
        }
        try {
            oList = configService.queryConfigObjects(session, scopeON, typeON, null);
        }
        catch (ConfigServiceException e1) {
            Tr.debug(tc, "Problem in queryConfigObjects. scope = " + scopeON + " type= " + typeON + "Exception = " + e1);
        }
        catch (ConnectorException e1) {
            Tr.debug(tc, "Problem in queryConfigObjects. scope = " + scopeON + " type= " + typeON + "Exception = " + e1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "back from call to queryConfigObjects.");
        }
        ArrayList<ObjectName> newList = new ArrayList<ObjectName>();
        if (oList != null) {
            for (int i = 0; i < oList.length; ++i) {
                ConfigDataId id = ConfigServiceHelper.getConfigDataId(oList[i]);
                if (id.isResolved()) {
                    newList.add(oList[i]);
                    continue;
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Id is not resolved; need to make another call.");
                }
                ObjectName[] tList = null;
                try {
                    tList = configService.queryConfigObjects(session, null, oList[i], null);
                }
                catch (ConfigServiceException e) {
                    Tr.debug(tc, "Problem in queryConfigObjects. type= " + oList[i] + "Exception = " + e);
                }
                catch (ConnectorException e) {
                    Tr.debug(tc, "Problem in queryConfigObjects. type= " + oList[i] + "Exception = " + e);
                }
                if (tList == null || tList.length != 1) {
                    // empty if block
                }
                newList.add(tList[0]);
            }
        }
        oList = new ObjectName[newList.size()];
        oList = newList.toArray(oList);
        return newList;
    }
}

