/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.J2EEAppDeployment;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.j2ee.deploy.spi.exceptions.J2EEDeployTargetException;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class J2EEAppDeploymentImpl
extends RuntimeCollaborator
implements J2EEAppDeployment {
    private static TraceComponent tc = Tr.register(J2EEAppDeploymentImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static TraceNLS nls;
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;

    public J2EEAppDeploymentImpl(Hashtable tbl) {
        this._props = tbl;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Target[] getTargets(Hashtable prefs, String wID) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTargets");
        }
        WorkSpace ws = null;
        Target[] targets = null;
        try {
            try {
                ws = ConfigRepoHelper.getWorkSpace(wID);
                Hashtable serverList = this.getServers(ws);
                Hashtable targetTable = this.getClusters(serverList, ws);
                targets = new Target[targetTable.size()];
                if (!targetTable.isEmpty()) {
                    Iterator iter = targetTable.values().iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        targets[i] = (Target)iter.next();
                        ++i;
                    }
                }
                Object var10_11 = null;
            }
            catch (Exception e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getTargets", "133", this);
                ResourceBundle resBundle = AppUtils.getBundle(prefs);
                Object var10_12 = null;
                EditApplication.doFinally(ws, wID, null, false);
                if (!tc.isEntryEnabled()) return targets;
                Tr.exit(tc, "getTargets");
                return targets;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            EditApplication.doFinally(ws, wID, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getTargets");
            throw throwable;
        }
        EditApplication.doFinally(ws, wID, null, false);
        if (!tc.isEntryEnabled()) return targets;
        Tr.exit(tc, "getTargets");
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getServers(WorkSpace ws) throws Exception {
        Hashtable indexDocs;
        Object[] nodeContexts;
        String cellName;
        Hashtable<String, TargetImpl> servers;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServers");
            }
            servers = new Hashtable<String, TargetImpl>();
            cellName = AdminServiceFactory.getAdminService().getCellName();
            RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
            nodeContexts = AppUtils.getContextArray("nodes", cellC, ws);
            Vector<RepositoryContext> nodes = new Vector<RepositoryContext>();
            for (int i = 0; i < nodeContexts.length; ++i) {
                RepositoryContext nodeCtx = (RepositoryContext)nodeContexts[i];
                nodes.add(nodeCtx);
            }
            Enumeration nodeEnum = nodes.elements();
            indexDocs = ConfigRepoHelper.getServerIndexDocs(ws, nodeEnum);
            if (indexDocs != null) break block11;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            Hashtable<String, TargetImpl> hashtable = servers;
            Object var19_12 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServers");
            }
            return hashtable;
        }
        try {
            for (int i = 0; i < nodeContexts.length; ++i) {
                RepositoryContext nodeCtx = (RepositoryContext)nodeContexts[i];
                Resource serverIndex = (Resource)indexDocs.get(nodeCtx);
                ServerIndex top = (ServerIndex)serverIndex.getContents().get(0);
                EList entries = top.getServerEntries();
                ServerEntry server = null;
                Object serverName = null;
                for (int j = 0; j < entries.size(); ++j) {
                    server = (ServerEntry)entries.get(j);
                    if (!server.getServerType().equals("APPLICATION_SERVER")) continue;
                    TargetImpl target = new TargetImpl(server.getServerName(), nodeCtx.getName(), cellName, server.getServerDisplayName(), false);
                    target.setNode(nodeCtx.getName());
                    target.setCell(cellName);
                    target.setCluster(false);
                    servers.put(server.getServerName() + "," + nodeCtx.getName(), target);
                }
            }
            Object var19_13 = null;
        }
        catch (Throwable throwable) {
            Object var19_14 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServers");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServers");
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getClusters(Hashtable servers, WorkSpace ws) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusters");
        }
        try {
            String cellName = AdminServiceFactory.getAdminService().getCellName();
            RepositoryMetaData metaData = RepositoryMetaDataFactory.getRepositoryMetaData();
            Collection clustersContext = ws.findContext(metaData.getContextType("clusters"));
            RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
            Object[] clusterContexts = AppUtils.getContextArray("clusters", cellC, ws);
            if (clustersContext != null) {
                Iterator iter = clustersContext.iterator();
                int index = 0;
                String nn = cellName + "/clusters/";
                while (iter.hasNext()) {
                    RepositoryContext clusterCtx = (RepositoryContext)iter.next();
                    index = clusterCtx.getURI().indexOf(nn);
                    if (index < 0) continue;
                    String clusterName = clusterCtx.getURI().substring(index + nn.length());
                    if (clusterName.indexOf("/") > 0) {
                        clusterName = clusterName.substring(0, clusterName.indexOf("/"));
                    }
                    URI uri = URI.createURI("cluster.xml");
                    Resource res = clusterCtx.getResourceSet().getResource(uri, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for cluster " + clusterCtx + " SI doc res: " + res);
                    }
                    TargetImpl target = new TargetImpl(clusterName, null, cellName, clusterName, true);
                    servers.put(clusterName, target);
                    ServerCluster cluster = (ServerCluster)res.getContents().get(0);
                    EList members = cluster.getMembers();
                    ClusterMember server = null;
                    Object serverName = null;
                    for (int i = 0; i < members.size(); ++i) {
                        server = (ClusterMember)members.get(i);
                        servers.remove(server.getMemberName() + "," + server.getNodeName());
                    }
                }
            }
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusters");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusters");
        }
        return servers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TargetModuleID[] getRunningModules(String type, Target[] targetList, Hashtable prefs, String wsId) throws TargetException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningModules");
        }
        Vector moduleIds = new Vector();
        Object[] targetMods = null;
        WorkSpace ws = null;
        try {
            block10: {
                try {
                    ws = ConfigRepoHelper.getWorkSpace(wsId);
                    String cellName = AdminServiceFactory.getAdminService().getCellName();
                    RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
                    Vector validTargets = this.getValidTargetList(cellC, ws, (Locale)prefs.get("app.client.locale"), targetList);
                    if (validTargets == null || validTargets.size() <= 0) break block10;
                    for (int i = 0; i < targetList.length; ++i) {
                        moduleIds = this.getRunningApplications(moduleIds, targetList[i], ws, cellC, cellName, prefs);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "All running: " + moduleIds);
                    }
                    Vector v = new Vector();
                    for (int i = 0; i < moduleIds.size(); ++i) {
                        if (!type.equals(((TargetModuleIDImpl)moduleIds.elementAt(i)).getModuleType())) continue;
                        v.add(moduleIds.elementAt(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Filtered list: " + v);
                    }
                    targetMods = new TargetModuleID[v.size()];
                    v.copyInto(targetMods);
                }
                catch (TargetException te) {
                    throw te;
                }
                catch (Exception e) {
                    RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getRunningModules", "395", this);
                    throw new J2EEDeployTargetException(e.getMessage(), e);
                }
            }
            Object var14_16 = null;
            EditApplication.doFinally(ws, wsId, null, false);
            if (!tc.isEntryEnabled()) return targetMods;
            Tr.exit(tc, "getRunningModules");
            return targetMods;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            EditApplication.doFinally(ws, wsId, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getRunningModules");
            throw throwable;
        }
    }

    private Vector getRunningApplications(Vector moduleIds, Target target, WorkSpace ws, RepositoryContext cellC, String cellName, Hashtable prefs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningApplications");
        }
        ObjectName on = null;
        String node = null;
        String server = null;
        try {
            if (!((TargetImpl)target).isCluster()) {
                node = ((TargetImpl)target).getNode();
                server = ((TargetImpl)target).getServerName();
            } else {
                RepositoryContext rc = this.getFirstClusterMember((TargetImpl)target, ws, cellC, cellName);
                node = rc.getParent().getName();
                server = rc.getName();
            }
            Iterator itr = this.queryObjects("type=Application,node=" + node + ",Server=" + server + ",*");
            while (itr.hasNext()) {
                String aName;
                String mType;
                on = (ObjectName)itr.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Application: " + on);
                }
                if ((mType = this.getModuleTypeFromContext(aName = on.getKeyProperty("name"), ws, prefs)) == null) continue;
                TargetModuleIDImpl targetMod = J2EEAppDeploymentImpl.createTargetMod(aName, mType, target, null);
                targetMod.setStartable(true);
                targetMod.setChildTargetModuleID(this.getRunningChildren(targetMod, on, node, server));
                moduleIds.add(targetMod);
            }
        }
        catch (Throwable th) {
            Tr.warning(tc, "Can not find modules using: " + on + " exception is: " + th);
            RasUtils.logException(th, tc, CLASS_NAME, "getRunning", "466", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningApplications");
        }
        return moduleIds;
    }

    private String getModuleTypeFromContext(String appName, WorkSpace ws, Hashtable prefs) {
        String type = null;
        try {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(appName, ws, prefs);
            if (rc != null) {
                type = rc.isAvailable("META-INF/was.webmodule") ? "WebModule" : (rc.isAvailable("META-INF/was.ejbmodule") ? "EJBModule" : "Application");
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no context for " + appName + ", hence system app");
            }
        }
        catch (Exception e) {
            RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getModuleTypeFromContext", "497", this);
        }
        return type;
    }

    private Iterator queryObjects(String query) throws MalformedObjectNameException {
        ObjectName on = null;
        on = new ObjectName("WebSphere:" + query);
        return AdminServiceFactory.getAdminService().queryNames(on, null).iterator();
    }

    private TargetModuleID[] getRunningChildren(TargetModuleID parentTargetModule, ObjectName parent, String node, String server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunningChildren");
        }
        Object[] allChildren = null;
        Vector children = new Vector();
        String query = "*,type=WebModule,node=" + node + ",Server=" + server + ",Application=" + parent.getKeyProperty("name");
        children = this.queryRunningChildren(children, query, parentTargetModule, parentTargetModule.getTarget());
        query = "*,type=EJBModule,node=" + node + ",Server=" + server + ",Application=" + parent.getKeyProperty("name");
        if ((children = this.queryRunningChildren(children, query, parentTargetModule, parentTargetModule.getTarget())).size() > 0) {
            allChildren = new TargetModuleID[children.size()];
            children.copyInto(allChildren);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunningChildren");
        }
        return allChildren;
    }

    private Vector queryRunningChildren(Vector children, String query, TargetModuleID parentTargetModule, Target target) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryRunningChildren");
        }
        Iterator childIter = this.queryObjects(query);
        ObjectName on = null;
        TargetModuleIDImpl cTargetMod = null;
        while (childIter.hasNext()) {
            on = (ObjectName)childIter.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "child module: " + on);
            }
            cTargetMod = J2EEAppDeploymentImpl.createTargetMod(on.getKeyProperty("name"), on.getKeyProperty("type"), target, parentTargetModule);
            children.add(cTargetMod);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryRunningChildren");
        }
        return children;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TargetModuleID[] getNonRunningModules(String type, Target[] targetList, Hashtable prefs, String wsId) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonRunningModules");
        }
        TargetModuleID[] availableModules = this.getAvailableModulesOnServers(type, targetList, prefs, wsId, false);
        Object[] nonRunningModules = null;
        Vector<TargetModuleIDImpl> nonRunningV = new Vector<TargetModuleIDImpl>();
        TargetModuleIDImpl mod = null;
        WorkSpace ws = null;
        try {
            try {
                String cellName = AdminServiceFactory.getAdminService().getCellName();
                ws = ConfigRepoHelper.getWorkSpace(wsId);
                RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
                ObjectName on = null;
                for (int i = 0; i < availableModules.length; ++i) {
                    Set s;
                    mod = (TargetModuleIDImpl)availableModules[i];
                    on = this.getAppObjectName(ws, cellC, cellName, mod);
                    if (on == null || !(s = AdminServiceFactory.getAdminService().queryNames(on, null)).isEmpty()) continue;
                    nonRunningV.add(mod);
                }
                nonRunningModules = new TargetModuleID[nonRunningV.size()];
                nonRunningV.copyInto(nonRunningModules);
            }
            catch (Exception e) {
                throw new AdminException(e);
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            EditApplication.doFinally(ws, wsId, null, false);
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "getNonRunningModules");
            throw throwable;
        }
        EditApplication.doFinally(ws, wsId, null, false);
        if (!tc.isEntryEnabled()) return nonRunningModules;
        Tr.exit(tc, "getNonRunningModules");
        return nonRunningModules;
    }

    private ObjectName getAppObjectName(WorkSpace ws, RepositoryContext cellC, String cellName, TargetModuleIDImpl mod) throws Exception {
        ObjectName on = null;
        TargetImpl target = (TargetImpl)mod.getTarget();
        if (target.isCluster()) {
            RepositoryContext serverRC = this.getFirstClusterMember(target, ws, cellC, cellName);
            if (serverRC != null) {
                on = mod.getObjectName();
                Hashtable propertyList = on.getKeyPropertyList();
                propertyList.remove("cluster");
                propertyList.put("Server", serverRC.getName());
                propertyList.put("node", serverRC.getParent().getName());
                on = new ObjectName("WebSphere", propertyList);
                on = new ObjectName(on.getCanonicalName() + ",*");
            }
        } else {
            on = mod.getObjectName();
        }
        return on;
    }

    private ObjectName convertServerAppToClusterApp(ObjectName on, TargetImpl target) throws Exception {
        Hashtable propertyList = on.getKeyPropertyList();
        propertyList.remove("process");
        propertyList.remove("Server");
        propertyList.remove("node");
        propertyList.put("cluster", target.getServerName());
        ObjectName newON = new ObjectName("WebSphere", propertyList);
        newON = new ObjectName(newON.getCanonicalName() + ",*");
        return newON;
    }

    private RepositoryContext getFirstClusterMember(TargetImpl target, WorkSpace ws, RepositoryContext cellC, String cellName) throws Exception {
        RepositoryContext serverRC = null;
        RepositoryContext clusterRC = AppUtils.findContext("clusters", target.getServerName(), cellName, cellC, ws, true);
        if (clusterRC != null) {
            Vector<RepositoryContext> v = new Vector<RepositoryContext>();
            v.add(clusterRC);
            Vector vServer = ConfigRepoHelper.getAllServers(ws, v);
            if (vServer != null) {
                serverRC = (RepositoryContext)vServer.firstElement();
            }
        }
        return serverRC;
    }

    public TargetModuleID[] getAvailableModules(String type, Target[] targetList, Hashtable prefs, String wsId) throws TargetException, AdminException {
        return this.getAvailableModulesOnServers(type, targetList, prefs, wsId, true);
    }

    /*
     * Loose catch block
     */
    private TargetModuleID[] getAvailableModulesOnServers(String type, Target[] targetList, Hashtable prefs, String wsId, boolean returnClusters) throws TargetException, AdminException {
        TargetModuleID[] targetMods;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAvailableModulesOnServers");
            }
            targetMods = null;
            Vector<TargetModuleIDImpl> targetModules = new Vector<TargetModuleIDImpl>();
            WorkSpace ws = null;
            try {
                block17: {
                    int i;
                    ws = ConfigRepoHelper.getWorkSpace(wsId);
                    String cellName = AdminServiceFactory.getAdminService().getCellName();
                    RepositoryContext cellC = AppUtils.findContext("cells", cellName, null, null, ws, true);
                    Vector targetRC = this.getValidTargetList(cellC, ws, (Locale)prefs.get("app.client.locale"), targetList);
                    if (targetRC == null || targetRC.size() <= 0) break block17;
                    RepositoryContext thisRC = null;
                    RepositoryContext nodeCtx = null;
                    String nodeName = null;
                    TargetImpl thisTarget = null;
                    Vector vServer = null;
                    Vector<RepositoryContext> vCluster = new Vector<RepositoryContext>();
                    Hashtable<RepositoryContext, Target> clusterMap = new Hashtable<RepositoryContext, Target>();
                    Vector<RepositoryContext> allServers = new Vector<RepositoryContext>();
                    for (int iTarg = 0; iTarg < targetRC.size(); ++iTarg) {
                        thisRC = (RepositoryContext)targetRC.elementAt(iTarg);
                        if (thisRC.getType().getName().equals("clusters")) {
                            vCluster.clear();
                            vCluster.add(thisRC);
                            vServer = ConfigRepoHelper.getAllServers(ws, vCluster);
                            if (vServer != null && vServer.size() > 0) {
                                thisRC = (RepositoryContext)vServer.firstElement();
                            }
                        }
                        if (thisRC == null) continue;
                        allServers.add(thisRC);
                        clusterMap.put(thisRC, targetList[iTarg]);
                    }
                    Hashtable uniqueClusterMaps = new Hashtable();
                    Vector uniqueNodes = this.getUniqueNodes(allServers);
                    RepositoryContext thisNode = null;
                    for (i = 0; i < uniqueNodes.size(); ++i) {
                        thisNode = (RepositoryContext)uniqueNodes.elementAt(i);
                        nodeCtx = thisNode.getParent();
                        nodeName = nodeCtx.getName();
                        URI uri = URI.createURI("serverindex.xml");
                        Resource res = nodeCtx.getResourceSet().getResource(uri, true);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found for node " + nodeCtx + " SI doc res: " + res);
                        }
                        ServerIndex si = (ServerIndex)res.getContents().get(0);
                        EList serverList = si.getServerEntries();
                        ServerEntry server = null;
                        TargetModuleIDImpl targetMod = null;
                        for (int j = 0; j < serverList.size(); ++j) {
                            server = (ServerEntry)serverList.get(j);
                            thisRC = this.isServerIncluded(allServers, server.getServerName(), nodeName);
                            if (!server.getServerType().equals("APPLICATION_SERVER") || thisRC == null) continue;
                            thisTarget = (TargetImpl)clusterMap.get(thisRC);
                            EList deployedApps = server.getDeployedApplications();
                            for (int k = 0; k < deployedApps.size(); ++k) {
                                String deploymentName = (String)deployedApps.get(k);
                                String appName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                                String contextName = deploymentName.substring(deploymentName.indexOf("/"));
                                Object clusterAppMap = null;
                                boolean includeIt = false;
                                String mType = this.getModuleTypeFromContext(appName, ws, prefs);
                                if (mType == null || !type.equals(mType)) continue;
                                targetMod = J2EEAppDeploymentImpl.createTargetMod(appName, mType, thisTarget, null);
                                targetMod.setChildTargetModuleID(this.getAvailableChildren(appName, targetMod, prefs, ws.getUserName()));
                                targetMod.setStartable(this.isStartable(targetMod));
                                targetModules.add(targetMod);
                            }
                        }
                    }
                    if (targetModules.size() > 0) {
                        targetMods = new TargetModuleID[targetModules.size()];
                        for (i = 0; i < targetModules.size(); ++i) {
                            targetMods[i] = (TargetModuleID)targetModules.elementAt(i);
                        }
                        break block17;
                    }
                    targetMods = new TargetModuleID[]{};
                }
                Object var40_42 = null;
            }
            catch (Throwable throwable) {
                Object var40_43 = null;
                EditApplication.doFinally(ws, wsId, null, false);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAvailableModulesOnServers");
                }
                throw throwable;
            }
            EditApplication.doFinally(ws, wsId, null, false);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableModulesOnServers");
            }
            break block18;
            {
                catch (TargetException te) {
                    throw te;
                }
                catch (Exception e) {
                    RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getAvailableModulesOnServers", "939", this);
                    throw new AdminException(e);
                }
            }
        }
        return targetMods;
    }

    private Vector getUniqueNodes(Vector allServers) {
        Hashtable<String, RepositoryContext> nodes = new Hashtable<String, RepositoryContext>();
        RepositoryContext rc = null;
        for (int i = 0; i < allServers.size(); ++i) {
            rc = (RepositoryContext)allServers.elementAt(i);
            nodes.put(rc.getParent().getName(), rc);
        }
        Vector uniqueNodes = new Vector();
        Enumeration n = nodes.elements();
        while (n.hasMoreElements()) {
            uniqueNodes.add(n.nextElement());
        }
        return uniqueNodes;
    }

    private RepositoryContext isServerIncluded(Vector allServers, String servername, String nodeName) {
        RepositoryContext rc = null;
        for (int i = 0; i < allServers.size(); ++i) {
            rc = (RepositoryContext)allServers.elementAt(i);
            if (!rc.getName().equals(servername) || !rc.getParent().getName().equals(nodeName)) continue;
            return rc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableChildren(String appName, TargetModuleID parent, Hashtable prefs, String wsID) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren");
        }
        Vector targetModules = new Vector();
        TargetModuleID[] targetMods = null;
        try {
            EditApplication edit = new EditApplication(appName, prefs, null, wsID, null);
            AppDeploymentTask t = edit.listModules();
            String[][] td = t.getTaskData();
            String displayName = null;
            String uniqueModuleName = null;
            if (td.length > 0) {
                targetMods = new TargetModuleID[td.length - 1];
                for (int i = 1; i < td.length; ++i) {
                    displayName = td[i][0];
                    uniqueModuleName = td[i][1];
                    uniqueModuleName = util.getModuleURIFromUniqueName(uniqueModuleName);
                    String type = this.getModuleType(uniqueModuleName);
                    String id = td[i][2];
                    try {
                        TargetModuleIDImpl targetMod = J2EEAppDeploymentImpl.createTargetMod(uniqueModuleName, type, parent.getTarget(), parent);
                        targetMods[i - 1] = targetMod;
                        continue;
                    }
                    catch (Throwable th) {
                        throw new AdminException(th, "Unknown exception");
                    }
                }
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableModules");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableModules");
        }
        return targetMods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableChildren(AppManagement appM, String appName, TargetModuleID parent, Hashtable prefs, String wsID) throws TargetException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAvailableChildren");
        }
        TargetModuleID[] targetMods = null;
        try {
            AppDeploymentTask t = (AppDeploymentTask)appM.listModules(appName, prefs, wsID);
            String[][] td = t.getTaskData();
            String displayName = null;
            String uniqueModuleName = null;
            if (td.length > 0) {
                targetMods = new TargetModuleID[td.length - 1];
                for (int i = 1; i < td.length; ++i) {
                    displayName = td[i][0];
                    uniqueModuleName = td[i][1];
                    uniqueModuleName = util.getModuleURIFromUniqueName(uniqueModuleName);
                    String type = this.getModuleType(uniqueModuleName);
                    String id = td[i][2];
                    try {
                        TargetModuleIDImpl targetMod = J2EEAppDeploymentImpl.createTargetMod(uniqueModuleName, type, parent.getTarget(), parent);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "targetMod: " + targetMod);
                        }
                        targetMods[i - 1] = targetMod;
                        continue;
                    }
                    catch (Throwable th) {
                        throw new AdminException(th, "Unknown exception");
                    }
                }
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAvailableChildren");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAvailableChildren");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "targetModID list: " + targetMods);
            if (targetMods != null) {
                for (int i = 0; i < targetMods.length; ++i) {
                    Tr.debug(tc, "availableChildren[" + i + "]" + targetMods[i]);
                }
            }
        }
        return targetMods;
    }

    private boolean isStartable(TargetModuleIDImpl targetMod) {
        boolean startable = false;
        TargetModuleID[] children = targetMod.getChildTargetModuleID();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                TargetModuleIDImpl child = (TargetModuleIDImpl)children[i];
                if (!child.getModuleType().equals("EJBModule") && !child.getModuleType().equals("WebModule")) continue;
                startable = true;
                break;
            }
        }
        return startable;
    }

    private Target isThisServerATarget(ServerEntry server, String node, Target[] targetList) {
        for (int i = 0; i < targetList.length; ++i) {
            if (!node.equals(((TargetImpl)targetList[i]).getNode()) || !server.getServerName().equals(((TargetImpl)targetList[i]).getServerName())) continue;
            return targetList[i];
        }
        return null;
    }

    private String getModuleType(String name) {
        String type = null;
        type = name.indexOf(".jar") >= 0 ? "EJBModule" : (name.indexOf(".war") >= 0 ? "WebModule" : (name.indexOf(".rar") >= 0 ? "RARModule" : "Unknown"));
        return type;
    }

    private Vector getValidTargetList(RepositoryContext cellC, WorkSpace ws, Locale locale, Target[] targets) throws TargetException {
        boolean isValid = true;
        Object rc = null;
        Exception e = null;
        Vector<RepositoryContext> targetRC = new Vector<RepositoryContext>();
        for (int i = 0; i < targets.length; ++i) {
            TargetImpl target = (TargetImpl)targets[i];
            String nodeName = target.getNode();
            String serverName = target.getServerName();
            boolean found = true;
            try {
                RepositoryContext clContext;
                if (target.isCluster()) {
                    Object[] clusterContextArray = null;
                    if (clusterContextArray == null) {
                        clusterContextArray = AppUtils.getContextArray("clusters", cellC, ws);
                    }
                    if (clusterContextArray != null && clusterContextArray.length > 0) {
                        clContext = AppUtils.getContextFromArray(clusterContextArray, serverName, null, false);
                        if (clContext == null) {
                            found = false;
                        } else {
                            targetRC.add(clContext);
                        }
                    } else {
                        found = false;
                    }
                } else {
                    Object[] serverContextArray = null;
                    if (serverContextArray == null) {
                        serverContextArray = AppUtils.getContextArray("servers", cellC, ws);
                    }
                    if (serverContextArray != null && serverContextArray.length > 0) {
                        clContext = AppUtils.getContextFromArray(serverContextArray, serverName, nodeName, false);
                        if (clContext == null) {
                            found = false;
                        } else {
                            targetRC.add(clContext);
                        }
                    } else {
                        found = false;
                    }
                }
            }
            catch (Exception e1) {
                found = false;
                e = e1;
            }
            if (found) continue;
            if (target.isCluster()) {
                throw new J2EEDeployTargetException(AppUtils.getMessage(AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", locale), "ADMJ1026E", new Object[]{serverName}), e);
            }
            throw new J2EEDeployTargetException(AppUtils.getMessage(AppUtils.getBundle("com.ibm.ws.management.resources.J2eeDeploymentMessages", locale), "ADMJ1008E", new Object[]{serverName, nodeName}), e);
        }
        return targetRC;
    }

    public static TargetModuleIDImpl createTargetMod(String name, String type, Target target, TargetModuleID parent) throws Exception {
        return AppDeploymentUtil.createTargetMod(name, type, target, parent);
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/J2EEAppDeploymentImpl.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.10");
        }
        CLASS_NAME = J2EEAppDeploymentImpl.class.getName();
        nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
        seqNum = 0L;
    }
}

