/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.DistributionStatusTask;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class DistributionStatusSchedulerImpl
extends SchedulerImpl {
    private static TraceComponent tc = Tr.register(DistributionStatusSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    List _nodes;
    String _compStatus = null;

    public DistributionStatusSchedulerImpl(String aName, Hashtable tbl, AppManagement appM, AppNotification.Listener notf) {
        super(aName, tbl, appM, notf);
        this.appTaskName = "AppDistribution";
    }

    protected void setupTasks() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupTasks");
        }
        if (this.appName == null) {
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0016E"));
        }
        if (AppManagementImpl.isLocalMode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local mode: no-op");
            }
            throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0090E", new Object[]{"getDistributionStatus"}));
        }
        try {
            RepositoryContext rc = AppUtils.findAppContextFromConfig(this.appName, this.getWorkSpace(), this.getProperties());
            if (rc == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA0017E", new Object[]{this.appName}));
            }
            ApplicationDeployment appDepl = ConfigRepoHelper.getAppDeploymentForApp(rc);
            Vector not = new Vector();
            Vector v = ConfigRepoHelper.getServersForAppDeployment(appDepl, not, this.getCellContext(), this.getWorkSpace(), false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App targets : " + v);
            }
            if (not.size() > 0 && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not found : " + not);
            }
            Hashtable tbl = ConfigRepoHelper.getNodeServerRelation(this.getWorkSpace(), v);
            this._nodes = new ArrayList();
            Enumeration en = tbl.keys();
            while (en.hasMoreElements()) {
                this._nodes.add(((RepositoryContext)en.nextElement()).getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nodes are: " + this._nodes);
            }
        }
        catch (Throwable th) {
            RasUtils.logException(th, tc, CLASS_NAME, "setupTasks", "123", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in setupTasks: " + th);
            }
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th, th.getMessage());
        }
        this.tasks = new Vector();
        this.tasks.addElement(new DistributionStatusTask());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The tasks are: " + this.tasks);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupTasks");
        }
    }

    protected AppNotification createCompletionEvent(boolean bSuccess) {
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, "ADMA5072I", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("AppDistributionNode", "", bSuccess ? "Completed" : "Failed", "", msg);
        Properties props = new Properties();
        if (this._compStatus != null) {
            props.put("AppDistributionAll", this._compStatus);
        }
        notf.setProperties(props);
        return notf;
    }

    protected AppNotification createStartEvent() {
        String msg = "";
        if (this.resBundle != null) {
            msg = AppUtils.getMessage(this.resBundle, "ADMA5071I", new String[]{this.appName});
        }
        AppNotification notf = new AppNotification("AppDistributionNode", "", "InProgress", "", msg);
        return notf;
    }

    protected void performCleanup(boolean bSuccess) throws Exception {
    }

    public List get_nodes() {
        return this._nodes;
    }

    public String addCompStatus(String s) {
        this._compStatus = AppUtils.isEmpty(this._compStatus) ? s : this._compStatus + "+" + s;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "comp status: " + this._compStatus);
        }
        return this._compStatus;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/DistributionStatusSchedulerImpl.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.4");
        }
        CLASS_NAME = DistributionStatusSchedulerImpl.class.getName();
    }
}

