/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.SchedulerImpl;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.util.RasUtils;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveSchedulerImpl
extends SchedulerImpl {
    private static final TraceComponent tc = Tr.register(ArchiveSchedulerImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected final String _origPathToContent;
    protected String _pathToContent = null;
    protected String _contentType = "app";
    private Archive _archive = null;
    private boolean _removeLooseMapping = false;
    private boolean _appEntitled = false;

    public ArchiveSchedulerImpl(String path, String appName, Hashtable<String, ?> options, AppManagement appManagement, AppNotification.Listener notificationListener) {
        super(appName, options, appManagement, notificationListener);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new String[]{"path=" + path, "appName=" + appName, "options=" + options, "appManagement=" + appManagement, "notificationListener=" + notificationListener});
        }
        this._origPathToContent = path;
        this._pathToContent = path;
        Object looseConfigProperty = this.properties.get("was.loose.config");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "looseConfigProperty=" + looseConfigProperty);
        }
        if (looseConfigProperty instanceof String) {
            LooseConfigRegister looseConfigRegister = LooseConfigRegister.singleton();
            looseConfigRegister.addLooseMapping(this._origPathToContent, (String)looseConfigProperty);
            this._removeLooseMapping = true;
        }
        Object zeroBinaryCopy = this.properties.get("zeroBinaryCopy");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", "zeroBinaryCopy=" + zeroBinaryCopy);
        }
        if (zeroBinaryCopy instanceof String) {
            this.properties.put("zeroBinaryCopy", Boolean.valueOf((String)zeroBinaryCopy));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected String getArchivePath() {
        return this._pathToContent;
    }

    protected void setArchivePath(String path) throws AdminException {
        this.setArchivePath(path, true);
    }

    protected void setArchivePath(String path, boolean close) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setArchivePath", new String[]{"path=" + path, "close=" + close});
        }
        this._pathToContent = path;
        if (this._archive != null && close) {
            try {
                this.closeArchive();
            }
            catch (Throwable t) {
                RasUtils.logException(t, tc, CLASS_NAME, "setArchivePath", "152", this);
                AdminException adminException = null;
                if (this.resBundle != null) {
                    String message = AppUtils.getMessage(this.resBundle, "ADMA0053E", new Object[]{this._pathToContent});
                    adminException = new AdminException(t, message);
                } else {
                    adminException = new AdminException(t);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setArchivePath", adminException);
                }
                throw adminException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setArchivePath");
        }
    }

    protected Archive getArchive() throws AdminException {
        return this.getArchive(false, false);
    }

    protected Archive getArchive(boolean useReflection, boolean readOnly) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getArchive", new String[]{"useReflection=" + useReflection, "readOnly=" + readOnly});
        }
        boolean reopen = false;
        if (this._archive != null) {
            ArchiveOptions archiveOptions = this._archive.getOptions();
            boolean bl = reopen = archiveOptions.isReadOnly() && !readOnly || !archiveOptions.useJavaReflection() && useReflection;
            if (reopen) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getArchive", new Object[]{"reopen required", new Throwable()});
                }
                this.closeArchive();
            }
        }
        if (this._archive == null) {
            try {
                if (!reopen) {
                    this.checkIfAppEntitled();
                }
                boolean ear = this._contentType.equals("app");
                this._archive = AppInstallHelper.getArchive(this._pathToContent, true, readOnly, this.resBundle, ear);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getArchive", "opened archive " + this._archive.getURI());
                }
            }
            catch (AppDeploymentException e) {
                RasUtils.logException((Throwable)e, tc, CLASS_NAME, "getArchive", "224", this);
                AdminException adminException = new AdminException(e.getEmbeddedEx(), e.getMessage());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getArchive", adminException);
                }
                throw adminException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getArchive", this._archive);
        }
        return this._archive;
    }

    @Override
    protected void performCleanup(boolean success) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performCleanup", "success=" + success);
        }
        this.closeArchive();
        Object deleteSourceEar = this.getProperties().get("DeleteSourceEar");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "performCleanup", "deleteSourceEar=" + deleteSourceEar);
        }
        if (Boolean.TRUE.equals(deleteSourceEar)) {
            File file = new File(this._origPathToContent);
            boolean deleted = file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performCleanup", "delete original file " + this._origPathToContent + "; deleted=" + deleted);
            }
        }
        if (this.setupDone) {
            String tempDirectory = AppUtils.getAppTempDir(this);
            if (tc.isDebugEnabled()) {
                String message = AppUtils.getMessage(this.resBundle, "ADMA6011I", new Object[]{tempDirectory});
                Tr.debug(tc, "performCleanup", message);
            }
            AppUtils.deleteDirTree(tempDirectory);
        }
        if (this._removeLooseMapping) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performCleanup", "removing loose mapping for " + this._origPathToContent);
            }
            LooseConfigRegister looseConfigRegister = LooseConfigRegister.singleton();
            looseConfigRegister.removeLooseMapping(this._origPathToContent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performCleanup");
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_origPathToContent=");
        stringBuilder.append(this._origPathToContent);
        stringBuilder.append(", _pathToContent=");
        stringBuilder.append(this._pathToContent);
        stringBuilder.append(", _contentType=");
        stringBuilder.append(this._contentType);
        stringBuilder.append(", _archive=");
        stringBuilder.append(this._archive);
        stringBuilder.append(", _removeLooseMapping=");
        stringBuilder.append(this._removeLooseMapping);
        stringBuilder.append(", _appEntitled=");
        stringBuilder.append(this._appEntitled);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void checkIfAppEntitled() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfAppEntitled");
        }
        if (!this._appEntitled && AppUtils.isEntitled() && !new File(this._pathToContent).isDirectory()) {
            if (!AppUtils.isAppEntitled(this._pathToContent)) {
                Tr.error(tc, "ADMA9006E", new Object[]{this._pathToContent, AppUtils.getProductName()});
                AppDeploymentException e = new AppDeploymentException("This application is not licensed to be installed in this server", null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getArchive", e.toString());
                }
                throw e;
            }
            this._appEntitled = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfAppEntitled");
        }
    }

    private void closeArchive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeArchive");
        }
        if (this._archive != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "closeArchive", "closing archive " + this._archive.getURI());
            }
            this._archive.close();
            this._archive = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeArchive");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/ArchiveSchedulerImpl.java, WAS.admin.installapp.server, WAS70.SERV1, q0834.18, ver. 1.6.1.4");
        }
        CLASS_NAME = ArchiveSchedulerImpl.class.getName();
    }
}

