/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.util.RasUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;

public abstract class AppUpdate {
    private static TraceComponent tc = Tr.register(AppUpdate.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    protected Locale locale;
    protected ResourceBundle bundle;
    protected static final String ADD = "add";
    protected static final String DELETE = "delete";
    protected static final String UPDATE = "update";
    protected static final String ADDUPDATE = "addupdate";
    private static final String defaultBundleName = "com.ibm.ws.management.resources.AppDeploymentMessages";
    private List _deleted = new ArrayList();
    private List _added = new ArrayList();
    private List _updated = new ArrayList();
    private boolean _syncMode = false;
    protected static List ddFiles;

    public AppUpdate() {
        this._deleted = new ArrayList();
    }

    public abstract List getURIs();

    public abstract InputStream getContentAsInputStream(String var1);

    public List getDeletedList() {
        return this._deleted;
    }

    public void setLists(List d, List a, List u) {
        this._deleted = d;
        this._added = a;
        this._updated = u;
    }

    public void setSyncMode(boolean isSyncMode) {
        this._syncMode = isSyncMode;
    }

    public void mergeFiles(String operation, String srcPath, String destPath) throws Exception {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeFiles");
        }
        ArrayList collapseArchives = new ArrayList();
        List l = this.getURIs();
        for (i = 0; i < l.size(); ++i) {
            this.createDirsInPath(destPath, (String)l.get(i), collapseArchives);
            this.performFileOperation(srcPath, destPath, (String)l.get(i), this._deleted, operation);
        }
        AppUtils.dbg(tc, "Collapse list is: " + collapseArchives);
        for (i = 0; i < collapseArchives.size(); ++i) {
            Archive a = AppInstallHelper.getArchive((String)collapseArchives.get(i), false, true, this.getResourceBundle(), false);
            a.saveNoReopen();
            a.close();
            a = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeFiles");
        }
    }

    private void createDirsInPath(String mergeRoot, String uri, List collapse) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDirsInPath " + uri);
        }
        String currDir = mergeRoot;
        String[] dirs = uri.split("/");
        String currRelativePath = "";
        for (int i = 0; i < dirs.length - 1; ++i) {
            String nextDirPath;
            block12: {
                nextDirPath = "/" + dirs[i];
                File f = new File(currDir + nextDirPath);
                if (!f.exists()) {
                    return;
                }
                currRelativePath = currRelativePath + (i == 0 ? dirs[0] : nextDirPath);
                if (!f.isDirectory()) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expanding archive at " + f.getPath());
                        }
                        Archive arch = AppInstallHelper.getArchive(f.getPath(), false, true, this.getResourceBundle(), false);
                        arch.extract(0);
                        arch.close();
                        arch = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "archURI: " + currRelativePath);
                        }
                        if (this.addToCollapse(currRelativePath)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Need to collapse archURI: " + currRelativePath);
                            }
                            collapse.add(f.getPath());
                        }
                    }
                    catch (AppDeploymentException e) {
                        Throwable rootCause = e.getEmbeddedEx();
                        if (!(rootCause instanceof OpenFailureException)) break block12;
                        RasUtils.logException((Throwable)e, tc, CLASS_NAME, "createDirsInPath", "209", this);
                        AdminException ae = new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0197E", new Object[]{uri, currRelativePath}));
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "createDirsInPath: Exception:", ae);
                        }
                        throw ae;
                    }
                }
            }
            currDir = currDir + nextDirPath;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDirsInPath " + uri);
        }
    }

    private void performFileOperation(String source, String dest, String uri, List deleted, String op) throws Exception {
        AppUtils.dbg(tc, "performFileOperation: source=" + source + ", dest=" + dest + ", uri= " + uri + ", op= " + op);
        if (this.doDeletes(source, dest, uri, op, deleted)) {
            return;
        }
        File d = new File(dest + "/" + uri);
        if (!this._syncMode) {
            if (op.equals(ADD) && d.exists()) {
                throw new AdminException("File URI " + uri + " already exists so add operation failed.");
            }
            if (op.equals(UPDATE) && !d.exists()) {
                throw new AdminException("File URI " + uri + " does not exist.  Update operation failed.");
            }
        }
        InputStream in = this.getContentAsInputStream(uri);
        if (!op.equals(DELETE)) {
            if (d.exists()) {
                this._updated.add(uri);
                if (d.isDirectory()) {
                    AppUtils.deleteDirTree(d, false);
                }
            } else {
                this._added.add(uri);
            }
            AppUtils.dbg(tc, "Copying file from " + source + "/" + uri + " to " + d.getPath());
            AppUtils.copyFile(in, d.getPath());
        }
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDeletes(String source, String dest, String uri, String op, List deleted) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "doDeletes");
        }
        String archiveURI = null;
        String delPattern = "";
        if (uri.endsWith("META-INF/ibm-partialapp-delete.props")) {
            String delDir;
            block21: {
                AppUtils.dbg(tc, "Processing delete from : " + uri);
                archiveURI = this.getPropFileArchiveURI(uri);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting files under archive path: " + archiveURI);
                }
                delDir = dest + "/" + archiveURI;
                BufferedReader in = null;
                try {
                    Object var12_13;
                    try {
                        String delFile = null;
                        in = new BufferedReader(new FileReader(source + "/" + uri));
                        while ((delFile = in.readLine()) != null) {
                            if (this.validateDelFile(delFile)) {
                                delPattern = (delPattern.trim().equals("") ? delPattern : delPattern + "|") + delFile;
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Cannot delete deployment descriptor file, ignoring " + delFile);
                        }
                        var12_13 = null;
                        if (in == null) break block21;
                    }
                    catch (Throwable th) {
                        RasUtils.logException(th, tc, CLASS_NAME, "doDeletes", "295", this);
                        Tr.debug(tc, "Error reading " + uri + " for partial app deletion processing.");
                        var12_13 = null;
                        if (in != null) {
                            in.close();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "delete patterns = " + delPattern);
            }
            List f = AppUtils.getURIs(delDir);
            String file = "";
            for (int i = 0; i < f.size(); ++i) {
                file = (String)f.get(i);
                AppUtils.dbg(tc, "trying to match file for delete: " + file);
                if (!file.matches(delPattern)) continue;
                AppUtils.dbg(tc, "Deleting file " + file + " from " + delDir);
                File jFile = new File(delDir + "/" + file);
                if (jFile.exists()) {
                    jFile.delete();
                    deleted.add((AppUtils.isEmpty(archiveURI) ? "" : archiveURI + "/") + file);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "File does not exist: " + jFile);
            }
        } else if (DELETE.equals(op)) {
            if (!this.validateDelFile(uri)) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0183E", new Object[]{uri}));
            }
            File jFile = new File(dest + "/" + uri);
            if (jFile.exists()) {
                AppUtils.deleteDirTree(dest + "/" + uri, false);
                deleted.add(uri);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "doDeletes");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doDeletes");
        }
        return true;
    }

    protected boolean validateDelFile(String uri) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateDelFile", new Object[]{uri});
        }
        boolean ret = true;
        String validateFile = null;
        if (uri.indexOf("META-INF") > -1) {
            validateFile = uri.substring(uri.indexOf("META-INF"));
        } else if (uri.indexOf("WEB-INF") > -1) {
            validateFile = uri.substring(uri.indexOf("WEB-INF"));
        }
        if (validateFile != null && ddFiles.contains(validateFile)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file requested to be deleted " + uri + " is a deployment descriptor file");
            }
            ret = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateDelFile", new Object[]{new Boolean(ret)});
        }
        return ret;
    }

    protected boolean addToCollapse(String archiveURI) throws Exception {
        return true;
    }

    private String getPropFileArchiveURI(String uri) {
        String aURI = "";
        int index = uri.indexOf("META-INF/ibm-partialapp-delete.props");
        if (index != 0) {
            aURI = uri.substring(0, index - 1);
        }
        return aURI.trim();
    }

    protected ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = AppUtils.getBundle(this.getResourceBundleName(), this.locale);
        }
        return this.bundle;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    protected String getResourceBundleName() {
        return defaultBundleName;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/ws/management/application/AppUpdate.java, WAS.admin.installapp, WAS70.SERV1, q0834.18, ver. 1.12");
        }
        CLASS_NAME = AppUpdate.class.getName();
        ddFiles = new ArrayList();
        ddFiles.add("META-INF/application.xml");
        ddFiles.add("WEB-INF/web.xml");
        ddFiles.add("META-INF/ejb-jar.xml");
        ddFiles.add("META-INF/ra.xml");
    }
}

