/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBEHelper {
    private static final Vector RESERVEDEXTENSIONNAMES;
    private static final int MAX_CHARS_PER_EDE_VALUE = 500;
    private static final String svLineSeparatorTab;

    public static final byte[] getExtendedDataElementByteArray(CommonBaseEvent cbe, String name) {
        try {
            ExtendedDataElement ede;
            EList edes = cbe.getExtendedDataElements(name);
            if (edes != null && !edes.isEmpty() && (ede = (ExtendedDataElement)edes.get(0)) != null) {
                return ede.getValuesAsByteArray();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static final int getExtendedDataElementInt(CommonBaseEvent cbe, String name, int notPresentValue) {
        try {
            ExtendedDataElement ede;
            EList edes = cbe.getExtendedDataElements(name);
            if (edes != null && !edes.isEmpty() && (ede = (ExtendedDataElement)edes.get(0)) != null) {
                return ede.getValuesAsInt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return notPresentValue;
    }

    public static final String getExtendedDataElementString(CommonBaseEvent cbe, String name) {
        try {
            ExtendedDataElement ede;
            EList edes = cbe.getExtendedDataElements(name);
            if (edes != null && !edes.isEmpty() && (ede = (ExtendedDataElement)edes.get(0)) != null) {
                return ede.getValuesAsString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static final String getExtendedDataElementLargeString(CommonBaseEvent cbe, String name) {
        try {
            String[] values;
            ExtendedDataElement ede;
            EList edes = cbe.getExtendedDataElements(name);
            if (edes != null && !edes.isEmpty() && (ede = (ExtendedDataElement)edes.get(0)) != null && (values = ede.getValuesAsStringArray()) != null && values.length > 0) {
                return CBEHelper.mergeStringArray(values);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static final String getFormattedMessage(CommonBaseEvent cbe) {
        return cbe.getMsg();
    }

    public static final int getLocalizable(CommonBaseEvent cbe) {
        return CBEHelper.convertLocalizableToInt(CBEHelper.getExtendedDataElementString(cbe, "localizable"));
    }

    public static final String getMessageLocale(CommonBaseEvent cbe) {
        MsgDataElement msgDataElement = cbe.getMsgDataElement();
        if (msgDataElement == null) {
            return null;
        }
        return msgDataElement.getMsgLocale();
    }

    public static final Object[] getParameters(CommonBaseEvent cbe) {
        Object[] msgCatalogTokens;
        MsgDataElement msgDataElement = cbe.getMsgDataElement();
        if (msgDataElement != null && (msgCatalogTokens = msgDataElement.getMsgCatalogTokensAsStrings()) != null && msgCatalogTokens.length > 0) {
            return msgCatalogTokens;
        }
        return null;
    }

    public static final boolean requiresNoLocalization(CommonBaseEvent cbe) {
        return CBEHelper.getLocalizable(cbe) == 2;
    }

    public static final String getFlatStackTrace(CommonBaseEvent cbe) {
        return CBEHelper.getExtendedDataElementLargeString(cbe, "flatStackTrace");
    }

    public static final String getStackTrace(CommonBaseEvent cbe) {
        ExtendedDataElement ede;
        StringBuffer thrown = null;
        EList edes = cbe.getExtendedDataElements(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN);
        if (edes != null && !edes.isEmpty() && (ede = (ExtendedDataElement)edes.get(0)) != null) {
            thrown = new StringBuffer();
            String[] values = null;
            if (ede.getType().equals("string")) {
                values = new String[]{ede.getValuesAsString()};
            } else if (ede.getType().equals("stringArray")) {
                values = ede.getValuesAsStringArray();
            }
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        thrown.append(svLineSeparatorTab);
                    }
                    thrown.append(values[i]);
                }
            }
            int childNum = 1;
            EList children = ede.getChildren("Cause" + String.valueOf(childNum));
            while (children != null && !children.isEmpty()) {
                ExtendedDataElement child = (ExtendedDataElement)children.get(0);
                if (child != null) {
                    if (child.getType().equals("string")) {
                        values = new String[]{child.getValuesAsString()};
                    } else if (child.getType().equals("stringArray")) {
                        values = child.getValuesAsStringArray();
                    }
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (i > 0) {
                                thrown.append(svLineSeparatorTab);
                            }
                            thrown.append(values[i]);
                        }
                    }
                }
                children = ede.getChildren("Cause" + String.valueOf(++childNum));
            }
        }
        if (thrown != null) {
            return thrown.toString();
        }
        return null;
    }

    public static final void setExtendedDataElementByteArray(EventFactory eventFactory, CommonBaseEvent cbe, String name, byte[] value) {
        if (value == null) {
            return;
        }
        cbe.removeExtendedDataElements(name);
        ExtendedDataElement ede = eventFactory.createExtendedDataElement();
        ede.setName(name);
        ede.setValuesAsByteArray(value);
        cbe.addExtendedDataElement(ede);
    }

    public static final void setExtendedDataElementInt(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String name, int value) {
        commonBaseEvent.removeExtendedDataElements(name);
        ExtendedDataElement ede = eventFactory.createExtendedDataElement();
        ede.setName(name);
        ede.setValuesAsInt(value);
        commonBaseEvent.addExtendedDataElement(ede);
    }

    public static final void setExtendedDataElementString(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String name, String value) {
        if (value == null) {
            return;
        }
        commonBaseEvent.removeExtendedDataElements(name);
        ExtendedDataElement ede = eventFactory.createExtendedDataElement();
        ede.setName(name);
        ede.setValuesAsString(value);
        commonBaseEvent.addExtendedDataElement(ede);
    }

    public static final void setExtendedDataElementLargeString(EventFactory eventFactory, CommonBaseEvent commonBaseEvent, String name, String value) {
        if (value == null) {
            return;
        }
        commonBaseEvent.removeExtendedDataElements(name);
        ExtendedDataElement ede = eventFactory.createExtendedDataElement();
        ede.setName(name);
        ede.setValuesAsStringArray(CBEHelper.chunkString(value, 500));
        commonBaseEvent.addExtendedDataElement(ede);
    }

    public static final void setFormattedMessage(CommonBaseEvent cbe, String formattedMessage) {
        cbe.setMsg(formattedMessage);
    }

    public static final void setLocalizable(EventFactory eventFactory, CommonBaseEvent cbe, int localizable) {
        String value = CBEHelper.convertLocalizableToString(localizable);
        CBEHelper.setExtendedDataElementString(eventFactory, cbe, "localizable", value);
    }

    public static final void setMessageLocale(EventFactory eventFactory, CommonBaseEvent cbe, String locale) {
        MsgDataElement msgDataElement = cbe.getMsgDataElement();
        if (msgDataElement == null) {
            msgDataElement = eventFactory.createMsgDataElement();
            cbe.setMsgDataElement(msgDataElement);
        }
        msgDataElement.setMsgLocale(locale);
    }

    public static final void setMsgId(EventFactory eventFactory, CommonBaseEvent cbe, String msgId) {
        MsgDataElement msgDataElement = cbe.getMsgDataElement();
        if (msgDataElement == null) {
            msgDataElement = eventFactory.createMsgDataElement();
            cbe.setMsgDataElement(msgDataElement);
        }
        msgDataElement.setMsgId(msgId);
    }

    private static String[] chunkString(String value, int maxBytesPerValue) {
        if (value == null || maxBytesPerValue <= 0) {
            return null;
        }
        int length = value.length();
        if (maxBytesPerValue > length) {
            return new String[]{value};
        }
        int start = 0;
        int end = start + maxBytesPerValue;
        int numChunks = (length + maxBytesPerValue - 1) / maxBytesPerValue;
        String[] chunks = new String[numChunks];
        for (int i = 0; i < numChunks; ++i) {
            chunks[i] = value.substring(start, end);
            start += maxBytesPerValue;
            if ((end += maxBytesPerValue) <= length) continue;
            end = length;
        }
        return chunks;
    }

    private static String mergeStringArray(String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuffer sb = new StringBuffer(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.append(values[i]);
        }
        return new String(sb);
    }

    private static String getSystemProperty(String propName) {
        final String temp = propName;
        try {
            String prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static final String convertLocalizableToString(int localizable) {
        switch (localizable) {
            case 1: {
                return "yes";
            }
            case 2: {
                return "no";
            }
        }
        return "default";
    }

    private static final int convertLocalizableToInt(String localizable) {
        if (localizable == null) {
            return 0;
        }
        if (localizable.equals("yes")) {
            return 1;
        }
        if (localizable.equals("no")) {
            return 2;
        }
        return 0;
    }

    public static void populateMsgId(CommonBaseEvent cbe, String localizedMessage) {
        String[] msgIdInfo;
        MsgDataElement mde = cbe.getMsgDataElement();
        if (mde != null && mde.getMsgId() == null && (msgIdInfo = CBEHelper.detectMsgIdInfo(localizedMessage))[0] != null) {
            mde.setMsgIdType(msgIdInfo[0]);
            mde.setMsgId(msgIdInfo[1]);
        }
    }

    static String[] detectMsgIdInfo(String localizedMessage) {
        char[] lm;
        String[] msgIdInfo = new String[2];
        if (localizedMessage.length() >= 11) {
            lm = new char[11];
            localizedMessage.getChars(0, 11, lm, 0);
            if (lm[10] == ':' && (lm[9] == 'E' || lm[9] == 'W' || lm[9] == 'I') && lm[8] >= '0' && lm[8] <= '9' && lm[7] >= '0' && lm[7] <= '9' && lm[6] >= '0' && lm[6] <= '9' && lm[5] >= '0' && lm[5] <= '9' && lm[4] >= 'A' && lm[4] <= 'Z' && lm[3] >= 'A' && lm[3] <= 'Z' && lm[2] >= 'A' && lm[2] <= 'Z' && lm[1] >= 'A' && lm[1] <= 'Z' && lm[0] >= 'A' && lm[0] <= 'Z') {
                msgIdInfo[0] = "IBM5.4.1";
                msgIdInfo[1] = localizedMessage.substring(0, 10);
            }
        }
        if (msgIdInfo[0] == null && localizedMessage.length() >= 10) {
            lm = new char[10];
            localizedMessage.getChars(0, 10, lm, 0);
            if (lm[9] == ':' && (lm[8] == 'E' || lm[8] == 'W' || lm[8] == 'I') && lm[7] >= '0' && lm[7] <= '9' && lm[6] >= '0' && lm[6] <= '9' && lm[5] >= '0' && lm[5] <= '9' && lm[4] >= '0' && lm[4] <= '9' && lm[3] >= 'A' && lm[3] <= 'Z' && lm[2] >= 'A' && lm[2] <= 'Z' && lm[1] >= 'A' && lm[1] <= 'Z' && lm[0] >= 'A' && lm[0] <= 'Z') {
                msgIdInfo[0] = "IBM4.4.1";
                msgIdInfo[1] = localizedMessage.substring(0, 9);
            }
        }
        return msgIdInfo;
    }

    public static String getAlreadyFormattedMessage(CommonBaseEvent cbe, Locale locale) {
        String previousMessageLocale = CBEHelper.getMessageLocale(cbe);
        if (previousMessageLocale != null && previousMessageLocale.length() > 1) {
            String previousFormattedMessage;
            String currentMessageLocale = locale.toString();
            String previousLanguage = previousMessageLocale.substring(0, 2);
            String currentLanguage = locale.getLanguage();
            if ((previousMessageLocale.equals(currentMessageLocale) || previousLanguage.equals(currentLanguage)) && (previousFormattedMessage = CBEHelper.getFormattedMessage(cbe)) != null) {
                return previousFormattedMessage;
            }
        }
        return null;
    }

    public static Vector getReservedExtenionNames() {
        return RESERVEDEXTENSIONNAMES;
    }

    static {
        svLineSeparatorTab = CBEHelper.getSystemProperty("line.separator") + "\t";
        RESERVEDEXTENSIONNAMES = new Vector();
        RESERVEDEXTENSIONNAMES.add("correlationId");
        RESERVEDEXTENSIONNAMES.add("organization");
        RESERVEDEXTENSIONNAMES.add(CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_THROWN);
        RESERVEDEXTENSIONNAMES.add("version");
        RESERVEDEXTENSIONNAMES.add("localizable");
        RESERVEDEXTENSIONNAMES.add("rawData");
        RESERVEDEXTENSIONNAMES.add("component");
        RESERVEDEXTENSIONNAMES.add("processId");
        RESERVEDEXTENSIONNAMES.add("processName");
        RESERVEDEXTENSIONNAMES.add("product");
        RESERVEDEXTENSIONNAMES.add("flatStackTrace");
        RESERVEDEXTENSIONNAMES.add("addressSpaceId");
        RESERVEDEXTENSIONNAMES.add("jobName");
        RESERVEDEXTENSIONNAMES.add("serverName");
        RESERVEDEXTENSIONNAMES.add("jobId");
        RESERVEDEXTENSIONNAMES.add("systemName");
        RESERVEDEXTENSIONNAMES.add("tcbAddress");
        RESERVEDEXTENSIONNAMES.add("pthreadId");
        RESERVEDEXTENSIONNAMES.add("ORBRequestId");
    }
}

