/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ws.logging.WsLogger;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerHelper {
    public static final String EXTENSION_NAME_HANDLER_PREFERENCE = "handler_preference";
    public static final String EXTENSION_VALUE_HANDLER_PREFERENCE_OPERATOR = "operator";
    public static final String EXTENSION_NAME_DIAGNOSTIC_PROVIDER_ID = "DiagnosticProvider";
    public static final String EXTENSION_NAME_SERVICELOG_ONLY_PREFERENCE = "service_log_only";

    public static void addLoggerToGroup(Logger logger, String group) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addLoggerToGroup must not be null");
        }
        if (group == null) {
            throw new NullPointerException("group name passed as argument to addLoggerToGroup must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addLoggerToGroup must be a named logger");
        }
        StringTokenizer st = new StringTokenizer(group, ",;: ");
        while (st.hasMoreTokens()) {
            ((WsLogger)logger).addToGroup(st.nextToken().trim());
        }
    }

    public static String getExtension(Logger logger, String name) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to getExtension must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name passed as argument to getExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to getExtension must be a named logger");
        }
        return ((WsLogger)logger).getExtension(name);
    }

    public static Map getExtensions(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to getExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to getExtensions must be a named logger");
        }
        return ((WsLogger)logger).getExtensions();
    }

    public static void addExtension(Logger logger, String name, String value) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addExtension must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name passed as argument to addExtension must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value passed as argument to addExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addExtension must be a named logger");
        }
        ((WsLogger)logger).addExtension(name, value);
    }

    public static void addExtensions(Logger logger, Map extensions) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to addExtensions must not be null");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions passed as argument to addExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to addExtensions must be a named logger");
        }
        ((WsLogger)logger).addExtensions(extensions);
    }

    public static void removeExtension(Logger logger, String name) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to removeExtension must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name passed as argument to removeExtension must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to removeExtension must be a named logger");
        }
        ((WsLogger)logger).removeExtension(name);
    }

    public static void clearExtensions(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to clearExtensions must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to clearExtensions must be a named logger");
        }
        ((WsLogger)logger).clearExtensions();
    }

    public static void setAttributes(Logger logger, String organization, String product2, String component2, Level minimumLocalizationLevel) {
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to setAttributes must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to setAttributes must be a named logger");
        }
        WsLogger wsLogger = (WsLogger)logger;
        if (organization != null) {
            wsLogger.setOrganization(organization);
        }
        if (product2 != null) {
            wsLogger.setProduct(product2);
        }
        if (component2 != null) {
            wsLogger.setComponent(component2);
        }
        if (minimumLocalizationLevel != null) {
            wsLogger.setMinimumLocalizationLevel(minimumLocalizationLevel);
        }
    }
}

