/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannel;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.base.OutboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundLink
extends OutboundProtocolLink
implements OutboundProtocol {
    private static final TraceComponent tc = Tr.register(HttpOutboundLink.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private HttpOutboundServiceContextImpl myInterface = null;
    private HttpOutboundChannel myChannel = null;
    private boolean bAllowReconnect = true;
    private boolean bEnableReconnect = true;
    private HttpAddress targetAddress = null;
    private boolean bIsActive = false;
    private boolean reconnecting = false;
    private IOException reconnectException = null;
    private boolean earlyReconnectDestroy = false;

    public HttpOutboundLink(HttpOutboundChannel c, VirtualConnection vc) {
        this.init(vc, c);
    }

    public void init(VirtualConnection inVC, HttpOutboundChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Init on link: " + this + " " + inVC);
        }
        super.init(inVC);
        this.myChannel = channel;
        this.bIsActive = true;
        this.setEnableReconnect(this.myChannel.getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying this outbound link: " + this + " " + this.getVirtualConnection());
        }
        if (!this.reconnecting) {
            HttpOutboundLink httpOutboundLink = this;
            synchronized (httpOutboundLink) {
                if (!this.bIsActive) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Ignoring destroy on an inactive object");
                    }
                    return;
                }
                this.bIsActive = false;
            }
            super.destroy(e);
            if (null != this.myInterface) {
                this.myInterface.destroy();
                this.myInterface = null;
            }
            this.targetAddress = null;
            this.myChannel = null;
        } else {
            this.earlyReconnectDestroy = true;
            IOException ioe = this.reconnectException;
            this.reconnectException = null;
            this.reconnecting = false;
            this.myInterface.callErrorCallback(this.getVirtualConnection(), ioe);
        }
    }

    private HttpOutboundServiceContextImpl getInterface(VirtualConnection inVC) {
        if (null == this.myInterface) {
            this.myInterface = new HttpOutboundServiceContextImpl((TCPConnectionContext)this.getDeviceLink().getChannelAccessor(), this, inVC, this.myChannel.getHttpConfig());
        }
        return this.myInterface;
    }

    public Object getChannelAccessor() {
        return this.getInterface(this.getVirtualConnection());
    }

    public String getProtocol() {
        return "HTTP";
    }

    protected void postConnectProcessing(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Finished connecting to target: " + this + " " + inVC);
        }
        this.getInterface(inVC);
    }

    public void ready(VirtualConnection inVC) {
        if (!this.reconnecting) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound ready for " + this + " " + inVC);
            }
            super.ready(inVC);
        } else {
            this.reconnecting = false;
            this.reconnectException = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Outbound reconnect finished for " + this + " " + inVC);
            }
            this.myInterface.nowReconnectedAsync();
        }
    }

    protected void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing the outbound link: " + this + " " + this.getVirtualConnection());
        }
        this.setEnableReconnect(this.myChannel.getHttpConfig().allowsRetries());
        this.setAllowReconnect(true);
        this.reconnecting = false;
        this.reconnectException = null;
        this.earlyReconnectDestroy = false;
    }

    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Closing this outbound link: " + this + " " + this.getVirtualConnection());
        }
        this.setAllowReconnect(false);
        if (!this.earlyReconnectDestroy) {
            super.close(inVC, e);
        } else {
            this.destroy(e);
        }
    }

    public void connect(Object address) throws Exception {
        this.targetAddress = (HttpAddress)address;
        if (null != this.myInterface && this.isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing existing OSC on connect");
            }
            this.myInterface.clear();
        }
        super.connect(address);
    }

    public void connectAsynch(Object address) {
        this.targetAddress = (HttpAddress)address;
        if (null != this.myInterface && this.isReconnectAllowed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing existing OSC on connectAsynch");
            }
            this.myInterface.clear();
        }
        super.connectAsynch(address);
    }

    protected void reConnectSync(IOException originalExcep) throws IOException {
        this.setAllowReconnect(false);
        try {
            this.connect(this.getTargetAddress());
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Sync reconnect failed, throwing original exception");
            }
            throw originalExcep;
        }
    }

    protected void reConnectAsync(IOException originalExcep) {
        this.setAllowReconnect(false);
        this.reconnecting = true;
        this.reconnectException = originalExcep;
        this.connectAsynch(this.getTargetAddress());
    }

    protected boolean isReconnectAllowed() {
        return this.bAllowReconnect;
    }

    private boolean isReconnectEnabled() {
        return this.bEnableReconnect;
    }

    private void setEnableReconnect(boolean flag) {
        this.bEnableReconnect = flag;
    }

    protected void setAllowReconnect(boolean flag) {
        this.bAllowReconnect = flag & this.isReconnectEnabled();
    }

    protected boolean disallowRewrites() {
        this.setEnableReconnect(false);
        this.setAllowReconnect(false);
        return !this.isReconnectAllowed();
    }

    protected final boolean allowRewrites() {
        this.setAllowReconnect(true);
        return this.isReconnectAllowed();
    }

    public HttpAddress getTargetAddress() {
        return this.targetAddress;
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.myChannel ? null : this.myChannel.getObjectFactory();
    }

    public boolean isConnected() {
        if (!this.myInterface.isIncomingMessageFullyRead()) {
            return true;
        }
        try {
            if (null == this.myInterface.getTSC().getReadInterface().getBuffer()) {
                this.myInterface.getTSC().getReadInterface().setJITAllocateSize(this.myInterface.getHttpConfig().getIncomingHdrBufferSize());
            }
            this.myInterface.getTSC().getReadInterface().read(0L, 0);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

