/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadAhead
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSCReadAhead.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpOSCReadAhead myInstance = new HttpOSCReadAhead();

    private HttpOSCReadAhead() {
    }

    public static final HttpOSCReadAhead getRef() {
        return myInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        int state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        osc.markReadCancelFailure();
        Object object = osc.stateSyncObject;
        synchronized (object) {
            state = osc.getReadState();
            osc.setCallbackState(4, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read-ahead state: " + state);
        }
        switch (state) {
            case 0: {
                IOException ioe = new IOException("Unexpected read complete");
                osc.getAppReadCallback().error(vc, (Throwable)ioe);
                break;
            }
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: Read-ahead completed after init() call.");
                }
                osc.setCallbackState(2, new IOException("Invalid read-ahead data"));
                break;
            }
            case 3: {
                osc.wakeupReadAhead();
                break;
            }
            case 4: {
                HttpOSCReadCallback.getRef().complete(vc, rsc);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected read-ahead state: " + state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        int state;
        HttpOutboundServiceContextImpl osc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + vc + " ioe=" + ioe);
        }
        if ((osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC)).markReadCancelSuccess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring error callback on canceled read");
            }
            return;
        }
        Object object = osc.stateSyncObject;
        synchronized (object) {
            state = osc.getReadState();
            osc.setCallbackState(2, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Read-ahead state: " + state);
        }
        switch (state) {
            case 0: {
                osc.getAppReadCallback().error(vc, (Throwable)ioe);
                break;
            }
            case 1: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Received the read-ahead immed timeout.");
                break;
            }
            case 3: {
                osc.wakeupReadAhead();
                break;
            }
            case 4: {
                osc.setPersistent(false);
                osc.reConnect(vc, ioe);
                break;
            }
            default: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Unexpected read-ahead state: " + state);
            }
        }
    }
}

