/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpICLReadCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpIgnoreBodyCallback;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannel;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.inbound.impl.HttpRequestHandler;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.InboundConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.impl.BaseConnectionLink;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.exception.MessageTooLargeException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HttpInboundLink
extends BaseConnectionLink
implements InterChannelCallback,
InboundConnectionLink {
    private static final TraceComponent tc = Tr.register(HttpInboundLink.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private HttpInboundServiceContextImpl myInterface = null;
    private HttpInboundChannel myChannel = null;
    private TCPConnectionContext myTSC = null;
    private boolean bPartialParsedRequest = false;
    private int numRequestsProcessed = 0;
    private boolean filterExceptions = false;
    private boolean bIsActive = false;
    private List<ConnectionReadyCallback> appSides = new ArrayList<ConnectionReadyCallback>(5);

    public HttpInboundLink(HttpInboundChannel channel, VirtualConnection vc) {
        this.init(vc, channel);
        this.myInterface = new HttpInboundServiceContextImpl(null, this, this.getVirtualConnection(), this.getChannel().getHttpConfig());
    }

    public void init(VirtualConnection inVC, HttpInboundChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Init on link: " + (Object)((Object)this) + " " + inVC);
        }
        super.init(inVC);
        this.myChannel = channel;
        if (null != this.getHTTPContext()) {
            this.getHTTPContext().setHttpConfig(channel.getHttpConfig());
        }
        this.getVirtualConnection().getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, this);
        this.bIsActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying inbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection());
        }
        HttpInboundLink httpInboundLink = this;
        synchronized (httpInboundLink) {
            if (!this.bIsActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ignoring destroy on an inactive object");
                }
                return;
            }
            this.bIsActive = false;
        }
        this.getVirtualConnection().getStateMap().remove(CallbackIDs.CALLBACK_HTTPICL);
        this.getVirtualConnection().getStateMap().remove("zConfiguredHttpReadBufferSize");
        super.destroy();
        for (int i = this.appSides.size() - 1; i >= 0; --i) {
            this.appSides.remove(i).destroy(e);
        }
        this.myInterface.clear();
        this.myInterface.destroy();
        this.myInterface = null;
        this.myTSC = null;
        this.filterExceptions = false;
        this.numRequestsProcessed = 0;
        this.myChannel = null;
    }

    public Object getChannelAccessor() {
        return this.myInterface;
    }

    protected HttpInboundServiceContextImpl getHTTPContext() {
        return this.myInterface;
    }

    protected HttpInboundChannel getChannel() {
        return this.myChannel;
    }

    protected boolean maxRequestsServed() {
        if (this.getChannel().isStopping()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped, disabling keep-alive request");
            }
            return true;
        }
        if (!this.getChannel().getHttpConfig().isKeepAliveEnabled()) {
            return true;
        }
        int max = this.getChannel().getHttpConfig().getMaximumPersistentRequests();
        if (0 <= max) {
            return this.numRequestsProcessed >= max;
        }
        return false;
    }

    protected boolean isFirstRequest() {
        return 0 == this.numRequestsProcessed || 1 == this.numRequestsProcessed && this.getHTTPContext().headersParsed();
    }

    protected boolean isPartiallyParsed() {
        return this.bPartialParsedRequest;
    }

    protected void setPartiallyParsed(boolean b) {
        this.bPartialParsedRequest = b;
    }

    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ready: " + (Object)((Object)this) + " " + inVC);
        }
        this.myTSC = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        sc.init(this.myTSC, (ConnectionLink)this, inVC, this.getChannel().getHttpConfig());
        if (this.getChannel().getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.INFO)) {
            this.getChannel().getHttpConfig().getDebugLog().log(DebugLog.Level.INFO, "Received new connection ", (HttpServiceContext)sc);
        }
        this.handleNewInformation();
        VirtualConnection vcRC = null;
        while (this.isPartiallyParsed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Partial request, reading more");
            }
            if (null == (vcRC = this.myTSC.getReadInterface().read(1L, (TCPReadCompletedCallback)HttpICLReadCallback.getRef(), false, sc.getReadTimeout()))) break;
            this.handleNewInformation();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ready");
        }
    }

    void handleNewInformation() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Parsing new information: " + this.getVirtualConnection());
        }
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        if (!this.isPartiallyParsed() && this.getChannel().isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Channel stopped during initial read");
            }
            sc.setHeadersParsed();
            sc.getResponse().setVersion(VersionValues.V10);
            this.sendErrorMessage(StatusCodes.UNAVAILABLE);
            return;
        }
        boolean completed = false;
        try {
            completed = sc.parseMessage();
        }
        catch (UnsupportedMethodException meth) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.NOT_IMPLEMENTED);
            this.setPartiallyParsed(false);
            return;
        }
        catch (UnsupportedProtocolVersionException ver) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.UNSUPPORTED_VERSION);
            this.setPartiallyParsed(false);
            return;
        }
        catch (MessageTooLargeException mtle) {
            sc.setHeadersParsed();
            this.sendErrorMessage(StatusCodes.ENTITY_TOO_LARGE);
            this.setPartiallyParsed(false);
            return;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "HttpInboundLink.handleNewInformation", "2", (Object)this);
            sc.setHeadersParsed();
            this.sendErrorMessage(t);
            this.setPartiallyParsed(false);
            return;
        }
        this.setPartiallyParsed(!completed);
        if (this.isPartiallyParsed()) {
            sc.setupReadBuffers(sc.getHttpConfig().getIncomingHdrBufferSize(), false);
            return;
        }
        sc.setRequestVersion(sc.getRequest().getVersionValue());
        sc.setRequestMethod(sc.getRequest().getMethodValue());
        sc.getResponseImpl().init(sc);
        ++this.numRequestsProcessed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Received request number " + this.numRequestsProcessed + " on link " + (Object)((Object)this));
        }
        if (!sc.check100Continue()) {
            return;
        }
        this.handleDiscrimination();
    }

    protected void handleDiscrimination() {
        if (this.getHTTPContext().checkFormData()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Discrimination will be called");
        }
        if (this.getChannel().getHttpConfig().runningOnZOS()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing buffer size on z/OS");
            }
            this.getVirtualConnection().getStateMap().put("zConfiguredHttpReadBufferSize", new Integer(this.getChannel().getHttpConfig().getIncomingBodyBufferSize()));
        }
        ConnectionReadyCallback oldAppSide = this.getApplicationCallback();
        DiscriminationProcess dp = this.getChannel().getDiscriminationProcess();
        int state = 0;
        try {
            state = dp.discriminate(this.getVirtualConnection(), (Object)this.getHTTPContext().getRequest(), (ConnectionLink)this);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during discriminate: " + e);
            }
            this.setPartiallyParsed(false);
            this.sendErrorMessage(e);
            return;
        }
        if (1 == state) {
            if (null == oldAppSide) {
                this.appSides.add(this.getApplicationCallback());
            } else if (!this.getApplicationCallback().equals(oldAppSide)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received new appside connlink: " + oldAppSide + " vs " + this.getApplicationCallback());
                }
                if (!this.appSides.contains(this.getApplicationCallback())) {
                    this.appSides.add(this.getApplicationCallback());
                }
            }
            try {
                this.getApplicationCallback().ready(this.getVirtualConnection());
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "HttpInboundLink.handleDiscrimination", "1", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "App side ready() threw exception: " + t);
                }
                if (!this.bIsActive) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Link not active, returning out.");
                    }
                    return;
                }
                if (this.getHTTPContext().headersSent()) {
                    this.getDeviceLink().close(this.getVirtualConnection(), new Exception(t));
                    return;
                }
                this.sendErrorMessage(StatusCodes.UNAVAILABLE);
                return;
            }
        } else {
            this.setPartiallyParsed(false);
            this.sendErrorMessage(new Exception("Discrimination failed"));
        }
    }

    private void sendErrorMessage(Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending a 400 for throwable [" + t + "]");
        }
        this.sendErrorMessage(StatusCodes.BAD_REQUEST);
    }

    private void sendErrorMessage(StatusCodes code) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending an error page back [code: " + code + "]");
        }
        try {
            this.getHTTPContext().sendError(code.getHttpError());
        }
        catch (MessageSentException mse) {
            this.close(this.getVirtualConnection(), new Exception("HTTP Message failure"));
        }
    }

    private void handlePipeLining() {
        block9: {
            HttpInboundServiceContextImpl sc = this.getHTTPContext();
            WsByteBuffer buffer = sc.returnLastBuffer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Pipelined request found: " + buffer);
            }
            ((HttpServiceContextImpl)sc).clear();
            sc.storeAllocatedBuffer(buffer);
            sc.disableBufferModification();
            String poolName = (String)this.getVirtualConnection().getStateMap().get("TCP_THREADPOOL_NAME");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Threadpool name is [" + poolName + "]");
            }
            ThreadPool pool = null;
            pool = null != poolName ? ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(poolName) : this.getChannel().getConfig().getChannelFramework().getDefaultThreadPool();
            if (null != pool) {
                HttpRequestHandler handler = new HttpRequestHandler(this);
                try {
                    int rc = pool.execute((Runnable)handler, 0);
                    if (0 == rc) {
                        return;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "ThreadPool failed to run handler, rc=" + rc);
                    }
                    break block9;
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, ((Object)((Object)this)).getClass().getName() + ".handlePipeLining", "1", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Error queueing pipeline request to threadpool; " + t);
                    }
                    break block9;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to find any pool, continuing on this thread");
            }
        }
        this.ready(this.getVirtualConnection());
    }

    public void close(VirtualConnection inVC, Exception e) {
        VirtualConnection rc;
        boolean errorState;
        boolean bTrace = TraceComponent.isAnyTracingEnabled();
        if (bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "close() called: " + (Object)((Object)this) + " " + inVC);
        }
        boolean bl = errorState = null != e;
        if (errorState && bTrace && tc.isDebugEnabled()) {
            Tr.debug(tc, "close() in error state, " + e);
        }
        HttpInboundServiceContextImpl sc = this.getHTTPContext();
        HttpChannelConfig config = sc.getHttpConfig();
        if (sc.containsLargeMessage()) {
            this.getChannel().getFactory().releaseLargeMessage();
        }
        if (!errorState && !sc.isMessageSent()) {
            try {
                rc = sc.finishResponseMessage(null, this, false);
                if (null == rc) {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug(tc, "finishing response msg async");
                    }
                    return;
                }
            }
            catch (MessageSentException mse) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: message sent exception when flag doesn't agree");
                }
                this.getDeviceLink().close(inVC, (Exception)mse);
                return;
            }
        }
        if (!errorState && this.getChannel().isRunning() && !sc.isIncomingMessageFullyRead()) {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Incoming request body never read.");
            }
            try {
                rc = sc.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                boolean reachedEnd = false;
                while (null != rc) {
                    WsByteBuffer buffer = sc.getRequestBodyBuffer();
                    if (null != buffer) {
                        buffer.release();
                        rc = sc.getRequestBodyBuffer(HttpIgnoreBodyCallback.getRef(), false);
                        continue;
                    }
                    reachedEnd = true;
                    break;
                }
                if (!reachedEnd) {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug(tc, "close() waiting for body purge callback");
                    }
                    return;
                }
            }
            catch (Exception purgeException) {
                if (bTrace && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception purging request body: " + purgeException);
                }
                errorState = true;
            }
        }
        if (!errorState && sc.isPersistent() && this.getChannel().isRunning()) {
            if (config.getDebugLog().isEnabled(DebugLog.Level.DEBUG)) {
                config.getDebugLog().log(DebugLog.Level.DEBUG, "Reading for another request", (HttpServiceContext)sc);
            }
            this.myTSC.getWriteInterface().setBuffers(null);
            if (sc.isReadDataAvailable()) {
                this.handlePipeLining();
                return;
            }
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading for another request...");
            }
            this.getVirtualConnection().getStateMap().put("HTTPFirstRead", "true");
            sc.clear();
            sc.setReadBuffer(null);
            sc.setupJITRead(config.getIncomingHdrBufferSize());
            if (config.isKeepThread()) {
                try {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug(tc, "keepThread says to block read");
                    }
                    this.myTSC.getReadInterface().read(1L, config.getPersistTimeout());
                    this.ready(inVC);
                }
                catch (IOException ioe) {
                    if (bTrace && tc.isDebugEnabled()) {
                        Tr.debug(tc, "IOException while reading data.");
                    }
                    if (config.getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                        config.getDebugLog().log(DebugLog.Level.WARN, "Read for another request failed", (HttpServiceContext)sc);
                    }
                    this.myTSC.getWriteInterface().setBuffer(null);
                    this.myTSC.getReadInterface().setBuffer(null);
                    this.getDeviceLink().close(inVC, null);
                }
                return;
            }
            this.myTSC.getReadInterface().read(1L, (TCPReadCompletedCallback)HttpICLReadCallback.getRef(), true, config.getPersistTimeout());
        } else {
            if (bTrace && tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing connection");
            }
            if (config.getDebugLog().isEnabled(DebugLog.Level.INFO)) {
                config.getDebugLog().log(DebugLog.Level.INFO, "Closing connection to client", (HttpServiceContext)sc);
            }
            if (this.filterExceptions) {
                e = null;
            }
            this.myTSC.getWriteInterface().setBuffer(null);
            this.myTSC.getReadInterface().setBuffer(null);
            this.getDeviceLink().close(inVC, e);
        }
    }

    public void complete(VirtualConnection inVC) {
        this.close(inVC, null);
    }

    public void error(VirtualConnection inVC, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called on " + (Object)((Object)this) + " " + inVC);
        }
        try {
            this.close(inVC, (Exception)t);
        }
        catch (ClassCastException cce) {
            this.close(inVC, new Exception("Problem when finishing response"));
        }
    }

    protected void setFilterCloseExceptions(boolean b) {
        this.filterExceptions = b;
    }

    public HttpObjectFactory getObjectFactory() {
        return this.getChannel().getObjectFactory();
    }
}

