/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.logging.DebugLog;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpICLReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpICLReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final HttpICLReadCallback myInstance = new HttpICLReadCallback();

    private HttpICLReadCallback() {
    }

    public static final HttpICLReadCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: " + vc);
        }
        HttpInboundLink myLink = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        do {
            myLink.handleNewInformation();
            if (myLink.isPartiallyParsed()) continue;
            return;
        } while (null != rsc.read(1L, (TCPReadCompletedCallback)this, false, myLink.getHTTPContext().getReadTimeout()));
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: " + vc);
        }
        HttpInboundLink myLink = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        HttpInboundServiceContextImpl isc = myLink.getHTTPContext();
        isc.setPersistent(false);
        myLink.setFilterCloseExceptions(true);
        if (myLink.isFirstRequest() || myLink.isPartiallyParsed()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error, sending 408 timeout back");
                }
                if (isc.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                    isc.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "A read during the connection failed due to a socket exception.", (HttpServiceContext)isc);
                }
                isc.setHeadersParsed();
                isc.sendError(StatusCodes.REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException mse) {
                FFDCFilter.processException(mse, this.getClass().getName() + ".error", "152");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MessageSent error during ICL read error");
                }
                myLink.close(vc, ioe);
            }
        } else {
            myLink.close(vc, ioe);
        }
    }
}

