/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class TrailerCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(TrailerCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final TrailerCallback myInstance = new TrailerCallback();

    private TrailerCallback() {
    }

    public static final TrailerCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: vc=" + vc);
        }
        if (vc instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
            osc.continueRead();
        } else {
            HttpInboundServiceContextImpl isc = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            isc.continueRead();
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: vc=" + vc + " ioe=" + ioe);
        }
        if (vc instanceof OutboundVirtualConnection) {
            HttpOutboundServiceContextImpl osc = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
            osc.setPersistent(false);
            osc.getAppReadCallback().error(vc, (Throwable)ioe);
        } else {
            HttpInboundServiceContextImpl isc = (HttpInboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPISC);
            isc.setPersistent(false);
            isc.getAppReadCallback().error(vc, (Throwable)ioe);
        }
    }
}

