/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HTTPChannelDM;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpTrailersImpl;
import com.ibm.ws.util.objectpool.TwoTierObjectPool;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;

public class HttpObjectFactory {
    private static final TraceComponent tc = Tr.register(HttpObjectFactory.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int SIZE_THREAD = 50;
    private static final int SIZE_MAIN = 50;
    private final TwoTierObjectPool reqPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool respPool = new TwoTierObjectPool(50, 50);
    private final TwoTierObjectPool hdrPool = new TwoTierObjectPool(50, 50);

    public HttpObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "New HTTP object factory created: " + this);
        }
        HTTPChannelDM.getRef();
    }

    public HttpRequestMessageImpl getRequest(HttpInboundServiceContext hsc) {
        HttpRequestMessageImpl req = null;
        Object ret = this.reqPool.get();
        if (null == ret) {
            req = new HttpRequestMessageImpl(hsc);
        } else {
            req = (HttpRequestMessageImpl)ret;
            req.init(hsc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequest(isc): " + req);
        }
        return req;
    }

    public HttpRequestMessageImpl getRequest(HttpOutboundServiceContext hsc) {
        HttpRequestMessageImpl req = null;
        Object ret = this.reqPool.get();
        if (null == ret) {
            req = new HttpRequestMessageImpl(hsc);
        } else {
            req = (HttpRequestMessageImpl)ret;
            req.init(hsc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRequest(osc): " + req);
        }
        return req;
    }

    public void releaseRequest(HttpRequestMessageImpl request) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseRequest: " + request);
        }
        this.reqPool.put((Object)request);
    }

    public HttpResponseMessageImpl getResponse(HttpInboundServiceContext hsc) {
        HttpResponseMessageImpl resp = null;
        Object ret = this.respPool.get();
        if (null == ret) {
            resp = new HttpResponseMessageImpl(hsc);
        } else {
            resp = (HttpResponseMessageImpl)ret;
            resp.init(hsc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResponse(isc): " + resp);
        }
        return resp;
    }

    public HttpResponseMessageImpl getResponse(HttpOutboundServiceContext hsc) {
        HttpResponseMessageImpl resp = null;
        Object ret = this.respPool.get();
        if (null == ret) {
            resp = new HttpResponseMessageImpl(hsc);
        } else {
            resp = (HttpResponseMessageImpl)ret;
            resp.init(hsc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResponse(osc): " + resp);
        }
        return resp;
    }

    public void releaseResponse(HttpResponseMessageImpl response) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseResponse: " + response);
        }
        this.respPool.put((Object)response);
    }

    public HttpTrailersImpl getTrailers() {
        Object o = this.hdrPool.get();
        HttpTrailersImpl hdrs = null == o ? new HttpTrailersImpl() : (HttpTrailersImpl)o;
        hdrs.setFactory(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTrailers: " + hdrs);
        }
        return hdrs;
    }

    public void releaseTrailers(HttpTrailersImpl h) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseTrailers: " + h);
        }
        this.hdrPool.put((Object)h);
    }
}

