/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.compression;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.http.channel.compression.DecompressionHandler;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeflateInputHandler
implements DecompressionHandler {
    private static final TraceComponent tc = Tr.register(DeflateInputHandler.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private Inflater inflater = null;
    private byte[] buf = new byte[16384];

    public DeflateInputHandler() {
        this.inflater = new Inflater(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created a deflate input handler; " + this);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private void release(List<WsByteBuffer> list) {
        while (!list.isEmpty()) {
            list.remove(0).release();
        }
    }

    @Override
    public List<WsByteBuffer> decompress(WsByteBuffer inputBuffer) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "decompress, input=" + inputBuffer);
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        int dataSize = inputBuffer.remaining();
        byte[] input = new byte[dataSize];
        inputBuffer.get(input, 0, dataSize);
        int inOffset = 0;
        if (!this.inflater.finished()) {
            this.inflater.setInput(input, inOffset, dataSize - inOffset);
        }
        long initialBytesRead = this.inflater.getBytesRead();
        int outOffset = 0;
        int len = -1;
        while (inOffset < input.length && !this.inflater.finished() && 0 != len) {
            try {
                len = this.inflater.inflate(this.buf, outOffset, this.buf.length - outOffset);
            }
            catch (DataFormatException dfe) {
                this.release(list);
                throw dfe;
            }
            long bytesRead = this.inflater.getBytesRead();
            inOffset = (int)((long)inOffset + (bytesRead - initialBytesRead));
            initialBytesRead = bytesRead;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Decompressed amount=" + len + " inOffset=" + inOffset + " read=" + this.inflater.getBytesRead() + " written=" + this.inflater.getBytesWritten() + " finished=" + this.inflater.finished());
            }
            if ((outOffset += len) != this.buf.length) continue;
            WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocate(this.buf.length);
            buffer.put(this.buf, 0, this.buf.length);
            buffer.flip();
            list.add(buffer);
            outOffset = 0;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Storing decompressed buffer; " + buffer);
        }
        if (0 < outOffset) {
            WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocate(outOffset);
            buffer.put(this.buf, 0, outOffset);
            buffer.flip();
            list.add(buffer);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Stored final decompressed buffer; " + buffer);
            }
        }
        if (inOffset < dataSize) {
            inputBuffer.position(inputBuffer.position() - (dataSize - inOffset));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "input buffer has unused data; " + inputBuffer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "decompress, output=" + list.size());
        }
        return list;
    }

    @Override
    public void close() {
        this.inflater.end();
    }

    @Override
    public boolean isFinished() {
        return this.inflater.finished();
    }

    @Override
    public long getBytesRead() {
        return this.inflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.inflater.getBytesWritten();
    }
}

