/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ffdc.Manager;
import com.ibm.ws.ffdc.DiagnosticModuleRegistrationFailureException;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.impl.CallStack;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DiagnosticModule {
    String[] directives;
    String[] defaultDirectives;
    Hashtable methodTable = new Hashtable();
    boolean continueProcessing = true;
    private static ThreadLocal<CallStack> threadLocal = new ThreadLocal();
    static final Class[] ffdcDumpParams = new Class[]{Throwable.class, IncidentStream.class, Object.class, new Object[0].getClass(), String.class};
    static final String ffdcDumpPrefix = "ffdcdump";
    static final String ffdcDumpDefault = "default";
    static final boolean debug = false;
    static final int PREFLEN = "ffdcdump".length();

    protected final void init() throws DiagnosticModuleRegistrationFailureException {
        Method[] methods = null;
        try {
            methods = this.getClass().getMethods();
            this.buildMethods(methods);
        }
        catch (Exception ex) {
            methods = new Method[]{};
            ex.printStackTrace();
            throw new DiagnosticModuleRegistrationFailureException("Exception: " + ex + " caught!", ex);
        }
    }

    public boolean validate() {
        System.out.println("This method is NOT intended to be called from the runtime");
        System.out.println("but is provided as part of unit test for diagnostic modules");
        try {
            this.init();
        }
        catch (DiagnosticModuleRegistrationFailureException dmfailed) {
            System.out.println("Diagnostic Module failed to register");
            dmfailed.printStackTrace();
            return false;
        }
        catch (Throwable th) {
            System.out.println("Some unknown failure occured");
            th.printStackTrace();
            return false;
        }
        System.out.println("ffdc methods on the diagnostic module : ");
        Enumeration e = this.methodTable.keys();
        String methodName = null;
        while (e.hasMoreElements()) {
            methodName = (String)e.nextElement();
            System.out.println("    " + methodName);
        }
        System.out.println("The default directives are : ");
        if (this.defaultDirectives == null || this.defaultDirectives.length == 0) {
            System.out.println("No default directives were found");
            System.out.println("This diagnostic module would fail to register");
            return false;
        }
        for (int i = 0; i < this.defaultDirectives.length && this.defaultDirectives[i] != null; ++i) {
            System.out.println("    " + this.defaultDirectives[i]);
        }
        return true;
    }

    public void stopProcessingException() {
        this.continueProcessing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpComponentData(String[] input_directives, Throwable ex, IncidentStream ffdcis, Object callerThis, Object[] catcherObjects, String sourceId, CallStack callStack) {
        this.continueProcessing = true;
        try {
            threadLocal.set(callStack);
            ffdcis.writeLine("==> Performing default dump from " + this.getClass().getName() + " ", new Date());
            this.getDataForDirectives(this.defaultDirectives, ex, ffdcis, callerThis, catcherObjects, sourceId);
            if (input_directives != null && input_directives.length > 0) {
                ffdcis.writeLine("==> Default dump complete for " + this.getClass().getName() + ".\n\n==> Now customized dump is running... ", new Date());
                this.getDataForDirectives(input_directives, ex, ffdcis, callerThis, catcherObjects, sourceId);
            }
            ffdcis.writeLine("==> Dump complete for " + this.getClass().getName() + " ", new Date());
        }
        catch (Throwable th) {
            ffdcis.writeLine("==> Dump did not complete for " + this.getClass().getName() + " ", new Date());
        }
        finally {
            threadLocal.set(null);
        }
        return this.continueProcessing;
    }

    protected static final String getExecutionMethodName() {
        CallStack exceptionCallStack = threadLocal.get();
        if (exceptionCallStack != null) {
            return exceptionCallStack.getExecutionMethodName();
        }
        return null;
    }

    void buildMethods(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Method method2 = methods[i];
            String name = method2.getName().toLowerCase();
            if (name.length() <= PREFLEN || !name.startsWith(ffdcDumpPrefix)) continue;
            Class<?>[] params = method2.getParameterTypes();
            if (params.length != ffdcDumpParams.length) {
                throw new IllegalStateException("Error: " + method2 + " starts with " + ffdcDumpPrefix + " but takes " + params.length + " parameters.  It is supposed to have " + ffdcDumpParams.length + " parameters and have the signature " + ffdcDumpPrefix + "<....>(" + this.buildParamList() + ");" + " Method skipped!");
            }
            boolean error = false;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == ffdcDumpParams[j]) continue;
                throw new IllegalStateException("Error: " + method2 + " starts with " + ffdcDumpPrefix + " but does not conform to the signature\n\t" + ffdcDumpPrefix + "<....>(" + this.buildParamList() + "); \n\tParameter " + (j + 1) + " does not match.  Method skipped!");
            }
            if (error) continue;
            this.methodTable.put(name.substring(PREFLEN), method2);
        }
        this.directives = new String[this.methodTable.size()];
        Vector<String> defaultv = new Vector<String>();
        int k = 0;
        Enumeration keys = this.methodTable.keys();
        while (keys.hasMoreElements()) {
            String directive = (String)keys.nextElement();
            this.directives[k++] = directive;
            if (!directive.startsWith(ffdcDumpDefault)) continue;
            defaultv.addElement(directive);
        }
        if (defaultv.isEmpty()) {
            throw new IllegalStateException("Error: class " + this.getClass().getName() + " must have at least one DEFAULT dumping method of the form:\n\t" + ffdcDumpPrefix + ffdcDumpDefault + "<....>(" + this.buildParamList() + ");");
        }
        this.defaultDirectives = defaultv.toArray(new String[0]);
    }

    public String[] getDirectives() {
        return this.directives;
    }

    public void getDataForDirectives(String[] directives, Throwable ex, IncidentStream out, Object callerThis, Object[] catcherObjects, String sourceId) {
        if (directives == null) {
            return;
        }
        for (int i = 0; i < directives.length; ++i) {
            String directive = directives[i];
            this.getDataForDirective(directive, ex, out, callerThis, catcherObjects, sourceId);
        }
    }

    private void getDataForDirective(String directive, Throwable excep, IncidentStream out, Object callerThis, Object[] catcherObjects, String sourceId) {
        Method method2 = (Method)this.methodTable.get(directive.toLowerCase());
        if (method2 == null) {
            out.writeLine("Unsupported directive [" + directive + "] !!!", "");
            return;
        }
        try {
            Object[] o = new Object[ffdcDumpParams.length];
            o[0] = excep;
            o[1] = out;
            o[2] = callerThis;
            o[3] = catcherObjects;
            o[4] = sourceId;
            method2.invoke((Object)this, o);
            out.writeLine("+Data for directive [" + directive + "] obtained.", "");
        }
        catch (Throwable t) {
            try {
                String mname = method2.getDeclaringClass().getName() + method2.getName();
                Manager.Ffdc.log(t, this, this.getClass().getName(), "getDataForDirective", mname);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    String buildParamList() {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < ffdcDumpParams.length; ++j) {
            sb.append(DiagnosticModule.getTypeName(ffdcDumpParams[j]));
            if (j >= ffdcDumpParams.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    void msg(Object o) {
        System.out.println(o);
    }
}

